<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
      <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
      <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
      <h1 data-ng-bind="headingLabel"></h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form cv-hide-api name="credentialsForm" data-cv-submit="saveCredentials()" novalidate>
		<div class="modal-list bootstrap-wrapper">
			<div class="form-group row">
			<label class="col-xs-12 col-sm-4" for="connectionDetails"><cv:msg key="label.credential" bundle="users"/></label>
			<div class="col-xs-12 col-md-8">
				 <cv-radio-group 
            	radio-model="userCreationOptionVal" 
            	radio-obj="userCredentialsOptions"
            	on-click="userCredentialCreationOptionValChange(data)">
        		</cv-radio-group>
    		</div>
		</div>
			<div data-ng-if="impersonateExistingUser" class="form-group row">
				<label class="col-xs-12 col-sm-4" for="credential">
					<cv:msg key="label.savedCredential" bundle="users"/>
				</label>
				<div class="col-xs-12 col-sm-8">
					<isteven-multi-select id="userCredentials_isteven-multi-select_#2359"
						directive-id="credential"
						input-model="savedCredentials"
						output-model="model.credential"
						is-disabled="disabledCredential"
						button-label="credentialName"
						item-label="credentialName"
						search-property = "credentialName"
						selection-mode="single"
						tick-property="selected"
					>
					</isteven-multi-select>
					<span class="help-block" data-ng-show="helpText.showError"><cv:msg key="error.user" bundle="users" /></span>
				</div>
			</div>
			<div data-ng-if="!impersonateExistingUser">
				<div class="form-group row">
					<label class="col-xs-12 col-sm-4" for="loginName">
						<cv:msg key="label.userName" bundle="users"/>
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="loginName" required data-ng-model="userCredentials.userName"/>
						<span class="help-block" data-ng-show="cv.credentialsForm.needsAttention(credentialsForm.loginName)"><cv:msg key="error.userName" bundle="users" /></span>
					</div>
				</div>
				<div class="form-group row">
					<label class="col-xs-12 col-sm-4" for="password">
						<cv:msg key="label.password" bundle="users"/>
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="password" name="password" required data-ng-model="userCredentials.password"/>
						<span class="help-block" data-ng-show="cv.credentialsForm.needsAttention(credentialsForm.password)"><cv:msg key="error.password" bundle="users" /></span>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="userCredentials_button_#9868" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="userCredentials_button_#2506" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages" /></button>
		</div>
	</form>
</div>
