<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.tdfs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.tdfs">
	<div class="setup-title">
		<h1 ng-bind="networkFileShare.dataItem.shareName"></h1>
	</div>

		<div class="col-xs-12">
			<p class="server-message {{networkFileShare.serverMessage.type}}"
				data-ng-bind="networkFileShare.serverMessage.message"></p>
		</div>
		<div class="bootstrap-wrapper">
			<form name="networkFileShareForm" novalidate data-cv-submit="save()"
				autocomplete="off" id="networkFileShareForm"
				class="edit-users-grid-form">
				<div class="row ">
					<div class="col-md-12">
						<ul class="list-style-secondary">
							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.name" />
								</p>
								<p data-ng-bind="networkFileShare.dataItem.shareName"></p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.networkStorageServer" />
								</p>
								<p
									data-ng-bind="networkFileShare.dataItem.tdfsServer.mediaAgentName"></p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.networkClients" />
									<span class="inline-editor-buttons ng-scope pull-right">
        								<a href="" class="inline-editor-button text " data-ng-click="networkFileShare.editNetworkClients()"><cv:msg key="label.inlineEdit" bundle="messagesJs"/></a>
        							</span>
								</p>
								<p>{{networkFileShare.dataItem.nfsClients}}</p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.toTime" />
								</p>
								<p data-ng-bind="networkFileShare.dataItem.toTime.formattedtime"></p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.copyName" />
								</p>
								<p data-ng-bind="networkFileShare.copyName"></p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.acl" />
								</p>
								<p ng-show="networkFileShare.dataItem.showDeleted ==false">
										<fmt:message key="label.no" />
								</p>
								<p ng-show="networkFileShare.dataItem.showDeleted ==true">
									<fmt:message key="label.yes" />
								</p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.enabledACL" />
								</p>
								<p ng-show="networkFileShare.dataItem.acl ==0">
										<fmt:message key="label.no" />
								</p>
								<p ng-show="networkFileShare.dataItem.acl ==1">
									<fmt:message key="label.yes" />
								</p>
							</li>

							<li class="group">
								<p class="text-muted">
									<fmt:message key="label.accessType" />
								</p>
								<p data-ng-bind="networkFileShare.dataItem.formattedAccessType"></p>
							</li>

							<h4>
								<fmt:message key="label.status" />
								<span class="pull-right">
									<fieldset class="toggle-inner-links">
										<a href ng-click="networkFileShare.retrieveStatus()"><fmt:message
												key="link.retrieveStatus" /></a>
									</fieldset>
								</span>
							</H4>
							<p ng-bind-html=status ng-show="status"></p>

						</ul>
					</div>
				</div>
				<div class="button-container">
					<button id="cancel_tdfsFileShareUpdate" type="button"
						class="btn btn-default setup-btn--hidden" data-ng-click="cancel()">
						<fmt:message key="button.close"/>
					</button>
				</div>
			</form>
		</div>
</fmt:bundle>
