<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.tdfs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.tdfs">
<div class="setup-title">
	<h1 ><fmt:message key="title.addNetworkShare" />
	<cv-help-component help-text="<cv:msg key="help.addShare" bundle="tdfs"/>"></cv-help-component>
	</h1>
</div>
	<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
		<form name="tdfsAddShareForm" novalidate data-cv-submit="ctrl.save()"
			autocomplete="off" id="tdfsAddShareForm" class="edit-users-grid-form">
			<div class="col-xs-12">
				<span class="server-message {{ctrl.errorMessage.type}}"
					data-ng-bind="ctrl.errorMessage.message"></span>
			</div>
			<cv-plain-accordion accordion-label="accordion.general"
				collapsed="ctrl.status.generalCollapsed">

			<div class="form-group  row">
				<label class="col-xs-12 col-md-4 col-lg-4" for="shareName">
					<cv:msg key="label.shareName" bundle="tdfs" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="shareName" name="shareName"
						data-ng-model="ctrl.tdfsShareInfo.shareInfo.shareName"
						ng-model-options="{ updateOn: 'blur' }"
						data-ng-class="{'has-error': cv.tdfsAddShareForm.needsAttention(tdfsAddShareForm.shareName)}"
						required autofocus  data-ng-pattern='ctrl.namePattern'/> <span class="help-block"
						data-ng-show="cv.tdfsAddShareForm.needsAttention(tdfsAddShareForm.name)"><fmt:message
							key="error.shareName" /></span>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name">
						<span class="pageDetailColumn"><cv-help-text help-label="label.networkStorageServer" help-text="help.networkStorageServer"/></span>
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select
						id="networkStorageServer_isteven-multi-select"
						input-model="ctrl.networkStorageServer"
						output-model="ctrl.tdfsShareInfo.shareInfo.tdfsServerList"
						button-label="displayName" item-label="displayName"
						tick-property="selected" selection-mode="single"
						helper-elements="none"
						on-item-click="ctrl.onChangeNetworkFileServer()"> </isteven-multi-select>
						 <span class="help-block" data-ng-if="ctrl.networkFileServerError"><cv:msg key="error.selectNetworkServer" bundle="tdfs"/></span>
				</div>
			</div>


			<div class="form-group row">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name"> <cv:msg
						key="label.backupSet" bundle="tdfs" />

				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select id="backupsets_isteven-multi-select"
						input-model="ctrl.backupSetInputModel"
						output-model="ctrl.tdfsShareInfo.shareInfo.backupSetList"
						button-label="backupSetName" item-label="backupSetName"
						tick-property="selected" selection-mode="single"
						helper-elements="none" on-item-click="ctrl.onChangeBackupSet()"
						is-disabled = !ctrl.subclientLoaded>
					</isteven-multi-select>
					 <span class="help-block" data-ng-if="ctrl.selectBackupsetError"><cv:msg key="error.selectBackupset" bundle="tdfs"/></span>
				</div>
			</div>
			<div class="form-group row">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name"> <cv:msg
						key="label.subclient" bundle="tdfs" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
				<span ng-if="ctrl.subclientLoaded">
					<isteven-multi-select id="subclients_isteven-multi-select"
						input-model="ctrl.subclientInputModel "
						output-model="ctrl.tdfsShareInfo.shareInfo.subclientList"
						button-label="subclientName" item-label="subclientName"
						tick-property="selected" selection-mode="single"
						helper-elements="none" on-item-click="ctrl.onChangeSubclient()"> </isteven-multi-select>
						</span>
						<span ng-if="!ctrl.subclientLoaded">
						<label class="col-xs-12 col-md-4 col-lg-4" for="name"> <cv:msg
						key="label.loading" bundle="tdfs" />
				</label>
						</span>
				</div>
			</div>

			</cv-plain-accordion>

			<cv-plain-accordion accordion-label="accordion.refreshOptions">
			<!--// start //-->
			<div class="form-group row" ng-hide ="ctrl.isWindowsOS">
				<div class="col-xs-12 col-md-8 col-lg-8">
					<label for="refreshOnBackup"><input id="refreshOnBackup"
						name="refreshOnBackup" data-ng-value=true type="radio"
						data-ng-model="ctrl.tdfsShareInfo.shareInfo.isForeverShare" /> <span
						class="block-indent"><cv:msg key="radio.refreshOnBackup"
								bundle="tdfs" /></span></label>
				</div>
			</div>
			<div class="form-group row">
				<div class="col-xs-12 col-md-4 col-lg-4">
					<label for="restoreTime"><input id="restoreTime"
						name="restoreTime" data-ng-value=false type="radio"
						data-ng-model="ctrl.tdfsShareInfo.shareInfo.isForeverShare" /> <span
						class="block-indent"><cv:msg key="radio.restoreTime"
								bundle="tdfs" /></span></label>
				</div>

				<!--// end //-->
				<div data-ng-show="!ctrl.tdfsShareInfo.shareInfo.isForeverShare">
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="input-group calendar-wrapper date-picker">
							<input type="text" id="enableTime" name="enableTime"
								class="date-box" data-datetime-picker="yyyy-MM-dd hh:mma"
								data-ng-model="ctrl.dateTime"
								data-datepicker-options="ctrl.dateOptions"
								data-timepicker-options="ctrl.timeOptions"
								data-show-meridian="false" data-is-open="ctrl.isDatePickerOpen" />
							<span class="input-group-btn">
								<button id="addShare_button_#7922" type="button"
									data-ng-click="ctrl.openDatePicker()" class="btn btn-default">
									<i class="glyphicon glyphicon-calendar"></i>
								</button>
							</span>
						</div>
					</div>
				</div>
			</div>
			</cv-plain-accordion>

			<cv-plain-accordion accordion-label="accordion.clientOptions" >
			<div class="form-group row">
				<label for="allClients" class="col-xs-12 col-sm-4"> <input
					id="allClients" name="allClients" ng-value="0" class="" type="radio"
					data-ng-model="ctrl.customClients" data-toggle="tooltip" data-placement="right" title="'radio.allClients' | cvLoc"/>
					<span class="block-indent">
					<cv-help-text help-label="radio.allClients" help-text="help.allClient"/>
					</span>
				</label> <label for="customClients" class="col-xs-12 col-sm-4"> <input
					id="customClients" name="customClients" ng-value="1" class=""
					type="radio" data-ng-model="ctrl.customClients" /> <span
					class="block-indent"><cv:msg key="radio.customClients"
							bundle="tdfs" /></span>
				</label>
			</div>
			<div ng-show="ctrl.customClients==1">
				<tdfs-clients-template nfs-clients="ctrl.nfsClients"></tdfs-clients-template>
			</div>
			</cv-plain-accordion>

			<cv-plain-accordion accordion-label="accordion.additionalOptions">
			<div class="form-group row">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name"> <cv:msg
						key="label.copyName" bundle="tdfs" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select id="copyList_isteven-multi-select"
						input-model="ctrl.copyListInputModel "
						output-model="ctrl.tdfsShareInfo.shareInfo.copyList"
						button-label="copyName" item-label="copyName"
						tick-property="selected" selection-mode="single"
						helper-elements="none"> </isteven-multi-select>
				</div>
			</div>

			<div class="form-group row">
				<div class="col-xs-12 col-md-8 col-lg-8">
					<toggle-control class=" ng-isolate-scope"
						status="ctrl.tdfsShareInfo.shareInfo.showDeleted ? 'enabled-activity' : 'disabled-activity'"
						title="Enable/Disable" data-ng-click="ctrl.toggleFullBackup()">
					<div class="cv-material-toggle cv-toggle"
						data-ng-class="{'enabled':(status == trueProperty || status === true), disabled:(disabled===true)}">
						<div class="cv-material-toggle-bar"></div>
						<div class="cv-material-toggle-round"></div>
					</div>
					</toggle-control>
					<label><cv:msg key="option.includeDeletedItems"
							bundle="tdfs" /></label>
				</div>
			</div>
			<div class="form-group row">
				<div class="col-xs-12 col-md-8 col-lg-8" ng-hide ="ctrl.isWindowsOS">
					<toggle-control class=" ng-isolate-scope"
						status="ctrl.tdfsShareInfo.shareInfo.acl ? 'enabled-activity' : 'disabled-activity'"
						title="Enable/Disable" data-ng-click="ctrl.toggleACL()">
					<div class="cv-material-toggle cv-toggle"
						data-ng-class="{'enabled':(status == trueProperty || status === true), disabled:(disabled===true)}">
						<div class="cv-material-toggle-bar"></div>
						<div class="cv-material-toggle-round"></div>
					</div>
					</toggle-control>
					<label><cv:msg key="option.enable.ACL" bundle="tdfs" /></label>
				</div>
			</div>
			</cv-plain-accordion>

			<div class="modal-footer">
				<button id="canceladdShare" type="button"
					class="btn btn-default setup-btn--hidden"
					data-ng-click="ctrl.cancel()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="saveaddShare" type="submit"
					class="btn btn-primary cvBusyOnAjax" data-ng-click="ctrl.save()">
					<cv:msg key="Add" bundle="messages" />
				</button>
			</div>
		</form>
	</div>
</fmt:bundle>