<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
</script>
<div data-ng-controller="restoreController">
	<div class="setup-title"><h1><cv:msg key="label.restoreOpts" bundle="sqlserver" /></h1></div>
	<div class="setup-content">
		<form name="restoreForm" novalidate data-cv-submit="doRestore()" autocomplete="off">
			<div class="global-options">
				<span class="serverMessage error" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
					<cv:msg key="error.destinationServer" bundle="sqlserver" />
				</span>
				<label><cv:msg key="label.destinationClient" bundle="sqlserver" />
					<div class="destination-client">
						<span data-ng-if="!loadingInstanceDetails" data-ng-bind="restoreData.globalOptions.destinationEntity.clientName"></span>
						<span data-ng-if="loadingInstanceDetails"><cv:msg key="Loading" bundle="messages" /></span>
					</div>
				</label>
				<label for="destinationServer" class="select-label restorePathLabel"><cv:msg key="label.destinationServer" bundle="sqlserver" />
					<select	id="destinationServer" name="destinationServer"	data-ng-required="true"	data-ng-model="restoreData.globalOptions.destinationServer"
						data-ng-options="ds as ds.instanceName for ds in restoreData.globalOptions.destinationServerList | orderBy:'instanceName' track by ds.instanceId"
						data-ng-change="destinationServerChanged(restoreData.globalOptions.destinationServer)">
						<%-- <option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>--%>
					</select>
				</label>
				<label for="proxyClient" class="select-label restorePathLabel" data-ng-if="isDestSqlCloudInstance && isDestVirtual">
					<cv:msg key="label.proxyClient" bundle="sqlserver" />
					<select id="proxyClient" name="proxyClient" data-ng-required="true"
						data-ng-model="restoreData.globalOptions.proxyClient"
						data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.proxyClientList | orderBy:'clientName' track by ds.clientId"
						data-ng-change="proxyClientChanged(restoreData.globalOptions.proxyClient)">
						<%-- <option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>--%>
					</select>
				</label>
				<label for="stagingServer" class="select-label restorePathLabel" data-ng-if="!isSourceSqlAzureInstance && isDestSqlAzureInstance">
					<cv:msg key="label.stagingServer" bundle="sqlserver" />
					<select id="stagingServer" name="stagingServer" data-ng-required="true"
						data-ng-model="restoreData.globalOptions.stagingServer"
						data-ng-options="ds as ds.instanceName for ds in restoreData.globalOptions.stagingServerList | orderBy:'instanceName' track by ds.instanceId">
						<%-- <option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>--%>
					</select>
				</label>
				<label for="stagingPath" id="stagingPathID" data-ng-if="isSrcSqlCloudInstance || isDestSqlCloudInstance" class="restorePathLabel">
					<span class="serverMessage error" data-ng-show="cv.restoreForm.needsAttention(restoreForm.stagingPath)"> {{stagingPath.error}} </span>
					<span class="long-label-span"> {{stagingPath.label}} </span>
					<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
						client-id='{{(isDestVirtual)? restoreData.globalOptions.proxyClient.clientId : restoreData.globalOptions.destinationServer.clientId}}'
						result-function="stagingPathResultFunction"> </cv-machine-browse>
					<input type="text" name="stagingPath" id="stagingPath" data-ng-model="stagingPath.value" data-ng-required="true" />
				</label>
				<label  for="restorePath" class="restorePathLabel" data-ng-if="!isDestSqlCloudInstance">
					<cv:msg key="label.restoreToDisk" bundle="sqlserver"/>
					<button id="sqlRestoreOptions_button_#8942" type="button" 
						data-ng-click="openSelectDestinationFolder(restoreData.subClientEntity)"
						class="btn btn-default browse-btn">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
					<input type="text" name="restorePath" id="restorePath" data-ng-model="selectedPath" >
					</input>
				</label>
				<input id="dropConnections" type="checkbox" data-ng-model="restoreData.globalOptions.dropConnections">
				<label for="dropConnections" class="overwriteLabel"><cv:msg key="label.dropConnectionsToDB" bundle="sqlserver"/></label>
				<input id="overwrite" type="checkbox" data-ng-model="restoreData.globalOptions.overwrite">
				<label for="overwrite" class="overwriteLabel"><cv:msg key="label.unconditionallyOverwriteDatabaseOrFile" bundle="restore"/></label>
			</div>
			<label ><cv:msg key="label.dataFiles" bundle="sqlserver"/></label>
			<div class="local-options">
				<ul class="vm-full-restore-list">
	 				<li data-ng-repeat="sqlDbDeviceItem in restoreData.globalOptions.sqlDbDeviceItems">
						<a class="btn" data-ng-click="displaySqlDeviceRestoreOptions(sqlDbDeviceItem)" title="{{sqlDbDeviceItem.logicalFileName}}"
							data-ng-class="{'selected-value': sqlDbDeviceItem.logicalFileName == restoreData.globalOptions.selectedSqlDbdeviceItem.logicalFileName}">{{sqlDbDeviceItem.logicalFileName}}
						</a>
					</li>
				</ul>
				<div class='vm-full-restore-form'>
					<div id="perVmOptions" class="mainFormContent hyperv-restore-form-content">
						<label for="databaseName"
							class="data-store-label"><cv:msg key="label.DatabaseName" bundle="sqlserver"/>
							<input type="text" name="databaseName" data-ng-model="restoreData.globalOptions.selectedSqlDbdeviceItem.sqlDBInfo.databaseName" data-ng-blur = "changeAllDatabaseNames(restoreData.globalOptions.selectedSqlDbdeviceItem.sqlDBInfo.databaseName)" />
						</label>
						<span class="serverMessage error" data-ng-show="cv.restoreForm.needsAttention(restoreForm.physicalPathFolder)">
							<cv:msg key="error.physicalFilePath" bundle="sqlserver" />
						</span>
						<label for="physicalPathFolder" class="destination-vm"><cv:msg key="label.physicalFilePath" bundle="sqlserver"/>
							<input type="text" name="physicalPathFolder" id="physicalPathFolder" data-ng-required="!isDestSqlCloudInstance" data-ng-Disabled="isDestSqlCloudInstance"
								data-ng-model="restoreData.globalOptions.selectedSqlDbdeviceItem.physicalFilePath" />
							<button type="button" data-ng-Disabled="isDestSqlCloudInstance"
								data-ng-click="browsePhysicalPath(restoreData.subClientEntity)" class="btn btn-default browse-btn" id="physicalPathFileBrowse">
								<cv:msg key="label.browse" bundle="restore"/>
							</button>
						</label>
						<label for="physicalPathFile" class="destination-vm"><cv:msg key="label.physicalFileName" bundle="sqlserver"/>
							<input type="text" name="physicalPathFile" id="physicalPathFile" data-ng-model="restoreData.globalOptions.selectedSqlDbdeviceItem.physicalFileName"/>
						</label>
						<label class="destination-vm"><cv:msg key="label.fileSize" bundle="sqlserver"/> {{restoreData.globalOptions.selectedSqlDbdeviceItem.fileMaxSize | capacity}}</label>
					</div>
					<div class="button-container">
						<button id="sqlRestoreOptions_button_#1533" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden"	data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
						<button id="sqlRestoreOptions_button_#8518" class="btn btn-primary cvBusyOnAjax" type="submit"><cv:msg key="Submit" bundle="messages" /></button> 
					</div>
				</div>
			</div>
		</form>
	</div>
</div>
