<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<span data-ng-show="!backupMsg" >
		<label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
		</div>
		<div class="global-options remove-border-padding form-panel-holder">
			<label class="element-indent-class" data-ng-hide="hideFullBackupLevel">
				<input type="radio" name="bkptype" ng-model="backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule"/>
			</label>
			<label class="element-indent-class">
				<input type="radio" name="bkptype" ng-model="backupType" value="INCREMENTAL">
				<cv:msg key="option.incremental" bundle="schedule"/>
			</label>
			<label class="element-indent-class" data-ng-show="isDifferentialSupported">
				<input type="radio" name="bkptype" ng-model="backupType" value="DIFFERENTIAL">
				<cv:msg key="option.differential" bundle="schedule"/>
			</label>
			<label class="element-indent-class" data-ng-show="isSyntheticFullSupported">
				<input type="radio" name="bkptype" ng-model="backupType" value="SYNTHETIC_FULL">
				<cv:msg key="option.synthfull" bundle="schedule"/>
			</label>
		</div>
	</span>
	<span data-ng-show="!backupMsg">
	   <div class="global-options remove-border-padding">
			<label><cv:msg key="label.options" bundle="oracle"/></label>
		</div>
	   <div class="global-options remove-border-padding form-panel-holder">
			<label class="element-indent-class">
				<input type="radio" name="bkpVer" ng-model="bkpVersion" value="Latest">
				<cv:msg key="label.backupLatestVersion" bundle="sharepoint"/>
			</label>
			<label class="element-indent-class">
				<input type="radio" name="bkpVer" ng-model="bkpVersion" value="All">
				<cv:msg key="label.backupAllVersions" bundle="sharepoint"/>
			</label>
		</div>
	</span>
	<div class="button-container">
		<button id="sharepointDocBackupOptions_button_#4137" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="sharepointDocBackupOptions_button_#7667" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="sharepointDocBackupOptions_button_#7637" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>