<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ReportsPlusMessages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<div class="row reports-list-top-container">
	<div class="col-md-12 reports-list-header" data-ng-show="hasAnyData">
		<span class="search-widget-wrapper search-filter">
			<input autofocus type="text" class="search-field" autocomplete="off" placeholder="<cv:msg key='label.search' bundle='navJs' />" id="reports-search-field" title="<cv:msg key='label.search' bundle='navJs' />" data-ng-model="searchText" data-ng-keyup="filterReports($event)"/>
			<span data-ng-click="searchText='';filterReports()" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title="<cv:msg key='label.clear' bundle='navJs' />"></span>
		</span>
		<div class="page-action-item spacing-right">
				<span uib-dropdown class="uib-dropdown" on-toggle="toggled(open)">
					<a href class="uib-dropdown-toggle" uib-dropdown-toggle>
						<span class="dropdownArrow right"></span> <cv:msg key='header.actions' bundle='reports' />
					</a>
					<ul uib-dropdown-menu class="dropdown-menu menu-icons" role="menu">
						<li data-ng-if="canManageReports" class="ADD_REPORT">	<a href="/webconsole/reportsplus" target="_blank" title="<cv:msg key='CustomReport.ACReport.addReport' bundle='ReportsPlusMessages' />"><cv:msg key='CustomReport.ACReport.addReport' bundle='ReportsPlusMessages' /></a></li>
						<li data-ng-if="canManageReports" class="reports-file-link IMPORT_TEMPLATE">
							<a title="<cv:msg key='CustomReport.ACReport.importTemplate' bundle='ReportsPlusMessages' />" data-ng-click="importReportTemplate()"><cv:msg key='CustomReport.ACReport.importTemplate' bundle='ReportsPlusMessages' /></a>
							<input type="file" class="import-report-template-input" data-files-input data-ng-model="files" title="<cv:msg key='CustomReport.ACReport.importTemplate' bundle='ReportsPlusMessages' />" data-ng-change="onInputChange(files)" accept=".xml" multiple/>
						</li>
						<li data-ng-if="isMspAdmin" class="CONNECT_TO_STORE"><a target="_blank" href="/webconsole/softwarestore/store.do?category=report" target="_blank"><cv:msg key='CustomReport.ACReport.connectToStore' bundle='ReportsPlusMessages' /></a></li>
						<li class="SCHEDULE"><a href data-ng-href="#/reportSchedules" title="<cv:msg key='label.viewSchedules' bundle='reports'/>"><cv:msg key='label.viewSchedules' bundle='reports'/></a></li>
						<li class="ALERTS"><a href data-ng-href="#/reportAlerts" title="<cv:msg key='label.viewAlerts' bundle='reports'/>"><cv:msg key='label.viewAlerts' bundle='reports'/></a></li>
					
					</ul>
				</span>
		</div>
		<div class="page-action-item store-updates-action-item" data-ng-if="updateCount && isMspAdmin">
			<div uib-dropdown class="uib-dropdown store-updates" on-toggle="storeUpdatesDropDownOpen=!storeUpdatesDropDownOpen" tooltip-enable="!storeUpdatesDropDownOpen" tooltip-placement="bottom" uib-tooltip="<cv:msg key='reportsList.storeUpdates.uppercase' bundle='reports' />">
				<a href class="uib-dropdown-toggle store-updates-label" uib-dropdown-toggle>{{updateCount}}</a>
				<ul uib-dropdown-menu class="dropdown-menu store-updates-dropdown-menu" role="menu">
					<li class="has-updates-header-item">
						<div class="has-updates-header"><cv:msg key="reportsList.storeUpdates" bundle="reports" /></div>
					</li>
					<li class="report-with-update" data-ng-repeat="reportUpdate in updates | orderBy: 'reportName'">
						<a title="{{reportUpdate.reportName}}">{{reportUpdate.reportName}}</a>
					</li>
					<li data-ng-repeat-end class="update-all-on-store-action">
						<button id="reportsList_button_#8395" class="update-all-on-store-btn" data-ng-click="openStoreUpdatesPage()"><cv:msg key="reportsList.updateOnStore" bundle="reports" /></button> 
					</li>
				</ul>
			</div>
		</div>
		<div class="float-left">
			<h1>{{title}}</h1>
		</div>
	</div>
</div>
<div class="all-tags-back-button" data-ng-show="initialized && selectedTags.length > 0">
	<a title="<cv:msg key='reportsList.clearAll' bundle='reports' />" data-ng-click="clearTagSelection()">
		<cv:msg key='reportsList.showAllTags' bundle='reports' />
	</a>
</div>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div data-ng-show="hasAnyData">
<!-- group view -->
<div class="reports-content">
	<ul class="tagSections row" data-ng-repeat="tag in groupViewDataProjection track by tag.tagId">
		<li class="tag-section col-lg-12 col-md-12 col-sm-12 col-xs-12" data-ng-class="{'tag-section-hovered': hoveredOnTagName, 'tag-actions-supported': doesHeadingRespondToAction(tag)}" data-ng-mouseenter="hoveredOnTagName=true" data-ng-mouseleave="hoveredOnTagName=false">
			<h2 class="group-tag-name">
				<span class="group-tag-name-content" data-ng-click="tagSelectionChanged(tag)">{{tag.tagName}}</span>
				<span class="edit-tags k-icon k-i-edit k-i-pencil" title="<cv:msg key='reportsList.editTag' bundle='reports' />" data-ng-click="editTags(tag)"></span>
			</h2>
			<ul class="row group-tile-list">
				<li id="report{{report.reportId}}" class="group-tile-item col-sm-6 col-md-6 col-lg-3" data-ng-repeat="report in tag.associatedReports track by report.reportId" data-ng-class="{'hover': groupTileHovered}" data-ng-mouseenter="groupTileHovered=true" data-ng-mouseleave="groupTileHovered=false">
					<a class="group-view-icon-wrapper" href="#/reportDetails?reportId={{report.reportId}}&app=ADMIN_CONSOLE">
						<div data-ng-bind-html="getSVGIcon(report)" class="cv-report-icon-small"></div>
					</a>
					<div class="report-details-wrapper">
						<label class="report-name">
							<a class="report-name-link" href="#/reportDetails?reportId={{report.reportId}}&app=ADMIN_CONSOLE" title="{{report.reportName}}">{{report.reportName}}</a> 
						</label>
						<p class="report-description" title="{{report.description}}">{{report.description}}</p>
						<div class="group-tile-actions" data-ng-class="{'visibile': groupTileHovered || groupViewActionMenuOpen}">
							<!-- <span class="group-tile-action-btn k-icon k-i-more-horizontal"></span> -->
							<span data-uib-dropdown class="uib-dropdown" on-toggle="groupViewActionMenuOpen = !groupViewActionMenuOpen; dropdownToggled(groupViewActionMenuOpen, report) ">
								<a data-uib-dropdown-toggle class="dropdown-toggle" title="<cv:msg key='header.actions' bundle='reports' />" aria-label="<cv:msg key='header.actions' bundle='reports' />"><span class="group-tile-action-btn1" data-ng-class="{'active': groupViewActionMenuOpen}"><span class="k-icon k-i-more-horizontal"></span></span></a>
								<ul class="dropdown-menu-right dropdown-menu">
									<li class="group-tile-list-item">										
										<a class="group-tile-action-name" title="<cv:msg key='reportsList.action.tags' bundle='reports' />" data-ng-click="editReportTags(report)"><cv:msg key="reportsList.action.tags" bundle="reports" /></a>
									</li>
									<li class="group-tile-list-item">										
										<a class="group-tile-action-name" title="<cv:msg key='label.view.schedules' bundle='reports'/>" data-ng-click="viewReportSchedules(report)"><cv:msg key='label.view.schedules' bundle='reports'/></a>
									</li>
									<li class="group-tile-list-item">										
										<a class="group-tile-action-name" title="<cv:msg key='label.view.alerts' bundle='reports'/>" data-ng-click="viewReportAlerts(report)"><cv:msg key='label.view.alerts' bundle='reports'/></a>
									</li>
									<li class="group-tile-list-item">										
										<a class="group-tile-action-name" title="<cv:msg key='reportsList.action.permissions' bundle='reports' />" data-ng-click="modifySecurityAssociations(report);"><cv:msg key="reportsList.action.permissions" bundle="reports" /></a>
									</li>
									<li class="group-tile-list-item" data-ng-if="report.canEditReport">										
										<a class="group-tile-action-name" title="<cv:msg key='CustomReport.ACReport.edit' bundle='ReportsPlusMessages' />" href="/webconsole/reportsplus/index.jsp?reportId={{report.reportId}}" target="_blank"><cv:msg key="CustomReport.ACReport.edit" bundle="ReportsPlusMessages" /></a>
									</li>
									<li class="group-tile-list-item" data-ng-if="report.canDeleteReport">										
										<a class="group-tile-action-name" title="<cv:msg key='CustomReport.ACReport.delete' bundle='ReportsPlusMessages' />" data-ng-click="deleteReport(report)"><cv:msg key="CustomReport.ACReport.delete" bundle="ReportsPlusMessages" /></a>
									</li>
								</ul>
							</span>
						</div>
					</div>
				</li>
			</ul>
		</li>
	</ul>
</div>
</div>
<h2 class="no-reports-found"><cv:msg key="CustomReport.ACReport.noReportsFound" bundle="reports" /></h2>
<h2 data-ng-if="initialized && !hasAnyData"><cv:msg key="CustomReport.ACReport.noReportsAvailable" bundle="ReportsPlusMessages" /></h2>
