<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-12" data-ng-if="::ctrl.model.isAlertLoaded">
    	<h1 class="page-title">{{ctrl.model.props.alarmName}}</h1>
        <%-- <span><cv-changename obj='ctrl.model.changeNameObj' service-method="renameSchedule.do" class="float-left"></cv-changename></span> --%>
        <span><a class="page-action-item" ng-click="ctrl.deleteAlert()"><cv:msg key="Delete" bundle="messages" /></a></span>
        <span><a class="page-action-item" data-ng-click="ctrl.editAlert()"><cv:msg key="action.edit" bundle="schedule" /></a></span>
        <span><a class="page-action-item" ng-click="ctrl.toggleAlertStatus()" ng-if="!ctrl.model.isAlertEnabled"><cv:msg key="action.enable" bundle="schedule" /></a></span>
        <span><a class="page-action-item" ng-click="ctrl.toggleAlertStatus()" ng-if="ctrl.model.isAlertEnabled"><cv:msg key="action.disable" bundle="schedule" /></a></span>
        <span><a class="page-action-item" ng-click="ctrl.triggerAlert()"><cv:msg key="actionMenu.label.runNow" bundle="reports" /></a></span>
    </div>
</div>
<div class="row">
	<div class="col-xs-12 col-sm-6">
        <cv-tile-component data-ng-if="(!ctrl.model.isAlertLoaded)" data-loader="ctrl.model.isAlertLoaded" data-title='<cv:msg key="label.reportOptions" bundle="schedule" />'></cv-tile-component>
        <cv-tile-component ac-id="alert-details" data-ng-if="ctrl.model.isAlertLoaded" data-title='<cv:msg key="label.reportOptions" bundle="schedule" />'>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.report" bundle="schedule" />'"></span>
                    <span class="pageDetailColumn" data-ng-if="ctrl.model.props.reportName"> <a href="{{ctrl.model.props.reportURL}}" target="_blank">{{ctrl.model.props.reportName}} </a> </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.criteria" bundle="reports" />'"></span>
                    <span class="pageDetailColumn" >
                        <span data-ng-bind-html="ctrl.model.criteria"></span>
                    </span>
                </li>
		        <li class="group">
		            <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.createdBy" bundle="reports" />'"></span>
		            <span class="pageDetailColumn">{{ctrl.model.props.userName}}</span>
		        </li>
                <li class="group">
		            <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.status" bundle="schedule" />'"></span>
		            <span class="pageDetailColumn"  data-ng-if="ctrl.model.isAlertEnabled"><cv:msg key="label.enabled" bundle="schedule" /></span>
		            <span class="pageDetailColumn"  data-ng-if="!ctrl.model.isAlertEnabled"><cv:msg key="label.disabled" bundle="schedule" /></span>
		        </li>
            </ul>
        </cv-tile-component>
    </div>
    <div class="col-xs-12 col-sm-6">
        <cv-tile-component data-ng-if="!ctrl.model.isAlertLoaded" data-loader="ctrl.model.isAlertLoaded" data-title='<cv:msg key="label.notification" bundle="reports" />'></cv-tile-component>
        <cv-tile-component ac-id="alert-notification" data-ng-if="::ctrl.model.isAlertLoaded" data-title='<cv:msg key="label.notification" bundle="reports" />'>
            <ul class="list-style-secondary">
            	<li class="group">
                    <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.severity" bundle="reports"/>'"></span>
                    <span class="pageDetailColumn">{{ctrl.model.severity}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.type" bundle="reports"/>'"></span>
                    <span class="pageDetailColumn">{{ctrl.model.notificationMethods}}</span>
                </li>
                <li class="group" data-ng-if="ctrl.model.emails.to">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.email.to" bundle="reports" />'"></span>
                    <ul class="pageDetailColumn">
                        <li class="gen-alarm-row" data-ng-repeat="email in ctrl.model.emails.to"><span>{{email}}</span></li>
                    </ul>
                </li>
                <li class="group" data-ng-if="ctrl.model.emails.cc">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.email.cc" bundle="reports" />'"></span>
                    <ul class="pageDetailColumn">
                        <li class="gen-alarm-row" data-ng-repeat="email in ctrl.model.emails.cc" ><span>{{email}}</span></li>
                    </ul>
                </li>
                <li class="group" data-ng-if="ctrl.model.emails.bcc">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.email.bcc" bundle="reports" />'"></span>
                    <ul class="pageDetailColumn">
                        <li class="gen-alarm-row" data-ng-repeat="email in ctrl.model.emails.bcc"><span>{{email}}</span></li>
                    </ul>
                </li>
                <li class="group" data-ng-if="ctrl.model.props.scheduleInfo">
                    <span class="pageDetailColumn" data-ng-bind-html="'<cv:msg key="label.timeAndFrequency" bundle="reports" />'"></span>
                    <span class="pageDetailColumn">{{ctrl.model.props.scheduleInfo}}</span>
                </li>
            </ul>
        </cv-tile-component>
    </div>
     <div class="col-xs-12 col-sm-6">
       <cv-tile-component data-ng-if="!ctrl.model.isAlertScheduleLoaded" data-loader="ctrl.model.isAlertScheduleLoaded" data-title='<cv:msg key="label.schedule" bundle="schedule" />'></cv-tile-component>
       <cv-tile-component ac-id="schedule-pattern" data-ng-if="::ctrl.model.isAlertScheduleLoaded" data-title='<cv:msg key="label.schedule" bundle="schedule" />'>
           <span class="error" data-ng-if="ctrl.model.alertScheduleError">
           	{{ ctrl.model.alertScheduleError }}
           </span>
           <ul class="list-style-secondary">
           	<li class="group" data-ng-if="ctrl.model.alertSchedulePattern.frequency">
                   <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.scheduleFrequency" bundle="schedule"/>'"></span>
                   <span class="pageDetailColumn">{{ctrl.model.alertSchedulePattern.frequency}}</span>
               </li>
               <li class="group" data-ng-if="ctrl.model.alertSchedulePattern.time">
                   <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.time2" bundle="schedule"/>'"></span>
                   <span class="pageDetailColumn">{{ctrl.model.alertSchedulePattern.time}}</span>
               </li>
               <li class="group" data-ng-if="ctrl.model.alertSchedulePattern.repeat">
                   <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.repeat" bundle="schedule"/>'"></span>
                   <span class="pageDetailColumn">{{ctrl.model.alertSchedulePattern.repeat}}</span>
               </li>
           </ul>
       </cv-tile-component>
    </div>
</div>
