<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
</script>

<li class="incremental-rpo-container-for-profile group" id="rpo-frequency">
	<span class="pageDetail-three-columns-first">
		<label class="cv-label" for="rpo">
			<cv-help-text help-label="{{repFreqencyCtrl.model.frequencyLabel}}" help-text="repFreqencyCtrl.model.frequencyHelpText">
				</cv-help-text>
		</label>
	</span>
	<span data-ng-if="!repFreqencyCtrl.editMode" class="pageDetail-three-columns-second">
		<cv:msg key="label.incrementalFrequencyText" bundle="profiles"/>
		<span ng-bind="repFreqencyCtrl.slaLabel"></span>
	</span>
	<div data-ng-if="repFreqencyCtrl.editMode" data-ng-disabled="repFreqencyCtrl.isEditting" class="row col-lg-6 col-xs-12 col-md-12">
		<div class="incremental-rpo-options-container form-group cv-inline-wrapper">
			<label class="freqLabel inline-label schedule-repeat-label vertial-align-middle" for="logSlaHours">
				<cv:msg key="label.incrementalFrequencyText" bundle="profiles"/>
			</label>
			<input id="rpo" name="rpo" type="number" min="1" required
			data-ng-model="repFreqencyCtrl.slaInfo.rpoTimeUI"
			class="frequency-input text-center"
			data-ng-class="{'setup' : skipForSetup}"
			data-ng-change="repFreqencyCtrl.onRPOChange()"
			step="1"/>

			<select name="rpoTime" id="rpoType" class="frequency-select"
					data-ng-options="option.name for option in
					repFreqencyCtrl.availableRPOFreq track by option.value"
					data-ng-model="repFreqencyCtrl.slaInfo.freq"
					data-ng-change="repFreqencyCtrl.onRPOChange()" ></select>
			<a data-ng-if="repFreqencyCtrl.editMode"
				data-ng-click="repFreqencyCtrl.save()"
				class="save-frequency cvBusyOnAjax"><i class="glyphicon glyphicon-ok" ></i></a>

			<a data-ng-if="repFreqencyCtrl.editMode"
				data-ng-click="repFreqencyCtrl.disableEditMode()"
				class="disable-edit-frequency cvBusyOnAjax"><i class="glyphicon glyphicon-remove" ></i></a>
		</div>
	</div>
	<div data-ng-if="repFreqencyCtrl.errorMessage.message" class="pageDetail-three-columns-second">
		<p class="incremental-rpo-error-msg help-block margin-top-10-important margin-left-0"
			data-ng-bind="repFreqencyCtrl.errorMessage.message" ></p>
	</div>

	<a  data-ng-if="repFreqencyCtrl.showEdit && !repFreqencyCtrl.editMode"
		title='<cv:msg key="action.edit" bundle="collections"/>'
		data-ng-click="repFreqencyCtrl.enableEditMode()"
		class="pageDetail-three-columns-third" data-ng-click="repGroupDetail.toggleEdit(repGroupDetail.CONSTANT.replicationCopy)">
		<cv:msg key="action.edit" bundle="collections"/>
	</a>
</li>