<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div data-ng-if="$parent.planPolicyTileLoaded && !isSubclientPolicyAppType">
	<cv-tile-component data-ac-id="Policies-clients" data-title='<cv:msg key="header.policies" bundle="clients"/>' data-ng-if="(policies.storagePolicy.id || policies.schedulePolicy.length>0)">
<ul class="group list-style-secondary" >
	<li class="group" data-ng-if="showStoragePolicy">
		<span class="pageDetailColumn"><cv:msg key="header.storagePolicy" bundle="clients"/></span>
		<a data-ng-if="policies.storagePolicy.id" class="pageDetailColumn" data-ng-href="#/storagePolicyInfo?storagePolicyId={{policies.storagePolicy.id}}"
		data-ng-bind='policies.storagePolicy.name || "(<cv:msg key="header.storagePolicy" bundle="clients"/>)"'></a>
		<span data-ng-if="!policies.storagePolicy.id" class="pageDetailColumn"><cv:msg key="label.policyNotSet" bundle="clients"/></span>
		<%-- Default name is used in case policy name is blank so that the link is still clickable --%>
	</li>
	<li class="group" data-ng-if="showStoragePolicy && showLogStoragePolicy">
		<span class="pageDetailColumn"><cv:msg key="header.logStoragePolicy" bundle="clients"/></span>
		<a data-ng-if="policies.logStoragePolicy.id" class="pageDetailColumn" data-ng-href="#/storagePolicyInfo?storagePolicyId={{policies.storagePolicy.id}}"
		data-ng-bind='policies.logStoragePolicy.name || "(<cv:msg key="header.logStoragePolicy" bundle="clients"/>)"'></a>
		<span data-ng-if="!policies.logStoragePolicy.id" class="pageDetailColumn"><cv:msg key="label.policyNotSet" bundle="clients"/></span>
	</li>
	<li class="group" data-ng-if="showSchedulePolicy">
		<span class="pageDetailColumn"><cv:msg key="header.schedulePolicy" bundle="clients"/></span>
		<div class="schedules-list list-style__row group pageDetailColumn" >
				<div data-ng-repeat="scheduleIdent in policies.schedulePolicy">
					<a data-ng-if="scheduleIdent.id" data-ng-href="#schedulePolicyDetails/{{scheduleIdent.id}}"
					data-ng-bind='scheduleIdent.name || "(<cv:msg key="header.schedulePolicy" bundle="clients"/>)"'></a>
				</div>
				<span data-ng-if="!policies.schedulePolicy" class="pageDetailColumn"><cv:msg key="label.policyNotSet" bundle="clients"/></span>
		</div>
		
	</li>
	<li class="group" data-ng-if="showSubclientPolicy">
		<span class="pageDetailColumn"><cv:msg key="header.subclientPolicy" bundle="clients"/></span>
		<a data-ng-if="policies.subclientPolicy.id" class="pageDetailColumn" data-ng-href="#subclientPolicyDetail/{{policies.subclientPolicy.id}}"
		data-ng-bind='policies.subclientPolicy.name || "(<cv:msg key="header.subclientPolicy" bundle="clients"/>)"'></a>
		<span data-ng-if="!policies.subclientPolicy.id" class="pageDetailColumn"><cv:msg key="label.policyNotSet" bundle="clients"/></span>
	</li>
</ul>
<div class="page-details-box-links" data-ng-if="showEdit">
	<a href="" data-ng-click="editPolicies()">
		<cv:msg key="action.edit" bundle="collections" />
	</a>
</div>
</cv-tile-component>
<cv-tile-component data-title='<cv:msg key="header.policies" bundle="clients"/>' data-ng-if = "(!policies.storagePolicy.id && !policies.schedulePolicy) " >
		<p class="info-place-holder">
			<cv:msg key="error.noPoliciesAssociated" bundle="clients"/>
		</p>
		<div class="page-details-box-links" data-ng-if="showEdit">
	<a href="" data-ng-click="editPolicies()">
		<cv:msg key="action.edit" bundle="collections" />
	</a>
</div>
</cv-tile-component>
</div>
<cv-tile-component data-ng-if="storagePolicyLoaded && isSubclientPolicyAppType" data-ac-id="Policies-clients" data-title="{{'header.policies' | cvLoc}}">
		<span class="server-message {{serverMessage.type}}" ng-bind="serverMessage.message"></span>
		<ul class="group list-style-secondary">
			<li class="group">
				<span class="pageDetailColumn" ng-bind="'header.storagePolicy' | cvLoc"></span>
				<div class="pageDetailColumn inline-editor" ng-if="!editMode">
					<span class="inline-editor-text">
						<a data-ng-if="policies.storagePolicy.id"
							data-ng-href="#/storagePolicyInfo?storagePolicyId={{policies.storagePolicy.id}}"
							data-ng-bind="policies.storagePolicy.name">
						</a>
					</span>
					<span class="inline-editor-buttons">
						<a  class="inline-editor-button text " ng-click="editStoragePolicy()" ng-bind="'label.inlineEdit' | cvLoc">
						</a>
					</span>
				</div>
			
				<div ng-if="editMode">
						<span class="pageDetailColumn inline-editor">
							<div class="inline-editor-input">
									<isteven-multi-select
									input-model="storagePolicyList"
									button-label="name"
									id="entity-storage-policy-select"
									item-label="name"
									search-limit="10"
									search-property="name"
									selection-mode="single"
									tick-property="selected"
									class="isteven-multi-select user-group-select"
									helper-elements="filter"
									on-item-click="onPolicySelect(data)">
								</isteven-multi-select>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="savePolicy()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="cancelEdit()"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</div>
			</div>
		</li>
	</cv-tile-component>