<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div data-ng-controller="restoreController">
	<div class="setup-title">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	
	<div class="clone-database-markup-holder setup-content" >
		 
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<form name="restoreForm" class="restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
		
			<!-- For Destination Severs -->
			<div class="global-options destinationServerDiv">
				<label for="destinationServer" class="select-label restorePathLabel" ><cv:msg key="label.fsServer" bundle="restore"/>
					<select id="destinationServer" name="destinationServer"  data-ng-required="true"
						data-ng-model="restoreData.globalOptions.destinationServer"
						data-ng-options="ds as ds.clientName for ds in restoreData.globalOptions.destinationServerList track by (ds.clientName|lowercase)"
						data-ng-change="destinationServerChanged(restoreData.globalOptions.destinationServer)" >
						<option value=""><cv:msg key="placeholder.selectDestinationHost" bundle="restoreJs"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
						<cv:msg key="error.destinationServer" bundle="restore"/>
					</span>
				</label>
			</div>
			<div class="panel form-panel-holder"> 
			
			
			<!-- Oracle restore options -->
			<label> <cv:msg key="label.restore" bundle="oracle"/> </label>
			 <label class="element-indent-class">
				<span class="page-detail-column"> 
					<input type="checkbox" id="controlfile" name="controlfile" data-ng-model="restoreData.globalOptions.controlfile" /> 
					<label for="controlfile"><cv:msg key="label.controlfile" bundle="oracle" /></label>
				</span> 
				<span class="page-detail-column"> 
					<input type="checkbox" id="database" name="database" data-ng-model="restoreData.globalOptions.database" />
					<label for="database"><cv:msg key="label.database" bundle="oracle" /></label>
				</span>
			</label> 
			<label> <cv:msg key="label.recoverTo" bundle="oracle"/> </label>
			<label class="element-indent-class"> 
				<span class="page-detail-column"> 
					<input type="radio" ng-model="restoreData.globalOptions.pitType" value="0" id="mostRecent" name="mostRecent" /> 
					<label for="mostRecent"> <cv:msg key="label.mostRecent" bundle="oracle"/></label>
				</span>
				<span class="page-detail-column float-right"> </span>
			</label>
			
			<label class="element-indent-class"> 
				<span class="page-detail-column"> 
					<input type="radio" ng-model="restoreData.globalOptions.pitType" value="1" id="pitDate1" name="pitDate" /> 
					<label for="pitDate1"><cv:msg key="label.pit" bundle="oracle" /></label>
				</span> 
				<span class="page-detail-column date-input-holder float-right">
					<input ng-disabled="(restoreData.globalOptions.pitType != '1')" name="pitDate" id="pitDate" type="text" data-ng-model="restoreData.globalOptions.pitDate" />
					<cv-date-time heading-label="To Time" result-function="resultFunction" >
						<button id="oracleRestoreOptions_button_#2534" ng-disabled="(restoreData.globalOptions.pitType != '1')" type="button" class="btn btn-default" > 
							<i class="glyphicon glyphicon-calendar"></i>
						</button>
					</cv-date-time>
				</span>
			</label>
			
			<label class="element-indent-class"> 
				<span class="page-detail-column"> 
					<input type="radio" ng-model="restoreData.globalOptions.pitType" value="2" id="scn" name="scn" /> 
					<label for="scn"> <cv:msg key="label.scn" bundle="oracle" /> </label>
				</span> 
				<span class="page-detail-column float-right"> 
					<input ng-disabled="(restoreData.globalOptions.pitType != '2')" type="text" id="pitScn" name="pitScn" data-ng-model="restoreData.globalOptions.pitScn" />
				</span>
			</label>
					
			<label>{{oraInstanceStatus}}</label>		
			
			<div class="button-container">
				<button id="oracleRestoreOptions_button_#3781" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
				<button id="oracleRestoreOptions_button_#5338" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button> 
			</div>
		</form>
	</div>
  </div>
</div>