<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content backup-options">
	<span data-ng-show="backupJobId">
		<div class="global-options remove-border-padding">
			<cv:msg key="notification.backup.started" bundle="serversJs"/> {{backupJobId}}.<a data-ng-click='goToJob()'> <cv:msg key="notification.jobDetails" bundle="serversJs"/></a>
		</div>
	</span>
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<span data-ng-show="!backupMsg">
		<label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
		</div>
			
		<div class="global-options remove-border-padding form-panel-holder">
			<label class="element-indent-class">
				<input type="radio" ng-model="backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule"/>
			</label>
				
			<label class="element-indent-class">
				<input type="radio" ng-model="backupType" value="INCREMENTAL">
				<cv:msg key="option.incremental" bundle="schedule"/>
			</label>
			<label class="element-double-indent-class">
				<input ng-disabled="(backupType !== 'INCREMENTAL')" type="checkbox" id="cumulative" name="cumulative" data-ng-model="cumulative" />
				<label for="cumulative"><cv:msg key="label.cumulative" bundle="oracle" /></label>
			</label>	
		</div>
	</span>
			
	<div class="button-container">
		<button id="oracleBackupOptions_button_#9207" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="oracleBackupOptions_button_#5002" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="oracleBackupOptions_button_#5853" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>