<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
      <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
      <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
      <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
      <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<!--This view is for Subclient Edit or Add for FS Agent -->
<div class="setup-title">
      <h1><cv:msg key="label.AddOrEditContent" bundle="fs" /></h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}} serverMessage" data-ng-bind="serverMessage.message"></span>
	<form name="fsSubclientContentForm" novalidate data-cv-submit="modifySubclientContent()" autocomplete="off"	class="add-collection-form">
	
	<div data-ng-if='isIBMiSubclient'>
		<h5>
			<span class="pull-left padding-left-20"><cv:msg key="label.includeGlobalExceptions" bundle="fs" /> </span>
			<span class="pageDetailColumn pull-right">
				<toggle-control class="useGlobalFiltersActivity" status="useGlobalFiltersActivity" data-ng-click="enableDisableIncludeGlobalExceptions()"></toggle-control>
			</span>
		</h5>
	</div>
	<br>
	<div class="bootstrap-wrapper accordion-tab">
	
		<div data-ng-if='isIBMiSubclient'>
		<uib-accordion close-others="true">
				<!-- // content start // -->
				<div uib-accordion-group is-open="model.accordionStatus.contentTab" data-scroll-to-when-open data-ng-init="model.accordionStatus.contentTab=true">
				<uib-accordion-heading><cv:msg key="header.content" bundle="collections" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.contentTab, 'glyphicon-chevron-right': !model.accordionStatus.contentTab}"></i>
				</uib-accordion-heading>
				<div data-ng-if="isIBMiSubclient" class="form-group row">
					<label class="col-xs-12 col-lg-4" for="content"><cv:msg key="label.contentType" bundle="clients"/></label>
					<div class="col-xs-12 col-lg-8">
						<select id="content"
								name="content"
								data-ng-change="changeContentType()"
								data-ng-model="detailedContentEntityList.ibmiContent.customSubclientFlag"
								required="required"
								data-ng-options="option.value as option.label for option in selectOptions">
						</select>
					</div>
				</div>
				<div class="form-group"  data-ng-if="isIBMiSubclient && !detailedContentEntityList.ibmiContent.customSubclientFlag">
					<div class="col-xs-6 col-md-6 col-lg-6">
						<div class="row" data-ng-repeat="content in ibmiInputs.subclientContentList | limitTo: ibmiInputs.subclientContentList.length/2 + 1:0">
							<input type="checkbox" ng-disabled="content.disabled" id="{{content.customSubclientContentFlags}}" name="{{content.customSubclientContentFlags}}" data-ng-model="content.selected" data-ng-change="changeCustomSubclientContentFlags()"/>
							<label for="{{content.customSubclientContentFlags}}" data-ng-bind-html="content.label" data-uib-tooltip-html="content.tooltip"></label>
						</div>
					</div>
					<div class="col-xs-6 col-md-6 col-lg-6">
						<div class="row" data-ng-repeat="content in ibmiInputs.subclientContentList | limitTo: ibmiInputs.subclientContentList.length/2: ibmiInputs.subclientContentList.length/2 + 1">
							<input type="checkbox" ng-disabled="content.disabled" id="{{content.customSubclientContentFlags}}" name="{{content.customSubclientContentFlags}}"  data-ng-model="content.selected" data-ng-change="changeCustomSubclientContentFlags()"/>
							<label for="{{content.customSubclientContentFlags}}" data-ng-bind-html="content.label" data-uib-tooltip-html="content.tooltip"></label>
						</div>
					</div>
				</div>
				<div data-ng-if="!isIBMiSubclient || detailedContentEntityList.ibmiContent.customSubclientFlag">
					<div class="form-group row">
						<div class="col-xs-12 col-md-9 col-lg-9" data-ng-if="detailedContentEntityList.typeWiseCounterArray[0].counter==0">
							<cv:msg key="label.NoContentAdded" bundle="clients" />
						</div>
					</div>
					<div class="limit-modal-height border-on" data-ng-if="detailedContentEntityList.typeWiseCounterArray[0].counter>0">
						<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in detailedContentEntityList.contentEntities" data-ng-if="contentEntity.type == 0"> <!-- TAB INDEX: 0 - CONTENTS -->
							<li data-ng-bind="contentEntity.path" class="content-entry float-left"></li>
							<li class="delete-content float-left"><span class="delete-row"><a href="" data-ng-click="removeFromSubclientContent(contentEntity)" title="Delete content {{contentEntity.path}}">&times;</a></span></li>
						</ul>
					</div>
					<div class="form-group row">
						<div class="col-xs-12 text-center">
							<button id="manageFSSubclientContentModal_button_#4186" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="browseClient()"><cv:msg key="label.browse" bundle="restore" /></button> 
							<button id="manageFSSubclientContentModal_button_#4693" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addPaths()"><cv:msg key="label.AddPaths" bundle="fs" /></button> 
							<button id="manageFSSubclientContentModal_button_#6688" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="showEditCredentials()" data-ng-if="showAsUser && model.accordionStatus.contentTab"><cv:msg key="label.asUser" bundle="clients" /></button> 
						</div>
					</div>
				</div>
				</div>
				<!-- // content end // -->
				<!-- // exclusions start // -->
				<div uib-accordion-group is-open="model.accordionStatus.exclusionsTab" data-scroll-to-when-open>
				<uib-accordion-heading><cv:msg key="label.Exclusions" bundle="fs" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.exclusionsTab, 'glyphicon-chevron-right': !model.accordionStatus.exclusionsTab}"></i>
				</uib-accordion-heading>
				<div class="form-group row">
					<div class="col-xs-12 col-md-9 col-lg-9" data-ng-if="detailedContentEntityList.typeWiseCounterArray[1].counter==0 && detailedContentEntityList.typeWiseCounterArray[3].counter==0">
						<cv:msg key="label.NoContentAdded" bundle="clients" />
					</div>
				</div>
				<div class="limit-modal-height border-on" data-ng-if="detailedContentEntityList.typeWiseCounterArray[1].counter>0 || detailedContentEntityList.typeWiseCounterArray[3].counter>0">
					<div data-ng-if = "useGlobalFilters !== 'OFF'">				
						<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in detailedContentEntityList.contentEntities" data-ng-if="contentEntity.type == 3"><!-- TAB INDEX: 1 - Global exceptions come under exclusions -->
							<li class="inheritedSecurityAssociation" data-ng-bind="contentEntity.path" class="content-entry float-left"></li>
						</ul>
					</div>
					<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in detailedContentEntityList.contentEntities" data-ng-if="contentEntity.type == 1"><!-- TAB INDEX: 1 - EXCLUSIONS -->
						<li data-ng-bind="contentEntity.path" class="content-entry float-left"></li>
						<li class="delete-content float-left"><span class="delete-row"><a href="" data-ng-click="removeFromSubclientContent(contentEntity)" title="Delete exclusion {{contentEntity.path}}">&times;</a></span></li>
					</ul>
				</div>
				<div class="form-group row">
					<div class="col-xs-12 text-center">
						<button id="manageFSSubclientContentModal_button_#7366" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="browseClient()"><cv:msg key="label.browse" bundle="restore" /></button> 
						<button id="manageFSSubclientContentModal_button_#0995" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addPaths()"><cv:msg key="label.AddPaths" bundle="fs" /></button> 
						<%-- <button id="manageFSSubclientContentModal_button_#0057" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="showEditCredentials()" data-ng-if="showAsUser && model.accordionStatus.contentTab"><cv:msg key="label.asUser" bundle="clients" /></button> --%>  --%>
					</div>
				</div>
				</div>
				<!-- // exclusions end // -->
				<!-- // exceptions start // -->
				<div uib-accordion-group is-open="model.accordionStatus.exceptionsTab" data-scroll-to-when-open>
				<uib-accordion-heading><cv:msg key="label.Exceptions" bundle="fs" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.exceptionsTab, 'glyphicon-chevron-right': !model.accordionStatus.exceptionsTab}"></i>
				</uib-accordion-heading>
				<div class="form-group row">
					<div class="col-xs-12 col-md-9 col-lg-9" data-ng-if="detailedContentEntityList.typeWiseCounterArray[2].counter==0">
						<cv:msg key="label.NoContentAdded" bundle="clients" />
					</div>
				</div>
				<div class="limit-modal-height border-on" data-ng-if="detailedContentEntityList.typeWiseCounterArray[2].counter>0">
					<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in detailedContentEntityList.contentEntities" data-ng-if="contentEntity.type == 2"><!-- TAB INDEX: 2 - EXCEPTIONS -->
						<li data-ng-bind="contentEntity.path" class="content-entry float-left"></li>
						<li class="delete-content float-left"><span class="delete-row"><a href="" data-ng-click="removeFromSubclientContent(contentEntity)" title="Delete exception {{contentEntity.path}}">&times;</a></span></li>
					</ul>
				</div>
				<div class="form-group row">
					<div class="col-xs-12 text-center">
						<button id="manageFSSubclientContentModal_button_#7343" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="browseClient()"><cv:msg key="label.browse" bundle="restore" /></button> 
						<button id="manageFSSubclientContentModal_button_#5679" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addPaths()"><cv:msg key="label.AddPaths" bundle="fs" /></button> 
						<%-- <button id="manageFSSubclientContentModal_button_#4460" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="showEditCredentials()" data-ng-if="showAsUser && model.accordionStatus.contentTab"><cv:msg key="label.asUser" bundle="clients" /></button> --%>
					</div>
				</div>
				</div>
				<!-- // exceptions end // -->
			<%-- <button id="manageFSSubclientContentModal_button_#9500" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="browseClient()"><cv:msg key="label.browse" bundle="restore" /></button> 
			<button id="manageFSSubclientContentModal_button_#5470" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addPaths()"><cv:msg key="label.AddPaths" bundle="fs" /></button> 
			<button id="manageFSSubclientContentModal_button_#9596" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="showEditCredentials()" data-ng-if="showAsUser && model.accordionStatus.contentTab"><cv:msg key="label.asUser" bundle="clients" /></button> --%>
            <br />
            <div class="extra-top-padding">
				<input type="checkbox" id="backupSystemState" name="backupSystemState" data-ng-model="backupConfig.backupSystemState" data-ng-show = "showSystemStateBackup"/>
				<label for="backupSystemState" data-ng-show = "showSystemStateBackup"><cv:msg key="label.backupSystemState" bundle="fs" />
				<span class="help-block" data-ng-show="checkForSystemStateSubclient()"><cv:msg key="error.duplicateSystemStateSubclient" bundle="fs"/></span></label>
			</div>
			
				
		
		</uib-accordion>
		</div>
		<div class="panel" ng-show="openVMSProperties.isOpenVMSClient">
			<div class="panel-body">
				<div class="form-group">
				</div>
				<div class="form-group">
					<input type="checkbox" id="enableDateAttribute" name="enableDateAttribute" ng-model="openVMSProperties.isopenVMSDateAttributeEnabled">
					<label for="enableDateAttribute"><cv:msg key="label.enableDateAttribute" bundle="fs"/></label>
				</div>
			</div>
		</div>
		
		
		<div data-ng-if='!isIBMiSubclient'>
			<div class="form-group row modal-list">
				<div class="col-xs-12 col-md-12 col-lg-12">
				<div data-ng-if='contentEntities && contentOptions'>							
					<cv-content-selection
					data-options= 'contentOptions'
					data-content-entities= 'contentEntities'>
					</cv-content-selection>	
				</div>
				</div>
			</div>		
		</div>
	</div>
            <div class="button-container">
                <button id="manageFSSubclientContentModal_button_#3705" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
                <button id="manageFSSubclientContentModal_button_#1818" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages" /></button> 
            </div>
		</form>
</div>
