<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvEnum name="App.CipherTypeDef"></cv:cvEnum>
	<cv:cvEnum name="App.EncryptionSettings"></cv:cvEnum>
	<cv:cvEnum name="App.CipherDirectMediaAccess"></cv:cvEnum>
</script>
<div>
	<div class='setup-title'>
		<h1><cv:msg key="pageHeader.manageEncryptionSetting" bundle="security" /></h1>
	</div>
	<div data-ng-if="manageEncryptionCtrl.serverMessage" class="text-center ok col-sm-12 {{manageEncryptionCtrl.serverMessage.type}} serverMessage"  data-ng-bind="manageEncryptionCtrl.serverMessage.message" style=""></div>
	<form data-ng-init="manageEncryptionCtrl.init()" name="manageEncryptionSettingForm" novalidate autocomplete="off"
	data-cv-submit="manageEncryptionCtrl.submitEdittingEncryptionSetting()"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper">
		<div class="modal-body cv-grid-modal-container">
			<div class="form-group">
				<label for="useStoragePolicy">
					<input type="radio"
						id="useStoragePolicy"
						name="useStoragePolicy"
						value="USE_SPSETTINGS"
						data-ng-model="manageEncryptionCtrl.encryptionInfo.encryptionSettings"
						data-ng-change="manageEncryptionCtrl.changeEncryptionPolicy(manageEncryptionCtrl.encryptionInfo.encryptionSettings)" />
					<span class="padding-left-10"><cv:msg key="label.encryption.storagePolicySetting" bundle="security" /></span>
				</label>
			</div>
			<div class="form-group">
				<label for="customizedEncryptionSetting">
					<input type="radio"
						id="customizedEncryptionSetting"
						name="customizedEncryptionSetting"
						value="ON_CLIENT"
						data-ng-model="manageEncryptionCtrl.encryptionInfo.encryptionSettings"
						data-ng-change="manageEncryptionCtrl.changeEncryptionPolicy(manageEncryptionCtrl.encryptionInfo.encryptionSettings)" />
					<span class="padding-left-10"><cv:msg key="label.encryption.customizedSetting" bundle="security" /></span>
				</label>
				<div class="panel-body">
					<div class="cv-grid-modal-container" data-ng-disabled="manageEncryptionCtrl.disableCustomizeOption">
						<span class="col-xs-12" for="dataEncryptionAlgorithm">
							<cv:msg key="label.dataEncryptionAlgorithm" bundle="security" />
						</span>
						<div class="row">
							<div class="col-xs-6">
								<div class="col-xs-6 no-padding">
									<label for="encryptionCipher"><cv:msg key="label.cipher" bundle="security" /></label>
								</div>
								<div class="col-xs-6 no-padding">
									<select id="encryptionCipher" name="encryptionCipher"
										data-ng-options="item as item for item in manageEncryptionCtrl.cipherTypeList"
										data-ng-model="manageEncryptionCtrl.encryptionInfo.cipherType"
										data-ng-change="manageEncryptionCtrl.cipherTypeOptionChanged(manageEncryptionCtrl.encryptionInfo.cipherType)"></select>
								</div>
							</div>
							<div class="col-xs-6 no-padding">
								<div class="col-xs-6">
									<label for="keyLength"><cv:msg key="label.keyLength" bundle="security" /></label>
								</div>
								<div class="col-xs-6 no-padding">
									<select id="keyLength" name="keyLength" 
										data-ng-options="item as item for item in manageEncryptionCtrl.encryptKeyList"
										data-ng-model="manageEncryptionCtrl.encryptionInfo.encryptKeyLength" ></select>
								</div>
							</div>
						</div>
						<span class="col-xs-12" for="directMediaAccess">
							<cv:msg key="label.directMediaAccess" bundle="security" />
						</span>
						<div class="col-xs-12">
							<label for="viaMediaPassword">
								<input type="radio"
									id="viaMediaPassword"
									name="viaMediaPassword"
									value="Regular"
									data-ng-model="manageEncryptionCtrl.encryptionInfo.directMediaAccess"
									data-ng-change="manageEncryptionCtrl.changeMediaAccess(manageEncryptionCtrl.encryptionInfo.directMediaAccess)" />
								<span class="padding-left-10"><cv:msg key="label.viaMediaPassword" bundle="security" />
									<br/>
									<span class="subtext-unspaced medium-size italic"><cv:msg key="label.viaMediaPasswordHelpText" bundle="security" /></span>
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<label for="noAccess">
								<input type="radio"
									id="noAccess"
									name="noAccess"
									value="None"
									data-ng-model="manageEncryptionCtrl.encryptionInfo.directMediaAccess"
									data-ng-change="manageEncryptionCtrl.changeMediaAccess(manageEncryptionCtrl.encryptionInfo.directMediaAccess)" />
								<span class="padding-left-10"><cv:msg key="label.noAccess" bundle="security" />
									<br/>
									<span class="subtext-unspaced medium-size italic"><cv:msg key="label.noAccessHelpText" bundle="security" /></span>
								</span>
							</label>
						</div>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label  for="notUseEncryption">
					<input type="radio"
						id="notUseEncryption"
						name="notUseEncryption"
						value="OFF"
						data-ng-model="manageEncryptionCtrl.encryptionInfo.encryptionSettings"
						data-ng-change="manageEncryptionCtrl.changeEncryptionPolicy(manageEncryptionCtrl.encryptionInfo.encryptionSettings)" />
					<span class="padding-left-10"><cv:msg key="label.encryption.doNotEncrypt" bundle="security" /></span>
				</label>
			</div>
		</div>
		<fmt:bundle basename="localization.users">
			<div class="modal-footer">
				<button id="manageEncryptionSetting_button_#5378" type='button' class='btn btn-default cvBusyOnAjax' 
					data-ng-click='manageEncryptionCtrl.cancelEditting()'>
					<fmt:message key="action.cancel" />
				</button>
				<button id="manageEncryptionSetting_button_#7142" data-ng-disabled="manageEncryptionCtrl.serverMessage" type='submit' 
					class='btn btn-primary cvBusyOnAjax'>
					<fmt:message key="action.save" />
				</button>
			</div>
		</fmt:bundle>
	</form>
</div>