<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="title.addMediaAgent" bundle="storage"/>
		<cv-help-component help-text="{{addMediaAgentHelpText}}"></cv-help-component>
	</h1>
</div>
<div id="maShareWizard" class="setup-content user-edit-content mount-path-select" data-ng-controller="wizardController">
	<form name="storageForm" data-ng-class="[typeOfStorage.type]" novalidate data-cv-submit="next()" autocomplete="off">
		<div id="wizardHolder" class="wizard-content padding-bottom-0">
			<script type="text/ng-template" id="step1.html">
				<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
				<div data-ng-if="!flagShowGrid" class="ajax-loader-container">
					<span data-cv-loading-spinner data-ng-model="loader"></span>
				</div>
				<div class="grid-container">
					<cv-kendo-grid data-cv-grid-options="kendGridOptions.gridOptions" ng-show="flagShowGrid">
					</cv-kendo-grid>				
				</div>
			</script>
			<script type="text/ng-template" id="step2.html">
				<div class="setup-content">
					<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
						<label>
							<cv:msg key="Name" bundle="storage"/>
							<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" data-ng-readonly="action=='shareDisk'" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName"  data-ng-disabled="action=='shareDisk'" required maxlength="128"/>
							<span class="help-block" data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
							<span class="help-block" data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.libraryName.length" bundle="storage"/></span>
						</label>
						<div class="storage-type" data-ng-hide="!windowsOS">
							<label>
								<input type="radio" data-ng-model="typeOfStorage.type" value="localStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()">
								<cv:msg key="Local_Path" bundle="storage"/>
							</label>
							<label>
								<input type="radio" data-ng-model="typeOfStorage.type" value="networkStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()">
								<cv:msg key="Network_Path" bundle="storage"/>
							</label>
						</div>
						<div data-ng-if="typeOfStorage.type=='networkStorage'" class="credentials">
							<div data-ng-show="showUsernamePassword">
								<label>
									<cv:msg key="User Name" bundle="storage"/>
									<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.loginName)}" type="text" name=loginName data-ng-model="libraryInfo.loginName" data-ng-required="showUsernamePassword"/>
									<span class="help-block" data-ng-show="storageForm.loginName.$error.required && cv.storageForm.needsAttention(storageForm.loginName)"><cv:msg key="error.loginName.required" bundle="storage"/></span>
								</label>
								<label>
									<cv:msg key="Password" bundle="storage"/>
									<input type="password" data-ng-model="libraryInfo.password"/>
								</label>
							</div>
							<div>
								<label class="select-label" for="credential"> <cv:msg key="label.credential" bundle="users"/>					
									<select id="credential" name="credential" data-ng-model="libraryInfo.selectedCredential" 
									data-ng-options="cred as cred.credentialName for cred in savedCredentials track by cred.credentialId" data-ng-required="!showUsernamePassword"
									data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.credential)}">
										<option value=""><cv:msg key="placeholder.credential" bundle="storage"/></option>
									</select>
									<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.credential)"><cv:msg key="error.credential.required" bundle="storage"/></span>
								</label>
							</div>
						</div>
						<label for="mountPath" data-ng-class="{'storage-path-label': typeOfStorage.type=='localStorage'}">
							<cv:msg key="Path" bundle="storage"/>
							<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern.pattern' data-ng-init="setForm(storageForm)"/>
							<span class="help-block" data-ng-value="form-error" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><cv:msg key="error.mountpath.required" bundle="storage"/></span>
		
							<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
								<cv:msg key="error.mountpath.invalid" bundle="storage"/>
							</span>
						</label>
						<button id="maShareWizard_button_#8369" type="button" data-ng-if="typeOfStorage.type=='localStorage'" data-ng-click="browse()" class="btn btn-default browse-btn"> 
							<cv:msg key="Browse" bundle="storage"/>
						</button>
						<span>
							<div class="storage-type">
								<label for="editAllowed"><cv:msg key="label.editMaximumAllowedWriters" bundle="storage"/></label>
		
								<label style="display:block">
									<input type="radio" data-ng-model="libraryInfo.writersNumber.maxWriters" data-ng-value="-1" name="allowedWriters">
										<cv:msg key="label.maximumAllowedWriters" bundle="storage"/>
								</label>
								<label class="float-left">
									<input type="radio" data-ng-model="libraryInfo.writersNumber.maxWriters" data-ng-value="0" name="allowedWriters">
										<cv:msg key="label.allocateNumberOfWriters" bundle="storage"/>
								</label>
								<div data-ng-if="libraryInfo.writersNumber.maxWriters!='-1'">
									<label for="allowedWritersNumber">
										<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.allowedWritersNumber)}" id="allowedWritersNumber" name="allowedWritersNumber" type="number" data-ng-value="5" data-ng-model="libraryInfo.writersNumber.allowedWritersNumber" min="1" max="999" data-ng-maxlength="3" />
										<span class="help-block" data-ng-show="storageForm.allowedWritersNumber.$invalid && cv.storageForm.needsAttention(storageForm.allowedWritersNumber)">
											<cv:msg key="error.numWriters" bundle="storage"/>
										</span>
									</label>
								</div>
							</div>
							<div>
								<input id="preferred" type="checkbox" data-ng-model="libraryInfo.preferred" >
									<label for="preferred" style="clear:both">
										<cv:msg key="label.disableForWrite" bundle="storage"/>
									</label>
							</div>
								<input id="enable" type="checkbox" data-ng-model="libraryInfo.enabled" >
									<label for="enable" style="clear:both">
										<cv:msg key="label.enable" bundle="storage"/>
									</label>
						</span>
						<button type="submit" class="btn btn-primary cvBusyOnAjax hidden" id="btnSubmit"></button>
				</div>
			</script>
		</div>
		<div class="button-container">
			<button id="maShareWizard_button_#9115" type="button" class="btn btn-default setup-btn--hidden" 
				data-ng-show='currStep==1' data-ng-click="prev()">{{getPrevBtnText()}}</button>
				<button id="maShareWizard_button_#7900" type="button" class="btn btn-default setup-btn--hidden" 
				data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="storage"/></button>
			<button id="maShareWizard_button_#0262" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!selected.saveButtonEnable">{{getNextBtnText()}}</button>
		</div>
	</form>
	<div data-ng-repeat="step in steps track by $index">
		<div data-ng-include="step" data-ng-show="$index == currStep"></div>
	</div>
</div>
