<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
        <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
        <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
        <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
        <cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
        <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
        <cv:cvMessages bundle="localization.dr"></cv:cvMessages>
        <cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>
            <cv:msg key="label.disasterRecovery" bundle="dr"/>
        </h1>
	</div>
	<span class="ibmiDRC.serverMessage {{ibmiDRC.serverMessage.type}}" data-ng-bind="ibmiDRC.serverMessage.message"></span>
	<form name="disasterRecovery" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="ibmiDRC.submit()">

        <div class="panel panel-default">
            <div class="panel-body">
                <div class="form-group">

                    <label class="col-xs-12 col-sm-5">
                        <cv:msg key="label.destinationClient" bundle="blrJs"/>
                    </label>

                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select 
                        directive-id="destinationClients" 
                        input-model="ibmiDRC.destinationClientsInputModel"
                        output-model="ibmiDRC.destinationClientOutputModel"
                        button-label="displayName"
                        item-label="displayName"
                        selection-mode="single"
                        tick-property="selected"
                        translation="ibmiDRC.localLang"
                        helper-elements="filter"
                        search-property="displayName clientName hostName"
                        min-search-length="1"
                        is-required="true">
                        </isteven-multi-select>
                    </div>

                </div>

                <div class="form-group">

                    <label class="col-xs-12 col-sm-5">
                        <cv:msg key="label.backupset" bundle="dr"/>
                    </label>

                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select 
                        directive-id="backupsets" 
                        input-model="ibmiDRC.backupSetsInputModel"
                        output-model="ibmiDRC.backupSetOutputModel"
                        button-label="backupSetName"
                        item-label="backupSetName"
                        selection-mode="single"
                        tick-property="selected"
                        translation="ibmiDRC.localLang"
                        helper-elements="filter"
                        search-property="backupSetName"
                        min-search-length="1"
                        is-required="true">
                        </isteven-multi-select>
                    </div>

                </div>

                <div class="form-group">

                    <label class="col-xs-12 col-sm-5">
                        <cv:msg key="label.job" bundle="dr"/>
                    </label>

                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select 
                        directive-id="oneTouchBackupJobs" 
                        input-model="ibmiDRC.jobsInputModal"
                        output-model="ibmiDRC.jobOutputModal"
                        class="isteven-multi-select user-group-select isteven-summary-dropdown"
                        button-label="jobId"
                        html-template="true"
                        item-label="jobDescription"
                        selection-mode="single"
                        tick-property="selected"
                        translation="ibmiDRC.localLang"
                        helper-elements="filter"
                        search-property="jobId"
                        min-search-length="1"
                        is-required="true">
                        </isteven-multi-select>
                        <span class="cv-help-block" data-ng-show="ibmiDRC.noJobFound">
                            <cv:msg key="error.noJobFound" bundle="dr"/>
                        </span>
                    </div>


                </div>

                <div class="form-group">
                    <label class="col-xs-12 col-sm-5">
                        <cv:msg key="label.restoreDVDImages" bundle="clients"/>
                    </label>

                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select 
                        directive-id="fsClients" 
                        input-model="ibmiDRC.fsClientsInputModal"
                        output-model="ibmiDRC.fsClientOutputModal"
                        button-label="displayName"
                        item-label="displayName"
                        selection-mode="single"
                        tick-property="selected"
                        translation="ibmiDRC.localLang"
                        helper-elements="filter"
                        search-property="displayName clientName clientId hostName"
                        min-search-length="1"
                        is-required="true">
                        </isteven-multi-select>

                        <span class="cv-help-block" data-ng-show="disasterRecovery.fsClients.$invalid && disasterRecovery.$submitted">
                            <cv:msg key="error.pleaseSelectaClient" bundle="dr" />
                        </span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-xs-12 col-sm-5">
                        <cv:msg key="label.destinationPath" bundle="dr"/>
                    </label>
                    <div class="col-xs-10 col-sm-6">
                        <input 
                        type="text" 
                        id="restorePath" 
                        name="restorePath"
                        for="restorePath"
                        data-ng-model="ibmiDRC.logPath"
                        required
                        />
                        <span class="cv-help-block" data-ng-show="disasterRecovery.restorePath.$invalid && disasterRecovery.$submitted">
                            <cv:msg key="error.specifyPath" bundle="dr" />
                        </span>
                    </div>
                    <div class="col-xs-2 col-sm-1">
                        <cv-machine-browse 
                        class="upload-button"
                        button-label="<cv:msg key='label.browse' bundle='restore'/>"
                        client-id={{ibmiDRC.fsClientOutputModal[0].clientId}}
                        result-function="ibmiDRC.storeDVDImagePath" 
                        can-create-folder="true"
                        />
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-xs-12 col-sm-5">
                       <cv:msg key="label.copyPrecedence2" bundle="dr"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <input 
                        type="number" 
                        id="copyPrecedence" 
                        name="copyPrecedence" 
                        min="0" 
                        max="99"
                        data-ng-model="ibmiDRC.copyPrecedence"
                        required
                        />
                        <span data-ng-show="disasterRecovery.copyPrecedence.$invalid" class="cv-help-block">
                            <cv:msg key="error.copyPrecedence" bundle="dr" />
                        </span>
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-xs-12 col-sm-5">
                        <label><cv:msg key="label.logOutputDestination" bundle="clients"/></label>
                        <span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>
                    </div>
                    <div class="col-xs-12 col-sm-7">
                        <input
                         type="text"
                         id="outputPath" 
                         name="outputPath" 
                         data-ng-model="ibmiDRC.logOutput">
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-xs-12 col-sm-5">
                        <cv-checkbox 
                        checkbox-model="ibmiDRC.splfdta" 
                        checkbox-label="label.splftda" 
                        checkbox-name="splftda"
                        checkbox-id="splftda"
                        />
                    </div>
                </div>
            </div>
        </div>


        <div class="modal-footer">
            <button 
            type="button" 
            class="btn btn-default cvBusyOnAjax" 
            data-ng-click="ibmiDRC.cancel()"> 
                <cv:msg key="Cancel" bundle="messages"/>
            </button>

            <button  
            type="submit" 
            class="btn btn-primary cvBusyOnAjax"
            ng-disabled="disasterRecovery.backupsets.$invalid && 
                    disasterRecovery.destinationClients.$invalid &&
                    disasterRecovery.oneTouchBackupJobs.$invalid">
                <cv:msg key="Submit" bundle="messages"/> 
            </button>
        </div>
    </form>
</div>