<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-controller="restoreController">
	<div data-ng-if="select2Override">
		<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/select2Overrides.css?${applicationScope.BUILD_TS}" />
	</div>
	<div class="setup-title">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>

	<div class="setup-content" >
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div class="loading-data margin-top-15" data-ng-if="!clientDetailsLoaded">
			<div class="loader-skeleton tile-style margin-bottom-15"></div>
			<div class="loader-skeleton tile-style margin-bottom-5"></div>
		</div>
		<form name="restoreForm" class="restore-form" novalidate data-cv-submit="checkAndRestore()" autocomplete="off" data-ng-if="clientDetailsLoaded">

			<!-- For Destination Severs -->
			<div class="global-options destinationServerDiv">
				<label  data-ng-if ="browseType != 'fsFileBrowse' &&  browseType != 'nasBrowse' && browseType != 'clusterBrowse'" for="destinationServer" class="select-label restorePathLabel" >
					<cv:msg key="label.destClient" bundle="oracle"/>
					<select id="destinationServer" name="destinationServer"  data-ng-required="true"
							data-ng-model="restoreData.globalOptions.destinationServer"
							data-ng-options="ds as (ds.displayName || ds.clientName) for ds in restoreData.globalOptions.destinationServerList | orderBy:'clientName' track by (ds.clientName|lowercase)"
							data-ng-change="destinationServerChanged()" >
							<option value=""><cv:msg key="placeholder.selectDestinationHost" bundle="restoreJs"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
							<cv:msg key="error.destinationServer" bundle="restore"/>
					</span>
				</label>
				<label  data-ng-if ="browseType == 'fsFileBrowse' || browseType == 'nasBrowse' || browseType == 'clusterBrowse'" for="destinationServer" class="restorePathLabel" >
					<cv:msg key="label.fsServer" bundle="restore"/>
					<div class="company-multi-select" data-ng-if="!select2Override">
						<isteven-multi-select id="destinationServer"
									input-model="restoreData.globalOptions.destinationServerList"
									output-model="destinationServer"
									button-label="name"
									item-label="name"
									tick-property="selected"
									selection-mode="single"
									directive-id="destinationServer"
									class="isteven-multi-select user-group-select single-select"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="destinationClientLocalLang"
									on-item-click="destinationServerChanged(destinationServer[0])"
									group-property="msGroup">
						</isteven-multi-select>
					</div>
					<input data-ng-if="select2Override" type="text" id="select2DestinationList" class="select2Overrides"/>
					<span data-ng-show="(restoreAttempted && !restoreData.globalOptions.destinationServer)">
						<span class="help-block" data-ng-if="!isNASNetworkShareClient">
							<cv:msg key="error.fsServer" bundle="restore"/>
						</span>
						<span class="help-block" data-ng-if="isNASNetworkShareClient">
							<cv:msg key="error.fsServerNas" bundle="restore"/>
						</span>
					</span>
				</label>
			</div>

			<div data-ng-if="!isCloudStorageApp && isRestoreACLSTypeSupported" class="bootstrap-wrapper padding-bottom-35">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4 margin-left-5"><cv:msg key="label.restore" bundle="restore" /></label>
					<div class="col-xs-12 col-sm-7 margin-left-25">
						<div class="multiple-checkbox-group">
							<input name="acls" id="acls" type="checkbox" ng-model="aclsTypeCBModel.acl" data-ng-change="restoreACLsTypeClick()" ng-true-value="'{{RESTORE_ACLS_TYPE.ACL_ONLY}}'" />
							<label for="acls"><cv:msg key="label.acls" bundle="restore"/></label>
						</div>
						<div class="multiple-checkbox-group">
							<input name="data" id="data" type="checkbox" ng-model="aclsTypeCBModel.data" data-ng-change="restoreACLsTypeClick()" ng-true-value="'{{RESTORE_ACLS_TYPE.DATA_ONLY}}'" />
							<label for="data"><cv:msg key="label.data" bundle="restore"/></label>
						</div>
						<span class="help-block" ng-show="invalidRestoreACLsTypeSelection">
                        	<cv:msg key="error.restoreTypeRequired" bundle="restore"/>
						</span>
					</div>
				</div>
			</div>

			<div class="global-options remove-border-padding">
                <div style="clear:both;" data-ng-if="isOnePassSc">
                    <input name="restoreDataInsteadOfStub" id="restoreDataInsteadOfStub" type="checkbox"  ng-model="restoreData.globalOptions.restoreDataInsteadOfStub" ng-disabled="disableRestoreDataInsteadOfStub" >
                    <label for="restoreDataInsteadOfStub" class="overwriteLabel">
                    	<cv:msg key="label.restoreDataInsteadStub" bundle="restore"/>
                    </label>
                </div>
				<div style="clear:both;" data-ng-disabled="!restoreToOriginalFolderEnabled">
					<input name="inplace" id="inplace" type="checkbox"  data-ng-model="restoreData.globalOptions.restoreToOriginalPath" >
					<label for="inplace" class="overwriteLabel">
						<cv:msg key="label.restoreToOriginal" bundle="restore"/>
					</label>
				</div>


				<div style="clear:both;" data-ng-if=displaySkipAppendingVersionOption>
                    <input name="skipAppendingVersion" id="skipAppendingVersion" type="checkbox"  ng-model="restoreData.globalOptions.skipAppendingVersion" >
                    <label for="skipAppendingVersion" class="overwriteLabel">
                    	<cv:msg key="label.skipAppendingVersion" bundle="restore"/>
                    </label>
                </div>

				<label for="restorePath" class="restorePathLabel">
					<cv:msg key="label.destPath" bundle="snapArray"/>
					<button id="fsRestoreOptions_button_#6719" type="button"
						data-ng-click="openSelectDestinationFolder(restoreData.subClientEntity)"
						class="btn btn-default browse-btn" data-ng-disabled = "restoreData.globalOptions.restoreToOriginalPath" data-ng-hide="restoreData.globalOptions.disableDestinationPathBrowse">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
					<input type="text" name="restorePath" id="restorePath" data-ng-model="restoreData.selectedPath" data-ng-disabled = "restoreData.globalOptions.restoreToOriginalPath" data-ng-required="!restoreData.globalOptions.restoreToOriginalPath" data-ng-class="{'browse-btn-hidden':restoreData.globalOptions.disableDestinationPathBrowse}">
						<span class="help-block" data-ng-show="isRestoreDestinationPathNeeded() && cv.restoreForm.needsAttention(restoreForm.restorePath)">
							<cv:msg key="error.pathRequired" bundle="restore"/>
						</span>
                    	<span class="help-block" ng-show="isRestoreDestinationPathNeeded() && invalidDestinationPath">
                        	<cv:msg key="error.invalidPath" bundle="clients"/>
						</span>
					</input>
				</label>
				<label style="clear:both;" data-ng-if="isCloudStorageApp">
					<cv:msg key="label.noOfStreams" bundle="cloudStorageApp" />
					<input type="number" data-ng-model="restoreData.globalOptions.noOfStreams" id="restoreStreams" name="restoreStreams" min="2" max="100" />
					<span class="help-block" data-ng-show="!restoreData.globalOptions.noOfStreams">
	                	<cv:msg key="error.numberOfRestoreStreams" bundle="restore" />
	           	 	</span>
           	 	</label>
				<div style="clear:both;" data-ng-if="isOverRideOptionValid">
					<input name="overwrite" id="overwrite" type="checkbox"  data-ng-model="restoreData.globalOptions.overwrite">
					<label for="overwrite" class="overwriteLabel"><cv:msg key="warning.overwrite" bundle="restore"/></label>
				</div>
			</div>
			<div class="form-group row" data-ng-if="isCredentialsValid">
				<div class="col-sm-12">
					<label data-ng-click="toggleImpersonateUser()">
						<toggle-control status="restoreData.globalOptions.impersonateUser ? 'enabled-activity' : 'disabled-activity'" title="Enable/Disable">
						</toggle-control>
						<span>
							<cv:msg key="label.impersonateUser" bundle="restore" />
						</span>
					</label>
					<div data-ng-if="restoreData.globalOptions.impersonateUser">
						<label>
							<cv:msg key="label.username" bundle="restore" />
							<input type="text" name="impersonateUserName" autocomplete="new-password" data-ng-model="restoreData.globalOptions.impersonateUserName"
							data-ng-required="isUserImpersonationNeeded()" />
							<span class="help-block" data-ng-show="isUserImpersonationNeeded() && cv.restoreForm.needsAttention(restoreForm.impersonateUserName)">
								<cv:msg key="error.userNameRequired" bundle="restore" />
							</span>
						</label>
						<label>
							<cv:msg key="label.password" bundle="restore" />
							<input type="password" name="impersonatePassword" autocomplete="new-password" data-ng-model="restoreData.globalOptions.impersonatePassword"
							data-ng-required="isUserImpersonationNeeded()" />
							<span class="help-block" data-ng-show="isUserImpersonationNeeded() && cv.restoreForm.needsAttention(restoreForm.impersonatePassword)">
								<cv:msg key="error.uncPasswordRequired" bundle="restore" />
							</span>
						</label>
					</div>
				</div>
				<label class="col-sm-12 global-options remove-border-padding">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</label>
			</div>
			<div class="button-container">
				<button id="fsRestoreOptions_button_#2762" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
				<button id="fsRestoreOptions_button_#9826" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
			</div>
		</form>
	</div>
</div>