<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div data-ng-if="(!usePoliciesForSubclient && !showPlans)">
	<cv:msg key="error.noPlanOrPolicy" bundle="clients" />
</div>
<div data-ng-if="(usePoliciesForSubclient || showPlans)" class="bootstrap-wrapper form-horizontal padding-bottom-0" data-ng-class="{'bootstrap-wrapper': !noBootstrapWrapperClass}">
<p data-ng-if="serverMessage" class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
<h4 data-ng-if="!editPolicies && !hidePlanPolicyToggleOption"><cv:msg key="header.backupConfiguration" bundle="clients" /></h4> <!-- // class="margin-left-15" // -->
<div class="form-group row" data-ng-if="showPlanPolicyToggle">
	<div class="col-xs-12 col-md-1 col-lg-1" data-ng-click="toggleSubclientCreationMode()">
		<toggle-control
			status="planModeEnabled ? 'enabled-activity' : 'disabled-activity'"
			title="{{'label.enableDisable' | cvLoc}}">
		</toggle-control>
	</div>
	<label class="col-xs-12 col-md-11 col-lg-11" for="storage" data-ng-click="toggleSubclientCreationMode()"><cv:msg key="header.useBackupPlan" bundle="clients" /></label>
</div>
<div data-ng-if="!planModeEnabled && enableContentView" data-ng-class="wrapperClass">
	<label  data-ng-class="labelClass" for="selectBackupOptions">
		<cv:msg key="label.backupContent" bundle="profiles" />
	</label>
	<div data-ng-class="selectClass">
		<select id="selectBackupOptions" data-ng-model="model.backupContent" data-ng-change="model.backupContentError.showError = false" ng-options="backupContentOption.label for backupContentOption in backupContentOptions"></select>
		<span class="help-block" data-ng-show="model.backupContentError.showError" data-ng-bind="model.backupContentError.errorMsg"></span>
	</div>
</div>
<div data-ng-if="planModeEnabled" data-ng-class="wrapperClass">
	<label data-ng-class="labelClass" for="entity-plan-policy-plan-select-{{$id}}">
		{{planLabel}}
	</label>
	 <label data-ng-if="!planLoaded" class="col-xs-12 col-sm-7">
    	<cv:msg key="Loading" bundle="messages"/>
	</label>
	<label data-ng-if="planLoaded && !model.plan">
		<cv:msg key="label.noPlanAvailable" bundle="clients"/>
	</label>
	<!-- start: implement isteven for plans -->
	<div data-ng-if="planLoaded && model.plan" data-ng-class="selectClass">
		<cv-plan-summary-dropdown
			input-model="model.plan.list"
			output-model="model.plan.istSelected"
			button-label="'name'"
			item-label="'name'"
			tick-property="'selected'"
			selection-mode="'single'"
			helper-elements="'filter'"
			directive-id="backupPlan"
			on-close="parseIStevenOutput(model.plan)"
			on-item-click="model.plan.onChange()"
			translation="planLocal"
			search-property="name"
			group-property="'msGroup'">
		</cv-plan-summary-dropdown>
		<span class="help-block" data-ng-show="(submitAttempted && !model.plan.selected.id) || model.plan.showError" data-ng-bind="model.plan.errorMsg"></span>
	</div>
	<!-- end: implement isteven for FS -->
</div>
<div data-ng-if="usePoliciesForSubclient">
	<div data-ng-if="!planModeEnabled && model.storagePolicy" data-ng-class="wrapperClass">
		<div data-ng-show="!enableContentView || model.backupContent && model.backupContent.value ==='userDefined'">
			<label data-ng-class="labelClass" for="entity-plan-policy-storage-policy-select-{{$id}}">
				<span><cv:msg key="header.storagePolicy" bundle="clients" /></span>
			</label>
			<!-- Start isteven for log storage policy --->
			<div data-ng-class="selectClass">
				<isteven-multi-select
					input-model="model.storagePolicy.list"
					output-model="model.storagePolicy.istSelected"
					button-label="name"
					id="entity-plan-policy-storage-policy-select-{{$id}}"
					item-label="name"
					hide-search-button="true"
					search-limit="10"
					search-property="name"
					selection-mode="single"
					tick-property="selected"
					class="isteven-multi-select user-group-select"
					helper-elements="filter"
					on-close="model.onClose(model.storagePolicy)"
					on-item-click="model.storagePolicy.onChange()">
				</isteven-multi-select>
			</div>
			<span class="help-block" data-ng-show="model.storagePolicy.showError" data-ng-bind="model.storagePolicy.errorMsg"></span>
		</div>
	</div>
	<!-- End isteven for storage policy --->
	<div data-ng-if=" model.logStoragePolicy && !planModeEnabled " data-ng-class="wrapperClass">
		<label data-ng-class="labelClass" for="entity-plan-policy-storage-policy-select-{{$id}}">
			<span><cv:msg key="header.logStoragePolicy" bundle="clients" /></span>
		</label>
		<!-- Start isteven for storage policy --->
		<div data-ng-class="selectClass">
			<isteven-multi-select
				input-model="model.logStoragePolicy.list"
				output-model="model.logStoragePolicy.istSelected"
				button-label="name"
				selection-mode="single"
				id="entity-plan-policy-log-storage-policy-select-{{$id}}"
				item-label="name"
				hide-search-button="true"
	   			search-limit="10"
	            search-property="name"
				tick-property="selected"
				class="isteven-multi-select user-group-select"
				helper-elements="filter"
				on-close="model.onClose(model.logStoragePolicy)"
				on-item-click="model.logStoragePolicy.onChange()">
			</isteven-multi-select>
		</div>
		<span class="help-block" data-ng-show="model.logStoragePolicy.showError" data-ng-bind="model.logStoragePolicy.errorMsg"></span>
	</div>
	<!-- End isteven for log storage policy --->
	<div data-ng-if=" model.schedulePolicy && !planModeEnabled " data-ng-class="wrapperClass">
		<div data-ng-show="!enableContentView || model.backupContent">
		<!-- isteven for schedule policy --->
			<label data-ng-class="labelClass" for="entity-plan-policy-schedule-policy-select-{{$id}}">
				<span><cv:msg key="header.schedulePolicy" bundle="clients" /></span>
			</label>
			<div data-ng-class="selectClass">
				<isteven-multi-select
					input-model="model.schedulePolicy.list"
					output-model="model.schedulePolicy.selected"
					button-label="name"
					id="entity-plan-policy-schedule-policy-select-{{$id}}"
					item-label="name"
					search-property="name"
					tick-property="selected"
					class="isteven-multi-select user-group-select"
					helper-elements="filter"
					on-close="model.schedulePolicy.onChange()">
				</isteven-multi-select>
			</div>
			<span class="help-block" data-ng-show="model.schedulePolicy.showError" data-ng-bind="model.schedulePolicy.errorMsg"></span>
		</div>
	</div>
	<!-- end isteven for schedule policy --->
	<div data-ng-if="model.subclientPolicy && !planModeEnabled && (model.backupContent.value ==='policyDriven' )" data-ng-class="wrapperClass">
		<div data-ng-show="!enableContentView || model.backupContent && model.backupContent.value ==='policyDriven'">
			<label data-ng-class="labelClass" for="entity-plan-policy-subclient-policy-select-{{$id}}">
				<cv:msg key="header.subclientPolicy" bundle="clients" />
			</label>
			<div data-ng-class="selectClass">
				<isteven-multi-select
					input-model="model.subclientPolicy.list"
					output-model="model.subclientPolicy.istSelected"
					button-label="name"
					id="entity-plan-policy-subclient-policy-select-{{$id}}"
					item-label="name"
					hide-search-button="true"
					search-limit="10"
					search-property="name"
					tick-property="selected"
					class="isteven-multi-select user-group-select"
					helper-elements="filter"
					on-close="model.onClose(model.subclientPolicy)"
					selection-mode="single"
					on-item-click="model.subclientPolicy.onChange()">
				</isteven-multi-select>
			</div>
			<span class="help-block" data-ng-show="model.subclientPolicy.showError" data-ng-bind="model.subclientPolicy.errorMsg"></span>
		</div>
	</div>
</div>
</div>
