<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="modal-header">
	<h1><cv:msg key='header.snapshotManagement' bundle='clients'/></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="{{editSECtrl.editSnapShotEngineMessage.type}} serverMessage">{{editSECtrl.editSnapShotEngineMessage.message}}</div>
	<form id="editPSnapShotEngine" class="form-horizontal" name="editPSnapShotEngine" data-cv-submit="editSECtrl.saveSnapShotEngine()" novalidate autocomplete="off">
		<div class="panel panel-default">
			<div class="panel-body">
				<div>
					<div class="form-group" >
						<label class="col-xs-12 col-lg-5" for="engine" ><cv:msg key='label.engines' bundle='clients'/></label>
						<div class="col-xs-12 col-lg-7">
							<isteven-multi-select
								input-model="editSECtrl.engineLists"
								output-model="editSECtrl.model"
								button-label="name"
								item-label="name"
								helper-elements="filter"
								hide-search-button="false"
								directive-id="engine"
								id="engine"
								name="engine"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single"
								on-close="editSECtrl.updateEngineSelection()"
								translation="editSECtrl.localLang">
							</isteven-multi-select>
						</div>
					</div>

					<div class="form-group" data-ng-if="editSECtrl.vendor == 'VMW'">
						<label class="col-xs-12 col-lg-5" for="engine" ><cv:msg key="label.esxServer" bundle="collections"/></label>
					</div>
					<div class="form-group" data-ng-if="editSECtrl.vendor == 'VMW'">
						<div class="col-xs-12 col-lg-12">
							<cv-browse-collection-content
								selected-content="editSECtrl.collectionInfo.selectedContent"
								server-id="editSECtrl.subclientEntity.clientId"
								initial-content-browse-view-path='\NONE:Hosts'
								hide-grouping="true"
								single-selection-mode="true"
								selectable-types='SERVER'
								hide-search="true" >
							</cv-browse-collection-content>
						</div>
					</div>
					<div class="form-group" data-ng-if="editSECtrl.showProxy()">
						<label class="col-xs-12 col-lg-5" for="useProxy">
							<cv:msg key='label.useProxyForBackupCopy' bundle='collections'/>
						</label>

						<div class="col-xs-12 col-lg-7" >
							<!--  <select id="useProxy" name="useProxy" data-ng-model="editSECtrl.selectedProxy"
								data-ng-options="proxy.name for proxy in editSECtrl.proxyList">
							<option value=""></option>
							</select> -->

							<isteven-multi-select
								input-model="editSECtrl.proxyList"
								output-model="editSECtrl.selectedProxy"
								button-label="name"
								item-label="name"
								helper-elements="filter"
								id="useProxy"
								directive-id="useProxy"
								hide-search-button="false"
								name="useProxy"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single">
							</isteven-multi-select>
						</div>
					</div>

					<div data-ng-if="editSECtrl.showRmanImageCopy()">
						<%-- <div class="form-group">
							<div class="col-xs-12">
								<input type="checkbox" name="enableRmanImageCopy" id="enableRmanImageCopy" data-ng-model="editSECtrl.snapImageCopy" data-ng-change="editSECtrl.snapImageCopyChanged()"/>
								<label for="enableRmanImageCopy">
									<cv:msg key='label.enableRmanImageCopy' bundle='oracle'/>
								</label>
							</div>
						</div> --%>



						<div class="form-group" >
							<!-- <label class="col-xs-12 col-lg-6" for="rmanImageCopyPath">
								XXX
								Path
							</label> -->
							<div class="col-xs-12 col-sm-5">
								<input type="checkbox" name="enableRmanImageCopy" id="enableRmanImageCopy" data-ng-model="editSECtrl.snapImageCopy" data-ng-change="editSECtrl.snapImageCopyChanged()"/>
								<label for="enableRmanImageCopy">
									<cv:msg key='label.enableRmanImageCopy' bundle='oracle'/>
								</label>
							</div>

							<div class="col-xs-12 col-sm-5" >
								<input id="rmanImageCopyPath" name="rmanImageCopyPath" type="text" data-ng-model="editSECtrl.imageCopyDir" data-ng-required="editSECtrl.snapImageCopy"/>
								<span class="help-block" data-ng-show="cv.editPSnapShotEngine.needsAttention(editPSnapShotEngine.rmanImageCopyPath)" >
									<cv:msg key='label.enterPath' bundle='settingsJs'/>
								</span>
							</div>
							<div class="col-xs-12 col-sm-2">
								<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />"
									id="rmanImageCopyBrowse"  type="button" class="btn btn-default setup-btn--hidden float-right"
									pseudo-client="{{editSECtrl.isRacInstance}}" physical-client-list="editSECtrl.racPhysicalClientList"
									client-id='{{editSECtrl.subclientEntity.clientId}}' result-function="editSECtrl.rmanImageCopyPathResultFunction"
									 button-label='<cv:msg key="label.browse" bundle="restore"/>' >
								</cv-machine-browse>
							</div>
						</div>
						<div class="form-group" >
						</div>
					</div>

					<div data-ng-if="editSECtrl.showBackupCopyInterface()">
						<div class="form-group">
							<label class="col-xs-12 col-sm-5">
								<cv:msg key='label.backupCopyInterface' bundle='collections'/>
							</label>

							<div class="col-xs-12 col-sm-7" >
								<input id="bciFileSystem" name="backupCopyInterface" type="radio" data-ng-click="editSECtrl.backupCopyInterfaceChanged()"
									data-ng-model="editSECtrl.backupCopyInterface" value="FILE_SYSTEM"/>
								<label for="bciFileSystem">
									<cv:msg key='label.fileSystem' bundle='serversJs'/>
								</label>
							</div>

						</div>

						<div class="form-group">
							<div class="col-xs-12 col-sm-offset-5 col-sm-7" >
								<input id="bciRman" name="backupCopyInterface" type="radio" data-ng-click="editSECtrl.backupCopyInterfaceChanged()"
									data-ng-model="editSECtrl.backupCopyInterface" value="RMAN"/>
								<label for="bciRman">
									<cv:msg key='label.rman' bundle='oracle'/>
								</label>
							</div>
						</div>


						<div class="form-group" data-ng-if="editSECtrl.showVolumeCopyFlag">
							<div class="col-xs-12 col-sm-offset-5 col-sm-7" >
								<input id="bciVolumeCopy" name="backupCopyInterface" type="radio" data-ng-click="editSECtrl.backupCopyInterfaceChanged()"
									data-ng-model="editSECtrl.backupCopyInterface" value="VOLUME_COPY"/>
								<label for="bciVolumeCopy">
									<cv:msg key='label.volumeCopy' bundle='oracle'/>
									<cv-help-component help-text="<cv:msg key='label.volumeCopyHelp' bundle='oracle'/>"></cv-help-component>
								</label>
							</div>
						</div>

					</div>
					<!-- DB2 ACS option -->
					<div class="form-group" data-ng-if="editSECtrl.isDB2() && editSECtrl.isUnixClient">
						<div class="col-xs-12 col-sm-7" >
							<input id="db2ACSInterface" name="db2ACSInterface" type="checkbox" data-ng-model="editSECtrl.db2ACSInterface" />
							<label for="db2ACSInterface">
								<cv:msg key='label.db2ACSInfterface' bundle='db2'/>
							</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal-footer">
			<button id="editSnapShotEngine_button_#6321" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="editSECtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
			<button id="editSnapShotEngine_button_#7483" type="submit" class="btn btn-primary cvBusyOnAjax" ng-disabled="!editSECtrl.model.length || !editSECtrl.isContentSelected()"><cv:msg key="action.save" bundle="profiles"/></button>
		</div>
	</form>
</div>
