<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<cv-tile-component title="{{ title }}" edit-text="reorderHelpText" loader="loader">
	<ul class="list-style-secondary" ng-show="!editMode && !isEmptyEntityList()">
		<li ng-repeat="entity in entityList"><a ng-href="#/clientDetails/{{entity.clientId}}" ng-bind="entity[displayField]"></a></li>
	</ul>
	<ul class="list-style-secondary" dragula="'bag-one'" dragula-model="draggableList" ng-if="editMode">
		<li class="draggable-proxy" ng-repeat="entity in entityList" ng-bind="entity[displayField]"></li>
	</ul>
	<ul class="list-style-secondary" ng-if="isEmptyEntityList()">
		<li class="info-place-holder" ng-bind="customEmptyMessage"></li>
	</ul>
	<div class="page-details-box-links">
			<a href="" data-ng-click="showEditMode()" ng-hide="editMode || entityList.length < 2 || isEmptyEntityList()">
			<cv:msg key="label.reorder" bundle="messagesJs"/>
		</a>
		<a href="" data-ng-click="editEntities()" ng-hide="editMode || !onEdit || isEmptyEntityList()">
			<cv:msg key="label.edit" bundle="clients"/>
		</a>
		<a href="" data-ng-click="saveEntityOrder()" ng-show="editMode">
			<cv:msg key="label.save" bundle="alerts"/>
		</a>
		<a href="" data-ng-click="cancelEditMode()" ng-show="editMode">
			<cv:msg key="label.cancel" bundle="alerts"/>
		</a>
	</div>
</cv-tile-component>