<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>
<div><span class="pageDetailColumn" data-ng-if="!hideLabel">
    <span data-ng-if="!isDcPlan"><cv:msg key="label.profile" bundle="profiles" /></span>
    <span data-ng-if="isDcPlan"><cv:msg key="label.dataClassificationPlan" bundle="profiles" /></span>
</span>
<div class="pageDetailColumn inline-editor" ng-if="!editMode">
    <a ng-if="planObj.planName" ng-href="#/profileDetails/{{planObj.planId}}" class="inline-editor-text" ng-bind="planObj.planName"></a>
    <span ng-if="!planObj.planName" class="inline-editor-text" bundle="clients"><cv:msg key="label.notAssigned" bundle="exchange"/></span>
    <span ng-if="showEdit" class="inline-editor-buttons">
        <a href  class="inline-editor-button" ng-click="editPlan()" ng-class="showEditIcon ? ['inline-pencil', 'cv-flex', 'vertical-center', 'horizontal-center'] : ['text']">
            <span ng-if="!showEditIcon"><cv:msg key="label.inlineEdit" bundle="messagesJs" /></span>
            <svg ng-if="showEditIcon" width="16px" height="16px" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1 1 0 0 0 0-1.41l-2.34-2.34a1 1 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/></svg>
        </a>
    </span>
</div>
</div>
<div ng-if="editMode && planList">
    <span class="pageDetailColumn inline-editor" id="preview-region">
        <div class="inline-editor-input">
            <cv-plan-summary-dropdown
                input-model="planList"
                output-model="selectedPlanList"
                item-label="'planName'"
                button-label="'planName'"
                tick-property="'selected'"
                max-labels="1"
                group-property="'msGroup'"
                selection-mode="'single'"
                directive-id="planDirectiveId"
                show-none="showNone"
                search-property="'planName'"
       			helper-elements="'filter'"
                on-close="parseIStevenOutput()" class="full-width">
            </cv-plan-summary-dropdown>
        </div>
        <span data-ng-if="!previewRegion" class="inline-editor-buttons">
            <a class="inline-editor-button" href ng-click="saveEditPlan()"><span class="k-icon k-i-check"></span></a>
            <a class="inline-editor-button" href ng-click="cancelEditPlan()"><span class="k-icon k-i-x"></span></a>
        </span>
    </span>
</div>
<span class="server-message {{serverMessage.type}}" ng-bind="serverMessage.message"></span>