<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editPasskey.title" bundle="profiles"/></h1>
</div>
<div class="setup-content remove-top-padding smaller-inputs">
	<div class="alert alert-sign-detail text-center">
	    <div class="row">
	        <div class="col-xs-12">
	            <span class="alert-detail-icon k-icon k-i-warning"></span>
	            <span data-ng-bind="editPasskeyCtrl.passkeyWarningMessage"> </span>
	        </div>
	    </div>	
	</div>
	<form name="editPasskeyForm" data-ng-init="editPasskeyCtrl.init()" data-cv-submit="editPasskeyCtrl.submit()" autocomplete="off">
		<p data-ng-if="editPasskeyCtrl.serverMessage.message" class="{{editPasskeyCtrl.serverMessage.type}} serverMessage" data-ng-bind="editPasskeyCtrl.serverMessage.message"></p>
		<label for="existingPasskey">
			<cv:msg key="label.existingPasskey" bundle="profiles" />
			<input class="margin-right-20" type="password" name="existingPasskey" id="existingPasskey" data-ng-model="editPasskeyCtrl.userInfo.currentPasskey" placeholder= '<cv:msg key="label.existingPasskey.placeholder" bundle="profiles" />'>
		</label>
		<label for="newPasskey">
			<cv:msg key="label.newPasskey" bundle="profiles" />
			<input class="margin-right-20" type="password" name="newPasskey" id="newPasskey" data-ng-model="editPasskeyCtrl.userInfo.newPasskey" placeholder= '<cv:msg key="label.newPasskey.placeholder" bundle="profiles" />'>
		</label>
		<label for="confirmPasskey"><cv:msg key="label.confirmPasskey" bundle="profiles"/>
			<input class="margin-right-20" type="password" name="confirmPasskey" id="confirmPasskey" data-ng-model="editPasskeyCtrl.userInfo.confirmPasskey" placeholder= '<cv:msg key="label.confirmPasskey.placeholder" bundle="profiles" />'>
			<span class="help-block" data-ng-if="editPasskeyCtrl.userInfo.newPasskey !== editPasskeyCtrl.userInfo.confirmPasskey" style=""><cv:msg key='error.passwordsDoNotMatch' bundle='profiles' /></span>
		</label>
		<div class="button-container">
	  		<button id="cvEditPasskey_button_#4295" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="editPasskeyCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
	  		<button id="cvEditPasskey_button_#0080" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled= "!editPasskeyCtrl.isModalStateValidForSubmission()"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>