<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.authForRestore.title" bundle="profiles"/></h1>
</div>
<div class="setup-content smaller-inputs remove-top-padding">

	<form name="authForRestoreForm" data-ng-init="authForRestoreCtrl.init()" data-cv-submit="authForRestoreCtrl.submit()" autocomplete="off">
		<p data-ng-if="authForRestoreCtrl.serverMessage.message" class="{{authForRestoreCtrl.serverMessage.type}} serverMessage" data-ng-bind="authForRestoreCtrl.serverMessage.message"></p>
		<div class="modal-info-wrapper">
			<span class="glyphicon glyphicon-info-sign tile-tooltip icon-i-tag-modal" ></span>
			<span data-ng-bind="authForRestoreCtrl.authorizeForRestoreHelpText" class="i-tag-text"></span>
		</div>
		<label for="existingPasskey">
			<cv:msg key="label.passkey" bundle="profiles" />
			<input class="margin-right-20" type="password" name="existingPasskey" id="existingPasskey" data-ng-model="authForRestoreCtrl.existingPasskeyString" placeholder= '<cv:msg key="label.existingPasskey.placeholder" bundle="profiles" />'>
		</label>
		<label for="passkeyValidTill" data-ng-if="authForRestoreCtrl.showAuthForRestoreDuration">
			<cv:msg key="label.passkeyValidTill" bundle="profiles" />
			<input id="passkeyValidTillInput"
				name="passkeyValidTillInput"
				type="number"
				min="0"
				class="duration align-to-select"
				data-ng-model="authForRestoreCtrl.durationNumber"
				data-ng-change="ctrl.updateModel()"/>
			  <select id="passkeyValidTill"
					class="duration"
					data-ng-options="unit as unit.label for unit in authForRestoreCtrl.units track by unit.id"
					data-ng-model="authForRestoreCtrl.unit"
					data-ng-change="authForRestoreCtrl.updateModel()">
			</select>
		</label>

		<div class="button-container">
	 		<button id="cvAuthorizeForRestoreModal_button_#6385" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="authForRestoreCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
	 		<button id="cvAuthorizeForRestoreModal_button_#3820" type="submit" data-ng-disabled="!authForRestoreCtrl.existingPasskeyString || !authForRestoreCtrl.durationNumber" class="btn btn-primary cvBusyOnAjax" data-ng-click="authForRestoreCtrl.submit()"><cv:msg key="action.ok" bundle="subscriptions"/></button> 
		</div>
	</form>
</div>
