<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="cv-agent-dropdown-tree">
    <span uib-dropdown dropdown-append-to-body="true" auto-close="outsideClick" is-open="isDropdownOpen">
        <a class="uib-dropdown-toggle" uib-dropdown-toggle uib-tooltip="{{_labelModel}}" tooltip-placement="auto top"> {{_labelModel || placeholder}}
            <span class="dropdown-arrow"></span>
        </a>
        <ul uib-dropdown-menu class="dropdown-menu agent-dropdown-tree-menu narrow-menu" ng-style="{width: dropdownWidth}">
            <li>
                <div class="row">
                    <div class="col-md-6">
                        <input type="search" class="search-field" ng-model="model.searchText" placeholder="search" title="search" ng-change="onFilterChange(model.searchText)" />
                        <span data-ng-click="clear();" ng-if="model.searchText" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title="Clear"></span>
                    </div>
                    <div class="col-md-6" ng-if="treeContainer.isShowSelectedCheckboxVisible">
                        <input type="checkbox" name="showSelected{{id}}" id="showSelected{{id}}"
                        data-ng-model="treeContainer.isShowOnlySelected"
                        data-ng-click="treeContainer.toggleShowSelectedNodes()"/>
                        <label class="checkbox-label" for="showSelected{{id}}"><cv:msg key="label.showSelected" bundle="users" /></label>
                    </div>
                    <a class="close-btn" href="javascript:void(0);" ng-click="close();" title="Close"><i class="glyphicon glyphicon-remove-circle"></i></a>
                </div>
                <div id="category-container" ng-if="treeContainer" ng-init="markSelectedNodes()" ivh-treeview="treeContainer.tree" ivh-treeview-expand-to-depth="expandToDepth"
                    ivh-treeview-use-checkboxes="true"
                    ivh-treeview-on-cb-change="treeContainer.toggleShowSelectedCheckbox(); setSelectedNodes();"
                    ivh-treeview-filter="model.searchText">
                        <script type="text/ng-template">
                            <span ivh-treeview-toggle>
                                <span ivh-treeview-twistie></span>
                            </span>
                            <span ivh-treeview-checkbox-wrapper>
                                <span ivh-treeview-checkbox id="{{node.id}}"></span>
                            </span>
                            <span class="ivh-treeview-node-label" ivh-treeview-toggle data-ng-class="{'padding-left' : trvw.isLeaf(node)}">
                                <span class="content-label">{{trvw.label(node)}}</span>
                            </span>
                            <div ivh-treeview-children></div>
                        </script>
                </div>
            </li>
        </ul>
    </span>
</div>
