<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
		<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
</script>
<div class="setup-title"><h1><cv:msg key="action.subclientCreation" bundle="clients" /></h1></div>
<div class="setup-content" >
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<section>
			<form name="createSubclientForm" novalidate autocomplete="off" data-cv-submit="createSubclient()" >
				<div class="form-panel-holder">
				<cv-tabset-component control='tabControls'>
				<cv-tab tabname="<cv:msg key="heading.clientGeneral" bundle="clients" />">
				<label> 
						<span class="page-detail-column"> 
							<label for="subclientName">
								<cv:msg key="label.SubclientName" bundle="clients" />
							</label>
						</span> 
						<span class="page-detail-column float-right"> 
							<input type="text" name="subclientName" id="subclientName" 
								data-ng-model="subclientInfo.subClientEntity.subclientName" required autofocus />
						</span> 
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</label> 
					<label>
						<span class=page-detail-column>
							<label for="storagePolicy">
								<cv:msg key="header.storagePolicy" bundle="clients" />
							</label>	
						</span>	
						<span class="page-detail-column select-label float-right">
								<select id="storagePolicy" name="storagePolicy"  data-ng-required="true" 
									data-ng-model="subclientInfo.storagePolicy" data-ng-options="sp as sp.storagePolicyName for sp in subclientInfo.storagePoliciesList | orderBy:'storagePolicyName'">
									<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients"/></option>
								</select>
						</span>	
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.storagePolicy)">
							<cv:msg key="error.selectStoragePolicy" bundle="clients" />
						</span>
					</label>
					
					<label> 
						<span class="page-detail-column"> 
							<label for="numberBackupStreams">
								<cv:msg key="label.numberBackupStreams" bundle="oracle" /> 
							</label>	
						</span> 
						<span class="page-detail-column float-right"> 
							<input type="number" id="numberBackupStreams" 
								name="numberBackupStreams" min="0" data-ng-model="subclientInfo.numberBackupStreams" data-ng-required="true" />
						</span> 
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="clients" />
						</span>
					</label>
					
					<div id="subclient-activity-tab" class="extra-top-padding">
						<input id="collectObjectList" data-ng-model="subclientInfo.collectObjectListDuringBackup" type="checkbox">
						<label for="collectObjectList" style="line-height:inherit"><cv:msg key="label.CollectObjectList" bundle="postgres" /></label>
					</div>
					
					</cv-tab>
					
					<!-- TAB 2 : Content Tab -->
				<cv-tab tabname="<cv:msg key="header.content" bundle="collections" />">
				<div class="extra-top-padding" data-ng-if="subclientInfo.content.length==0">
					<ul class="manageCollectionList list-style__row group">
						<li><cv:msg key="label.NoContentAdded" bundle="clients" /></li>
					</ul>
				</div>
				<div class="limit-modal-height" data-ng-if="subclientInfo.content.length > 0">
				    <ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in subclientInfo.content">
						<li data-ng-bind="contentEntity.databaseName"></li>
					</ul>
				</div>
				<div class="extra-top-padding">
					<button id="createPostgreSQLSubclient_button_#1088" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addContent()"><cv:msg key="label.AddEditDatabases" bundle="postgres" /></button> 
				</div>
				<br>
				</cv-tab>	
					
					
			</cv-tabset-component>
					<div class="button-container" >
						<button id="createPostgreSQLSubclient_button_#7126" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
						<button id="createPostgreSQLSubclient_button_#6773" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="OK" bundle="messages" /></button> 
					</div>
				</div>
		</form>
	</section>
</div>