<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title"><h1>{{::addSubclientTitle}}</h1></div>
<div class="setup-content cr-subclient-modal" >
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<form id="createSubclientForm" name="createSubclientForm" novalidate autocomplete="off">
		<div class="bootstrap-wrapper padding-bottom-0">
		<div  class="modal-list" >
			<div id="subclient-general-tab" class="no-min-height">
				<div class="form-group row" ng-if="enableBackupsets">
					<label class="col-xs-12 col-sm-4" for="bs"><cv:msg key="header.backupSet" bundle="nas" /></label>
					<div class="col-xs-12 col-sm-8">
						<cv-plan-summary-dropdown
							input-model="_bs"
							output-model="_config.selectedBs"
							button-label="'backupSetClientLabel'"
							item-label="'name'"
							directive-id="'backup_set'"
							tick-property="'selected'"
							selection-mode="'single'"
							helper-elements="'filter'"
							search-placeholder="_config.searchPlaceholder"
							custom-config="_config.customConfig"
							on-item-clicked="updateBackupset()">
						</cv-plan-summary-dropdown>
					</div>
				</div>
				<div class="form-group row" ng-if="enableSave">
					<label class="col-xs-12 col-sm-4" for="subclientName">{{::subClientNameLabel}}</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="subclientName" data-ng-class="text-right" id="subclientName" data-ng-model="subclientInfo.subclientName" data-ng-change="inputAlertFlags.subclientName = false" required autofocus >
						<span class="help-block" data-ng-if="inputAlertFlags.subclientName">{{::subClientNameError}}</span>
						<span class="help-block" data-ng-if="checkForDuplicateNames()">{{::duplicateSubclientName}}/span>
					</div>
				</div>
				<div class="form-group row" ng-if="showBackupSet">
					<label class="col-xs-12 col-sm-4">Backups set</label>
					<div ng-if="!backupSetInputModel" class=" col-xs-12 col-sm-8">
						<span class="float-left margin-top-10" ng-bind="backupSetSelected.backupsetName">
						</span>
					</div>
					<div ng-if="backupSetInputModel" class=" col-xs-12 col-sm-8">
						<isteven-multi-select id="createFsSubclient_isteven-multi-select_#65d8657" 
							input-model="backupSetInputModel"
							button-label="backupSetName"
							item-label="backupSetName"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							helper-elements="filter"
							selection-mode="single"
							translation="localLang"
							on-item-click="changeBackupSet(data)">
						</isteven-multi-select>
					</div>
				</div>
				<div class="form-group row" data-ng-if="configureForSubclientPolicy">
					<label class="col-xs-12 col-sm-4" for="primaryStorage"><cv:msg key="label.storagePolicy" bundle="profiles"/></label>
					<div class="col-xs-12 col-sm-8">
					<div>
						<select id="primaryStorage" name="primaryStorage" data-ng-model="subclientInfo.storagePolicy" required
							data-ng-options="storagePolicy as storagePolicy.storagePolicyName  for storagePolicy in subclientInfo.storagePoliciesList"
							data-ng-change="inputAlertFlags.storagePolicy = false">
							<option value=""><cv:msg key="placeholder.selectStoragePolicy" bundle="collections"/></option>
						</select>
					</div>
					<span class="help-block" data-ng-show="inputAlertFlags.storagePolicy"><cv:msg key="error.storagePolicy" bundle="collections"/></span>
					</div>
				</div>			
			</div>
			
			<div class="saveWhileActiveTab" data-ng-if="isIbmiClient && !isIBMIDRSubclient">
				<h4 class="text-left"><cv:msg key="heading.saveWhileActive" bundle="clients"/></h4>
				<save-while-active save-while-active-options="saveWhileActiveOptions" has-custom-content="subclientInfo.content.ibmiContent.customSubclientFlag" client-id="subclientInfo.clientId" control="saveWhileActiveControl"/>
			</div>
		</div>
		
		
		<!-- cv select to toggle plan n policy list -->
		<div class="modal-list" data-ng-if="planPolicyModel && !configureForSubclientPolicy">
             <cv-entity-plan-policy-select plan-selection-change="planSelectionChange()"  data-cv-hide-policy-toggle-option="isCloudStorageApp || hidePlanPolicyToggle"  data-cv-model="planPolicyModel"  data-cv-backup-set-id = "subClientPlanParam.backupsetId" data-cv-app-id="subClientPlanParam.applicationId"  data-cv-client-id="subClientPlanParam.clientId" data-cv-wrapper-class="'form-group row'" no-bootstrap-wrapper-class="true"
                 data-cv-label-class="'col-xs-12 col-sm-4'" data-cv-select-class="'col-xs-12 col-sm-8'" >
             </cv-entity-plan-policy-select>
       	</div>

       	<div class="form-group padding-bottom-20" data-ng-if="aclModel.isShowACL">
		    <div class="col-xs-12 col-sm-12">
		        <input type="checkbox" id="collectACL" name="collectACL" data-ng-model="aclModel.collectACL"/>
		        <label for="collectACL">
		        	<cv-help-text
							help-label="<cv:msg key="label.collectAcl" bundle="cloudStorageApp" />"
							help-text="'<cv:msg key='info.collectAcl' bundle='cloudStorageApp' />'">
					</cv-help-text>
		        </label>
		    </div>
		</div>

		<div  data-ng-if="!isIbmiClient && contentOptions" class="form-group row modal-list">
			<h4 class="text-left"><cv:msg key="label.backupContent" bundle="restore"/></h4>						
			<cv-content-selection data-ng-if="!enableBackupsets || subclientInfo.content.contentEntities"
				data-options= 'contentOptions'
				data-content-entities= 'subclientInfo.content.contentEntities'>
			</cv-content-selection>	
		</div>
			<uib-accordion close-others="true" data-ng-if="isIbmiClient" class="text-left">
				<div data-ng-if="!isIBMIDRSubclient" uib-accordion-group data-is-open="model.accordionStatus.contentTab" data-scroll-to-when-open >
					<uib-accordion-heading>
						<cv:msg key="header.content" bundle="collections"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.contentTab, 'glyphicon-chevron-right': !model.accordionStatus.contentTab}"></i>
					</uib-accordion-heading>
					<div id="subclient-content-tab" class="no-min-height">
							<div class="custom-content-container">
							<div data-ng-disabled="subclientInfo.content.ibmiContent.customSubclientFlag==false" class="form-group row">
								<label class="col-xs-12 col-lg-4" for="customPath"><cv:msg key="label.typeCustomPath" bundle="messages" /></label>
								<div class="col-xs-12 col-lg-8">
								    <input type="text" name="customPath" data-ng-class="text-right" id="customPath" ng-keypress="($event.which === 13)?addCustomPath(model.customPath):0"" data-ng-model="model.customPath" required autofocus>
								    <i class="input-icon-right glyphicon glyphicon-plus" data-ng-click="addCustomPath(model.customPath)" title='<cv:msg key="Add" bundle="messages" />'></i>
								</div>
							</div>
							<div data-ng-if="subclientInfo.content.typeWiseCounterArray[0].counter==0 && !(subclientInfo.content.ibmiContent.customSubclientFlag==false && subclientInfo.content.ibmiContent.customSubclientContentFlags)">
								<div class="col-xs-12 col-lg-8 col-lg-offset-4">
								    <button id="createFsSubclient_button_#9980" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addContent()"><cv:msg key="label.addEditContent" bundle="messages" /></button> 
								</div>
							</div>
							<div data-ng-if="subclientInfo.content.typeWiseCounterArray[0].counter>0 || (subclientInfo.content.ibmiContent.customSubclientFlag==false && subclientInfo.content.ibmiContent.customSubclientContentFlags)" id="fs-table-wrapper">
								<ul class="manageCollectionList list-style__row group content-table-header">
									<li><input type="checkbox" data-ng-change="toggleAllPaths(model.toggleAllState)" data-ng-model="model.toggleAllState" id="title"><label class="inline-label" for="title"><cv:msg key="label.filesFolders" bundle="messages" /></label></li>
								</ul>
								<span class="modal-page-action-item"><a href="" data-ng-if="showRemovePaths()" data-ng-click="removePaths()"><cv:msg key="label.remove" bundle="clients" /></a><a href="" data-ng-click="addContent()"><cv:msg key="Add" bundle="messages" /></a></span>
								<div class="limit-modal-height custom-content-wrapper">
								    <!--FS: This div shows only the content of path type.includePath and excludePath type content wont be showed here. -->
									<ul class="manageCollectionList list-style__row">
										<div class="custom-content__UL">
											<li data-ng-if="subclientInfo.content.typeWiseCounterArray[0].counter==0 && !(subclientInfo.content.ibmiContent.customSubclientFlag==false && subclientInfo.content.ibmiContent.customSubclientContentFlags)">
												<div class="form-group row">
													<label class="collection-label col-xs-12 col-md-12 col-lg-12">
														<cv:msg key="label.NoContentAdded" bundle="clients" />
													</label>
												</div>
											</li>
											<li data-ng-repeat="ibmiInputItem in ibmiInputs.subclientContentList" data-ng-if="showIbmiItem(ibmiInputItem.customSubclientContentFlags, subclientInfo.content.ibmiContent.customSubclientContentFlags) && subclientInfo.content.ibmiContent.customSubclientFlag==false"><input type="checkbox" data-ng-model="ibmiInputItem.selected" id="{{ibmiInputItem.label}}"><label class="collection-label" data-ng-bind-html="ibmiInputItem.label" for="{{ibmiInputItem.label}}"></label></li>
											<li data-ng-repeat="contentEntity in subclientInfo.content.contentEntities" data-ng-if="contentEntity.type==0 && !(subclientInfo.content.ibmiContent.customSubclientFlag==false)"><input type="checkbox" data-ng-model="contentEntity.selected" id="{{contentEntity.path}}"><label class="collection-label" data-ng-bind="contentEntity.path" for="{{contentEntity.path}}"></label></li>
										</div>
									</ul>
								</div>
							</div>
						</div>
						<div class="form-group row" data-ng-if="subclientInfo.content.ibmiContent.customSubclientFlag==false && subclientInfo.content.ibmiContent.customSubclientContentFlags">
							<div class="col-xs-12 col-lg-12">
								<input type="checkbox" id="backupLibraryContent" name="backupLibraryContent" data-ng-model="backupLibraryContent"/>
								<label for="backupLibraryContent"><cv:msg key="label.backupLibraryContent" bundle="clients" /></label>
							</div>
						</div>
						
					</div>
				</div>
				<div data-ng-if="isIbmiClient && isIBMIDRSubclient" uib-accordion-group data-is-open="model.accordionStatus.IBMIDRTab" data-scroll-to-when-open>
					<uib-accordion-heading>
						<cv:msg key="label.IBMIDRConfiguration" bundle="clients"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.IBMIDRTab, 'glyphicon-chevron-right': !model.accordionStatus.IBMIDRTab}"></i>
					</uib-accordion-heading>
					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="SRBootServerDir"><cv:msg key="label.SRBootServerDir" bundle="clients"/></label>
						<div class="col-xs-8 col-lg-6">
							<input type="text" id="SRBootServerDir" name="SRBootServerDir" data-ng-model="ibmiSubclientprop.SRBootServerDir" data-ng-change="inputAlertFlags.SRBootServerDirEmpty = false; inputAlertFlags.SRBootServerDirLib=false;inputAlertFlags.SRBootServerDirIFS=false;inputAlertFlags.SRBootServerDirPath = false;"/>
							<span class="help-block" data-ng-show="inputAlertFlags.SRBootServerDirEmpty"><cv:msg key="error.SRBootServerDirEmpty" bundle="clients" /></span>
							<span class="help-block" data-ng-show="inputAlertFlags.SRBootServerDirLib"><cv:msg key="error.SRBootServerDirLib" bundle="clients" /></span>
							<span class="help-block" data-ng-show="inputAlertFlags.SRBootServerDirIFS"><cv:msg key="error.SRBootServerDirIFS" bundle="clients" /></span>
							<span class="help-block" data-ng-show="inputAlertFlags.SRBootServerDirPath"><cv:msg key="error.invalidPath" bundle="clients" /></span>
						</div>
						<div class="col-xs-4 col-lg-2">
							<button id="physicalPathFileBrowse" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="browseCommand('SRBootServerDir')"><cv:msg key="action.browse" bundle="collections" /></button>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="backupMaxTime"><cv:msg key="label.backupMaxTime" bundle="clients"/></label>
						<div class="col-xs-12 col-lg-8">
							<input type="number" id="backupMaxTime" name="backupMaxTime" data-ng-model="ibmiSubclientprop.backupMaxTime"/>
						</div>
					</div>
					<div class="form-group row">
						<div class="col-xs-12 col-md-12 col-lg-12">
							<input type="checkbox" id="notifyuser" name="notifyuser" data-ng-model="ibmiSubclientprop.notifyuser"/>
							<label for="notifyuser"><cv:msg key="label.notifyuser" bundle="clients" /></label>
						</div>
					</div>
					<div data-ng-show="ibmiSubclientprop.notifyuser">
						<div class="form-group row">
							<label class="col-xs-12 col-lg-4" for="notifyDelay"><cv:msg key="label.notifyDelay" bundle="clients"/></label>
							<div class="col-xs-12 col-lg-8">
								<input type="number" id="notifyDelay" name="notifyDelay" data-ng-model="ibmiSubclientprop.notifyDelay"/>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-xs-12 col-lg-4" for="notifyMessage"><cv:msg key="label.notifyMessage" bundle="clients"/></label>
							<div class="col-xs-12 col-lg-8">
								<input type="text" id="notifyMessage" name="notifyMessage" data-ng-model="ibmiSubclientprop.notifyMessage" data-ng-change="inputAlertFlags.notifyMessage = false;"/>
								<span class="help-block" data-ng-show="inputAlertFlags.notifyMessage"><cv:msg key="error.notifyMessage" bundle="clients" /></span>
							</div>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="userProgram"><cv:msg key="label.userProgram" bundle="clients"/></label>
						<div class="col-xs-8 col-lg-6">
							<input type="text" id="userProgram" name="userProgram" data-ng-model="ibmiSubclientprop.userProgram"/>
						</div>
						<div class="col-xs-4 col-lg-2">
							<button id="physicalPathFileBrowse" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="browseCommand('userProgram')"><cv:msg key="action.browse" bundle="collections" /></button>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-lg-4" for="userIPLProgram"><cv:msg key="label.userIPLProgram" bundle="clients"/></label>
						<div class="col-xs-8 col-lg-6">
							<input type="text" id="userIPLProgram" name="userIPLProgram" data-ng-model="ibmiSubclientprop.userIPLProgram"/>
						</div>
						<div class="col-xs-4 col-lg-2">
							<button id="physicalPathFileBrowse" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="browseCommand('userIPLProgram')"><cv:msg key="action.browse" bundle="collections" /></button>
						</div>
					</div>
				</div>		
		</uib-accordion>
		<uib-accordion class="text-left" ng-if="osId && fileSystemAgentType">
			<div uib-accordion-group data-is-open="model.accordionStatus.prepostTab">
				<uib-accordion-heading >
					<cv:msg key="header.prepostCommand" bundle="messages" />
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.prepostTab, 'glyphicon-chevron-right': !model.accordionStatus.prepostTab}"></i>
				</uib-accordion-heading>
				<prepost-commands show-only-backup-process="true" class="margin-left-20 margin-top-10" backup-only form-name="createSubclientForm" set-format-data-fn="setFormatPrepostDataFunction(getPrepostData)" client-id="subclientInfo.clientId" os-id="osId" application-id="subclientInfo.agentInfo.applicationId"></prepost-commands>
			</div>	
		</uib-accordion>
		
		<div class="button-container" >
			<button id="createFsSubclient_button_#2577" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<!--data-ng-disabled="!((showPlan && planList.length > 0) || (configureForSubclientPolicy && subclientInfo.storagePoliciesList.length))" -->
			<button id="createFsSubclient_button_#9652" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="createSubclient()" data-ng-disabled="!enableSave" ><cv:msg key="Save" bundle="messages" /></button> 
		</div>
		</form>
</div>
