<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>

</script>

<div class="setup-title">
    <h1 ng-bind="'label.addContentGroup' | cvLoc"></h1>
</div>

<div class="setup-content">
    <form id="createFsContentGroup" name="createFsContentGroup" data-cv-submit="ctrl.createContentGroup()" novalidate>
        <div class="col-xs-12"><span class="serverMessage {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message"></span></div>
        <label for="contentGroupName" class="input">
                <span class="long-label-span"><cv:msg key="label.name" bundle="profiles" /></span>
                <input type="text" id="contentGroupName" name="contentGroupName"  ng-model="ctrl.contentGroupName" required/>
                <!-- ng change -->
                <span class="help-block" ng-if="cv.createFsContentGroup.needsAttention(createFsContentGroup.contentGroupName)" ng-bind="'label.enterContentGroupName' | cvLoc"></span>
        </label>

        <div  class="modal-list margin-top-10 bootstrap-wrapper padding-bottom-0">
            <div data-ng-hide="ctrl.isHadoopAgent || ctrl.isClusterTypeFileSystem || ctrl.isNasContentGroup" class="form-group row">
                <label class="col-xs-12 col-sm-4" ng-bind="ctrl.backupSetLabel"></label>
                <div ng-if="ctrl.backupSetList.length === 1" class=" col-xs-12 col-sm-6 company-multi-select padding-left-5">
                    <span class="float-left margin-top-10" ng-bind="ctrl.backupSetEntity.backupsetName">
                    </span>
                </div>
                <div ng-if="ctrl.backupSetList.length > 1" class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                    <isteven-multi-select id="createFsContentGroup_isteven-multi-select_#65657"
                        input-model="ctrl.backupSetInputModel"
                        button-label="backupSetName"
                        item-label="backupSetName"
                        tick-property="selected"
                        class="isteven-multi-select user-group-select"
                        helper-elements="filter"
                        selection-mode="single"
                        translation="ctrl.localLang"
                        on-item-click="ctrl.changeBackupSet(data)">
                    </isteven-multi-select>
                </div>
            </div>
        </div>
        <div  ng-if="ctrl.isArchival || ctrl.isHadoopAgent" class="modal-list margin-top-10 bootstrap-wrapper padding-bottom-0 margin-bottom-15">
            <div class="form-group row" ng-if="!ctrl.isHadoopAgent">
                <label class="col-xs-12 col-sm-4" for="archivalPlans"><cv:msg key="label.plan" bundle="archiving" /></label>
                <div  class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                    <cv-plan-summary-dropdown
                        input-model="ctrl.archivalPlans"
                        output-model="ctrl.selectedArchivalPlanList"
                        item-label="'planName'"
                        button-label="'planName'"
                        tick-property="'selected'"
                        selection-mode="'single'"
                        directive-id="'createFsContentGroup_isteven-multi-select_#687885'"
                        class="full-width" on-close="ctrl.changeArchivalPlan()">
                    </cv-plan-summary-dropdown>
                    <input type="text" name="archivalPlans" id="archivalPlans" ng-model="ctrl.selectedArchivePlan" ng-hide="true" required/>
                    <div class="help-block" ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.archivalPlans)">
                        <i class="ion-alert-circled"></i>
                        <span><cv:msg key="error.plan" bundle="archiving" /></span>
                    </div>
                </div>
            </div>
            <cv-archiving-rules cv-disk-cleanup-rules="ctrl.diskCleanupRules" cv-output-model="ctrl.savedDiskCleanupRules" cv-enable-toggle-override-archiving-rules="'true'" cv-enable-preview-mode="'true'" ng-if="ctrl.diskCleanupRules"></cv-archiving-rules>
            <div class="form-group row" ng-if="ctrl.isNasContentGroup || ctrl.isHadoopAgent">
                <label class="col-xs-12 col-sm-4" for="archivalAccessNodes"><cv:msg key="label.dataAccessNodes" bundle="bigData" /></label>

                <div  class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                    <isteven-multi-select id="createFsContentGroup_isteven-multi-select_#687886"
                        input-model="ctrl.accessNodes"
                        output-model="ctrl.selectedAccessNode"
                        button-label="clientName"
                        item-label="clientName"
                        selection-mode="multiple"
                        tick-property="selected"
                        translation="ctrl.localLangNode"
                        class="isteven-multi-select user-group-select">
                    </isteven-multi-select>
                    <input type="text" name="archivalAccessNodes" id="archivalAccessNodes" ng-model="ctrl.selectedAccessNode" ng-hide="true" required/>
                    <div class="help-block" ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.archivalAccessNodes)">
                        <span ng-if="ctrl.isNasContentGroup"><cv:msg key="error.accessNode" bundle="archiving" /></span>
                        <span ng-if="ctrl.isHadoopAgent"><cv:msg key="error.dataAccessNodes" bundle="bigData" /></span>
                    </div>
                </div>
            </div>
        </div>

        <div ng-if="!ctrl.isArchival" class="modal-list margin-top-15">
            <cv-entity-plan-policy-select data-cv-hide-policy-toggle-option="true" data-cv-model="ctrl.planModel"
                data-cv-backup-set-id="ctrl.backupSetEntity.backupsetId" data-cv-app-id="ctrl.backupSetEntity.applicationId" data-cv-client-id="ctrl.backupSetEntity.clientId" data-cv-wrapper-class="'form-group row'" no-bootstrap-wrapper-class="true"
                data-cv-label-class="'col-xs-12 col-sm-4'" data-cv-select-class="'col-xs-12 col-sm-8 company-multi-select padding-left-5'"  plan-selection-change="ctrl.onPlanSelection(planDetails)"></cv-entity-plan-policy-select>
        </div>

        <div class="modal-list margin-top-10 margin-bottom-20" data-ng-if="!ctrl.isArchival && ctrl.showFSMeditechSystemOption()">
            <label class="margin-0">
                <toggle-control status="ctrl.isMeditechSystemEnabled ? 'enabled-activity':'disabled-activity'" data-ng-click="ctrl.toggleMeditechSystem()" title='<cv:msg key="label.enableMeditech" bundle="dr" />'></toggle-control>
                <span class="margin-left-5"><cv:msg key="label.enableMeditech" bundle="dr" /></span>
            </label>
            <div class="modal-list margin-top-10 bootstrap-wrapper padding-bottom-0" name="meditechForm" id="meditechForm" data-ng-if="ctrl.isMeditechSystemEnabled">
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="systemName"> <cv:msg key="label.systemName" bundle="dr" /></label>
                    <div  class="col-xs-12 col-sm-6 company-multi-select padding-left-5">
                        <input type="text" name="systemName" id="systemName" data-ng-model="ctrl.hcSubclientProp.medicalSystemName" required />
                        <span class="help-block" data-ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.systemName)"><cv:msg key="error.medicalSystemName" bundle="dr" /></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="masterNode"> <cv:msg key="label.masterNode" bundle="dr" /></label>
                    <div  class="col-xs-12 col-sm-6 company-multi-select padding-left-5">
                        <input type="text" name="masterNode" id="masterNode" data-ng-model="ctrl.hcSubclientProp.masterNode" required />
                        <span class="help-block" data-ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.masterNode)"><cv:msg key="error.masterNode" bundle="dr" /></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="masterNodePort"> <cv:msg key="label.masterNodePort" bundle="dr" /></label>
                    <div  class="col-xs-12 col-sm-6 company-multi-select padding-left-5">
                        <input type="number" class="float-left" name="masterNodePort" id="masterNodePort" min="0" max="65535" data-ng-model="ctrl.hcSubclientProp.masterNodePort" />
                        <span class="help-block" data-ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.masterNodePort)"><cv:msg key="error.masterNodePort" bundle="dr" /></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="userName"> <cv:msg key="label.userName" bundle="dr" /></label>
                    <div  class="col-xs-12 col-sm-6 company-multi-select padding-left-5">
                        <input type="text" name="userName" id="userName" data-ng-model="ctrl.hcSubclientProp.userName" required />
                        <span class="help-block" data-ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.userName)"><cv:msg key="error.mbfUserName" bundle="dr" /></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="userPassword"> <cv:msg key="label.password" bundle="dr" /></label>
                    <div  class="col-xs-12 col-sm-6 company-multi-select padding-left-5">
                        <input type="password" name="userPassword" id="userPassword" data-ng-model="ctrl.hcSubclientProp.userPassword" required />
                        <span class="help-block" data-ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.userPassword)"><cv:msg key="error.mbfUserPassword" bundle="dr" /></span>
                    </div>
                </div>
            </div>
        </div>

        <div ng-if="(!ctrl.isMeditechSystemEnabled) && (ctrl.planModel.plan.selected && !ctrl.isArchival && !ctrl.isNasOnlySolution && !ctrl.isClusterTypeFileSystem && !ctrl.isHadoopAgent)">
            <label ng-if="ctrl.planPreviewEntity.isPlanHaveBackupContent" ng-bind="'label.backupContentPlan'| cvLoc"></label>
            <plan-content-preview  plan-preview-entity="ctrl.planPreviewEntity"></plan-content-preview>
            <label ng-if="ctrl.planPreviewEntity.isPlanHaveBackupContent" class="text-left margin-top-10">
                <cv-toggle value="ctrl.overrideBackupContent" toggle-label="label.defineContent" help-text="'label.overrideBackupContent.helpText'" on-click="ctrl.overridePlanContent()" help-direction="top"></cv-toggle>
            </label>
        </div>
        <span class="cv-help-block" data-ng-if="ctrl.emptyContentError">
            <cv:msg key="error.addContent" bundle="fs" /></span>
        <div data-ng-show="(!ctrl.isMeditechSystemEnabled) && (ctrl.overrideBackupContent || !ctrl.planPreviewEntity.isPlanHaveBackupContent)">
            <div class="row modal-list bootstrap-wrapper">
                <!-- <h4 class="text-left">
                    <cv:msg key="label.backupContent" bundle="profiles" />
                </h4> -->
                <cv-content-selection class="form-group"  ng-if="ctrl.contentOptions && ctrl.contentEntities" data-options="ctrl.contentOptions"
                    data-content-entities="ctrl.contentEntities">
                </cv-content-selection>
            </div>
        </div>

        <div data-ng-if="ctrl.isMeditechSystemEnabled" class="margin-left-20 padding-bottom-0 bootstrap-wrapper">
            <h4 class="subtitle">
                <cv:msg key='header.snapshotManagement' bundle='clients'/>
            </h4>
            <div class="form-group row">
                <label class="col-xs-12 col-sm-4" for="snapshotManagement" ><cv:msg key='label.engineName' bundle='clients'/></label>
                <div  class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                    <isteven-multi-select id="createFsContentGroup_isteven-multi-select_snapshotManagement"
						input-model="ctrl.engineLists"
						output-model="ctrl.model"
						button-label="name"
						item-label="name"
						helper-elements="filter"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						selection-mode="single"
						translation="ctrl.localLang">
					</isteven-multi-select>
					<input type="text" name="snapshotManagement" id="snapshotManagement" ng-model="ctrl.model" ng-hide="true" required/>
					<span class="help-block" ng-show="cv.createFsContentGroup.needsAttention(createFsContentGroup.snapshotManagement)">
                        <cv:msg key="label.selectSnapshotEngine" bundle="clients" />
                    </span>
                </div>
            </div>
        </div>

        <div class="bootstrap-wrapper modal-list margin-top-20" data-ng-if="!ctrl.isNasOnlySolution && !ctrl.isHadoopAgent && !ctrl.isClusterTypeFileSystem && (!ctrl.isArchival || (ctrl.isArchival && !ctrl.isNasContentGroup))">
            <prepost-commands client-id="ctrl.prepostClientId" form-name="createFsContentGroup" application-id="ctrl.prepostApplicationId" os-id="ctrl.osId" show-only-backup-process="true" browse-options="ctrl.browseOptions" set-format-data-fn="ctrl.setPrepostGetterFunction(getPrepostData)"></prepost-commands>
        </div>
        <div class="button-container">
                <button id="createFsContentGroup_button_#4299" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" ng-click="ctrl.$modal.dismiss()"><cv:msg key="Cancel" bundle="messages" /></button>
                <button id="createFsContentGroup_button_#2561" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages" /></button>
        </div>
    </form>
</div>