<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>

<div class="setup-title">
    <h1 ng-bind="ctrl.createBackupSetLabel"></h1>
</div>

<div class="setup-content bootstrap-wrapper padding-bottom-0">
    <form id="createFsBackupsetSimplified" name="createFsBackupsetSimplified" data-cv-submit="ctrl.createFsBackupset()" novalidate>
            <span class="server-message {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message"></span>
            <label for="backupSetName" class="input">
                    <span class="long-label-span"><cv:msg key="label.name" bundle="profiles" /></span>
                    <input type="text" id="backupSetName" name="backupSetName" data-ng-model="ctrl.backupsetInfo.backupSetName" data-ng-change="ctrl.serverMessage.message=''" required/>
                    <span class="help-block" data-ng-show="cv.createFsBackupsetSimplified.needsAttention(createFsBackupsetSimplified.backupSetName);" ><cv:msg key="error.BackupsetName" bundle="clients" /></span>
            </label>
           
  
            <div class="modal-list margin-top-20" data-ng-if="ctrl.planPolicy && ctrl.planPolicy.plan.list && !ctrl.isArchival">
                <cv-entity-plan-policy-select cv-hide-policy-toggle-option="true" data-cv-model="ctrl.planPolicy" plan-selection-change="ctrl.onPlanSelection(planDetails)" data-cv-wrapper-class="'form-group row input'" no-bootstrap-wrapper-class="true" 
                    data-cv-label-class="'col-xs-12 col-sm-4'" data-cv-select-class="'col-xs-12 col-sm-8 company-multi-select padding-left-5'" data-cv-enable-content-view="true">
                </cv-entity-plan-policy-select>
            </div>
           	<div class="form-group row margin-left-5" data-ng-if="!ctrl.isArchival && ctrl.showFSMeditechSystemOption()">
                <div class="col-xs-1">
                    <toggle-control status="ctrl.isMeditechSystemEnabled ? 'enabled-activity':'disabled-activity'" data-ng-click="ctrl.toggleMeditechSystem()" title='<cv:msg key="label.enableMeditech" bundle="dr" />'></toggle-control>
                </div>
                <label class="col-xs-11"><cv:msg key="label.enableMeditech" bundle="dr" /></label>
            </div>
            <div ng-if="(!ctrl.isMeditechSystemEnabled) && (!ctrl.isArchival && !ctrl.isIBMIfileSystem)" class="form-group row margin-left-5">
                <div class="col-xs-12">
                    <div ng-if="ctrl.planPolicy.plan.selected.planId">
                        <label ng-if="ctrl.planPreviewEntity.isPlanHaveBackupContent" ng-bind="'label.backupContentPlan'| cvLoc"></label>
                        <plan-content-preview  plan-preview-entity="ctrl.planPreviewEntity" custom-class="margin-left-0 margin-top-20 margin-bottom-20"></plan-content-preview>
                        <label ng-if="ctrl.planPreviewEntity.isPlanHaveBackupContent" class="text-left margin-top-10">
                            <cv-toggle value="ctrl.overrideBackupContent" toggle-label="label.defineContent" help-text="'label.overrideBackupContent.helpText'" help-direction="top"></cv-toggle>
                        </label>
                    </div>
                </div>
            </div>
            <div  ng-if="ctrl.isArchival" class="modal-list margin-top-10 bootstrap-wrapper padding-bottom-0 margin-bottom-15">
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-4" for="archivalPlans"><cv:msg key="label.plan" bundle="archiving" /></label>
                    <div  class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                        <cv-plan-summary-dropdown
                            input-model="ctrl.archivalPlans"
                            output-model="ctrl.selectedArchivalPlanList"
                            item-label="'planName'"
                            button-label="'planName'"
                            tick-property="'selected'"
                            selection-mode="'single'"
                            directive-id="'createFsContentGroup_isteven-multi-select_#687885'"
                            class="full-width" on-close="ctrl.changeArchivalPlan()">
                        </cv-plan-summary-dropdown>
                        <input type="text" name="archivalPlans" id="archivalPlans" ng-model="ctrl.selectedArchivePlan" ng-hide="true" required/>
                        <div class="help-block" ng-show="cv.createFsBackupsetSimplified.needsAttention(createFsBackupsetSimplified.archivalPlans)">
                            <i class="ion-alert-circled"></i>
                            <span><cv:msg key="error.plan" bundle="archiving" /></span>
                        </div>
                    </div>
                </div>
                <cv-archiving-rules cv-disk-cleanup-rules="ctrl.diskCleanupRules" cv-output-model="ctrl.savedDiskCleanupRules" cv-enable-toggle-override-archiving-rules="'true'" cv-enable-preview-mode="'true'" ng-if="ctrl.diskCleanupRules"></cv-archiving-rules>
                <div class="form-group row" ng-if="ctrl.isNAS">
                    <label class="col-xs-12 col-sm-4" for="archivalAccessNodes"><cv:msg key="label.accessNode" bundle="archiving" /></label>
                 
                    <div  class=" col-xs-12 col-sm-8 company-multi-select padding-left-5">
                        <isteven-multi-select id="createFsBackupsetSimplified_isteven-multi-select_#687d886" 
                            input-model="ctrl.accessNodes"
                            output-model="ctrl.selectedAccessNode"
                            button-label="clientName"
                            item-label="clientName"
                            selection-mode="multiple"
                            tick-property="selected"
                            translation="ctrl.localLang"
                            class="isteven-multi-select user-group-select">
                        </isteven-multi-select>
                        <input type="text" name="archivalAccessNodes"  ng-model="ctrl.selectedAccessNode" ng-hide="true" required/>
                        <div class="help-block" ng-show="cv.createFsBackupsetSimplified.needsAttention(createFsBackupsetSimplified.archivalAccessNodes)">
                            <i class="ion-alert-circled"></i>
                            <span><cv:msg key="error.accessNode" bundle="archiving" /></span>
                        </div>
                    </div>
                </div>
            </div>
            <span class="cv-help-block ng-scope" data-ng-if="ctrl.emptyContentError" ng-bind="'error.addContent' | cvLoc"></span>
            <div data-ng-show="(!ctrl.isMeditechSystemEnabled) && (ctrl.overrideBackupContent || !ctrl.planPreviewEntity.isPlanHaveBackupContent)" class="row modal-list bootstrap-wrapper padding-bottom-5">
                <cv-content-selection class="form-group" data-options='ctrl.contentOptions' data-content-entities='ctrl.contentEntities'>
                </cv-content-selection>
            </div>
            
            <div class="margin-top-20" ng-if="!ctrl.isArchival">
                <input type="checkbox" id="isDefaultBackupSet" name="isDefaultBackupSet" data-ng-model="ctrl.backupsetInfo.isDefaultBackupSet" />
                <label for="isDefaultBackupSet"><cv:msg key="label.makeDefaultBackupset" bundle="clients" /></label>
            </div>

            <div class="button-container">
                    <button id="createFsBackupsetSimplified_button_#1267" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="ctrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
                    <button id="createFsBackupsetSimplified_button_#7979" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages" /></button> 
            </div>        
    </form>
</div>