<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1>
		<cv:msg key="label.associateToCompany" bundle="profiles" />
	</h1>
</div>

<div class="padding-left-15 padding-right-15 padding-top-10">
	<div class="loading-data margin-top-50 text-center" ng-if="!ctrl.initComplete">
		<div class="loader-skeleton tile-style margin-bottom-15"></div>
		<div class="loader-skeleton tile-style margin-bottom-5"></div>
	</div>

	<span
		class="col-xs-12 padding-0 text-center margin-left-0 margin-right-0 serverMessage"
		ng-class="ctrl.serverMessage.type"
		ng-bind="ctrl.serverMessage.message"
		ng-if="ctrl.serverMessage.message"
	></span>

	<form name="associateCompaniesWithEntity" cv-submit="ctrl.saveAssociations()" class="bootstrap-wrapper">
		<cv-kendo-grid
			ng-if="ctrl.companyListGridOptions"
			data-cv-grid-options="ctrl.companyListGridOptions"
		></cv-kendo-grid>

		<div class="button-container">
			<button
				id="associate-entity-cancel"
				type="button"
				class="btn btn-default cvBusyOnAjax"
				ng-click="ctrl.closeModal()"
				ng-bind="ctrl.companyList.length ? 'Cancel' : 'label.closeCompanyAssociation' | cvLoc"
			></button>
			<button id="associate-to-company-save" type="submit" class="btn btn-primary cvBusyOnAjax" ng-if="ctrl.companyList.length">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>
