<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<!-- <h1 class="page-title">
	<span data-ng-bind="clientGroupDetails.clientGroup.clientGroupName"	data-ng-show="serverMessage.message==''"></span>
	<span data-ng-bind="serverMessage.message"></span>
</h1> -->
<div class="row">
	<div class="col-md-12" data-ng-if="clientGroupDetails && clientGroupDetails.clientGroup.clientGroupId != specialClientGroup.clientGroupId">
		<h1 class="float-left" data-ng-bind="clientGroupDetails.clientGroup.clientGroupName"></h1>
		<cv-capability-links data-ng-if="clientGroupDetails" cv-permitted-options="permittedOptions"></cv-capability-links>
	</div>
</div>
<div class="row" data-ng-if="showTiles">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="clientDetails-pageHeader_dlp-settings" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="clientGroupDetails.dlpPropertise">
			<ul class="list-style__row group">
				<!-- region add/edit block -->
                <li class="group" data-ng-if="planRuleEnabled">
                	<cv-region-select class="planMigration-block" data-cv-client-id="clientGroupId" data-cv-client-region-info="clientRegion" client-api="ClientGroup"></cv-region-select>
                </li>
                <!-- End region add/edit block -->	
				<li>
					<span class="pageDetailColumn"><cv:msg key="label.showDLP" bundle="clients" /> </span>
					<span class="pageDetailColumn pull-right">
						<toggle-control class="dlpShowToggle" status="dlpShowToggle" data-ng-click="showHideDLP()" title="<cv:msg key="label.enableDisable" bundle="messages"/>"></toggle-control>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<div data-ng-show="clientGroupDetails.clientGroup.clientGroupId != specialClientGroup.clientGroupId">
			<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded'>
			</cv-security-component>
		</div>
		<div data-ng-show="clientGroupDetails.clientGroup.clientGroupId != specialClientGroup.clientGroupId">
			<cv-activity-control-component data-ac-params="acParams">
			</cv-activity-control-component>
		</div>
	</div>
                       	
   	<div class="col-md-6">
       	<div data-ng-show=clientGroupDetails.powerManagementInfo.isPowerMgmtSupported>
            <cv-tile-component data-ac-id = "title-powerManagement" data-title='<cv:msg key="title.powerManagement" bundle="storage"/>'> 
            <div class="page-details-box-links" >
            <a href="" data-ng-click="editClientGroupPowerMgnt(clientGroupDetails.clientGroup.clientGroupId)"><cv:msg key="action.edit" bundle="storage" /></a>
            </div>
       	  
            <ul class="list-style-secondary">
	            <li class="group" data-ng-show="!clientGroupDetails.powerManagementInfo.isPowerManagementEnabled">
	                <span class="pageDetailColumn"><cv:msg key="label.powerManagementDisabled" bundle="storage" /></span>
	            </li>
	            <li class="group" data-ng-show="clientGroupDetails.powerManagementInfo.isPowerManagementEnabled">
	                <span class="pageDetailColumn"><cv:msg key="label.cloudController" bundle="storage" /></span>
	                <span class="pageDetailColumn" data-ng-bind="clientGroupDetails.powerManagementInfo.selectedCloudController.clientName"></span>
	            </li>
            </ul>
            </cv-tile-component>
        </div>
    
	    <div data-ng-if = "clientGroupId && clientGroupDetails">
	    	<cv-global-exceptions-component data="clientGroupDetails" id = "clientGroupId" source-page = "clientGroupDetails"></cv-global-exceptions-component>
	    </div>
	</div>
</div>
<div data-ng-if="showServersTiles" class="dashboard">
	<div class="dash-details-page">
		<div class="servers-list-page">
			<div class="row">
				<div class="col-lg-4 col-md-12 col-sm-12 dash-col">
					<div class="first-row-tile">
						<cv-reports-usage-overview dashboard-type="'server'" entity-class="'servers-env-summary'" ></cv-reports-usage-overview>
					</div>
				</div>
				
				<div class="col-lg-4 col-md-12 col-sm-12 dash-col">
					<div class="first-row-tile">
						<cv-reports-need-attention dashboard-type="'server'" entity-class="'servers-attn-summary'"></cv-reports-need-attention>
					</div>
				</div>
				<div class="col-lg-4 col-md-12 col-sm-12 dash-col">
					<div class="second-row-tile">
						<cv-reports-sla sla-data="{dashboardType: 'server', showAsSmaller: 'true'}"></cv-reports-sla>
					</div>
				</div>	
			</div>
		</div>	
	</div>
</div>
<cv-grid cv-grid-options="gridOptions">
	<svg data-cv-on-grid-empty class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
		<path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"/>
	</svg>
</cv-grid>
