<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title">
<h1><cv:msg key="label.managePlan" bundle="servers"/></h1>
</div>
  <form name="changePlan" novalidate autocomplete="off" >
	<div class="error" data-ng-bind-html="errorMessage" data-ng-if="errorMessage"></div>
		<div class="bootstrap-wrapper form-horizontal">
		<div class="row">
			<div class="col-sm-4">
					<label class="cv-label padding-left-20 padding-top-30"><cv:msg key="label.selectPlan" bundle="servers"/></label>
			</div>
			<div class="col-sm-8" >
				<div class="modal-body" >
					<cv-plan-summary-dropdown
						input-model="planList"
						output-model="selectedPlan"
						item-label="'planName'"
						button-label="'planName'"
						tick-property="'selected'"
						selection-mode="'single'"
						max-labels="1"
						group-property="'msGroup'"
						helper-elements="'filter'"
						directive-id="'plans'"
						show-none="true"
						translation="localLang"
						on-close="parseIStevenOutput()">
					</cv-plan-summary-dropdown>

				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="changePlanCancelButton" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
		<button id="changePlanSaveButton" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="save()" ><cv:msg key="Save" bundle="messages" /></button>
	</div>
</form>
