<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.changeCompany" bundle="servers"/></h1>
</div>
<form name="changeCompany" novalidate autocomplete="off" >
	<div class="error" data-ng-bind-html="changeCompanyCtrl.errorMessage" data-ng-if="changeCompanyCtrl.errorMessage"></div>
	<div class="bootstrap-wrapper form-horizontal">
		<div class="row">
			<div class="col-sm-4">
					<label class="cv-label padding-left-20 padding-top-30"><cv:msg key="label.selectCompany" bundle="subscriptions"/></label>
			</div>

			<div class="col-sm-8" >
				<div data-ng-click="changeCompanyCtrl._clearErrorMessage()" data-ng-if="changeCompanyCtrl.companiesList" class="modal-body" >
				    <isteven-multi-select
							input-model="changeCompanyCtrl.companiesList"
							output-model="changeCompanyCtrl.selectedCompany"
							button-label="name"
							item-label="name"
							tick-property="selected"
							selection-mode="single"
							directive-id="name"
							class="isteven-multi-select user-group-select single-select"
							helper-elements="filter"
							max-labels="1"
							prevent-sort="true"
							translation="changeCompanyCtrl.localLang">
					</isteven-multi-select>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="changeCompanyCancelButton" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="changeCompanyCtrl._cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
		<button id="changeCompanyPreviewButton" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="changeCompanyCtrl._preview()" data-ng-disabled="changeCompanyCtrl.companiesList.length == 0" ><cv:msg key="label.preview" bundle="collectionsJs" /></button>
	</div>
</form>
