<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
		<cv:cvMessages bundle="localization.facets"></cv:cvMessages>
		<cv:cvMessages bundle="localization.search"></cv:cvMessages>
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
        <cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
 <div class="row">
	<div class="col-xs-12 flex-detail-header">
		<h1 class="page-title"><span data-ng-bind="backupSetDetails.backupSetEntity.backupsetName" data-ng-show="serverMessage.message==''"></span></h1>
		<span class="flex-page-actions">
			<cv-search-box  ng-if="searchModel" query="searchModel.query" on-search="onBackupsetSearch(query, fields)" custom-class="searchModel.customClass" field-defs="searchModel.fieldDefs"></cv-search-box>
			<cv-capability-links class="flex-page-actions margin-top-5" data-ng-if="backupSetDetailsActionsLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>
		</span>
		
	</div>
</div>
 <div class="row">
	<div class="col-xs-12">
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	</div>
</div>
<!-- <cv-tab-nav data-ng-if="fsSolutionState"></cv-tab-nav> -->
<div class="row ">
	<div class="col-md-6">
		<cv-tile-component data-ng-hide="isSharePointAgent" data-ac-id="spBackupSetDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients"/>' data-loader="backupSetDetails" cv-capability="cvCapabilityConfig.general">
		<div data-ng-hide="generalTileEditModeEnabled">
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.server" bundle="fs" /></span>
					<a href="#/clientDetails/{{backupSetDetails.backupSetEntity.clientId}}" class="pageDetailColumn" data-ng-bind="clientDisplayName"></a></li>
				<li  data-ng-if="!fsSolutionState" class="group"><span class="pageDetailColumn"><cv:msg key="label.agent" bundle="collections" /></span>
					<span class="pageDetailColumn" data-ng-bind="backupSetDetails.backupSetEntity.appName"></span></li>
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.defaultBackupSet" bundle="clients" /></span>
					<span class="pageDetailColumn">
						<toggle-control status="isDefaultBackupSet ? 'enabled-activity' : 'disabled-activity'" disabled="isDefaultBackupSet || onDemandBackupset"
						data-ng-click="modifyDefaultBackupSet()" title='<cv:msg key="label.toggleDefaultBackupset" bundle="servers" />'>
						</toggle-control>
					</span>
				</li>
				<li data-ng-show="planName" class="group">
					<cv-plan-select show-none="true" show-edit="true" plan-entity="backupSetDetails.planEntity" entity="backupSetDetails.backupSetEntity" ng-if="backupSetDetails.backupSetEntity"></cv-plan-select>
				</li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.column.status" bundle="job" /></span>		
					
					<span class="text-capitalize" ng-class="{'green-font': backupSetDetails.commonBackupSet.slaStatus === 'MET_SLA', 'red-font': backupSetDetails.commonBackupSet.slaStatus === 'MISSED_SLA'}">
						<cv-help-text help-label="{{backupSetDetails.status}}" help-text="backupSetDetails.statusHelpText"></cv-help-text>
					</span>
				</li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastBackupTime" bundle="storage" /></span>
					<span  data-ng-if="backupSetDetails.lastBackupTime" class="pageDetailColumn" data-ng-bind="backupSetDetails.lastBackupTime | customDateTime"></span>
					<span data-ng-if="!backupSetDetails.lastBackupTime" class="pageDetailColumn"><cv:msg key="label.neverBackedUp" bundle="serversJs" /></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.firstBackupTime" bundle="clients" /></span>
					<span  data-ng-if="backupSetDetails.firstBackupTime" class="pageDetailColumn" data-ng-bind="backupSetDetails.firstBackupTime | customDateTime">></span>
					<span data-ng-if="!backupSetDetails.firstBackupTime" class="pageDetailColumn"><cv:msg key="label.neverBackedUp" bundle="serversJs" /></span></li>
				<li class="group"><span class="pageDetailColumn"><cv-help-text
					help-label="{{'label.column.applicationSize' | cvLoc}}"
					help-text="'label.column.applicationSizeText' | cvLoc" /></span> <span
					class="pageDetailColumn"
					data-ng-bind="backupSetDetails.applicationSize	| capacity"></span>
				</li>
				<!-- <li class="group"><span class="pageDetailColumn"><cv-help-text
					help-label="{{'label.totalbackup.size' | cvLoc}}"
					help-text="'label.totalbackup.text' | cvLoc" /></span> <span
					class="pageDetailColumn"
					data-ng-bind="backupSetDetails.totalBackupSize | capacity"></span>
				</li>	 -->
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.savingsPercentage" bundle="job" /></span>
					<span class="pageDetailColumn">
						<span data-ng-bind="backupSetDetails.dedupeRatio"></span>
						<cv-call-out html-template="savingsPercentageCallOutTemplate"></cv-call-out>
					</span>
				</li>
			</ul>
		</div>
		</cv-tile-component>
		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded="associationsLoaded" cv-capability="cvCapabilityConfig.security">
		</cv-security-component>
	</div>
	<div class="col-md-6">
		<cv-backup-history entity="backupEntity" params="params" on-restore="performBackupsetRestore(job, toTimeStr, restoreLevel)" ng-if="backupEntity"></cv-backup-history>
		<!-- sharepoint office365 properties tile-->
		<span data-ng-if="backupSetDetails.sharepointBackupSet.spOffice365BackupSetProp && isSPOffice365">
			<cv-tile-component data-ac-id="spBackupSetDetails-label_office365Details-sharepoint" data-title='<cv:msg key="label.office365Details" bundle="sharepoint" />'>
				<div>
					<ul class="group list-style-secondary">
						<li class="group">
								<span class="pageDetailColumn"><cv:msg key="label.tenantURL" bundle="sharepoint" /></span>
							<span class="pageDetailColumn" data-ng-if=spOffice365Prop data-ng-bind="backupSetDetails.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem"></span>
							</li>
							<li class="group" >
								<span class="pageDetailColumn"><cv:msg key="label.azureUserAccount" bundle="sharepoint" /></span>
							<span class="pageDetailColumn" data-ng-bind="backupSetDetails.sharepointBackupSet.spOffice365BackupSetProp.azureUserAccount"></span>
							</li>
							<li class="group" >
								<span class="pageDetailColumn"><cv:msg key="label.office365user" bundle="sharepoint" /></span>
								<span class="pageDetailColumn" data-ng-bind="backupSetDetails.sharepointBackupSet.spOffice365BackupSetProp.office365Credentials.userName"></span>
							</li>
					</ul>
					<div class="page-details-box-links">
					<a href="" data-ng-click="editOffice365Prop()"><cv:msg key="action.edit" bundle="profiles" /></a>
					</div>
				</div>
			</cv-tile-component>
		</span>
	</div>
</div>
<cv-grid cv-grid-options="gridOptions" ng-if="!isFileSystemAgent"></cv-grid>
<cv-kendo-grid data-cv-grid-options="kendoGridOptions" ng-if="isFileSystemAgent && kendoGridOptions"></cv-kendo-grid>
