<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content backup-options">
	<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<span data-ng-show="!backupMsg">
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
		</div>
		<div class="global-options remove-border-padding">
			<label data-ng-hide="hideFullBackupLevel">
				<input type="radio" ng-model="backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule"/>
			</label>
			<label data-ng-show="isIncrementalSupported">
				<input type="radio" ng-model="backupType" value="INCREMENTAL">
				<cv:msg key="option.incremental" bundle="schedule"/>
			</label>
			<label data-ng-show="isTransactionLogSupported">
				<input type="radio" ng-model="backupType" value="TRANSACTION_LOG">
				<cv:msg key="option.transactionlog" bundle="schedule"/>
			</label>
			<label data-ng-show="isDifferentialSupported">
				<input type="radio" ng-model="backupType" value="DIFFERENTIAL">
				<cv:msg key="option.differential" bundle="schedule"/>
			</label>
			<label data-ng-show="isSyntheticFullSupported">
				<input type="radio" ng-model="backupType" value="SYNTHETIC_FULL">
				<cv:msg key="option.synthfull" bundle="schedule"/>
			</label>
		</div>
	</span>
	<div class="button-container">
		<button id="backupOptions_button_#2826" type="button" class="btn btn-primary" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="backupOptions_button_#8284" type="button" class="btn btn-default setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="backupOptions_button_#9878" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>