<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="form-group">
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<label for="title">
			<h1 id="title" class="full-width">
				<cv:msg key="title.editEncryption" bundle="storage" />
			</h1>
		</label>
	</div>
	<div class="setup-content">
        <span ng-if="serverMessage" class="error serverMessage">{{serverMessage}}</span>
		<form name="addProxyForm" novalidate cv-submit="addPolicy()" autocomplete="off" class="add-proxy-form" data-ng-hide="showSkip || formConfig.hide">
			<div class="global-options remove-border-padding">
                <label class="cv-inline-checkbox">
                    <input name="encrypt" id="encrypt" type="checkbox" ng-checked="modalEncyption.encrypt === true" data-ng-model="modalEncyption.encrypt" />
                    <label for="encrypt" class="cv-checkbox-label"><cv:msg key="title.encryption" bundle="storage" /></label>
                </label>
                <label
                 data-ng-class="{'hidden': modalEncyption.encrypt === false }"
                 data-ng-show="cipherList"><cv:msg key="label.cipher" bundle="storage"/>
					<div class="company-multi-select">
                        <isteven-multi-select id="addStorageEncryptModal_isteven-multi-select_#9216" 
                            input-model="cipherList"
                            output-model="selectedCipher"
                            button-label="name"
                            item-label="name"
                            helper-elements="none"
                            hide-search-button="true"
                            tick-property="selected"
                            on-close="getkeyLengths()"
                            class="isteven-multi-select user-group-select"
                            selection-mode="single">
                        </isteven-multi-select>
					</div>
                </label>
                <label data-ng-class="{'hidden': modalEncyption.encrypt === false }" for="keyLength" class="" data-ng-show="keyLengths"><cv:msg key="label.keyLength" bundle="storage" />
					<div class="company-multi-select">
                        <isteven-multi-select id="addStorageEncryptModal_isteven-multi-select_#9849" 
                            input-model="keyLengths"
                            output-model="selectedKeyLength"
                            button-label="length"
                            item-label="length"
                            helper-elements="none"
                            hide-search-button="true"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            selection-mode="single">
                        </isteven-multi-select>
					</div>
                </label>
                <label class="cv-inline-checkbox">
                    <input name="storeOnMedia" id="storeOnMedia" type="checkbox" ng-checked="modalEncyption.storeOnMedia === true" data-ng-model="modalEncyption.storeOnMedia" />
                    <label for="storeOnMedia" class="cv-checkbox-label"><cv:msg key="label.storeKeysOnMedia" bundle="storage" /></label>
                </label>
                <label for="plans" class="" data-ng-show="keyManagement"><cv:msg key="label.keyManagement" bundle="storage" />
					<div class="company-multi-select">
                        <isteven-multi-select id="addStorageEncryptModal_isteven-multi-select_#4731" 
                            input-model="keyManagement"
                            output-model="selectedKeyManagement"
                            button-label="keyProviderName"
                            item-label="keyProviderName"
                            helper-elements="none"
                            hide-search-button="true"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            on-item-click="changedValue()"
                            selection-mode="single">
                        </isteven-multi-select>
					</div>
                </label>
            </div>
			<div class="button-container">
				<button id="addStorageEncryptModal_button_#8512" type="button" data-ng-if="setup" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="Skip" /></button> 
				<button id="addStorageEncryptModal_button_#9905" type="button" data-ng-if="!setup" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"><cv:msg key="Cancel" /></button> 
				<button id="addStorageEncryptModal_button_#9219" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
			</div>
		</form>
	</div>
</div>