<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.storage">
<div data-ng-controller="addStorageController">
<div class="setup-title">
	<h1 data-ng-if="action=='newDiskLib'"><fmt:message key="Add_Disk_Library" /></h1>
	<h1 data-ng-if="action=='editMP'"><fmt:message key="Edit_Path" /></h1>
	<h1 data-ng-if="action=='addMP'"><fmt:message key="Add_Path" /></h1>
</div>
<div class="setup-content" >
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="storageForm" class="{{typeOfStorage.type}}" novalidate data-cv-submit="addLibraryOrEditMountPath()" autocomplete="off">
		<label>
			<fmt:message key="Name" />
			<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" data-ng-readonly="action=='addMP'||action=='editMP'" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" required maxlength="128"/>
			<span class="help-block" data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><fmt:message key="error.libraryName.required" /></span>
			<span class="help-block" data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><fmt:message key="error.libraryName.length" /></span>
		</label>
		<label data-ng-if='agentList.length > 0' for="mediaAgent" class="select-label"><fmt:message key="label.mediaAgent"/>
				<select id="mediaAgent" name="mediaAgent" data-ng-model="libraryInfo.mediaAgentId"
						data-ng-options="agent.id as agent.name for agent in agentList | orderBy:'name'" required
						data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)}">
					<option value=""><fmt:message key="label.mediaAgent" /></option>
				</select>
				<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"><fmt:message key="error.mediaAgent" /></span>
		</label>
		<div class="storage-type">
			<label>
				<input type="radio" data-ng-model="typeOfStorage.type" value="localStorage" name="typeOfStorage" data-ng-disabled="action=='editMP'">
				<fmt:message key="Local_Path" />
			</label>
			<label>
				<input type="radio" data-ng-model="typeOfStorage.type" value="networkStorage" name="typeOfStorage" data-ng-disabled="action=='editMP'">
				<fmt:message key="Network_Path" />
			</label>
		</div>
		<div data-ng-if="typeOfStorage.type=='networkStorage' && action!='editMP'" class="credentials">
			<label>
				<fmt:message key="User Name" />
				<input type="text" name=loginName data-ng-model="libraryInfo.loginName"/>
			</label>
			<label>
				<fmt:message key="Password" />
				<input type="password" data-ng-model="libraryInfo.password"/>
			</label>
		</div>
		<label for="mountPath" data-ng-class="{'storage-path-label': typeOfStorage.type=='localStorage'}">
			<fmt:message key="Disk_Device" />
			<input data-ng-readonly="action=='editMP'" data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern.pattern'/>
			<span class="help-block" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><fmt:message key="error.mountpath.required" /></span>
			
			<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
							<fmt:message key="error.mountpath.invalid" />
			</span>
		</label>
		<button id="addStorage_button_#2234" type="button" data-ng-if="typeOfStorage.type=='localStorage' && action!='editMP'" data-ng-click="browse()" class="btn btn-default browse-btn"> 
			<fmt:message key="Browse" />
		</button>
		<div class="button-container">
			<button id="addStorage_button_#2079" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"> 
				<fmt:message key="Cancel" bundle="${common }"/>
			</button>
			<button id="addStorage_button_#5087" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-hide="action=='newDiskLib'||action=='addMP'" data-ng-click="deleteMountPath()"> 
				<fmt:message bundle="${common }" key="Delete" />
			</button>
			<button id="addStorage_button_#7197" class="btn btn-primary cvBusyOnAjax" type="submit" data-ng-if="action!='editMP'"> 
				<fmt:message bundle="${common }" key="Save" />
			</button>
		</div>
	</form>
</div>
</div>
</fmt:bundle>