<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1>
		    <label ng-if="!isEditMode">
				<cv:msg key="label.addIBMiServer" bundle="serversJs"/>
				<cv-help-component help-text="<cv:msg key="label.addIBMiHelpText" bundle="serversJs"/>"></cv-help-component>
			</label>
			<label ng-if="isEditMode">
				<cv:msg key="label.editIBMiServer" bundle="serversJs"/>
				<cv-help-component help-text="<cv:msg key="label.editIBMiHelpText" bundle="serversJs"/>"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
				<form name="addIBMiServerForm" id="addIBMiServerForm" novalidate autocomplete="off" class="add-IBMi-form">
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label word-wrap" for="clientName">
							<cv:msg key="label.clientName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="clientName" id="clientName" data-ng-model="IBMiServerRequest.entity.clientName" data-ng-change="helpText.clientName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.clientName"><cv:msg key="error.clientName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label word-wrap" for="hostName">
							<cv:msg key="label.hostName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="hostName" id="hostName" data-ng-model="IBMiServerRequest.entity.hostName" data-ng-change="helpText.hostName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.hostName"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="dataFolder">
							<cv:msg key="label.dataFolder" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="dataFolder" id="dataFolder" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.dataFolder" data-ng-change="helpText.dataFolder = false" required />
							<span class="cv-help-block" data-ng-show="helpText.dataFolder"><cv:msg key="error.dataFolder" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="cvdPort">
							<cv:msg key="label.cvdPort" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input 
							type="number" 
							name="cvdPort"
							id="cvdPort" 
							data-ng-model="IBMiServerRequest.clientInfo.openVMSProperties.cvdPort" 
							min="0" 
							max="9999" 
							required />
							<span data-ng-show="addIBMiServerForm.cvdPort.$invalid" class="cv-help-block"><cv:msg key="error.cvdPort" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="planId"> <cv:msg key="tableHeader.plan" bundle="users" />
							<span class="optional-text">
								<cv:msg key="label.optional" bundle="users" />
							</span>
						</label>
							<div class="cv-inline-wrapper">
								<div class="cv-app-page-config">
									<isteven-multi-select
											id="plan" 
											input-model="ibmiPlansInputModal"
											button-label="planName"
											item-label="planName"
											selection-mode="single"
											search-property="planName planId"
											tick-property="ticked"
											class="isteven-multi-select user-group-select"
											helper-elements="filter none"
											on-item-click="selectPlan(data)"
											translation="localLang">
									</isteven-multi-select>
								</div>
							</div>
					</div>
					<div class="cv-modal-wrapper" data-ng-show="IBMiServerRequest.clientInfo.plan">
						<div class="cv-inline-wrapper">
							<div class="optional-text">
								<cv:msg key="helptext.plan.DRSubclientExceptionOnClient" bundle="servers"/>
							</div>
						</div>
					</div>
					<h4 class="text-left padding-left-20"><cv:msg key="label.IBMiUserCredentials" bundle="serversJs" /></h4>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="userName">
							<cv:msg key="label.userName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input 
							type="text" 
							name="userName" 
							id="addIBMiServer_userName_input1" 
							data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.userProfile.userName" 
							data-ng-pattern="/^[$a-zA-Z]([a-zA-Z0-9_@#$])*$/"
							data-ng-maxlength="9"
							required />
							<span 
							class="cv-help-block" 
							data-ng-show="addIBMiServerForm.userName.$invalid && addIBMiServerForm.userName.$touched">
								<cv:msg key="error.userName" bundle="serversJs"/>
							</span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="password">
							<cv:msg key="label.password" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="password" name="password" id="password" placeholder="{{ keepSamePlaceholder }}" data-ng-model="dummy.password" data-ng-change="helpText.password = false" ng-required="!isEditMode" />
							<span class="cv-help-block" data-ng-show="addIBMiServerForm.password.$error.required && addIBMiServerForm.password.$dirty"><cv:msg key="error.password" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="confirmPassword">
							<cv:msg key="label.confirmPassword" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="password" name="confirmPassword" data-cv-equals="{{ dummy.password }}" id="confirmPassword" data-ng-model="dummy.confirmPassword" data-ng-change="helpText.confirmPassword = false" ng-required="!isEditMode" />
							<span class="cv-help-block" data-ng-show="addIBMiServerForm.confirmPassword.$error.cvEquals && addIBMiServerForm.password.$dirty"><cv:msg key="error.confirmPassword" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label word-wrap" for="proxyClient">
							<cv:msg key="label.proxyClient" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<div class="cv-app-page-config">
								<isteven-multi-select id="addIBMiServer_isteven-multi-select_#3689" input-model="proxyClientList" output-model="selectedProxyClient" helper-elements="filter reset" button-label="clientName" item-label="clientName" tick-property="selected" class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter" on-reset="reset()" on-close="helpText.proxyClient = false; addProxyClientSelected()" selection-mode= {{selectionMode}} required translation="localLang"></isteven-multi-select> 
							</div>
							<span class="cv-help-block" data-ng-show="helpText.proxyClient"><cv:msg key="error.proxyClient" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="subsystemDescription">
							<cv:msg key="label.subsystemDescription" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="subsystemDescription" id="subsystemDescription" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.subsysDescription" data-ng-change="changeSubsystemDescription(); helpText.subsystemDescription = false" required />
							<span class="cv-help-block" data-ng-show="helpText.subsystemDescription"><cv:msg key="error.subsystemDescription" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="jobQueue">
							<cv:msg key="label.jobQueue" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" data-ng-disabled="IBMiServerRequest.clientInfo.ibmiInstallOptions.createJobQueue" name="jobQueue" id="jobQueue" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.jobQueue" data-ng-change="helpText.jobQueue = false" required />
							<span class="cv-help-block" data-ng-show="helpText.jobQueue"><cv:msg key="error.jobQueue" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label">&nbsp;</label>
						<div class="cv-inline-wrapper float-none margin-left-20 margin-top-5">
								<input id="createJobQueue" name="createJobQueue" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.createJobQueue" data-ng-change="createJobQueueChanged()" type="checkbox" />
								<label for="createJobQueue"><cv:msg key="label.createJobQueue" bundle="serversJs" /></label>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="jobPriority">
							<cv:msg key="label.jobPriority" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="number" name="jobPriority" id="jobPriority" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.jobPriority" data-ng-change="helpText.jobPriority = false" required />
							<span class="cv-help-block" data-ng-show="helpText.jobPriority"><cv:msg key="error.jobPriority" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="runPriority">
							<cv:msg key="label.runPriority" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="number" name="runPriority" id="runPriority" data-ng-model="IBMiServerRequest.clientInfo.ibmiInstallOptions.runPriority" data-ng-change="helpText.runPriority = false" required />
							<span class="cv-help-block" data-ng-show="helpText.runPriority"><cv:msg key="error.runPriority" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="button-container">
						<button id="addIBMiServer_button_#8741" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="addIBMiServer_button_#3513" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="serverMessage.message!='' || addIBMiServerForm.$invalid" data-ng-click="addIBMiServer()"><cv:msg key="Save"/></button> 
					</div>
				</form>
			</div>
	</div>
