<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>

<div class="setup-title" ng-switch="createGPFSCtrl.clusterTypeForCreation">
    <h3 ng-switch-when="11"><cv:msg key="header.addGlusterFSClient" bundle="profiles" /></h3>
    <h3 ng-switch-when="13"><cv:msg key="header.addLustreClient" bundle="profiles" /></h3>
    <h3 ng-switch-default><cv:msg key="header.addGPFSClient" bundle="profiles" /></h3>
</div>

<div class="setup-content nas-file-storage-modal">
    <div>
        <p class="{{createGPFSCtrl.gpfsMessage.type}} serverMessage" ng-bind="createGPFSCtrl.gpfsMessage.message"></p>
    </div>
    <form class="bootstrap-wrapper modal-margin" name="createGPFSServerForm" novalidate autocomplete="off" data-cv-submit="createGPFSCtrl.createGPFSServer()">
        <div>
            <div class="form-group row">
                <label class="col-xs-12 col-md-4" for="serverName"><cv:msg key="label.name" bundle="profiles" /></label>
                <div class="col-xs-12 col-md-8 padding-right-20">
                    <input class="full-width" type="text" name="serverName" id="serverName" ng-model="createGPFSCtrl.name">
                    <span class="cv-help-block margin-top-5" ng-show="createGPFSCtrl.errors.emptyName && createGPFSCtrl.name.length === 0"><cv:msg key="error.name" bundle="settingsJs" /></span>
                </div>
            </div>
            <div class="form-group row margin-top-20">
                <label class="col-xs-12 col-md-4" for="serverName"><cv:msg key="label.accessNodes" bundle="servers" /></label>
                <div class="col-xs-12 col-md-8 padding-right-20">
                    <cv-accessnode-dropdown accessnodeoptions="createGPFSCtrl.accessNodeOptions" directive-id="accessnode-selection-dropdown" />
                </div>
            </div>
            <div class="form-group row margin-top-20" ng-class="{'cv-flex': !createGPFSCtrl.fsPlans}">
                <label for="gpfs-plan-select" class="col-xs-12 col-md-4"><cv:msg key="label.profile" bundle="profiles" /></label>
                <div class="col-xs-12 col-md-8 padding-right-20" ng-if="createGPFSCtrl.fsPlans">
                    <cv-plan-summary-dropdown 
                        input-model="createGPFSCtrl.fsPlans" 
                        button-label="'planName'" 
                        item-label="'planName'"
                        directive-id="'gpfs-plan-select'" 
                        tick-property="'selected'" 
                        max-labels="1" 
                        selection-mode="'single'" 
                        helper-elements="'filter'"
                        on-item-clicked="createGPFSCtrl.onPlanSelected(selectedPlan)"
                    />
                    <span class="cv-help-block margin-top-5" ng-show="createGPFSCtrl.errors.planUnselected && !createGPFSCtrl.selectedPlan"><cv:msg key="error.selectPlan" bundle="profiles" /></span>
                </div>
                <div class="col-xs-12 col-md-8 margin-top-10 text-center" ng-show="!createGPFSCtrl.fsPlans"><img src="${pageContext.request.contextPath}/img/loading.gif"></div>
            </div>
            <div class="position-relative">
                <div class="form-group row margin-top-20" ng-repeat="(key, content) in createGPFSCtrl.clientContent">
                    <div class="col-xs-12 col-md-4 line-height-31" ng-bind="content.contentTypeLabel"></div>
                    <div class="col-xs-12 col-md-7 line-height-31 text-center">
                        <span class="crop max-width" ng-bind="content.contentLabel" popover-class="no-border" uib-popover-html="createGPFSCtrl.getContentPopOver(content)"  popover-trigger="'mouseenter'"></span>
                    </div>
                </div>
                <div class="position-absolute top-0 right-0 line-height-31">
                    <a class="inline-editor-button text" id="edit-content" ng-click="createGPFSCtrl.overrideContentForClient()"><cv:msg key="label.edit" bundle="settingsJs" /></a>
                </div>
            </div>
        </div>

        <div class="button-container">
            <button class="btn btn-default cvBusyOnAjax" type="button" ng-click="createGPFSCtrl.dismissModal()"><cv:msg key="action.cancel" bundle="profiles" /></button>
            <button class="btn btn-primary cvBusyOnAjax" type="submit" ng-disabled="!createGPFSCtrl.fsPlans.length"><cv:msg key="action.save" bundle="profiles" /></button>
        </div>
    </form>
</div>