<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>
<div>
	<div class='modal-header'>
        <h5 data-ng-bind="addEntStgCtrl.confirmationTitle"></h5>
	</div>
	<div class="modal-body">
			<div class="row">
				<div class="col-md-3 dummy-col-entity-settings no-right-padding" data-ng-if="isEditMode">
					<p ng-bind="addEntStgCtrl.selectedSetting.keyName"></p>
				</div>
				<div class="col-md-3 no-right-padding typeahead-entity-setting" data-ng-if="!isEditMode">
					<input type="text" ng-model="addEntStgCtrl.selectedSettingKeyName" uib-typeahead="setting.keyName for setting in settingsData | filter:$viewValue | limitTo:10" placeholder="Enter setting name" typeahead-on-select="addEntStgCtrl.selectEntitySettingTA($item)">
					<a href="" class="lookup-button" data-ng-click="addEntStgCtrl.openLookup()" uib-tooltip="Lookup" tooltip-placement="top" >
						<span class="global-search-icon">
							<span class="glyphicon glyphicon-search"></span>
						</span>
					</a>
				</div>
				<div class="col-md-4 entities-form entities-target">
					<button id="" type="button" ng-click="addEntStgCtrl.toggleDropdown()" class="ng-binding tree-dropdown-button tree-dropdown-button-entity-settings">
					<span ng-bind="addEntStgCtrl.getEntities()"></span>
					<span class="caret"></span></button>
					<div class="dropdown-menu margin-top-0 entities-dropdown" ng-class="{'visible-dropdown' : showDropdown }">
						<cv-entity-selection-tree-component
						data-tree-options="addEntStgCtrl.treeParams">
						</cv-entity-selection-tree-component>
				</div>
				</div>
				<div data-ng-if="settingType" class="col-md-3 no-padding-right">
					<input type="text" data-ng-if="settingType == 'STRING' || settingType == 'MULTISTRING'"  ng-model="addEntStgCtrl.value" class="form-control additional-settings-input" placeholder="<cv:msg key='label.enterText' bundle='settings' />" uib-tooltip="<cv:msg key='label.enterAdditionalSettingValue' bundle='settings' />" ng-change="addEntStgCtrl.validateSetting()" ng-disabled="!valueInputReady"/>
					<input data-ng-if="settingType == 'INTEGER'" type="number" ng-model="addEntStgCtrl.value" class="form-control additional-settings-input" uib-tooltip="<cv:msg key='label.enterAdditionalSettingValue' bundle='settings' />" tooltip-placement="top" placeholder="<cv:msg key='label.enterNumber' bundle='settings' />" ng-change="addEntStgCtrl.validateSetting()"/>
					<div class="uib-dropdown entity-boolean-value-selection" data-uib-dropdown data-ng-if="settingType == 'BOOLEAN'">
						<a class="uib-dropdown-toggle dropdown-toggle no-user-select" data-uib-dropdown-toggle>
							<span ng-bind="addEntStgCtrl.getBoolString()"></span>
							<span class="k-icon k-i-arrow-60-down k-menu-expand-arrow"></span>
						</a>
						<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 margin-top-0">
							<li class='additionalSettingOption' data-ng-click="selectBoolean(boolValues.trueValue)"><cv:msg key='label.true' bundle='settings' /></li>
							<li class='additionalSettingOption' data-ng-click="selectBoolean(boolValues.falseValue)"><cv:msg key='label.false' bundle='settings' /></li>
						</ul>
					</div>
					<span class="cv-help-block entity-setting-help-block"
						ng-if="(!addValid) && showValidationMessage">
						<cv:msg key='label.enterValidValue' bundle='settings' />
					</span>
				</div>
				<div data-ng-if="!settingType" class="col-md-3 no-padding-right">
					<input type="text" class="form-control additional-settings-input" placeholder="Enter value" ng-disabled="true"/>
				</div>
				<div class="col-md-2">
					<button 
					class='btn btn-primary' ng-click="addEntStgCtrl.addSetting()" ng-disabled="(!addValid) || (!checkEntityValid()) ">Add
				</button>
				</div>
			</div>

			<div ng-if="selectedSetting" class="setting-info entity-setting-additional-info">
				<div class="row margin-top-bottom-additional-settings" ng-if='addEntStgCtrl.selectedSetting.description'>
					<div class="col-md-2">
						<strong><cv:msg key='label.description' bundle='settings' /></strong>
					</div>
					<div class="col-md-10 entity-setting-info-description">
						<span ng-bind="addEntStgCtrl.selectedSetting.description"></span>
					</div>
				</div>
				<div class="row margin-top-bottom-additional-settings">
					<div class="col-md-2">
						<strong><cv:msg key='label.type' bundle='settings' /></strong>
					</div>
					<div class="col-md-2">
						<span ng-bind="addEntStgCtrl.selectedSetting.type"></span>
					</div>
					<div class="col-md-1"></div>
					<div class="col-md-2">
						<strong><cv:msg key='label.category' bundle='settings' /></strong>
					</div>
					<div class="col-md-2">
						<span ng-bind="addEntStgCtrl.selectedSetting.category"></span>
					</div>
				</div>
				<div class="row margin-top-bottom-additional-settings" ng-if='showMinMax()'>
					<div class="col-md-2">
						<strong><cv:msg key='label.minValue' bundle='settings' /></strong>
					</div>
					<div class="col-md-2">
						<span ng-bind="addEntStgCtrl.selectedSetting.minValue"></span>
					</div>
					<div class="col-md-1"></div>
					<div class="col-md-2">
						<strong><cv:msg key='label.maxValue' bundle='settings' /></strong>
					</div>
					<div class="col-md-2">
						<span ng-bind="addEntStgCtrl.selectedSetting.maxValue"></span>
					</div>
				</div>
				<div class="row margin-top-bottom-additional-settings">
					<div class="col-md-2" ng-if="showDefaultValue()">
						<strong><cv:msg key='label.defaultValue' bundle='settings' /></strong>
					</div>
					<div class="col-md-2 overflow-wrap-word" ng-if="showDefaultValue()">
						<span ng-bind="addEntStgCtrl.selectedSetting.defaultValue"></span>
					</div>
					<div class="col-md-1" ng-if="showDefaultValue()"></div>
					<div class="col-md-2" ng-if="showSupportedValue()">
						<strong><cv:msg key='label.supportedValues' bundle='settings' /></strong>
					</div>
					<div class="col-md-2 overflow-wrap-word" ng-if="showSupportedValue()">
						<span ng-bind="getSupportedValues()"></span>
					</div>
				</div>

				<div class="entity-restart-message margin-top-bottom-additional-settings restart-warn" ng-if="addEntStgCtrl.selectedSetting.isRestartRequired">
					<cv:msg key='label.restartRequiredToApply' bundle='settings' />
				</div>
			</div>
			<div ng-if="showEntityGrid" class="entity-added-grid">
				<cv-kendo-grid id="entity-settings-sub-kendo-grid"  ng-if="entitySettingGridOptions"
				data-cv-grid-options="entitySettingGridOptions"></cv-kendo-grid>
			</div>
	</div>
	<div class="modal-footer button-container">
		<button id="deactivateSubscriptionWindow_button_#7775" type='button' class='btn btn-default cvBusyOnAjax' 
			data-ng-click='addEntStgCtrl.cancel()'>
			<cv:msg key="action.cancel" bundle='settings'></cv:msg>
		</button>
		<button id="deactivateSubscriptionWindow_button_#2428" type='button' data-ng-click="addEntStgCtrl.submit()" data-ng-disabled="!formValid" 
			class='btn btn-primary cvBusyOnAjax'>
			<cv:msg key="action.apply" bundle='settings'></cv:msg>
		</button>
	</div>
</div>