<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div data-ng-controller="addStorageController">
	<div class="setup-title">
		<h1 data-ng-if="action=='newDiskLib'"><cv:msg key="title.addDiskLibrary" bundle="storage" /></h1>
		<h1 data-ng-if="action=='editMP'"><cv:msg key="label.editAccessPath" bundle="storage"/></h1>
		<h1 data-ng-if="action=='addMP'">{{title}}</h1>
	</div>
	<div class="setup-content" >
		<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
		<p class="serverMessage">{{storagePresentMessage.message}}</p>
		<a data-ng-click="changeStorage()" data-ng-show="formStorage.hide"><cv:msg key="Edit Storage" bundle="storage"/></a>
		<form name="storageForm" ng-class="[typeOfStorage.type]" novalidate data-cv-submit="addEditShareLibrary()" autocomplete="off" data-ng-hide="formStorage.hide">
			<label class="add-collection-form">
                <cv:msg key="Name" bundle="storage"/>
                <div class="toggle-control name-text-ellipsis" data-ng-if="action=='addMP' || action=='editMP'">{{libraryInfo.libraryEntity.libraryName}}</div>
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" data-ng-if="action!='addMP' && action!='editMP'" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" required maxlength="128"/>
				<span class="help-block" data-ng-if="storageForm.libraryName.$error.required"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
				<span class="help-block" data-ng-if="storageForm.libraryName.$error.maxlength && storageForm.libraryName.$dirty"><cv:msg key="error.libraryName.length" bundle="storage"/></span>
			</label>
			<div class="add-collection-form form-group margin-0 ">
				<label for="mediaAgent"><cv:msg key="label.mediaAgent" bundle="storage"/>
					<div class="toggle-control" data-ng-if="action=='editMP'">{{libraryInfo.controller.mediaAgentName}}</div>
					<div class="toggle-control" data-ng-if="action!='editMP'">
						<select-with-create-button
							select-id="mediaAgent"
							select-name="mediaAgent"
							key-label="displayName"
							key-id="mediaAgentId"
							option-list="agentList"
							selected-option="selectedMediaAgent"
							select-only-option="true"
							on-change-option="setClientType"
							on-click-create-button="openCreateMediaAgentModal"
							is-required="true"
							has-error="mediaAgentError"
							select-disabled="action=='editMP'"
							placeholder='<cv:msg key="placeholder.mediaAgent" bundle="storage"/>'
							is-credential="false">
						</select-with-create-button>
					</div>
					<span class="help-block" data-ng-if="mediaAgentError"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
				</label>
			</div>
			<label data-ng-if="action=='editMP'" for="accessType" class="add-collection-form form-group"><cv:msg key="label.accessType" bundle="storage"/>
					<select id="accessType" name="accessType" class="toggle-control"
							data-ng-model="libraryInfo.controller.accessTypeValue"
							data-ng-options="at.value as at.text for at in accessTypes" required
							data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.Access)}">
						<option value=""> <cv:msg key="placeholder.accessType" bundle="storage"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.Access)"><cv:msg key="error.accessType" bundle="storage"/></span>
			</label>
			<div class="add-collection-form" data-ng-hide="isUnixMA || isDataServer">
				<label for="types"><cv:msg key="label.Type" bundle="storage"/>
					<div class="storage-type toggle-control" id="types">
						<label>
							<input type="radio" data-ng-model="typeOfStorage.type" value="localStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()">
							<cv:msg key="label.local" bundle="storage"/>
						</label>
						<label>
							<input type="radio" data-ng-model="typeOfStorage.type" value="networkStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()">
							<cv:msg key="label.network" bundle="storage"/>
						</label>
					</div>
				</label>
			</div>
	

			<div data-ng-if="typeOfStorage.type=='networkStorage'" data-ng-hide="isDataServer" class="credentials">				
				<div data-ng-class="{'panel-body no-padding' : showSwitchToCM}">
					<div class="col-xs-12" data-ng-if="showSwitchToCM">
						<h4 class="text-align-left"><span><cv:msg key="label.credentials" bundle="vmManagement"/></span></h4>
					</div>
					<div class="margin-left-20" data-ng-if="showSwitchToCM">
						<label>
							<toggle-control status="switchToCM" data-ng-click = "toggleCredentialType()"></toggle-control>
							<span><cv:msg key="label.useSavedCred" bundle="storage"/></span>
						</label>
					</div>
					<div data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, 'add-collection-form form-group panel-body no-padding' : showSwitchToCM }" class="margin-left-50" data-ng-if="showCredentialDropDown">
						<label for="credential" class="col-lg-4 col-md-4 col-xs-4 margin-0 padding-0 padding-left-20"> <cv:msg key="Name" bundle="storage"/></label>
						<div class="col-md-8 col-lg-8 col-xs-8 padding-right-20 padding-left-10">
							<select-with-create-button
								select-id="credential"
								select-name="credential"
								key-label="credentialName"
								key-id="credentialId"
								option-list="savedCredentials"
								selected-option="libraryInfo.credentialToSave"
								on-click-create-button="openCreateCredentialModal"
								has-error="cv.addCollectionForm.needsAttention(addCollectionForm.credential)"
								class="no-float-auto tile-large-width"
								placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'
								edit-disabled="libraryInfo.credentialToSave.length === 0"
								on-click-edit-button="openEditCredentialModal"
								is-credential="true">
							</select-with-create-button>
						</div>
						<span class="help-block margin-left-5 padding-right-30 margin-right-10" data-ng-show="credentialNotSelectedError || (storageForm.$submitted && (!libraryInfo.selectedCredential || libraryInfo.selectedCredential.credentialId == 0))"><cv:msg key="error.credential.required" bundle="storage"/></span>
					</div>
					<div data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, ' add-collection-form form-group panel-body no-padding' : showSwitchToCM }" class="margin-left-50" data-ng-if="!showCredentialDropDown">
						<div class="margin-left-20">
							<label class="col-lg-4 col-md-4 col-xs-4 padding-0 margin-0">
								<cv:msg key="User Name" bundle="storage"/>
							</label>
							<div class="col-lg-8 col-md-8 col-xs-8 padding-0 padding-right-20">
								<input
									data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.loginName)}"
									type="text"
									name=loginName
									class="full-width"
									data-ng-model="libraryInfo.loginName"
									data-ng-required="!showCredentialDropDown"
								/>
							</div>
							<span class="help-block" data-ng-show="storageForm.loginName.$error.required && cv.storageForm.needsAttention(storageForm.loginName)"><cv:msg key="error.loginName.required" bundle="storage"/></span>
						</div>
						<div class="margin-left-20">
							<label class="col-lg-4 col-md-4 col-xs-4 padding-0 margin-0">
								<cv:msg key="Password" bundle="storage"/>
							</label>
							<div class="col-lg-8 col-md-8 col-xs-8 padding-0 padding-right-20">
								<input type="password" class="full-width" data-ng-model="libraryInfo.password" />
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- <label for="mountPath" data-ng-if="!isDataServer" data-ng-class="{'storage-path-label': typeOfStorage.type=='localStorage'}">
					<cv:msg key="backupLocation" bundle="storage"/>
					<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern.pattern'/>
					<span class="help-block" data-ng-value="form-error" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><cv:msg key="error.mountpath.required" bundle="storage"/></span>
					
					<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
									<cv:msg key="error.mountpath.invalid" bundle="storage"/>
					</span>
			</label>
			<button id="addDiskStorage_button_#9845" type="button" data-ng-if="typeOfStorage.type=='localStorage'" data-ng-hide="isDataServer" data-ng-click="browse()" class="btn btn-default browse-btn"> 
				<cv:msg key="Browse" bundle="storage"/>
			</button> -->
			<div class="add-collection-form">
				<label for="mountPath" data-ng-if="!isDataServer">
					<cv:msg key="label.backupLocation" bundle="storage"/>
					<div class="input-group toggle-control">
						<input class="full-width" data-ng-if="!distributedStorage || !distributedStorage.distributedStorageId" data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern.pattern'/>
						<input class="full-width" data-ng-if="distributedStorage && distributedStorage.distributedStorageId" data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='/^\/ws\/hedvig(\/[^<>:"/\\|?*]+)+\/?$/'/>						
						<span data-ng-if="typeOfStorage.type != 'networkStorage'" class="input-group-btn">
							<button id="addDiskStorage_button_#0346" type="button" class="icon-style cv-material-button browse" data-ng-click="browse({isDDBLocation: false})"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
							</button>
						</span>
					</div>
					<!-- <button id="addDiskStorage_button_#9532" type="button" data-ng-if="typeOfStorage.type=='localStorage'" data-ng-hide="isDataServer" data-ng-click="browse()" class="btn btn-default browse-btn"> 
						<cv:msg key="Browse" bundle="storage"/>
					</button> -->
					
					<span class="help-block" data-ng-value="form-error" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><cv:msg key="error.mountpath.required" bundle="storage"/></span>

					<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
									<cv:msg key="error.mountpath.invalid" bundle="storage"/>
					</span>
				</label>
			</div>
			<!--  Hedvig cluster section -->
			<label for="distributedStorageName" class="add-collection-form" data-ng-if="distributedStorage && distributedStorage.distributedStorageName">
                <cv:msg key="label.hedvigClusterName" bundle="storage"/>
                <div class="toggle-control name-text-ellipsis" data-ng-bind="distributedStorage.distributedStorageName"></div>
			</label>
			
			<span data-ng-if="action=='editMP'">
				<input id="enable" type="checkbox" data-ng-model="libraryInfo.enabled" >
				<label for="enable">
					<cv-help-text help-label="<cv:msg key="label.enable" bundle="storage"/>" help-text="'<cv:msg key='label.enableBackupLocationHelpText' bundle='storage' />'"/>
				</label>
<!-- 			Since it's not a mount path property
				<div data-ng-if="libraryInfo.controller.protocolType == 0">
					<input id="disableForWrite" type="checkbox" data-ng-model="libraryInfo.disableForWrite" >
					<label for="disableForWrite">
						<cv-help-text help-label="<cv:msg key="label.disableForWrite" bundle="storage"/>" help-text="'<cv:msg key='label.disableForWriteHelpText' bundle='storage' />'"/>
					</label>
				</div> -->
			</span>
		<div class="button-container">
			<button id="addDiskStorage_button_#5109" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<%-- <button id="addDiskStorage_button_#1675" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-hide="action=='newDiskLib' || action=='addMP'" data-ng-click="deleteMountPath()"> 
				<<cv:msg key="Delete" bundle="messages"/>
			</button> --%>
			<button id="addDiskStorage_button_#7515" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-if="storagePresent && !formStorage.hide" data-ng-click="skip()"><cv:msg key="Skip" /></button> 
			<button id="addDiskStorage_button_#3909" class="btn btn-primary cvBusyOnAjax" type="submit" data-ng-click="saveButtonClick()"> 
				<div data-ng-if="action=='editMP'">
					<cv:msg key="action.save" bundle="storage"/>
				</div>
				<div data-ng-if="action=='newDiskLib' || action=='addMP'" data-ng-disabled ="!libraryInfo.controller.mediaAgentId" >
					<cv:msg key="action.save" bundle="storage"/>
				</div>
			</button>
		</div>
	</form>
	<div class="button-container centered" data-ng-show="formStorage.hide">
		<button id="addDiskStorage_button_#2723" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="Continue" /></button> 
	</div>
</div>
</div>
