<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.saphana">
	<div data-ng-controller="restoreController">
		<div class="setup-title">
			<h1>
				<fmt:message key="header.RestoreOptions" />
			</h1>
		</div>
		<div class="setup-content ng-scope">
		<form name="restoreForm" class="restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
			<div class="global-options remove-border-padding">
				<label for="destinationClient" class="select-label">
					<fmt:message key="label.DestinationClient" />
					<select id="destinationclient" name="destinationclient" data-ng-model="restoreData.globalOptions.destinationServer.clientId"
							data-ng-options="sp.clientId as sp.clientName for sp in restoreData.globalOptions.destinationServerList|orderBy:'clientName'"
							data-ng-change="updateInstcesModel(restoreData.globalOptions.destinationServer.clientId)" required>
						<option value=""><cv:msg key="placeholder.DestinationClient" bundle="saphana" /></option>
					</select>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreData.globalOptions.destinationServer.clientId)">
						<cv:msg key="error.DestinationClient" bundle="restore"/>
					</span>
				</label> 
				
				<label for="destinationDatabase" class="select-label">
					<fmt:message key="label.DestinationDatabase" />
					<select id="destinationDatabase" name="destinationDatabase" data-ng-model="restoreData.globalOptions.destinationInstanceId"
							data-ng-options="sp.instance.instanceId as sp.instance.instanceName for sp in restoreData.globalOptions.destinationInstances|orderBy:'instance.instanceName'" 
							data-ng-change="setInstanceInfo(restoreData.globalOptions.destinationInstanceId)" required>
						<option value=""><cv:msg key="placeholder.DestinationDatabase" bundle="saphana" /></option>
					</select>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreData.globalOptions.destinationInstanceId)">
						<cv:msg key="error.DestinationInstance" bundle="restore"/>
					</span>
				</label> 
				
				<label>
					<div class="setup-content backup-options remove-border-padding" style="padding: 0px;">
						<input type="radio" data-ng-model="restoreData.globalOptions.restoreType" value="0" />
						<fmt:message key="label.RecoverDatabase" />
						<label>
							<fmt:message key="label.CurrentTime" />
							<input type="radio" style="float: left;" data-ng-model="restoreData.globalOptions.restoreTimeType" value="0" data-ng-disabled="restoreData.globalOptions.restoreType!=0" />
						</label>
						<label>
							<fmt:message key="label.PointInTime" />
							<input type="radio" style="float: left;" data-ng-model="restoreData.globalOptions.restoreTimeType" value="1" data-ng-disabled="restoreData.globalOptions.restoreType!=0" />
							<input class="hana-restore-time" type="datetime-local" name="time" data-ng-model="restoreData.globalOptions.time" placeholder="yyyy-MM-ddTHH:mm:ss" data-ng-disabled="restoreData.globalOptions.restoreType!=0 || restoreData.globalOptions.restoreTimeType!=1" />
						</label>
					</div>
				</label>
				<label>
					<div class="setup-content backup-options remove-border-padding" style="padding: 0px;">
						<input type="radio" data-ng-model="restoreData.globalOptions.restoreType" value="1">
						<fmt:message key="label.RecoverDataOnly" />
					</div>
				</label>
				<label class="sub-text" for="backupPrefix">
					<span style="padding-left:25px"><fmt:message key="label.BackupPrefix" /></span>
					<input type="text" type="text" name="backupPrefixValue" data-ng-model="restoreData.globalOptions.backupPrefixValue" data-ng-disabled="restoreData.globalOptions.restoreType!=1" />
				</label>
				<div class="collectMetaDiv">
					<input id="checkAccess" data-ng-model="restoreData.globalOptions.checkAccess" type="checkbox">
					<label for="checkAccess"><fmt:message key="label.CheckAccess" /></label>
				</div>
	
				<div class="collectMetaDiv">
					<input id="initializeLogArea" data-ng-model="restoreData.globalOptions.initializeLogArea" type="checkbox" data-ng-disabled="restoreData.globalOptions.restoreType==1">
					<label for="initializeLogArea"><fmt:message key="label.InitializeLogArea" /></label>
				</div>
	
				<div class="button-container">
					<button id="SapHanaRestoreOptionsModal_button_#2061" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
					<button id="SapHanaRestoreOptionsModal_button_#5804" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button> 
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>