<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
<form name="backupForm" data-cv-submit="startBackup()" >
	<span data-ng-show="!backupMsg">
			<label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>

			<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
			</div>

			<div class="global-options remove-border-padding form-panel-holder">
				<label class="element-indent-class">
					<input type="radio" ng-model="backupType" value="FULL">
					<cv:msg key="option.full" bundle="schedule"/>
				</label>

				<label class="element-indent-class" data-ng-hide="isSnapBackupEnabled">
					<input type="radio" ng-model="backupType" value="INCREMENTAL">
					<cv:msg key="option.incremental" bundle="schedule"/>
				</label>

				<label class="element-indent-class" data-ng-hide="isSnapBackupEnabled">
					<input type="radio" ng-model="backupType" value="DIFFERENTIAL">
					<cv:msg key="option.differential" bundle="schedule"/>
				</label>
			</div>

		<br>
		<label for="backupPrefix" style="line-height:1.4" data-ng-disabled="isSnapBackupEnabled" >
			<input name="backupPrefix" data-ng-model="backupPrefix" />
			<cv:msg key="label.BackupPrefix" bundle="saphana"/>
		</label>
		<label class="global-options remove-border-padding padding-top-10"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></label>
</span>
	<div class="button-container">
		<button id="SapHanaBackupOptionsModal_button_#5659" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()">
			<cv:msg key="OK" bundle="messages" />
		</button>
		<button id="SapHanaBackupOptionsModal_button_#2243" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="SapHanaBackupOptionsModal_button_#1292" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" >
			<cv:msg key="OK" bundle="messages" />
		</button>
	</div>
	</form>
</div>