<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
</script>
<div data-ng-controller="restoreController">
	<div class="setup-title">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	
	<div class="setup-content" >
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<form name="restoreForm" class="restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
			
			<!-- For Destination Severs -->
			<div class="global-options remove-border-padding">
				<label for="dbIdentifier"><cv:msg key="label.dbIdentifier" bundle="restore" />
                  	<input type="text" name="dbIdentifier" data-ng-model="restoreData.globalOptions.targetDbName" required />
                	<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreData.globalOptions.targetDbName)">
						<cv:msg key="error.dbIdentifier" bundle="restore"/>
					</span>
                </label>
                 
                <label for="dbSubnetGroup"><cv:msg key="label.dbSubnetGroup" bundle="restore" />
                  	<input type="text" name="dbSubnetGroup" data-ng-model="restoreData.globalOptions.dbSubnetGroup"/>
                </label>
                 <input name="isMultiAZ" id="isMultiAZ" data-ng-model="restoreData.globalOptions.isMultiAZ" type="checkbox" checked><label for="isMultiAZ"><cv:msg key="label.isMultiAZ" bundle="restore" /></label>             
				<label for="targetAvailbilityZone" data-ng-hide="restoreData.globalOptions.isMultiAZ" class="select-label"><cv:msg key="label.targetAvailbilityZone" bundle="restore" />
						<select name="targetAvailbilityZone" data-ng-options="targetZone.value as targetZone.name for targetZone in restoreData.globalOptions.targetZoneOptions" data-ng-model="restoreData.globalOptions.targetAvailbilityZone">
							<option value=""><cv:msg key="placeholder.targetAvailbilityZone" bundle="restore" /></option>
						</select>
				</label>
				<input name="publicAccess" id="publicAccess" data-ng-model="restoreData.globalOptions.publicAccess" type="checkbox" checked><label for="publicAccess"><cv:msg key="label.publicAccess" bundle="restore" /></label>
				<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>
			
			<div class="button-container">
				<button id="AmazonRDSRestoreOptions_button_#2613" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
				<button id="AmazonRDSRestoreOptions_button_#8916" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button> 
			</div>
		</form>
	</div>
</div>