var wfUtils = {};

wfUtils.constants = (function() {
 
	var contextPath = cvUtil.getContextPath();
 
	var ACTIONS_URL = contextPath + "/server/retrieveActionForm.do";
	var FORMS_URL = contextPath + "/server/retrieveForm.do";
	var START_ACTION_URL = contextPath + "/server/startAction.do";
	var START_FORMS_URL = contextPath + "/server/startForm.do";
	var FORM_INDEX = 0;
	var ACTION_INDEX = 1;
	var PARAM_SUBMIT_OPTION = "_submit";
	var FORMS_POPUP_ID = "wfFormsPopup";
	var SEARCHABLE_POPUP_ID = "wfSearchablePopUp";
	var FORMS_WARNINGMESSAGE_ID = "wfWarningMessageDialog";
	var FORMS_RECORD_OPERATION_FIELD = "$form_type$"; 
	var FORMS_CUSTOM_OPERATION_FIELD = "$custom$"; 
	var ADMINCONSOLE_TARGET_ELEMENT = ".wrapper-view";
	var WARNING_DIALOG_TEMPLATE = '<div id="wfWarningMessageDialog" data-backdrop="static" data-keyboard="false" class="wfContainer modal fade hideOnExportFriendly wfFormsDialog" tabindex="-3" data-focus-on="input:first" role="dialog" style="z-index:9999;">'
		                        +        '<div class="modal-dialog" role="document" style="left:0%;top: 10%;">'
		                        +			'<div class="modal-content" style="max-width: 506px;">'
		                        +				'<div class="modal-header">'
		                        + 					'<button type="button" class="close" data-dismiss="modal">x</button>'
		                        + 					'<h4 style="margin-top:0px;margin-bottom:0px"></h4>'
		                        +				'</div>'
		                        + 				'<div class="modal-body" style="max-height: 350px;overflow-y: auto;">'
		                        + 				'</div>'
		                        + 				'<div class="modal-footer">'
		                        + 					'<button id="warningMsgNoBtn" type="button" class="btn">No</button>'
		                        +  					'<button id="warningMsgYesBtn" type="button" class="btn btn-primary">Yes</button>'
		                        +				'</div>'
		                        + 		 	'</div>'
		                        +		'</div>'
		                        + '</div>';

	return {
		'ACTIONS_URL':ACTIONS_URL,
		'FORMS_URL':FORMS_URL,
		'START_ACTION_URL':START_ACTION_URL,
		'START_FORMS_URL':START_FORMS_URL,
		'FORM_INDEX':FORM_INDEX,
		'ACTION_INDEX':ACTION_INDEX,
		'PARAM_SUBMIT_OPTION':PARAM_SUBMIT_OPTION,
		'FORMS_POPUP_ID':FORMS_POPUP_ID,
		'SEARCHABLE_POPUP_ID':SEARCHABLE_POPUP_ID,
		'FORMS_WARNINGMESSAGE_ID':FORMS_WARNINGMESSAGE_ID,
		'FORMS_RECORD_OPERATION_FIELD' : FORMS_RECORD_OPERATION_FIELD,
		'WARNING_DIALOG_TEMPLATE' : WARNING_DIALOG_TEMPLATE,
		'FORMS_CUSTOM_OPERATION_FIELD' : FORMS_CUSTOM_OPERATION_FIELD,
		'ADMINCONSOLE_TARGET_ELEMENT' : ADMINCONSOLE_TARGET_ELEMENT
	}
})();

wfUtils.functions = (function() {
 
	function isLMPage(){
		var $contextPath = cvUtil.getContextPath();
		return window.location.pathname ===  $contextPath + "/sysMonitoring.do" || window.location.pathname ===  $contextPath + "/logMonitoring.do" || window.location.pathname === $contextPath + "/logMonitoring/editSearch.jsp";
	}
 
	function getURL(startURL) {
		var selectedTab = Forms.getSelectedTab();

		if (selectedTab == wfUtils.constants.FORM_INDEX) {
			if (startURL) {
				return wfUtils.constants.START_FORMS_URL;
			} else {
				return wfUtils.constants.FORMS_URL;
			}
		} else {
			if (startURL) {
				if (Forms.getCurrentResp() != undefined) {
					return wfUtils.constants.START_FORMS_URL;
				} else {
					return wfUtils.constants.START_ACTION_URL;
				}
			} else {
				return wfUtils.constants.ACTIONS_URL;
			}
		}
	}
 
	function getAjaxTimeOut() {
		var ajaxReqOptions = {
			timeout : wfReqTimeOut?wfReqTimeOut:600000
		};
		return ajaxReqOptions;
	}
 
	function isMobileDevice() {
		  var check = false;
		  (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) check = true;})(navigator.userAgent||navigator.vendor||window.opera);
		  return check;
	}
	var isAdminConsole = function(){
		return cvUtil.getContextPath() == '/adminconsole';
	};
 
	function getParameterByName(name, url, defaultValue, getUrlViaHistoryJs,doNotEscape){
		if(doNotEscape==undefined)
			doNotEscape=true;
		    return cvUtil.getParameterByName(name, url, defaultValue, getUrlViaHistoryJs,doNotEscape)
	}
 
	function getParameterViaHistory(name, defaultValue){
		return cvUtil.getParameterByName(name, null, defaultValue, true, true);
	}

	function getParameter(name, defaultValue){
		return cvUtil.getParameterByName(name, null, defaultValue, false, true);
	}
 
	function isComplexEntity(currentInputType) {
		if (currentInputType == "commvault.msgs.CvEntities.ClientEntity" ||
				currentInputType == "commvault.msgs.CvEntities.ClientGroupEntity" ||
				currentInputType == "commvault.msgs.CvEntities.StoragePolicyEntity" ||
				currentInputType == "commvault.msgs.CvEntities.UserEntity" ||
				currentInputType == "commvault.msgs.CvEntities.UserGroupEntity" ||
				currentInputType == "commvault.msgs.CvEntities.MediaAgentEntity" ||
				currentInputType == "commvault.msgs.CvEntities.CommCellEntity" ||
				currentInputType == "commvault.msgs.CvEntities.SchedulePolicyEntity" ||
				currentInputType == "commvault.msgs.CvEntities.WorkflowEntity"
		) {
			return true;
		}
		return false;
	}
 
	function isAdminConsoleForms(){
		return window.location.hash.indexOf("#/forms") !== -1;
	}

	//Utility functions returned here...
	return {
		'getURL': getURL,
		'getAjaxTimeOut': getAjaxTimeOut,
		'isLMPage': isLMPage,
		'isMobileDevice': isMobileDevice,
		 "isAdminConsole" : isAdminConsole,
        'getParameterByName' : getParameterByName,
        'getParameterViaHistory' : getParameterViaHistory,
        'getParameter' : getParameter,
        'isComplexEntity' : isComplexEntity,
        'isAdminConsoleForms' : isAdminConsoleForms
	}
})();