"use strict";

var respType = {
	GENERIC_RESP : 0,
	INFO_RESP : 1,
	POPUP_RESP : 2,
	END_USER_RESP : 3,
	START_WORKFLOW_RESP : 4,
	INPUT_PAGE : 5
};

var wfInputEntryValMap = {};

function clearInputEntryVal(){
	wfInputEntryValMap = {};
}

function constructParamsFromInputs(wfId) {
	if (wfInputEntryValMap[wfId] && wfInputEntryValMap[wfId]["inputs"]) {
		return Forms.getCustomInputParams(wfInputEntryValMap[wfId]["inputs"]);
	}
	return undefined;
}

function resizeForm(){

}

var Forms = (function(formObj){
var FORMS_POPUP_HTML = undefined;
var IMPORT_FULL_PAGE_HTML = undefined;
var FULL_PAGE_HTML = undefined;
var FULL_PAGE_OTHER_POPUPS_HTML = undefined;
var FULL_PAGE_TARGET_HTML = undefined;
var FULL_PAGE_TARGET_HTML_FOR_ADMINCONSOLE = undefined;
var PARAM_WORKFLOW_ID = "workflowId";
var PARAM_WORKFLOW_NAME = "workflowName";
var PARAM_USER_INTERACTION = "id";
var PARAM_INTERACTION_ID = "interactionId";
var PARAM_INTERACTION_NAME = "interactionName";
var PARAM_CLIENT_ID = "clientId";
var PARAM_CLIENT_NAME = "clientName";
var PARAM_TARGET = "target";
var PARAM_DESCRIPTION = "description";
var PARAM_SUBTIME = "subTime";
var PARAM_FILTER = "filter";
var PARAM_TAB = "tab";
var PARAM_ACTION_NAME = "actionName";
var PARAM_USER_GUID = "id";
var PARAM_SHOW_AS_V1 = "v1";
var PARAM_WORKFLOWENGINE_ID = "workflowEngineId";
var PARAM_SHOW_AS_MODAL = "showAsModal";
var PARAM_SHOW_WARNING_MESSAGE = "showWarningMessage";
var PARAM_SHOW_AS_FULLPAGE_FORM = "fullPage";
var PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM = "mobileView";
var PARAM_TARGET_DIV = "targetElement";
var PARAM_APP_STUDIO_FORM = "appTableForm"
var PARAM_IS_PREVIEW_FORM = "isPreviewForm";
var MODAL_URL = "/forms/run.jsp?";
var INVALID_WORKFLOW = true;
var availableWorkflows = -1;
var actionsTable = undefined;
var reinitializingTable = false;
var ACTIONS_URL = cvUtil.getContextPath() + "/server/retrieveActionForm.do";
var FORMS_URL = cvUtil.getContextPath() + "/server/retrieveForm.do";
var START_ACTION_URL = cvUtil.getContextPath() + "/server/startAction.do";
var START_FORMS_URL = cvUtil.getContextPath() + "/server/startForm.do";
var FORM_INDEX = 0;
var ACTION_INDEX = 1;
var currRequest = [];
var hItem;
var isTabSelect = false;
var isModalBoxEnabled = false;
var isRefreshReq = true;
var isIntialReq = false;
var inputParamsForModal = "";
var urlParams = {};
var selectedTab;
var isOpenFilter = true;
var intialStateofIE = false;
var isEmptyForm = false;
var customInputsMap = {};
var reservedWords = [
		PARAM_WORKFLOW_ID,
		PARAM_WORKFLOW_NAME,
		PARAM_TAB,
		wfUtils.constants.PARAM_SUBMIT_OPTION,
		PARAM_FILTER,
		PARAM_USER_GUID,
		PARAM_SUBTIME,
		PARAM_ACTION_NAME,
		PARAM_INTERACTION_NAME,
		PARAM_WORKFLOWENGINE_ID,
		PARAM_INTERACTION_ID,
		PARAM_USER_INTERACTION,
		"onSuccess",
		"successParams",
		"onFailure",
		"failParams",
		"tableId",
		"sysRowId"];
var isFormsPage = true;
var wfJsonObj = undefined;
var wfActionsTableHeight = {};
var wfInfo = {};
var inputParamsForClosedWf = "";
var PARAM_READONLY_FORM = "_readonly";
var PARAM_DO_NOT_START_WORKFLOW = "doNotStartWorkflow";
var containerScrollTop = 0;
var urlToUpdate = undefined;
var localizedStringMap = {};

function resizeWorkflowTiles() {
	$("#formsTabs .disp").each(function(index) {
		columnresize(index);
	});
	addListenerForToggle();
}

function columnresize(workflowIndex) {
	if ($("#formsTabs .disp").eq(workflowIndex).height() > 38) {
		var more = "<a href='#' class='more' style='background:none; !important' data-open='0'>More</a>";
		var $disp = $("#formsTabs .disp").eq(workflowIndex);
		$disp.css("height", "37px");
		$disp.prev().show();
		$disp.parent(".displayText").append(more);
	}
}

function addListenerForToggle() {
	$(".more").off("click");
	$(".more").on("click", function(e) {
		e.preventDefault();
		if ($(this).data("open") == 0) {
			$(this).data("open", 1);
			$(this).html("Less");
			$(this).siblings(".ellip").hide();
			$(this).siblings(".disp").css("height", "auto");
			$(this).parents("li").css("height", "auto");
		} else {
			$(this).data("open", 0);
			$(this).html("More");
			$(this).siblings(".ellip").show();
			$(this).siblings(".disp").css("height", "37px");
			$(this).parents("li").css("height", "75px");
		}
	});
}

function addWorkflow(target, container, workflow, templateHTML) {
	if (workflow.inputForm != undefined/* && workflow.inputForm.entries!=undefined */) {
		var inputJSON = {};

		inputJSON[PARAM_CLIENT_ID] = workflow.client.clientId;
		inputJSON[PARAM_CLIENT_NAME] = workflow.client.clientName;
		inputJSON[PARAM_WORKFLOW_NAME] = workflow.entity.workflowName;
		inputJSON[PARAM_WORKFLOW_ID] = workflow.entity.workflowId;
		inputJSON[PARAM_TARGET] = target + '?tab=' + wfUtils.constants.FORM_INDEX + '&workflowName=' + workflow.entity.workflowName +
				'&workflowId=' + workflow.entity.workflowId;
		inputJSON[PARAM_DESCRIPTION] = ""/* workflow.description */;
			//inputJSON["useV1Forms"] = !getUseV2FormsFromProps(Forms.getFormProperties("",workflow));

		var workflowHTML = "";
		workflowHTML = $.trim(Mustache.to_html(templateHTML, inputJSON).replace(/^\s*/mg, ''));
		workflowHTML = workflowHTML.replace(/\n/g, '');

		container.append(workflowHTML);
		container.find("#" + inputJSON[PARAM_WORKFLOW_ID]).siblings(".disp").html(function() {
			return DOMPurify.sanitize(workflow.description,{SAFE_FOR_JQUERY: true});
		});

		columnresize(++availableWorkflows);
	}
}

function isiPhone() {
	return ((navigator.platform.indexOf("Mobile") != -1) || (navigator.platform.indexOf("iPad") != -1) || (navigator.platform
			.indexOf("iPhone") != -1));
}

function getCustomDialog(options) {
	var $topModal = cvUtil.getTopModal().jqDialog;
	$topModal
			.dialog({
				resizable : true,
				minHeight : options.minHeight,
				minWidth : options.minWidth,
				handles : "all"
			})
			.bind('dialogdragstart dialogresizestart',
					function() {
						var overlay = $(this).find('.hidden-dialog-overlay');
						if (!overlay.length) {
							overlay = $('<div class="hidden-dialog-overlay" style="position:absolute;top:0;left:0;right:0;bottom:0;z-order:100000;"></div>');
							overlay.appendTo(this);
						} else {
							overlay.show();
						}
					}).bind('dialogdragstop dialogresizestop', function() {
				$(this).find('.hidden-dialog-overlay').hide();
			});
}

function getAppropriateParams(workflowId, workflowName, interactionId, interactionName, subTime) {
	var param = [];
	wfInfo = {};

	if ((workflowId != undefined && workflowId != "") || (workflowName != undefined && workflowName != "")) {
		wfInfo[PARAM_WORKFLOW_ID] = workflowId;
		wfInfo[PARAM_WORKFLOW_NAME] = workflowName;
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_ID, workflowId));
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_NAME, workflowName));
	} else if (interactionId != undefined && interactionId != "") {
		wfInfo[PARAM_INTERACTION_ID] = interactionId;
		wfInfo[PARAM_SUBTIME] = subTime;
		param.push(cvUtil.createParamString(PARAM_INTERACTION_ID, interactionId));
		param.push(cvUtil.createParamString(PARAM_SUBTIME, subTime));
	}
	return param;
}

function getStateURL(urlParameters) {
	var param = [];
	param.push(cvUtil.createParamString(PARAM_TAB, urlParameters.tab));
	if (urlParameters.tab == wfUtils.constants.ACTION_INDEX) {
		//param.push(cvUtil.createParamString(PARAM_FILTER, urlParameters.isOpenFilter));
		if (urlParameters.actionName != "") {
			param.push(cvUtil.createParamString("actionName", urlParameters.actionName));
		}
	}
	var inputParam = cvUtil.createParamsString(param);
	param = getAppropriateParams(urlParameters.workflowId,
			urlParameters.workflowName,
			urlParameters.interactionId,
			urlParameters.interactionName,
			urlParameters.subTime);

	if (param.length > 0 && inputParam != '') {
		inputParam += '&';
	}

	inputParam += cvUtil.createParamsString(param);
	return inputParam;
}

function initiateInputForm(workflowId, workflowName, interactionId, interactionName, subTime) {
	inputParamsForModal = "";

	if(isAppTableFormReq()){
		displayModal();
	}
	else
	{
	if (urlParams.actionName != "") {
		processAction();
	} else {
		var param = getAppropriateParams(workflowId, workflowName, interactionId, interactionName, subTime);

		if (param.length > 0) {
			param.push(cvUtil.createParamString("isInfoResp", false));
			param.push(cvUtil.createParamString("isPopUpResp", false));
			inputParamsForModal = cvUtil.createParamsString(param);

			displayModal();
		}
	}
}
}

	function onWorkflowCompletion(res,modalOpen) {
	if(!wfUtils.functions.isLMPage()){
			if (!Forms.isCompletedForm()) {
			setInputParamsForClosedWf(Forms.getInputParamsEnteredByUser());
			}
			displayPostWorkflowMessage(res,modalOpen);
		}
		else
		{
			if(res.wfInputsAdded){
				$(".editWorkflow").css("display","block");
			}
		}
}

function processAction() {

	var url = wfUtils.functions.getURL(true);
	var params = [];
	var isV1Form = urlParams.v1;
	params.push(cvUtil.createParamString("interactionId", urlParams.interactionId));
	params.push(cvUtil.createParamString("id", urlParams.id));
	params.push(cvUtil.createParamString("actionName", urlParams.actionName));

	if(urlParams.v1!=undefined && urlParams.v1 === false)
		params.push(cvUtil.createParamString("reactForm",true));

	var inputParams = cvUtil.createParamsString(params);
	var message = wf_localMsg.successfulAction;
	cvUtil.loadPage(url, inputParams, function(data) {
		if (data != undefined) {
			var currentResp = data;
			if(data.response){
				data.response.outputParams = data || {};
			}
			Forms.setCurrentResp(currentResp);
			if (data.respType == respType.GENERIC_RESP) {
				message = data.response.errorMessage;
				if(data.response.errorCode == 0){
					message = wf_localMsg.successfulAction;
				}
				else if (data.response.errorCode == -1) {
					message = wf_localMsg.invalidInteraction;
				}
				else if (data.response.errorCode == -2) {
					message = wf_localMsg.unauthorizedAction;
				} else if (data.response.errorCode == -3) {
					message = wf_localMsg.completedAction + " " + data.response.errorMessage;
				} else if (data.response.errorCode == -4) {
					message = wf_localMsg.killedAction;
				}

			if(isV1Form == true)
			{
			$("#warning").attr("data-error", data.response.errorCode);
			$(".alert").html(message);
			$("#dialog").dialog({
				resizable : false,
				modal : true,
				width : 400,
				height : 150,
				close : function(event, ui) {
					invokeAppropriateWorkflowCallBack(data.response.errorCode,data.response);
				}
			});
			$("#dialog").parents(".ui-dialog").addClass("wfWarning");
			var margin = $("#dialog").innerWidth() / 2 - $("#warning").width() - 20 + "px";
			$("#warning").css("margin-right", margin);
			$("body .ui-dialog-titlebar").css("border-bottom", "none");
		}
			else
			{
					var $modalFooter = $("#"  + wfUtils.constants.FORMS_POPUP_ID).find(".modal-footer");
					$modalFooter.html('<button type="button" id="warningMsgBtn" class="btn btn-primary"  data-dismiss="modal">' + wf_localMsg.okButtonLbl + '</button>')
					$("#"  + wfUtils.constants.FORMS_POPUP_ID).find(".modal-body").html(message);
					Forms.setModalTitle("#"  + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4","Message");
						Forms.resizeDialog(undefined,false,true);

					if(!Forms.isModalOpen())
						$("#"  + wfUtils.constants.FORMS_POPUP_ID).modal("show");

							$("#warningMsgBtn").off("click");
							$("#warningMsgBtn").on("click", function(e) {
											e.preventDefault();
											invokeAppropriateWorkflowCallBack(data.response.errorCode,data.response);
										});

					$("#"  + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal").on("hidden.bs.modal", function () {
							$(this).data('bs.modal', null);
						invokeAppropriateWorkflowCallBack(data.response.errorCode,data.response);
					});
			}
			}
			else if (data.respType == respType.POPUP_RESP) {
				var params = [];
				params.push(cvUtil.createParamString("isPopUpResp", true));
				inputParamsForModal = cvUtil.createParamsString(params);
				wfInfo = {};
				wfInfo.isPopUpResp = "true";
				displayModal();
			} else if (data.respType == respType.INFO_RESP) {
				var params = [];
				params.push(cvUtil.createParamString("isInfoResp", true));
				inputParamsForModal = cvUtil.createParamsString(params);
				wfInfo = {};
				wfInfo.isInfoResp = "true";
				displayModal();
			}
		}
	}, function(xhr, ajaxOptions, thrownError) {
		alert(wf_localMsg.startFormTimeoutWarning);
	}, wfUtils.functions.getAjaxTimeOut());

}

var wfCloseListener = function(res) {
	if(!wfUtils.functions.isLMPage()){
	displayPostWorkflowMessage(res);
	}
	else
	{
		if(res.wfInputsAdded){
			$(".editWorkflow").css("display","block");
		}
	}
};

	function renderAsV1Form() {
		cvUtil.unmask();
		var target = cvUtil.getContextPath() + MODAL_URL + inputParamsForModal;
		var options = {
			width : 490,
			height : 445,
			title : "",
			resizable : true,
			href : target,
			iframe : true
		};

		cvUtil.showModal(options, null, wfCloseListener);

		var $topUIDialog = cvUtil.getTopModal().jqDialog.parent(".ui-dialog");

		var newwidth = $topUIDialog.width() + 10;
		$topUIDialog.addClass("wfPopup");
		$topUIDialog.find(".ui-dialog-titlebar").addClass("wfPopupTitle");

		var dialogOptions = {};
		dialogOptions.minHeight = 485;
		if (newwidth > 380) {
			dialogOptions.minWidth = newwidth;
		} else {
			dialogOptions.minWidth = 410;
		}

		getCustomDialog(dialogOptions);

		if (isiPhone()) {
			$(".ui-dialog").css("position", "fixed");
			$(".ui-dialog").css("top", "20px");
			$(".ui-dialog").css("left", "20px");
		}
	}

	function navigateToFormsPage(){
		$("#tabs").show();
		cvUtil.unmask();
		$("#wfFormsPopup").parents(".container").remove();
		//$("#wfFormsPopup").hide();
		//$("#wfFormsPopup").addClass("active");

		if(selectedTab == FORM_INDEX){
			resizeWorkflowTiles();
		}

	}

	function isAddRecordReq(){
		if(isAppTableFormReq()){
			var tableParams = getAppTableParams();

			if(tableParams["rowId"] === undefined)
				return true;
		}

		return false;
	}

	function isModifyRecordReq(){
		if(isAppTableFormReq()){
			var tableParams = getAppTableParams();

			if(tableParams["rowId"] && tableParams["rowId"]!="")
				return true;
		}

		return false;
	}

	function isAppTableFormReq(){
		return urlParams[PARAM_APP_STUDIO_FORM] != undefined && urlParams[PARAM_APP_STUDIO_FORM] === true;
	}

	function isFullPageForm(){
		return urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] != undefined && urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] === true || window.location.pathname === cvUtil.getContextPath() + "/form.do";
	}

	function isFullPageTableForm(){
		return window.location.pathname === cvUtil.getContextPath() + "/tableForm.do";
	}

	function isV3Form(){
		return urlParams.isV3Form;
	}

	function initializeModal(){
		$("#wfFormsPopup").find(".modal-dialog").draggable(
				{ cancel: '.rjsf' }
		);

		if(!wfUtils.functions.isMobileDevice()){
			$("#wfFormsPopup").find(".modal-content").eq(0).resizable({
			    alsoResize: ".modal-body",
			    minHeight: 300,
			    minWidth: 300
			});

			$('#wfFormsPopup .modal-content').off("resize").on("resize", function(e) {
				$("#wfFormsPopup .modal-content").css("height", "auto");
				$("#wfFormsPopup .modal-body").css("width", "auto");
				$("#wfSearchablePopUp .modal-body").css("width", "auto").css("height", "auto");
				$("#wfWarningMessageDialog .modal-body").css("width", "auto").css("height", "auto");
			});
		}
	}

	function getAppTableParams(){
		var appTableParams = {};

		if(urlParams["tableId"]!=undefined && urlParams["tableId"].trim()!="")
			appTableParams["tableId"] = urlParams["tableId"];

		if(urlParams["rowId"]!=undefined && urlParams["rowId"].trim()!="")
			appTableParams["rowId"] = urlParams["rowId"];

		if(urlParams["formId"]!=undefined && urlParams["formId"] !="")
			appTableParams["formId"] = urlParams["formId"];

		return appTableParams;
	}

	function reinitializeModal(){
			$("#wfFormsPopup").parents(".container").remove();
	    	$("#wfFormsPopup").remove();
    	$("#wfSearchablePopUp").remove();
    	$("#wfWarningMessageDialog").remove();
	}

	function renderAsV2Form() {

		reinitializeModal();

    	wfInfo["appTableParams"] = getAppTableParams();

		if (wfInfo.workflowName)
			wfInfo.workflowName = decodeURIComponent(wfInfo.workflowName);

		wfInfo.submit = urlParams.submit;
		wfInfo[PARAM_SHOW_AS_FULLPAGE_FORM] = true;

		if (!wfInfo[PARAM_INTERACTION_ID])
			wfInfo[PARAM_INTERACTION_ID] = "";

		Forms.openModal(wfInfo);
	}

	function displayImportPage(callBack, parameter, showBusinessRulesOptions) {
		if (wfUtils.functions.isAdminConsole()) {
			$(".wrapper-view").addClass("wfHeightOverflow");
		}
		var eleExists = showTargetFullPageForm(IMPORT_FULL_PAGE_HTML);
		if (eleExists != undefined && eleExists === true) {
			if (showBusinessRulesOptions === true) {
				$(".wfBusinessRulesOptions").show();
			} else {
				$(".wfBusinessRulesOptions").hide();
			}

			initializeModal();
			//initializeFullPageForm();
			callBack(parameter);
		}
	}

	function executeFullPageImportsCallBack(callBack,parameter){
		var entityId = 0;
		if(parameter["table"])
			entityId = parameter["table"];

		cvUtil.loadPage(cvUtil.getContextPath()
				+ "/proxy/CheckPermissionAssocToEntity/?permId=235&entityType=179&entityId=" + entityId, {}, function(
				permissionResp) {
			displayImportPage(callBack, parameter, permissionResp && permissionResp.documentElement
					&& permissionResp.documentElement.attributes[0].value && permissionResp.documentElement.attributes[0].value == "1" ? true : false);
		}, function(xhr, ajaxOptions, thrownError) {
			displayImportPage(callBack, parameter, false);
		}, {
			contentType : "application/json"
		});
	}

	function executeFullPageFormsCallBack(callBack,parameter){
		if(wfUtils.functions.isAdminConsole()){
			$(".wrapper-view").addClass("wfHeightOverflow");
		}
		var eleExists = showTargetFullPageForm(FULL_PAGE_HTML);
		$("body").prepend(FULL_PAGE_OTHER_POPUPS_HTML);
		if(eleExists!=undefined && eleExists === true)
		{
			initializeModal();
			initializeFullPageForm();
			callBack(parameter);
		}
	}

	function initializeV2Form(callBack,parameter) {
		if(isFullPageForm()){
			addEscListener();
			//$(document).off("keyup");

			if(wfUtils.functions.isAdminConsole()){
				if(!FULL_PAGE_HTML)
				{
					cvUtil.loadPage(cvUtil.getContextPath() + "/forms/fullPageFormWithTargetDivForAC.jsp",{},function(data) {
						FULL_PAGE_HTML = data;
						if(!FULL_PAGE_OTHER_POPUPS_HTML){
							cvUtil.loadPage(cvUtil.getContextPath() + "/forms/otherPopupsForFullPageForm.jsp",{},function(data) {
								FULL_PAGE_OTHER_POPUPS_HTML = data;
								executeFullPageFormsCallBack(callBack,parameter);
							});
						}
						else
						{
							executeFullPageFormsCallBack(callBack,parameter);
						}
					});
				}
				else
				{
					executeFullPageFormsCallBack(callBack,parameter);
				}
			}
			else
			{
			if(isFormPage()){
				if(!FULL_PAGE_HTML)
				{
					cvUtil.loadPage(cvUtil.getContextPath() + "/forms/fullPageForm.jsp",{},function(data) {
						FULL_PAGE_HTML = data;
						$("#content .vw-container_fullscreen").prepend(data);
						initializeModal();
						initializeFullPageForm();
						callBack(parameter);
					});
				}
				else
				{
						$("#content .vw-container_fullscreen").prepend(FULL_PAGE_HTML);
						initializeModal();
						initializeFullPageForm();
						callBack(parameter);
				}
			}
				else
				{
					if(isTargetDivFullPageForm()){
						if(!FULL_PAGE_HTML)
						{
							cvUtil.loadPage(cvUtil.getContextPath() + "/forms/fullPageFormWithTargetDivForAC.jsp",{},function(data) {
								FULL_PAGE_HTML = data;
								if(!FULL_PAGE_OTHER_POPUPS_HTML){
									cvUtil.loadPage(cvUtil.getContextPath() + "/forms/otherPopupsForFullPageForm.jsp",{},function(data) {
										FULL_PAGE_OTHER_POPUPS_HTML = data;
										executeFullPageFormsCallBack(callBack,parameter);
									});
								}
								else
								{
									executeFullPageFormsCallBack(callBack,parameter);
								}
							});
						}
						else
						{
							executeFullPageFormsCallBack(callBack,parameter);
						}
					}
				}
		}
		}
		else
		{
		addEscListener();

		//if(isFormPage()){
			if(!FORMS_POPUP_HTML)
			{
				cvUtil.loadPage(cvUtil.getContextPath() + "/forms/formModalHtml.jsp",{},function(data) {
					FORMS_POPUP_HTML = data;
					$("body").prepend(data);
					initializeModal();
					initializeWfPopup();
					callBack(parameter);
				});
			}
			else
				{
					$("body").prepend(FORMS_POPUP_HTML);
					initializeModal();
					initializeWfPopup();
					callBack(parameter);
				}
	  //}

		}
}

	function renderForm() {
		$(document).off("keyup");
		if (urlParams.v1) {
			renderAsV1Form();
		} else {
			renderAsV2Form();
		}
	}

	function getTargetContainerForFullPage(){
		return urlParams[PARAM_TARGET_DIV] != undefined && urlParams[PARAM_TARGET_DIV] != ""?$(urlParams[PARAM_TARGET_DIV]):undefined;
	}

	function isTargetDivFullPageForm(){
		return urlParams[PARAM_TARGET_DIV] != undefined && urlParams[PARAM_TARGET_DIV] != "";
	}

	function showTargetFullPageForm(formContainer){
		var $ele = getTargetContainerForFullPage();
		if($ele && $ele.length > 0)
		{
			$ele.find(".wfContainer").remove();
			$ele.children().addClass("wfBlurInnerDivs");
			//$ele.children().hide();
			$ele.prepend(formContainer);

			if(wfUtils.functions.isAdminConsole()){
				containerScrollTop = $(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop();
				$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(0);
			}
			return true;
		}
		return false;
	}

	function removeURLParam(paramName,currURL){
		var regexS = "[\\?&]" + paramName + "=([^&#]*)";
		var regex = new RegExp(regexS);
		return currURL.replace(regex,"");
	}

	function removeAppStudioParamsFromURL(){
		if(wfUtils.functions.isAdminConsole() && isAppTableFormReq() && urlToUpdate){
			urlToUpdate = removeURLParam("tableId",urlToUpdate);
			urlToUpdate = removeURLParam("formId",urlToUpdate);
			urlToUpdate = removeURLParam("rowId",urlToUpdate);
			history.pushState(null,document.title,urlToUpdate);
		}
	}

	function hideTargetFullPageForm(formContainer){
		removeAppStudioParamsFromURL();

		var $ele = getTargetContainerForFullPage();
		if($ele && $ele.length > 0)
		{
			$ele.find(".wfContainer").remove();
			$ele.children().removeClass("wfBlurInnerDivs");

			if(wfUtils.functions.isAdminConsole()){
				$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(containerScrollTop);
				containerScrollTop = 0;
			}
			//$ele.children().show();
		}
	}

	function cancelRulesValidCallBack(){
		if(Forms.isFullPageForm())
		onWorkflowCompletion(Forms.getWorkflowResp());
		else
			cancelRulesValidCallBackForPopup();
	}

	function cancelRulesValidCallBackForPopup(){
		$("#" + wfUtils.constants.FORMS_POPUP_ID).modal("hide");
		//Forms.closeModal();
	}

	function addFormCloseListener() {
		var isCancelRulesExist = Forms.isCancelRulesExists();

		if (!isFullPageForm()) {
			if (isCancelRulesExist) {
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").off("click").on("click", function(e) {
					e.preventDefault();
					Forms.processCancelEventRules(cancelRulesValidCallBackForPopup);
				});
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").attr("data-dismiss", "null");
			} else {
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").off("click");
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").attr("data-dismiss", "modal");
			}
		} else {
			if (isFormPage() || isTargetDivFullPageForm()) {
				addCloseListenerForFullPageForms(isCancelRulesExist);
			}
		}

	}

	function addCloseListenerForFullPageForms(isCancelRulesExist) {
		if (isCancelRulesExist) {
			$("#wfFullPageCloseBtnArea").off("click").on("click", function(event) {
				event.preventDefault();
				Forms.processCancelEventRules(cancelRulesValidCallBack);
			});
		} else {
			$("#wfFullPageCloseBtnArea").off("click").on("click", function(event) {
				event.preventDefault();
				onWorkflowCompletion(Forms.getWorkflowResp());
			});
		}
	}

	function initializeFullPageForm(){
		$(".wfcontainer").parents(".vw-content").addClass("wfNoPadding");
		hideFormHeader();
		$("#tabs").hide();
		$("#wfFormsPopup #inputFormArea").html('<div class="center" style="margin-left: 50%;"><img src="' + cvUtil.getContextPath() + '/common/img/loader.gif"/></div>');

		if($("#backUrl").val()!="" || isTargetDivFullPageForm())
		{
			$("#wfBaseUrlTitle > a").text("Back");
		}



		if (wfInfo.workflowName)
			wfInfo.workflowName = decodeURIComponent(wfInfo.workflowName);

		wfInfo.submit = urlParams.submit;
		wfInfo[PARAM_SHOW_AS_FULLPAGE_FORM] = true;

		if (!wfInfo[PARAM_INTERACTION_ID])
			wfInfo[PARAM_INTERACTION_ID] = "";
		else
			$("#wfBaseUrlTitle a").html("Actions");

		$("#wfFormsPopup").show();

			if(isFormPage() || isTargetDivFullPageForm()){


				$("#wfBaseUrlTitle").off("click").on("click",function(event){
					event.preventDefault();
					if($("#backUrl").val()!=undefined && $("#backUrl").val()!="")
					{
						window.open($("#backUrl").val());
						window.close();
					}
					else if(isTargetDivFullPageForm()){
						hideTargetFullPageForm();
					}
					else
					invokeAppropriateWorkflowCallBack(undefined);
					//navigateToFormsPage();
					//onWorkflowCompletion(Forms.getWorkflowResp());
				});
		}
	}

	function postFormRendering(){
		var controlToFocus = Forms.getControlToFocus();
		if(controlToFocus)
			$("#" + controlToFocus).focus();


		var formProps = Forms.getFormProperties(Forms.getInteractionId());

		var isCustomSizeForm = formProps && formProps.width && formProps.height?true:false;

		if(wfUtils.functions.isMobileDevice() || isCustomSizeForm || ( wfUtils.functions.isAdminConsole() && window && window.innerHeight && $("#wfFormsPopup .modal-body form").height() > window.innerHeight)){
			$("#wfFormsPopup").removeClass("smallForms");
		}
	}

	function initializeWfPopup(){
	  if(wfInfo.workflowName)
		  wfInfo.workflowName = decodeURIComponent(wfInfo.workflowName);

	  wfInfo.submit = urlParams.submit;

	  if(!wfInfo[PARAM_INTERACTION_ID])
		  wfInfo[PARAM_INTERACTION_ID] = "";

	  if(urlParams[PARAM_SHOW_AS_MODAL])
	  {
			$("#" + wfUtils.constants.FORMS_POPUP_ID).off("shown.bs.modal").on(
					"shown.bs.modal", function() {
					});

			$("#" + wfUtils.constants.FORMS_POPUP_ID).off("show.bs.modal").on(
					"show.bs.modal", function() {
					});

			$("#" + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal")
					.on("hidden.bs.modal", function() {
						// $("body").removeClass("modal-open");
						$(this).data('bs.modal', null);
						onWorkflowCompletion(Forms.getWorkflowResp());
					});

		  //$("#" + wfUtils.constants.FORMS_POPUP_ID).modal("show");
	  }
	}

	function getDefaultFormVersionBasedOnRegistry() {
		var v2Version = true;
		if (urlParams.v1 === -1) {
			v2Version = false;
		} else if (urlParams.v1 === -2) {
			v2Version = true;
		} else if (urlParams.v1 === -3) {
			v2Version = true;
			urlParams.isV3Form = true;
		} else {
			v2Version = true;
		}
		return v2Version
	}

	function getUseV2FormsFromProps(formProps){
		var v2Version = true;
		urlParams.isV3Form = false;
		if (formProps) {
			if (formProps.formVersion == undefined) {
				v2Version = getDefaultFormVersionBasedOnRegistry();
			} else {
			if (formProps.formVersion === "DEFAULT") {
					v2Version = getDefaultFormVersionBasedOnRegistry();
			} else {
				if(formProps.formVersion === "VERSION_3"){
					v2Version = true;
					urlParams.isV3Form = true;
				}
				else {
					v2Version = formProps.formVersion === "VERSION_1"?false:true;
				}
			}
			}
		} else {
			v2Version = getDefaultFormVersionBasedOnRegistry();
		}
		return v2Version;
	}

	function showMobileViewSpinner(){
		if(isMobileView())
		{
			$(".vw-loading-comp").addClass("mobileViewSpinner");
			$(".vw-loading-comp").html('<div><img width="60px" height="60px" class="centeredMobileSpinner" src="' + cvUtil.getContextPath() + '/forms/img/mobileViewSpinner.gif" style="background-color: transparent;"/></div>');
		}
	}

	function maskInitialPage() {
		if (!isFullPageForm()) {
			if (isFormPage()) {
				if (selectedTab == ACTION_INDEX) {
					cvUtil.mask();
				} else {
					cvUtil.mask(".cvApps");
				}
			} else if (wfUtils.functions.isAdminConsole()) {
				cvUtil.mask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
			} else {
				cvUtil.mask();
			}
		} else if (isFormPage()) {
			cvUtil.mask();
			showMobileViewSpinner();
		} else if (wfUtils.functions.isAdminConsole()) {
			cvUtil.mask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
		} else {
			cvUtil.mask();
		}
	}

	function displayModal() {
		maskInitialPage();

		if ((urlParams.v1 === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3 || (urlParams.submit == true && urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == -1)) && !isAppTableFormReq()) {
			var url = wfUtils.functions.getURL(false);
			var params = [];
			params.push(cvUtil.createParamString("workflowId",
					wfInfo.workflowId));
			params
					.push(cvUtil
							.createParamString(
									"workflowName",
									wfInfo.workflowName ? decodeURIComponent(wfInfo.workflowName)
											: undefined));
			params.push(cvUtil.createParamString("interactionId",
					wfInfo.interactionId));
			params.push(cvUtil.createParamString(
					wfUtils.constants.PARAM_SUBMIT_OPTION, false));
			params.push(cvUtil.createParamString("reactForm", false));

			var inputParams = cvUtil.createParamsString(params);

			var fullPageParameter = PARAM_SHOW_AS_FULLPAGE_FORM;
			var modalParamter = PARAM_SHOW_AS_MODAL;

			cvUtil.loadPage(url, inputParams, function(data) {
				if (Forms.isValidData(wfInfo.interactionId, data))
				{
					var currForm = Forms.getFormObject(wfInfo.interactionId, data);
					var formProps = Forms.getFormProperties(wfInfo.interactionId,currForm);

					if(urlParams.submit === true && urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == -1)
					{

							if(formProps!=undefined && formProps.pageMode!=undefined && formProps.pageMode!= "" && formProps.pageMode == "FULL_PAGE" )
							{
								urlParams[fullPageParameter] = true;
								urlParams[modalParamter] = false;
							}
							else
							{
								urlParams[fullPageParameter] = false;
								urlParams[modalParamter] = true;
							}
					}

					if(urlParams.v1 === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3)
					{
					urlParams.v1  = !getUseV2FormsFromProps(formProps);
				}
				}
				else
			    {
					if(urlParams.submit === true && urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == -1)
					{
						urlParams[fullPageParameter] = false;
						urlParams[modalParamter] = true;
					}
					urlParams.v1 = false;
				}
				renderForm();

				}, function(xhr, ajaxOptions, thrownError) {
					urlParams.v1 = false;
					renderForm();
			}, wfUtils.functions.getAjaxTimeOut());
		}
		else
			renderForm();
}

function pushWorkflowParameterChangesToUrl(params) {

	if (logging.urlhistory) {
		console.log("Pushing parameters to URL");
	}

	if (params == '' && History.isInternetExplorer()) {
		window.location.href = '';
	} else {
		if(window.location.pathname === cvUtil.getContextPath() + "/form.do")
			params = cvUtil.getContextPath() + "/forms/?" + params;
		else
			params = "?" + params;

		History.pushState(null, document.title,params);
	}
}

function historyStateChanged() {

	console.debug("URL statechange intercepted - updating workflow paramters from URL");
	readWorfklowParamtersFromUrl();

	var modalList = cvUtil.getTopWindow().cvUtil.openDialogs;
	if (modalList != undefined && modalList.length > 0) {
		$(modalList).each(function() {
			$("#modal" + this).remove();
		});
	}

	if (urlParams.workflowId != "" || urlParams.interactionId != "" || urlParams.id != "") {
		if (isIntialReq) // true for IE for first time when the page loads.
		{
			isIntialReq = false;
			workflowParametersChanged();
		}
			else if(isFullPageForm())
			{
				workflowParametersChanged();
			}
		/*
		 * else { inputParamsForModal = getStateURL(); displayModal(); }
		 */
	} else {
		if (isRefreshReq) {
			if (intialStateofIE) {
				intialStateofIE = false;
				urlParams.tab = wfUtils.constants.ACTION_INDEX;
				urlParams.isOpenFilter = isOpenFilter;
			}
			workflowParametersChanged();
		} else {
			isRefreshReq = true;
		}
	}

}

function getTagHtml(currTag,tagId){
	var tagIndexDiv = document.createElement("div");
	tagIndexDiv.className = "wfTagArea secureGroups active";
	tagIndexDiv.id = tagId;

	var tagHeadingDiv = document.createElement("div");
	var tagHeading = document.createElement("h4");
	tagHeading.className = "wfTagName";
	tagHeadingDiv.appendChild(tagHeading);
 
	var tagTitle = document.createTextNode(currTag);
	tagHeading.appendChild(tagTitle);
 
	tagIndexDiv.appendChild(tagHeadingDiv);
	var tagUl = document.createElement("ul");
	tagUl.className = "apps licenseApps";
	tagIndexDiv.appendChild(tagUl); 

	return tagIndexDiv.outerHTML; 
}

function renderTag(container,tagId,tagName,$tagWorkflows,templateHTML){
	if($tagWorkflows){
		var tagHtml = getTagHtml(tagName,tagId);
		container.append(tagHtml);
		renderWorkflowsToTag($("#" + tagId).find(".apps"),$tagWorkflows,templateHTML);
	}
}

function renderWorkflowsToTag($tagContainer,$tagWorkflows,templateHTML){
	for(var tagWfIndex = 0 ;tagWfIndex < $tagWorkflows.length ; tagWfIndex++){
		addWorkflow(cvUtil.getContextPath() + "/forms/", $tagContainer, $tagWorkflows[tagWfIndex], templateHTML);
	}
}

function showOrHideDescription() {
    if(!System)
        System = {};

    if(!System.additionalSettings)
        System.additionalSettings = {};

    if(!System.additionalSettings.Console)
        System.additionalSettings.Console = {};

    if(System.additionalSettings.Console.hideFormDescription == undefined)
        System.additionalSettings.Console.hideFormDescription = false;

    if(System.additionalSettings.Console.hideFormDescription === true)
    {
        $(".disp").css("opacity",0);
        $(".ellip").css("opacity",0);
        $(".more").css("opacity",0);
	}
    else {
        $(".disp").css("opacity",1);
        $(".ellip").css("opacity",1);
        $(".more").css("opacity",1);
    }
}

function createWorkflowPage(workflowList) {
	var container = $('.cvApps .secureGroups');
	container.empty();
	availableWorkflows = -1;

	var templateHTML = $('.wfTemplate ul').html();

	var tagMap = {};
	var tagList = [];
	var unTaggedWorkflows = [];

	for (var index = 0; index < workflowList.length; index++) {
		var currWorkflow = workflowList[index];
		if(currWorkflow.tags && currWorkflow.tags!=""){
			var tags = currWorkflow.tags.split(";");
			for(var tagIndex=0;tagIndex < tags.length; tagIndex++){
				var currTag = tags[tagIndex];
				var tagWorkflows = tagMap[currTag];
				if(tagWorkflows == undefined){
					tagWorkflows = [];
				}
				tagWorkflows.push(currWorkflow);
				tagMap[currTag] = tagWorkflows;
				if(tagList.indexOf(currTag) == -1)
				{
					tagList.push(currTag);
				}
			}
		}
		else
		{
			unTaggedWorkflows.push(currWorkflow);
		}
	}

	//sort tag names
	tagList.sort();

	var unTaggedTitle = "";
	if(tagList.length > 0)
		unTaggedTitle = "Untagged";

	for(var index = 0 ;index<tagList.length ; index++){
		var currTag = tagList[index];
		renderTag(container,"wfTag_" + index,currTag,tagMap[currTag],templateHTML);
	}

	if(unTaggedWorkflows.length > 0){
		renderTag(container,"wfTag_" + index,unTaggedTitle,unTaggedWorkflows,templateHTML);
	}

	showOrHideDescription();

	if (workflowList == undefined || workflowList.length == 0) {
		$("#formsTabs .laptopList").html('<span class="error">' + wf_localMsg.noRedeployedForms + '</span>');
	} else {
		$(".run").off("click");
		$(".run").on("click", function(event) {
			event.preventDefault();
			event.stopPropagation();
			var wfObj = {};
			wfObj.workflowId = $(this).attr("id");
			wfObj.workflowName = $(this).attr("name");
				//wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
				//wfObj.v1 = $(this).attr("data-useV1Forms");
			openForm(wfObj);
		});

		/*$("#" + wfUtils.constants.FORMS_POPUP_ID).on("hide.bs.modal", function (e) {
			Forms.setModalTitle("");
			$(".modal-body").html('<div class="center"><img src="../common/img/loader.gif"/></div>');
			});*/

		addListenerForToggle();
	}
}

function updateInputEntryVal(wfId,currInput,currInputVal){
	if(wfUtils.functions.isLMPage()){
		var wfInfo = {};
		var inputMap = {};

		if(wfInputEntryValMap[wfId])
			wfInfo = wfInputEntryValMap[wfId];
		else
			wfInputEntryValMap[wfId] = wfInfo;

		if(wfInfo["inputs"])
			inputMap = wfInfo["inputs"];

		inputMap[currInput] = currInputVal;
		wfInputEntryValMap[wfId]["inputs"] = inputMap;
	}
}

function updateCustomQueryParamValsFromJSON(wfObj) {
	customInputsMap = {};
	var inputs = wfObj.inputs;
	if (inputs != undefined) {
		jQuery.each(inputs, function(key, value) {
			var paramName = key.trim();
			if (reservedWords.indexOf(paramName) == -1) {
				customInputsMap[paramName] = [];
				if (value != undefined) {
					if ($.isArray(value)) {
						customInputsMap[paramName] = value;
					} else {
						customInputsMap[paramName].push(value);
					}
				}
			}
		});
	}
}

function updateCustomQueryParamVals(url) {
	url = url.split("+").join(" ");
	url = url.substring(url.indexOf("?"));
	customInputsMap = {};
	var tokens;
	var re = /[?&]?([^=]+)=([^&]*)/g;

	while (tokens = re.exec(url)) {
		var paramName = decodeURIComponent(tokens[1].replace(/\+/g, " "));
		if (reservedWords.indexOf(paramName) == -1) {
			if (customInputsMap[paramName] == undefined) {
				customInputsMap[paramName] = [];
			}
			customInputsMap[paramName].push(decodeURIComponent(tokens[2]));
		}
	}
}

function displaySelectedTab(previousTab) {
	if (previousTab != selectedTab) {
		urlParams.updateTab = true;
		if (selectedTab == wfUtils.constants.ACTION_INDEX) {
			$("#tabs").tabs("select", wfUtils.constants.ACTION_INDEX);
		} else {
			$("#tabs").tabs("select", wfUtils.constants.FORM_INDEX);
		}
	} else {
		updateTabsFromURLParams(false);
	}
}

function addWarningListener() {
	$("#warning").off("click");
	$("#warning").on("click", function(e) {
		e.preventDefault();
		var $dialogs = $(".wfBottomArea.ui-dialog-content");
		$dialogs.eq($dialogs.length - 1).dialog("destroy");
		removeOpenDialogsFromModal();
		invokeAppropriateWorkflowCallBack(parseInt($("#warning").attr("data-error")));
	});
}
function getWfParamVal(paramVal, defaultVal) {
	if (paramVal == undefined || paramVal == "") {
		return defaultVal;
	}
	return paramVal;
}

function readWorfklowParamtersFromObj(wfObj) {
	if (wfObj != undefined) {
		urlParams.isOpenFilter = true;
		urlParams.workflowId = getWfParamVal(wfObj[PARAM_WORKFLOW_ID], "");
		urlParams.workflowName = getWfParamVal(wfObj[PARAM_WORKFLOW_NAME], "");
		urlParams.interactionId = getWfParamVal(wfObj[PARAM_INTERACTION_ID], "");

		if(urlParams.interactionId == "")
			urlParams.interactionId = getWfParamVal(wfObj[PARAM_USER_INTERACTION], "");

		urlParams.interactionName = getWfParamVal(wfObj[PARAM_INTERACTION_NAME], "");
		urlParams.tab = getWfParamVal(wfObj[PARAM_TAB], 0);
		urlParams.subTime = getWfParamVal(wfObj[PARAM_SUBTIME], "");
		urlParams.actionName = getWfParamVal(wfObj[PARAM_ACTION_NAME], "");
		urlParams.submit = getWfParamVal(wfObj[wfUtils.constants.PARAM_SUBMIT_OPTION], "");
		urlParams.wfEngineId = getWfParamVal(wfObj[PARAM_WORKFLOWENGINE_ID], "");
		urlParams.id = getWfParamVal(wfObj[PARAM_USER_GUID], "");

			urlParams.showAsModal = getWfParamVal(wfObj[PARAM_SHOW_AS_MODAL] ? wfObj[PARAM_SHOW_AS_MODAL] + "" : undefined, "false");
		urlParams.showAsModal = urlParams.showAsModal == "true"?true:false;

		urlParams[PARAM_SHOW_WARNING_MESSAGE] = getWfParamVal(wfObj[PARAM_SHOW_WARNING_MESSAGE]!=undefined ? wfObj[PARAM_SHOW_WARNING_MESSAGE] + "" : undefined, "true");
		urlParams[PARAM_SHOW_WARNING_MESSAGE] = urlParams[PARAM_SHOW_WARNING_MESSAGE] == "true"?true:false;

		updateParamV1Val(wfObj);

		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = getWfParamVal(wfObj[PARAM_SHOW_AS_FULLPAGE_FORM]!=undefined?wfObj[PARAM_SHOW_AS_FULLPAGE_FORM]+"":undefined,-1);
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == "true"?true:urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == "false"?false:urlParams[PARAM_SHOW_AS_FULLPAGE_FORM];

		if(urlParams.showAsModal === true)
		{
			urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
		}
		else if(urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] === false)
		{
			urlParams.showAsModal = true;
		}

		urlParams[PARAM_IS_PREVIEW_FORM] = false;
		urlParams[PARAM_TARGET_DIV] = getWfParamVal(wfObj[PARAM_TARGET_DIV]?wfObj[PARAM_TARGET_DIV]+"":undefined,"");
	}

	if (urlParams.submit != "") {
		if (urlParams.submit == "true") {
			urlParams.submit = true;
		} else if (urlParams.submit == true) {
			urlParams.submit = true;
		} else if (urlParams.submit == "false") {
			urlParams.submit = false;
		} else {
			urlParams.submit = false;
		}
	}

	urlParams[PARAM_READONLY_FORM] = getWfParamVal(wfObj[PARAM_READONLY_FORM], false);
	updateReadonlyFormParam();
	updateCustomQueryParamValsFromJSON(wfObj);

	if (!$.isEmptyObject(customInputsMap)) {
		urlParams.submit = urlParams.submit == "" ? false : (urlParams.submit != true) ? false : true;
	}

	if(isAppTableFormReq())
	{
		urlParams.tableId = getWfParamVal(wfObj["tableId"], "");
		urlParams.rowId = getWfParamVal(wfObj["sysRowId"], "");
		urlParams.formId = getWfParamVal(wfObj["formId"], "");
	}

	urlParams[PARAM_DO_NOT_START_WORKFLOW] = getWfParamVal(wfObj[PARAM_DO_NOT_START_WORKFLOW], false);

	displayAppropriateLoader();
}

function updateReadonlyFormParam()
{
	if (urlParams[PARAM_READONLY_FORM] != "") {
		if (urlParams[PARAM_READONLY_FORM] == "true") {
			urlParams[PARAM_READONLY_FORM] = true;
		} else if (urlParams[PARAM_READONLY_FORM] == true) {
			urlParams[PARAM_READONLY_FORM] = true;
		} else if (urlParams[PARAM_READONLY_FORM] == "false") {
			urlParams[PARAM_READONLY_FORM] = false;
		} else {
			urlParams[PARAM_READONLY_FORM] = false;
		}
	}
}

function isReadOnlyForm(){
	return urlParams[PARAM_READONLY_FORM] != undefined && urlParams[PARAM_READONLY_FORM] === true;
}

function updateParamV1Val(wfObj){
		urlParams.v1 = getWfParamVal(
				wfObj[PARAM_SHOW_AS_V1] != undefined? wfObj[PARAM_SHOW_AS_V1] + ""
						: undefined, "");

		urlParams.isV3Form = false;

	if(isAppTableFormReq()){
		urlParams.v1 = false;
	}
	else if (urlParams.v1.trim() != "") {
			if(urlParams.v1 === "3"){
				urlParams.v1 = false;
				urlParams.isV3Form = true;
			}
			else
			{
		urlParams.v1 = urlParams.v1.trim();
		urlParams.v1 = urlParams.v1 == "true"?true:false;
			}
		}
		else if(useNewForms === 3) {
			urlParams.v1 = false;
			urlParams.isV3Form = true;
		}
		else
		{
			urlParams.v1 = (useNewForms === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3) ? useNewForms
					: !useNewForms;
		}
}

function removeParamsFromNativeACURL(){
	if(wfJsonObj.invokedFromACFormsURL){
		var currentUrl = window.location.href;
		currentUrl = currentUrl.substring(0,currentUrl.indexOf("?"));
		history.pushState(null,document.title,currentUrl);
	}
}

function invokeAppropriateWorkflowCallBack(errorCode,res) {
	removeParamsFromNativeACURL();

	if(wfUtils.functions.isAdminConsoleForms()){
		getOpenActionsCount();
	}

	if(getDoNotStartWorkflow()){
		if (wfJsonObj.success != undefined) {
				wfJsonObj.success(FormOps.getFormData());
		}
	}
	else if (isFormPage() && $("#reqFromOutsideForms").val() === "" && !isMobileView()) {
			var fullPageForm = isFullPageForm();
		pushDefaultParameters();
			if (typeof rpt!="undefined" && rpt) {
				rpt.reload();// we will reload the report using the rpt object.
			}

			if(fullPageForm){
				navigateToFormsPage();
			}

			getOpenActionsCount();

	} else {
		if (errorCode == 0) {

				//if(isFullPageForm()){
					if(isMobileView()){
						window.postMessage(JSON.stringify({event:"onSuccess",payLoad:res}),"*");
					}
					else if($("#successUrl").val() && $("#successUrl").val()!="")
					{
						window.document.location = $("#successUrl").val();
/*						window.open($("#successUrl").val());
						window.close();
*/					}
					else if (wfJsonObj.success != undefined) {
				wfJsonObj.success(wfJsonObj.successParams,res.outputParams);
			} else if (wfJsonObj.refreshOnSuccess == undefined ||
					(wfJsonObj.refreshOnSuccess != undefined && wfJsonObj.refreshOnSuccess == true)) {
						if(isMobileView()){
							window.postMessage(JSON.stringify({event:"onSuccess",payLoad:res}),"*");
						}
						else if (typeof rpt!="undefined" && rpt) {
					rpt.reload();// we will reload the report using the rpt object.
				} else {
					location.reload();
				}
			}

					if(isTargetDivFullPageForm()){
						hideTargetFullPageForm();
				}
				else
					removeAppStudioParamsFromURL();
				//}
				//else
				//{

				//}
		} else {
				//if(isFullPageForm()){
					if(isMobileView()){
						window.postMessage(JSON.stringify({event:"onFailure",payLoad:res}),"*");
					}
					else if($("#failureUrl").val() && $("#failureUrl").val()!="")
					{
						window.document.location = $("#failureUrl").val();
/*						window.open($("#failureUrl").val());
						window.close();*/
					}
					else if (wfJsonObj.fail != undefined) {
				wfJsonObj.fail(wfJsonObj.failParams,res.outputParams);
			} else if (wfJsonObj.refreshOnFail != undefined && wfJsonObj.refreshOnFail == true) {

						if(isMobileView()){
							window.postMessage(JSON.stringify({event:"onFailure",payLoad:res}),"*");
						}
						else if (typeof rpt!="undefined" && rpt) {
					rpt.reload(); // we will reload the report using the rpt object.
				} else {
					location.reload();
				}
			}

					if(isTargetDivFullPageForm()){
						hideTargetFullPageForm();
		}
		else
			removeAppStudioParamsFromURL();
				//}
				//else
				//{

	}
}
	}

function removeGivenElementsFromDOM($elementsToRemove){
	$($elementsToRemove).each(function() {
		if($(this).attr("id") !== wfUtils.constants.FORMS_POPUP_ID && $(this).attr("id") !== wfUtils.constants.SEARCHABLE_POPUP_ID && $(this).attr("id") !== wfUtils.constants.FORMS_WARNINGMESSAGE_ID)
		$(this).remove();
	});
}

function removeOpenDialogsFromModal() {
	if(!wfUtils.functions.isLMPage() && !wfUtils.functions.isAdminConsole()){
	var $topWindow = cvUtil.getTopWindow();
	removeGivenElementsFromDOM($topWindow.$(".overlay"));
	removeGivenElementsFromDOM($topWindow.$(".ui-dialog"));
	removeGivenElementsFromDOM($topWindow.$(".ui-widget-overlay"));
	removeGivenElementsFromDOM($topWindow.$(".modal"));
}
}

function fullPageStatusCallBack(resp){
	var message = resp.message;
	var res = resp.res;
	var $modalFooter = $(".wfFullPageForm").find(".modal-footer");
	$modalFooter.html('<button type="button" id="warningMsgBtn" class="btn btn-primary"  data-dismiss="modal">' + wf_localMsg.okButtonLbl + '</button>')
	$(".wfFullPageForm").find(".modal-body").addClass("wfFormSubmitMsg").html(message);
	Forms.setModalTitle("#"  + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4","Message");

	$("#warningMsgBtn").off("click");
	$("#warningMsgBtn").on("click", function(e) {
			e.preventDefault();
			invokeAppropriateWorkflowCallBack(res.errorCode,res);
			return false;
	});

	$("#wfFullPageCloseBtnArea").off("click").on("click", function(event) {
		event.preventDefault();
		invokeAppropriateWorkflowCallBack(res.errorCode,res);
	});

	$("#"  + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal").on("hidden.bs.modal", function () {
		invokeAppropriateWorkflowCallBack(res.errorCode,res);
	});
}

	function displayPostWorkflowMessage(res,modalOpen) {
		if(wfUtils.functions.isAdminConsole()){
			$(".wrapper-view").removeClass("wfHeightOverflow");
		}
		Forms.hideCustomizeAreaWithDom();
		Forms.resetForm();
	removeOpenDialogsFromModal();
		var isV1Form = urlParams.v1;
		var isFullPageForms = isFullPageForm();
	    var mobileView = isMobileView();
	if (res.errorCode != undefined) {
		var message = '';
		var status = true;
		if (res.errorCode == 10) {
					//alert(res.respMsg);
					message = res.respMsg;
					//invokeAppropriateWorkflowCallBack(res.errorCode);
			}
			else if (res.errorCode == 1) {
				if(res.respMsg)
					message = res.respMsg;
			}
			else if (res.errorCode == -1) {
				if (selectedTab == wfUtils.constants.FORM_INDEX) {
					//$("#warning").attr("data-workflowpresent",false);
					if(res.respMsg)
						message = res.respMsg;
					else
						message = '<span class="ellipsis" title="' + urlParams.workflowName + '">' +
							urlParams.workflowName + '</span>' + wf_localMsg.invalidWorkflow;
				} else {
					message = wf_localMsg.invalidInteraction;
				}
			} else if (res.errorCode == 0) {
				if (res.respType == 4) {
					if (selectedTab == wfUtils.constants.FORM_INDEX) {
						$("#warning").attr("data-workflowpresent", false);
						if(urlParams[PARAM_SHOW_WARNING_MESSAGE] === true)
						message = wf_localMsg.successfulWorkflow;
						else
						{
							status = false;
							invokeAppropriateWorkflowCallBack(res.errorCode,res);
						}
						//pushDefaultParameters();
					} else {
						status = false;
						invokeAppropriateWorkflowCallBack(res.errorCode,res);
					}
				} else {
					status = false;
					invokeAppropriateWorkflowCallBack(res.errorCode,res);
				}
			} else if (selectedTab == wfUtils.constants.ACTION_INDEX) {
				if (res.errorCode == -2) {
					message = wf_localMsg.unauthorizedAction;
				}
				if (res.errorCode == -3) {
					message = wf_localMsg.completedAction + " " + res.respMsg;
				} else if (res.errorCode == -4) {
					message = wf_localMsg.killedAction;
				}
			} else {
				message = res.respMsg;
			}

				if (isV1Form === true) {

				if (status) {
					$("#warning").attr("data-error", res.errorCode);
					$(".alert").html(message);
					$("#dialog").dialog({
						resizable : false,
						modal : true,
						width : 400,
						height : 150,
						close : function(event, ui) {
							invokeAppropriateWorkflowCallBack(res.errorCode,res);
						}
					});

					//if(!isFormsPage){
					var $dialogs = $(".wfBottomArea.ui-dialog-content");
					var $dialog = $(".wfBottomArea.ui-dialog-content").eq($dialogs.length - 1);
					$dialog.parents(".ui-dialog").addClass("wfWarning");
					//$("#dialog").parents(".ui-dialog").addClass("wfWarning");
					//}
				}

				var $dialogs = $(".wfBottomArea.ui-dialog-content");
				var $dialog = $(".wfBottomArea.ui-dialog-content").eq($dialogs.length - 1);
				var $warning = $dialog.find("#warning");
				var margin = $dialog.innerWidth() / 2 - $warning.width() - 20 + "px";
				$warning.css("margin-right", margin);
				$("body .ui-dialog-titlebar").eq($dialogs.length- 1).css("border-bottom", "none");
			}
			else
			{
				if(isFullPageForms)
				{
					if (status) {

						var callbackParams = {"message" : message, "res":res};

						if($(".wfFullPageForm").length === 0)
							initializeV2Form(fullPageStatusCallBack,callbackParams)
						else
							fullPageStatusCallBack(callbackParams);
					}
					else {}

				}
				else
				{
			if (status) {
				var $modalFooter = $("#"  + wfUtils.constants.FORMS_POPUP_ID).find(".modal-footer");
				$modalFooter.html('<button type="button" id="warningMsgBtn" class="btn btn-primary"  data-dismiss="modal">' + wf_localMsg.okButtonLbl + '</button>')
				$("#"  + wfUtils.constants.FORMS_POPUP_ID).find(".modal-body").html(message);
				Forms.setModalTitle("#"  + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4","Message");
					Forms.resizeDialog(undefined,false,true);

				if(!Forms.isModalOpen())
				$("#"  + wfUtils.constants.FORMS_POPUP_ID).modal("show");
				else
					checkWindowLocation();

				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").off("click");
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").attr("data-dismiss", "modal");

						$("#warningMsgBtn").off("click");
						$("#warningMsgBtn").on("click", function(e) {
										e.preventDefault();
										invokeAppropriateWorkflowCallBack(res.errorCode,res);
									});

				$("#"  + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal").on("hidden.bs.modal", function () {
						$(this).data('bs.modal', null);
					invokeAppropriateWorkflowCallBack(res.errorCode,res);
				});
			}
			else{
				if(isFullPageForms == false){
				if(Forms.isModalOpen())
				{
						$("#"  + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal");
						$("#"  + wfUtils.constants.FORMS_POPUP_ID).modal('hide');
				}
				removeAppStudioParamsFromURL();
				removeParamsFromNativeACURL();
			}
			}
				}
		}

	} else {
		if (res.respType == respType.POPUP_RESP) {
			var params = [];
			params.push(cvUtil.createParamString("isPopUpResp", true));
			inputParamsForModal = cvUtil.createParamsString(params);
			urlParams.v1 = (useNewForms === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3) ? useNewForms
					: !useNewForms;
			//wfInfo = {};
			wfInfo.isPopUpResp = "true";
			wfInfo.isInfoResp = "false";
			displayModal();
		} else if (res.respType == respType.INFO_RESP) {
			var params = [];
			params.push(cvUtil.createParamString("isInfoResp", true));
			inputParamsForModal = cvUtil.createParamsString(params);
			//wfInfo = {};
			urlParams.v1 = (useNewForms === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3) ? useNewForms
					: !useNewForms;
			wfInfo.isInfoResp = "true";
			wfInfo.isPopUpResp = "false";
			displayModal();
		}
		else
		{
				if (mobileView === true) {
					window.postMessage(JSON.stringify({
						event : "onCancel"
					}), "*");
				}
				else
				{
				if(isFullPageForm()){
					if($("#reqFromOutsideForms").val() === "")
					navigateToFormsPage();
					else
						invokeAppropriateWorkflowCallBack(res.errorCode,res);
				}
				isRefreshReq = "false";
				pushDefaultParameters();
				if(isFullPageForms == false){
				if(Forms.isModalOpen())
				{
						$("#"  + wfUtils.constants.FORMS_POPUP_ID).off("hidden.bs.modal");
						$("#"  + wfUtils.constants.FORMS_POPUP_ID).modal('hide');
				}
				removeAppStudioParamsFromURL();
				removeParamsFromNativeACURL();
		}
		}
	}
}
	}

	function getCustomInputParamsWithoutFieldList() {
		return getCustomInputParamsArr(wfUtils.functions.isLMPage() && savedInputMap ? savedInputMap : customInputsMap,true);
	}

	function getCustomInputParams(savedInputMap,doNotAddFieldList) {
		return getCustomInputParamsArr(wfUtils.functions.isLMPage() && savedInputMap ? savedInputMap : customInputsMap);
	}

	function getCustomInputParamsArr(customInputs,doNotAddFieldList){
	var params = [];
	jQuery.each(customInputs, function(key, value) {
		if (value.length > 0) {
			jQuery.each(value, function() {
				params.push(cvUtil.createParamString(key, $.trim(this)));
			});
				if(doNotAddFieldList == undefined)
			params.push(cvUtil.createParamString("fieldList", key));
		}
	});
	return params;
}


function triggerActivityForSubmit() {
	var params = [];
	params = getCustomInputParams();

	if (urlParams.interactionId != "") {
		params.push(cvUtil.createParamString("interactionId", urlParams.interactionId));
	} else {
			params.push(cvUtil.createParamString("workflowName", decodeURIComponent(urlParams.workflowName)));
		params.push(cvUtil.createParamString("workflowId", urlParams.workflowId));
		if(urlParams.wfEngineId && urlParams.wfEngineId!=""){
				params.push(cvUtil.createParamString("_wfClientId", urlParams.wfEngineId));
		}
	}

	params.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));

	if(urlParams.v1!=undefined && urlParams.v1 === false)
		params.push(cvUtil.createParamString("reactForm",true));

	var url = wfUtils.functions.getURL(true);

	if(Forms.isAppTableFormReq()){
		var appTableParams = getAppTableParams();

		params.push(cvUtil.createParamString("tableId",appTableParams["tableId"]));
		params.push(cvUtil.createParamString("rowId",appTableParams["rowId"]));

		url = Forms.getAppTableFormUrl(true,appTableParams);
	}

	var inputParams = cvUtil.createParamsString(params);

	if (wfUtils.functions.isAdminConsole())
		cvUtil.mask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
	else
	{
		cvUtil.mask();
		showMobileViewSpinner();
	}

		var wfResp = {
				respMsg : '',
				errorCode : undefined,
				respType : ''
			};

	cvUtil.loadPage(url, inputParams, function(data) {
		var isWfCompleted = true;
		if (data != undefined) {
			customInputsMap = {};
			if (wfUtils.functions.isAdminConsole())
				cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
			else
				cvUtil.unmask();

			var currentResp = data;
			Forms.setCurrentResp(currentResp);
				parent.currentResp = data;
			wfResp.respType = currentResp.respType;
			wfResp.outputParams = data || {};
			if (currentResp.respType == respType.GENERIC_RESP) {
				wfResp.respMsg = data.response.errorMessage;
				wfResp.errorCode = data.response.errorCode;
			} else if (currentResp.respType == respType.START_WORKFLOW_RESP) {
				wfResp.respMsg = "";
				wfResp.errorCode = 0;
			} else if (currentResp.respType == respType.END_USER_RESP) {
				wfResp.errorCode = undefined;
			} else if (currentResp.respType == respType.POPUP_RESP || currentResp.respType == respType.INFO_RESP) {
				isWfCompleted = false;
				initiateInputForm(urlParams.workflowId,
						urlParams.workflowName,
						urlParams.interactionId,
						urlParams.interactionName,
						urlParams.subTime);
			} else {
				wfResp.respMsg = data.errorMessage;
				wfResp.errorCode = data.errorCode;
			}

			if (isWfCompleted) {
				Forms.setCurrentResp(undefined);
				displayPostWorkflowMessage(wfResp);
			}
		}
		}, function(xhr, ajaxOptions, thrownError) {
			if(Forms.isAppTableFormReq())
			{
				wfResp.respMsg = xhr.responseText;
				wfResp.errorCode = 10;
				Forms.setWorkflowResp(wfResp);
				Forms.initializeV2Form(Forms.initializeV2ErrorCallBack);
			}
			else{
				wfResp.respMsg = "workflow submission failed";
				wfResp.errorCode = 10;
				Forms.setWorkflowResp(wfResp);
				Forms.initializeV2Form(Forms.initializeV2ErrorCallBack);

			}
			//closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
		}, wfUtils.functions.getAjaxTimeOut());
}

function isCurPageForms(){
	return window.location.pathname === cvUtil.getContextPath() + "/forms/" || window.location.pathname === cvUtil.getContextPath() + "/form.do";
}


function openFullPageFormInNewTab(actionUrl,paramMap) {
    var fullPageForm = $("<form target='_blank' method='POST' style='display:none;'></form>").attr({
        action: actionUrl
    }).appendTo(document.body);

    for (var inputName in paramMap) {
        if (paramMap.hasOwnProperty(inputName)) {
            $('<input type="hidden" />').attr({
                name: inputName,
                value: paramMap[inputName]
            }).appendTo(fullPageForm);
        }
    }
    fullPageForm.submit();
    fullPageForm.remove();
}

function constructWorkflowUrlFromOpenFormParams(wfObj){
	urlParams = {};
	readWorfklowParamtersFromObj(wfObj);
	var param = [];

	if(urlParams.workflowId !="" && urlParams.workflowId!=undefined)
	{
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_ID,urlParams.workflowId));
	}

	if(urlParams.workflowName!=undefined && urlParams.workflowName!="")
	{
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_NAME,decodeURIComponent(urlParams.workflowName)));
	}

	if(urlParams.interactionId!=undefined && urlParams.interactionId!="")
	{
		param.push(cvUtil.createParamString(PARAM_INTERACTION_ID,urlParams.interactionId));
	}

	if(urlParams.interactionName!=undefined && urlParams.interactionName!="")
	{
		param.push(cvUtil.createParamString(PARAM_INTERACTION_NAME,urlParams.interactionName));
	}

	if(urlParams.actionName!=undefined && urlParams.actionName!="")
	{
		param.push(cvUtil.createParamString(PARAM_ACTION_NAME,urlParams.actionName));
	}


	var inputParams = cvUtil.createParamsString(getCustomInputParamsWithoutFieldList());

	if(urlParams.submit!=undefined && urlParams.submit === true)
	{
		param.push(cvUtil.createParamString(wfUtils.constants.PARAM_SUBMIT_OPTION,urlParams.submit));
	}

	inputParams = cvUtil.createParamsString(param) + (inputParams!=undefined && inputParams!=""?"&" + inputParams:"");

	return inputParams

}

function executeOpenFormAsFullPage(wfObj){
	var paramMap = {};
		if(wfObj.successUrl!=undefined && wfObj.successUrl.trim()!="")
			paramMap["onSuccessURL"] = wfObj.successUrl;
		else
			paramMap["onSuccessURL"] = History.getState().cleanUrl;


		if(wfObj.failureUrl!=undefined && wfObj.failureUrl.trim()!="")
			paramMap["onFailureURL"] = wfObj.failureUrl;
		else
			paramMap["onFailureURL"] = History.getState().cleanUrl;

		paramMap["backURL"] = History.getState().cleanUrl;
		paramMap["reqFromOutsideForms"] = true;

		openFullPageFormInNewTab(cvUtil.getContextPath() + "/form.do?" + constructWorkflowUrlFromOpenFormParams(wfJsonObj),paramMap);
	}


function deleteAppTableRow(wfObj){
		wfJsonObj = wfObj;
		urlParams[PARAM_APP_STUDIO_FORM] = true;
		readWorfklowParamtersFromObj(wfObj);
		if(isFormPage()){
			if(selectedTab == ACTION_INDEX)
				cvUtil.mask();
			else
				cvUtil.mask(".cvApps");
		}
		else
			cvUtil.mask();

		Forms.deleteAppTableRecord(getAppTableParams());

		return false;
}

function updateAppStudioUrlParams(receivedForm){
		if(wfUtils.functions.isAdminConsole()){

			if(isAppTableFormReq() && (wfJsonObj["sysRowId"] || wfJsonObj["formId"])){
				urlToUpdate = window.location.href;
				urlToUpdate = urlToUpdate.substring(urlToUpdate.indexOf("#"));
				var currentRecordParams = [];
				if(wfJsonObj["doNotUpdateURL"] == undefined || wfJsonObj["doNotUpdateURL"] == false){

					if(receivedForm["tableId"]  && receivedForm["tableId"] !=0)
						currentRecordParams.push(cvUtil.createParamString("tableId",receivedForm["tableId"]));

					if(receivedForm["formId"]  && receivedForm["formId"] !=0)
						currentRecordParams.push(cvUtil.createParamString("formId",receivedForm["formId"]));

					if(receivedForm["rowId"] && receivedForm["rowId"]!=0)
						currentRecordParams.push(cvUtil.createParamString("rowId",receivedForm["rowId"]));

					if(currentRecordParams.length > 0)
						urlToUpdate += "&" + cvUtil.createParamsString(currentRecordParams);

					history.pushState(null,document.title,urlToUpdate);
				}

			}
		}
}

function hideImportPage(reloadTable){
	$(document).off("keyup");
	hideTargetFullPageForm();
	if(reloadTable === true && rpt)
		rpt.reload();
}

function addColumnsToDataImportPage(parameters){
	var columnList = parameters.columnList;
	if(columnList && columnList.length > 0){

		columnList.sort(function(a,b){
			if(a.displayName < b.displayName) return -1;
			if(a.displayName > b.displayName) return 1;
			return 0;
		});

		var noOfCols = columnList.length;
		var $matchCols = $('#wfMatchCols');
		var currCol = {};
		for(var i =0;i<columnList.length;i++){
			currCol = columnList[i]
			$matchCols.append($("<option></option>")
	                    .attr("value",currCol.displayName)
	                    .text(currCol.displayName));
		}
	}

	$(document).off("keyup").on("keyup",function(e) {
				e.preventDefault();
				if (e.keyCode == 27)
					hideImportPage(false);
	});

	$("#cancelImport").off("click").on("click",function(e){
		e.preventDefault();
		hideImportPage(false);
	});

	$("#wfFullPageImportCloseBtn").off("click").on("click",function(e){
		e.preventDefault();
		hideImportPage(false);
	});

	$("#saveImport").off("click").on("click",function(e){
		e.preventDefault();
		if ($("#wfImportedData").val().trim() == '') {
			showErrorMessages(["Enter rows to import"]);
			$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(0);
			return;
		}

		if ($("input[name='wfDataFormat']:checked").length == 0) {
			showErrorMessages(["Please select data format"]);
			$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(0);
			return;
		}

		if ($("input[name='RecordOperation']:checked").length == 0) {
			showErrorMessages(["Please select operation"]);
			$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(0);
			return;
		}

		var importSaveUrl = cvUtil.getContextPath() + "/proxy/cr/apps/tables/" + parameters.tableId + "/import";
		var params = [];


		if($("input[name='RecordOperation']:checked").val() != "addOnly"){
			if($("#wfMatchCols").val()!=null && $("#wfMatchCols").val().length > 0)
				params.push(cvUtil.createParamString("key",$("#wfMatchCols").val().join(",")));
			else{
				showErrorMessages(["Please select atleast one matching column"]);
				$(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT).scrollTop(0);
				return;
			}
		}

		params.push(cvUtil.createParamString("format", $("input[name='wfDataFormat']:checked").val()));
		params.push(cvUtil.createParamString("processBeforeRules",!$("#SkipBeforeIU").prop("checked")));
		params.push(cvUtil.createParamString("processAfterRules",!$("#SkipAfterIU").prop("checked")));
		params.push(cvUtil.createParamString("operation",$("input[name='RecordOperation']:checked").val()));

		importSaveUrl += "?" + cvUtil.createParamsString(params);

		maskImportPage();

		cvUtil.loadPage(importSaveUrl,$("#wfImportedData").val(),function(data,msg,xhr){
			unMaskImportPage();
				if (data != undefined) {
					if (xhr.status == 206) {
						showErrorMessages([ "Following errors were present while importing" ]);
						$("#wfImportedData").val(data.replace(/\\/g,""));
					} else {
						console.log("data imported successfully!");
						hideImportPage(true);
					}
				}
		},function(xhr, ajaxOptions, thrownError){
			unMaskImportPage();
			var errorMsg = xhr.responseText;
			try{
				errorMsg = JSON.parse(errorMsg);
				errorMsg = errorMsg && errorMsg.errorMessage?errorMsg.errorMessage:xhr.responseText;
			}
			catch(e){}

			showErrorMessages([errorMsg]);
			//hideTargetFullPageForm();
		},
		{
			callType : "PUT",
			contentType : "text_plain"

		});
	});

	$("#wfFormsPopup").find("[name='RecordOperation']").off("click").on("click",function(e){
	    console.log($(this).val());
	    if($(this).val() === "addOnly")
	        $("#wfMatchColsArea").hide();
	    else
	        $("#wfMatchColsArea").show();
	});


	$("#wfMatchCols").multiselect({
		enableCaseInsensitiveFiltering:true,
		buttonWidth:'100%',
		includeSelectAllOption:true,
		buttonClass:'testClass',
		buttonContainer:'<div id="Area" class="btn-group valAlign"></div>',
		height : 100,
		selectedList : 1,
		header : true,
		templates:{
			filterClearBtn:'<span class="input-group-btn"><button class="btn btn-default multiselect-clear-filter wfMultiSelectClearBtn" type="button"><i class="glyphicon glyphicon-remove-circle"></i></button></span>',
			ul: '<ul class="multiselect-container dropdown-menu wfMultiselectContainer wfImportMultiselectContainer"></ul>'
		},
		onChange:function(option, checked, select) {
			//$curComponent.handleChange(this.$select.val()!=undefined && this.$select.val() != null?$.isArray(this.$select.val())?this.$select.val():this.$select.val().split(","):undefined);
		},
		onSelectAll:function(e,e1){
			//var curVal = $("#" + $curComponent.props.name).val();
			//$curComponent.handleChange(curVal!=undefined && curVal != null?$.isArray(curVal)?curVal:curVal.split(","):undefined);
		},
		onDeselectAll:function(){
			//$curComponent.handleChange(Array());
		}
	});

}

function maskImportPage(){
	if(wfUtils.functions.isAdminConsole())
		cvUtil.mask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
	else
		cvUtil.mask();
}

function unMaskImportPage(){
	if(wfUtils.functions.isAdminConsole())
		cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
	else
		cvUtil.unmask();
}

function openDataImportPage(importReq){
	urlParams[PARAM_APP_STUDIO_FORM] = false;
	if(importReq["tableId"])
	{
		var parameters = {
				tableId : importReq["tableId"],
				table : importReq["table"]
		};

		maskImportPage();
		urlParams[PARAM_TARGET_DIV] = wfUtils.functions.isAdminConsole()?wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT:"#reportArea";
		cvUtil.loadPage(cvUtil.getContextPath() + "/api/cr/apps/tables/" + importReq["tableId"] + "/columns",{},function(columnList){
			if (columnList) {
				columnList = JSON.parse(columnList);
			}
			parameters["columnList"] = columnList;
			if(!IMPORT_FULL_PAGE_HTML)
			{
				cvUtil.loadPage(cvUtil.getContextPath() + "/forms/dataImportHtml.jsp",{},function(importHtml) {
					unMaskImportPage();
					IMPORT_FULL_PAGE_HTML = importHtml;
					executeFullPageImportsCallBack(addColumnsToDataImportPage,parameters);
				},function(xhr, ajaxOptions, thrownError) {
					unMaskImportPage();
				});
			}
			else
			{
				unMaskImportPage();
				executeFullPageImportsCallBack(addColumnsToDataImportPage,parameters);
			}
		},function(xhr, ajaxOptions, thrownError) {
			unMaskImportPage();
		},
		{
			contentType : "application/json",
			callType : "GET"
		});
	}
}

function openTableForm(wfObj){
	wfJsonObj = wfObj;
	urlParams[PARAM_APP_STUDIO_FORM] = true;
	urlToUpdate = undefined;
	wfInfo = {};

	if(wfUtils.functions.isAdminConsole()){
		if(wfObj[PARAM_TARGET_DIV] == undefined || wfObj[PARAM_TARGET_DIV]=="")
			wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = false;

		executeOpenFormAsModal(wfObj);
	}
	else
	{
		if((wfObj[PARAM_SHOW_AS_FULLPAGE_FORM]!=undefined && wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] == true) && !isCurPageForms())
		{
			if(wfObj[PARAM_TARGET_DIV]!=undefined && wfObj[PARAM_TARGET_DIV]!="")
				executeOpenFormAsModal(wfObj);
			else
			{
				wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
				executeOpenFormAsModal(wfObj);
			}
		}
	else
	{
		if(!isCurPageForms())
		{
			if(wfObj[PARAM_TARGET_DIV] == undefined || wfObj[PARAM_TARGET_DIV]=="")
				wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
		}
		executeOpenFormAsModal(wfObj);
	}
	}
}

function isPreviewInputForm(){
	return urlParams[PARAM_IS_PREVIEW_FORM]!=undefined && urlParams[PARAM_IS_PREVIEW_FORM] === true;
}

function previewAppStudioInputForm(inputFormJsonStr){
		urlParams = {};
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
		urlParams[PARAM_TARGET_DIV] = wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT;
		urlParams.showAsModal = false;
		urlParams[PARAM_IS_PREVIEW_FORM] = true;
		setSelectedTab(wfUtils.constants.FORM_INDEX);
		wfJsonObj = {};

		if(inputFormJsonStr && inputFormJsonStr!="")
		{
			var inputFormJson = {};
			inputFormJson.inputForm = JSON.parse(inputFormJsonStr);
			reinitializeModal();
			Forms.openModalForInputForm(inputFormJson);
		}
}

	function openInputForm(inputFormJsonStr){
		urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = true;
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
		urlParams.showAsModal = false;
		urlParams[PARAM_IS_PREVIEW_FORM] = true;

		if(inputFormJsonStr && inputFormJsonStr!="")
		{
			var inputFormJson = {};
			inputFormJson.inputForm = JSON.parse(inputFormJsonStr);
			reinitializeModal();
			Forms.openModalForInputForm(inputFormJson);
		}
	}

	function openConfigForm(inputFormJson,callback){
		urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = false;
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
		urlParams.showAsModal = true;
		urlParams[PARAM_IS_PREVIEW_FORM] = false;
		urlParams[PARAM_DO_NOT_START_WORKFLOW] = true;
		setSelectedTab(wfUtils.constants.FORM_INDEX);
		wfJsonObj = {}
		wfJsonObj.success = callback
	
		if(inputFormJson)
		{
			reinitializeModal();
			Forms.openModalForInputForm(inputFormJson);
		}
	}
		
	function getWorkflowParams(url){
		var interactionId = wfUtils.functions.getParameterByName(PARAM_INTERACTION_ID, url, "", false);

		if(interactionId == "")
			interactionId = wfUtils.functions.getParameterByName(PARAM_USER_INTERACTION, url, "", false);

		return {
			workflowId : wfUtils.functions.getParameterByName(PARAM_WORKFLOW_ID, url, "", false),
			workflowName : wfUtils.functions.getParameterByName(PARAM_WORKFLOW_NAME, url, "", false),
			interactionId : interactionId,
			interactionName : wfUtils.functions.getParameterByName(PARAM_INTERACTION_NAME, url, "", false)
		}
	}

	function getFullPageParam(wfObj){
		var fullPage = false;
		if(wfObj.invokedFromACFormsURL)
		{
			fullPage =  wfUtils.functions.getParameterByName(PARAM_SHOW_AS_FULLPAGE_FORM,wfObj.acURL,-1,false);
			fullPage = fullPage == "true"?true:fullPage == "false"?false:fullPage;
		}
		else
			fullPage = wfObj[PARAM_SHOW_AS_FULLPAGE_FORM];

		return fullPage;
	}


function openForm(wfObj) {
	urlParams[PARAM_APP_STUDIO_FORM] = false;

	wfJsonObj = wfObj;

	var fullPage = getFullPageParam(wfObj);


		if((fullPage!=undefined && fullPage == true) && !isCurPageForms())
		{
			if(wfObj[PARAM_TARGET_DIV]!=undefined && wfObj[PARAM_TARGET_DIV]!="")
				executeOpenFormAsModal(wfObj);
			else
			{
				if (wfUtils.functions.isAdminConsole()) {
					wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
					executeOpenFormAsModal(wfObj);
				}
				else
					executeOpenFormAsFullPage(wfObj);
			}
	}
	else
	{
			if(!isCurPageForms() && window.location.hash !== "#/forms" && window.location.hash.indexOf("#/workflows") == -1)
			{
				cvUtil.mask();
				if (wfObj.interactionId !=undefined && wfObj.interactionId != "" || wfObj.interactionName !=undefined && wfObj.interactionName != "") {
					selectedTab = wfUtils.constants.ACTION_INDEX;
				} else {
					selectedTab = wfUtils.constants.FORM_INDEX;
				}

				var url = wfUtils.functions.getURL(false);
				var params = [];
				params.push(cvUtil.createParamString("workflowId",
						wfObj.workflowId));
				params.push(cvUtil.createParamString("workflowName",wfObj.workflowName ? decodeURIComponent(wfObj.workflowName): undefined));
				params.push(cvUtil.createParamString("interactionId",wfObj.interactionId));
				params.push(cvUtil.createParamString(wfUtils.constants.PARAM_SUBMIT_OPTION, false));
				params.push(cvUtil.createParamString("reactForm", false));

				var inputParams = cvUtil.createParamsString(params);

				cvUtil.loadPage(url, inputParams, function(data) {
						cvUtil.unmask();
						if (Forms.isValidData(wfObj.interactionId, data))
						{
								var currForm = Forms.getFormObject(wfObj.interactionId, data);
								var formProps = Forms.getFormProperties(wfObj.interactionId, currForm);

								var fullPageParameter = PARAM_SHOW_AS_FULLPAGE_FORM;
								var modalParamter = PARAM_SHOW_AS_MODAL;

								if(formProps!=undefined && formProps.pageMode!=undefined && formProps.pageMode!= "" && formProps.pageMode == "FULL_PAGE" )
								{
									wfObj[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
									wfObj[modalParamter] = false;
								}
								else
								{
									wfObj[fullPageParameter] = false;
									wfObj[modalParamter] = true;
								}
						}

						if(wfObj[fullPageParameter]!=undefined && wfObj[fullPageParameter] === true)
							{
								if(wfObj[PARAM_TARGET_DIV]!=undefined && wfObj[PARAM_TARGET_DIV]!="")
									executeOpenFormAsModal(wfObj);
						else {
							if (wfUtils.functions.isAdminConsole()) {
								wfObj[fullPageParameter] = false;
								wfObj[modalParamter] = true;
								executeOpenFormAsModal(wfObj);
							} else {
								executeOpenFormAsFullPage(wfObj);
							}
						}
							}

						else
							executeOpenFormAsModal(wfObj);
					},function(xhr, ajaxOptions, thrownError) {
						cvUtil.unmask();
						executeOpenFormAsModal(wfObj);

					},{"async":false});

			}
			else
				{
				executeOpenFormAsModal(wfObj);
		}

		}
	//}
	return false;
}

function executeOpenFormAsModal(wfObj){
	addWarningListener();

	if(wfObj.invokedFromACFormsURL){
		readWorfklowParamtersFromUrl(wfObj.acURL);
		urlParams[PARAM_TARGET_DIV] = wfObj[PARAM_TARGET_DIV];
	}
	else
		readWorfklowParamtersFromObj(wfObj);

	if (urlParams.interactionId != "") {
		selectedTab = wfUtils.constants.ACTION_INDEX;
	} else {
		selectedTab = wfUtils.constants.FORM_INDEX;
	}
	isFormsPage = false;
	if (urlParams.submit) {
		triggerActivityForSubmit();
	} else {
		initiateInputForm(urlParams.workflowId,
				urlParams.workflowName,
				urlParams.interactionId,
				urlParams.interactionName,
				urlParams.subTime);
	}
	}

function readWorfklowParamtersFromUrl(url) {
	urlParams = {};
	var success = "",fail = "",successParams = "",failParams = "";
	var tableId = "",rowId = "";

	urlParams[PARAM_IS_PREVIEW_FORM] = false;

	if (url != undefined) {
		urlParams.isOpenFilter = wfUtils.functions.getParameterByName(PARAM_FILTER, url, true, false);
		urlParams.workflowId = wfUtils.functions.getParameterByName(PARAM_WORKFLOW_ID, url, "", false);
		urlParams.workflowName = wfUtils.functions.getParameterByName(PARAM_WORKFLOW_NAME, url, "", false);
		urlParams.interactionId = wfUtils.functions.getParameterByName(PARAM_INTERACTION_ID, url, "", false);

		if(urlParams.interactionId == "")
			urlParams.interactionId = wfUtils.functions.getParameterByName(PARAM_USER_INTERACTION, url, "", false);

		urlParams.interactionName = wfUtils.functions.getParameterByName(PARAM_INTERACTION_NAME, url, "", false);
		urlParams.tab = wfUtils.functions.getParameterByName(PARAM_TAB, url,0, false);
		urlParams.subTime = wfUtils.functions.getParameterByName(PARAM_SUBTIME, url, "", false);
		urlParams.actionName = wfUtils.functions.getParameterByName(PARAM_ACTION_NAME, url, "", false);
		urlParams.submit = wfUtils.functions.getParameterByName(wfUtils.constants.PARAM_SUBMIT_OPTION, url, "", false);
		urlParams.wfEngineId = wfUtils.functions.getParameterByName(PARAM_WORKFLOWENGINE_ID, url, "", false);
		urlParams.id = wfUtils.functions.getParameterByName(PARAM_USER_GUID, url, "", false);
		urlParams.showAsModal = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_MODAL, url, "false", false);
		urlParams.v1 = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_V1, url,false,false);
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_FULLPAGE_FORM,url,-1,false);
		urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM,url,false,false);
		success = wfUtils.functions.getParameterByName("onSuccess",url,"",false);
		successParams = wfUtils.functions.getParameterByName("successParams",url,"",false);
		fail = wfUtils.functions.getParameterByName("onFailure",url,"",false);
		failParams = wfUtils.functions.getParameterByName("failParams",url,"",false);

		tableId = wfUtils.functions.getParameterByName("tableId",url,"",false);
		rowId = wfUtils.functions.getParameterByName("sysRowId",url,"",false);

		urlParams[PARAM_SHOW_WARNING_MESSAGE] = wfUtils.functions.getParameterByName(PARAM_SHOW_WARNING_MESSAGE,url,"true",false);
		urlParams[PARAM_READONLY_FORM] = wfUtils.functions.getParameterByName(PARAM_READONLY_FORM,url,false,false);

	} else {
		if (History.isInternetExplorer()) {
			url = History.getState().cleanUrl;

			urlParams.isOpenFilter = wfUtils.functions.getParameterByName(PARAM_FILTER, url, true, false);
			urlParams.workflowId = wfUtils.functions.getParameterByName(PARAM_WORKFLOW_ID, url, "", false);
			urlParams.workflowName = wfUtils.functions.getParameterByName(PARAM_WORKFLOW_NAME, url, "", false);
			urlParams.interactionId = wfUtils.functions.getParameterByName(PARAM_INTERACTION_ID, url, "", false);

			if(urlParams.interactionId == "")
				urlParams.interactionId = wfUtils.functions.getParameterByName(PARAM_USER_INTERACTION, url, "", false);

			urlParams.interactionName = wfUtils.functions.getParameterByName(PARAM_INTERACTION_NAME, url, "", false);
			urlParams.tab = wfUtils.functions.getParameterByName(PARAM_TAB, url,0, false);
			urlParams.subTime = wfUtils.functions.getParameterByName(PARAM_SUBTIME, url, "", false);
			urlParams.actionName = wfUtils.functions.getParameterByName(PARAM_ACTION_NAME, url, "", false);
			urlParams.submit = wfUtils.functions.getParameterByName(wfUtils.constants.PARAM_SUBMIT_OPTION, url, "", false);
			urlParams.wfEngineId = wfUtils.functions.getParameterByName(PARAM_WORKFLOWENGINE_ID, url, "", false);
			urlParams.id = wfUtils.functions.getParameterByName(PARAM_USER_GUID, url, "", false);
			urlParams.showAsModal = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_MODAL, url, "false", false);
			urlParams.v1 = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_V1,url,"",false);
			urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_FULLPAGE_FORM,url,-1,false);
			urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = wfUtils.functions.getParameterByName(PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM,url,false,false);

			success = wfUtils.functions.getParameterByName("onSuccess",url,"",false);
			successParams = wfUtils.functions.getParameterByName("successParams",url,"",false);
			fail = wfUtils.functions.getParameterByName("onFailure",url,"",false);
			failParams = wfUtils.functions.getParameterByName("failParams",url,"",false);

			tableId = wfUtils.functions.getParameterByName("tableId",url,"",false);
			rowId = wfUtils.functions.getParameterByName("sysRowId",url,"",false);

			urlParams[PARAM_SHOW_WARNING_MESSAGE] = wfUtils.functions.getParameterByName(PARAM_SHOW_WARNING_MESSAGE,url,"true",false);
			urlParams[PARAM_READONLY_FORM] = wfUtils.functions.getParameterByName(PARAM_READONLY_FORM,url,false,false);
		} else {
			urlParams.isOpenFilter = wfUtils.functions.getParameterViaHistory(PARAM_FILTER, true);
			urlParams.workflowId = wfUtils.functions.getParameterViaHistory(PARAM_WORKFLOW_ID, "");
			urlParams.workflowName = wfUtils.functions.getParameterViaHistory(PARAM_WORKFLOW_NAME, "");
			urlParams.interactionId = wfUtils.functions.getParameterViaHistory(PARAM_INTERACTION_ID, "");

			if(urlParams.interactionId == "")
				urlParams.interactionId = wfUtils.functions.getParameterViaHistory(PARAM_USER_INTERACTION, "");

			urlParams.interactionName = wfUtils.functions.getParameterViaHistory(PARAM_INTERACTION_NAME, "");
			urlParams.tab = wfUtils.functions.getParameterViaHistory(PARAM_TAB, 0);
			urlParams.subTime = wfUtils.functions.getParameterViaHistory(PARAM_SUBTIME, "");
			urlParams.actionName = wfUtils.functions.getParameterViaHistory(PARAM_ACTION_NAME, "");
			urlParams.submit = wfUtils.functions.getParameterViaHistory(wfUtils.constants.PARAM_SUBMIT_OPTION, "");
			urlParams.wfEngineId = wfUtils.functions.getParameterViaHistory(PARAM_WORKFLOWENGINE_ID,"");
			urlParams.id = wfUtils.functions.getParameterViaHistory(PARAM_USER_GUID, "");
				urlParams.showAsModal = wfUtils.functions.getParameterViaHistory(PARAM_SHOW_AS_MODAL, "false");
			urlParams.v1 = wfUtils.functions.getParameterViaHistory(PARAM_SHOW_AS_V1,"");
			urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = wfUtils.functions.getParameterViaHistory(PARAM_SHOW_AS_FULLPAGE_FORM,-1);
			urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = wfUtils.functions.getParameterViaHistory(PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM,-1);
			success = wfUtils.functions.getParameterViaHistory("onSuccess","");
			successParams = wfUtils.functions.getParameterViaHistory("successParams","");
			fail = wfUtils.functions.getParameterViaHistory("onFailure","");
			failParams = wfUtils.functions.getParameterViaHistory("failParams","");

			tableId = wfUtils.functions.getParameterViaHistory("tableId","");
			rowId = wfUtils.functions.getParameterViaHistory("sysRowId","");

			urlParams[PARAM_SHOW_WARNING_MESSAGE] = wfUtils.functions.getParameterViaHistory(PARAM_SHOW_WARNING_MESSAGE,"true");
			urlParams[PARAM_READONLY_FORM] = wfUtils.functions.getParameterViaHistory(PARAM_READONLY_FORM,false);
		}
		url = History.getState().cleanUrl;
	}

	urlParams.workflowName = encodeURIComponent(urlParams.workflowName);
	urlParams.interactionName = encodeURIComponent(urlParams.interactionName);
	urlParams.subTime = encodeURIComponent(urlParams.subTime);

	urlParams[PARAM_SHOW_WARNING_MESSAGE] = urlParams[PARAM_SHOW_WARNING_MESSAGE] == "true"?true:false;

	if (urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] != "") {
		if (urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] == "true") {
			urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = true;
		} else {
			urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] = false;
		}
	}

	if (urlParams.submit != "") {
		if (urlParams.submit == "true") {
			urlParams.submit = true;
		} else {
			urlParams.submit = false;
		}
	}

	updateReadonlyFormParam();

	if(urlParams.showAsModal!=""){
		if (urlParams.showAsModal == "true") {
			urlParams.showAsModal = true;
		} else {
			urlParams.showAsModal = false;
		}
	}

		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == "true"?true:urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] == "false"?false:urlParams[PARAM_SHOW_AS_FULLPAGE_FORM];

		if(urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] == true)
		{
			urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
			urlParams.showAsModal = false;
		}
		else if(urlParams.showAsModal === true)
		{
			urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = false;
		}
		else if(urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] === false)
		{
			urlParams.showAsModal = true;
		}

	updateCustomQueryParamVals(url);

	if (!$.isEmptyObject(customInputsMap) || urlParams.submit == true) {
		urlParams.submit = urlParams.submit == "" ? false : urlParams.submit != true ? false : true;
		urlParams.tab = wfUtils.constants.FORM_INDEX;
	} else {
		if (urlParams.tab == -1) {
			if (urlParams.workflowId != "" || urlParams.workflowName != "") {
				urlParams.tab = wfUtils.constants.FORM_INDEX;
			} else if (urlParams.interactionId != "" || urlParams.interactionName != "") {
				urlParams.tab = wfUtils.constants.ACTION_INDEX;
			}
		}
	}

	if (urlParams.tab != "") {
		urlParams.tab = parseInt(urlParams.tab);
	}

	if (urlParams.tab == wfUtils.constants.FORM_INDEX) {
		urlParams.isOpenFilter = isOpenFilter;
	} else if (urlParams.isOpenFilter == "false") {
		urlParams.isOpenFilter = false;
		isOpenFilter = false;
	}

	if(!wfJsonObj || !wfJsonObj.invokedFromACFormsURL){
		wfJsonObj = {};
	}

	if(success!=undefined && success.trim()!="")
	{
		wfJsonObj.success = success;
	}

	if(fail!=undefined && fail.trim()!="")
	{
		wfJsonObj.fail = window[fail];
	}

	if(successParams!=undefined && successParams.trim()!="")
	{
		wfJsonObj.successParams = successParams;
	}

	if(failParams!=undefined && failParams.trim()!="")
	{
		wfJsonObj.failParams = failParams;
	}

	urlParams[PARAM_APP_STUDIO_FORM] = false;
	if(isFullPageTableForm())
	{
		urlParams[PARAM_APP_STUDIO_FORM] = true;
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = true;
		urlParams.showAsModal = false;
	}


		urlParams.isV3Form = false;

	if(isAppTableFormReq())
	{
		urlParams.v1 = false;
	}
	else if(typeof urlParams.v1 === "string" && urlParams.v1.trim()!=""){
		urlParams.v1 = urlParams.v1.trim();
			if(urlParams.v1 === "3"){
				urlParams.v1 = false;
				urlParams.isV3Form = true;
			}
			else
			{
		urlParams.v1 = urlParams.v1 == "true"?true:false;
			}
		}
		else if(useNewForms === 3) {
			urlParams.v1 = false;
			urlParams.isV3Form = true;
		} else {
			urlParams.v1 = (useNewForms === 0 || useNewForms === -1 || useNewForms === -2 || useNewForms === -3) ? useNewForms
					: !useNewForms;
		}

	if(isAppTableFormReq())
	{
		urlParams.tableId = tableId;
		urlParams.rowId = rowId;
	}


	displayAppropriateLoader();
}

function displayAppropriateLoader(){
	if(!urlParams.submit){
		if(urlParams.tab == wfUtils.constants.FORM_INDEX)
			$(".wfFormsLoader").show();
		else
			$(".wfActionsLoader").show();
	}
}

function workflowParametersChanged() {
	var previousTab = selectedTab;

	if (urlParams.tab != "") {
		selectedTab = urlParams.tab;
	} else if (urlParams.interactionId != "") {
		selectedTab = wfUtils.constants.ACTION_INDEX;
	} else {
		selectedTab = wfUtils.constants.FORM_INDEX;
	}
	displaySelectedTab(previousTab);
}

function updateOpenActionsCount(noOfRows) {
	if (noOfRows != 0) {
		$(".activeActionsCount").addClass("enable");
		$(".activeActionsCount").html(noOfRows);
	} else {
		$(".activeActionsCount").removeClass("enable");
	}
}

function loadWorkflows() {
		$("#wFsearchBox").show();
		if(!isFullPageForm())
			navigateToFormsPage();

	cvUtil.loadPageWithGET(cvUtil.getContextPath() + '/server/forms.do', null, function(data) {
		if (data != undefined) {
			var workflowList = data.container;
			if (workflowList != undefined && workflowList.length > 0) {
				createWorkflowPage(workflowList);
			} else {
				$(".center").remove();
			}

			var openCount = 0;
			if (data.pendingActions != undefined) {
				openCount = parseInt(data.pendingActions);
			}

			enableOrDisableActionsTab(openCount, data.completedActions);
			updateOpenActionsCount(openCount);
		} else {
			$(".center").remove();
		}
	}, undefined, wfUtils.functions.getAjaxTimeOut());
}

function updateWorkflowsPage() {

	var isWorkflowExists = $("#warning").attr("data-workflowpresent");
	if (isWorkflowExists != undefined && isWorkflowExists == "false") {
		$("#warning").removeAttr("data-workflowpresent");
		$(".apps").html('<div class="center"><img src="../common/img/loader.gif"/></div>');
		//loadWorkflows();
	}
}

/**
 *
 * @param aoData
 * @param key
 * @param value
 */
function addToMap(aoData, key, value) {
	if (aoData.push) {
		aoData.push({
			name : key,
			value : value
		});
	}
}

function reInitializeDataTable(id) {
	reinitializingTable = true; // used to prevent reinitialization from invoking another ajax call

	// Restore original table DOM:
	if (actionsTable != undefined) {
		console.debug("Destroying actions table");
		actionsTable.fnClearTable();
		actionsTable.fnDestroy();
		actionsTable = null;
		console.debug("Done destroying actions table");
	}

	// Reinitialized the data table:
	console.debug("Re-initializing actions table");
	reinitializingTable = false;
	$("#" + id + "body").empty(); // else the intialize may try to incorporate the old row data and break
	initializeUserActionsTable(id);

	console.debug("Done re-initializing actions table");
}

function paginationReplace() {
	var pag = $(".dataTables_info").html().replace("entries", "");
	pag = pag.replace("Showing", "");
	pag = pag.replace("to", "-");
	pag = pag.replace("of", "<span class='unbold'>of</span>");
	pag = pag.replace("</p>", "</p>");
	var pagpar = "<p class='newpagination'>" + pag + "</p>";
	$(".dataTables_info").html(pagpar);
	var vis = $(".dataTables_paginate").css("visibility");
	if (vis == "visible") {
		var width = 0;
		$('.paginate_button').each(function() {
			width += $(this).outerWidth(true);
		});
		width = width / 2 + 50;
		var topwidth = $(".top").width();
		var paginatewidth = topwidth - width + 120 + "px";
		$(".dataTables_info").width(paginatewidth);
		if (urlParams.isOpenFilter) {
			$(".newpagination").css("width", "813px");
		} else {
			$(".newpagination").css("width", "620px");
		}
	}

}

function getFormattedDate(actionTime) {
	var currdate = new Date(parseInt(actionTime) * 1000);
	var temp = currdate.toDateString();
	temp = temp.substring(4);
	return currdate.getHours() + ":" + currdate.getMinutes() + " " + temp;
}

function getSubjectCol(source) {
	var rowTemplate = "<a id=\"" + source.map.id + '" href="' + cvUtil.getContextPath() + '/forms/?tab=' +
			source.map.tabIndex + '&filter=' + source.map.filter + '&interactionId=' + source.map.id +
			'&interactionName=' + source.map.name;

	if (!source.map.filter) {
		rowTemplate += '&subTime=' + source.map.completionTime + '" data-subTime="' + source.map.completionTime + '"';
	} else {
		rowTemplate += '"';
	}

	rowTemplate += '" class="runActions">' + source.map.name + '</a>';
	return rowTemplate;
}

function initializeUserActionsTable(id) {
	//jQuery.fn.dataTableExt.oPagination.iFullNumbersShowPages = 1;
	return;

	actionsTable = $('#' + id).dataTable({
		"sAjaxSource" : cvUtil.getContextPath() + '/server/retrieveActions',
		"iDisplayLength" : 15,
		"fnServerParams" : function(aoData) {
			addToMap(aoData, "tab", wfUtils.constants.ACTION_INDEX);
			addToMap(aoData, "isOpenfilter", urlParams.isOpenFilter);
			var date = new Date();
			addToMap(aoData, "timeOffset", date.getTimezoneOffset());
		},
		"fnDrawCallback" : function() {
			if (urlParams.isOpenFilter) {
				updateOpenActionsCount(this.dataTableSettings[0].fnRecordsTotal());
			}
			$(".runActions").off("click");
			$(".runActions").on("click", function(e) {
				e.preventDefault();
				initiateInputForm("", "", $(this).attr("id"), $(this).html(), $(this).attr("data-subTime"));
			});
			paginationReplace();
		},
		"sDom" : 'rt<"bottom"iflp<"clear">>',
		"sPaginationType" : 'full',
		"fnServerData" : function(sSource, aoData, fnCallback) {
			$.ajax({
				"dataType" : 'json',
				"type" : "POST",
				"url" : sSource,
				"data" : aoData,
				"error" : function() {
				},
				"success" : function(json) {
					// Proceed with normal dataTable processing:
					$(".dataTables_info").css("visibility", "visible");
					console.log(json);
					fnCallback(json);

					//enableOrDisableActionsTab(parseInt(json.iTotalRecords));
					if (actionsTable.dataTableSettings[0]._iDisplayLength < json.iTotalRecords) {
						$("#" + id + "_paginate").show();
						$(".dataTables_info").css("visibility", "visible");
					} else {
						$("#" + id + "_paginate").hide();
						if (json.iTotalDisplayRecords == 0) {
							$(".dataTables_info").hide();
						}
						//$(".newpagination").css("width","813px");
					}
				}
			});
		},
		"aoColumnDefs" : (urlParams.isOpenFilter) ? [ {
			"aTargets" : [ 0 ],
			"mDataProp" : function(source, type, val) {
				return getSubjectCol(source);
			}
		}, {
			"type" : "num",
			"aTargets" : [ 1 ],
			"mDataProp" : function(source, type, val) {
				if (type == "sort") {
					return source.map.createdTime_epoch;
				} else {
					return source.map.createdTime;
				}
			}
		} ] : [ {
			"aTargets" : [ 0 ],
			"mDataProp" : function(source, type, val) {
				return getSubjectCol(source);
			}
		}, {
			"aTargets" : [ 1 ],
			"mDataProp" : function(source, type, val) {
				return source.map.completedby;
			}
		}, {
			"type" : "num",
			"aTargets" : [ 2 ],
			"mDataProp" : function(source, type, val) {
				if (type == "sort") {
					return source.map.completionTime_epoch;
				} else {
					return source.map.completionTime;
				}
			}
		} ],
		"aaSorting" : (urlParams.isOpenFilter) ? [ [ 1, "desc" ] ] : [ [ 2, "desc" ] ],
		"bLengthChange" : false,
		"bRetrieve" : true,
		"bAutoWidth" : false,
		"bFilter" : false,
		"oLanguage" : {
			"oPaginate" : {
				"sFirst" : '',
				"sNext" : '',
				"sPrevious" : '',
				"sLast" : ''
			},
			"sLoadingRecords" : "",
			"sEmptyTable" : urlParams.isOpenFilter ? wf_localMsg.noPendingActions : wf_localMsg.noCompletedActions
		},
	});
}

function enableOrDisableAppropriateAction() {
	if (urlParams.isOpenFilter) {
		$(".closedActions").hide();
		$(".openActions").show();
		$("#completed").removeClass("active");
		$("#open").addClass("active");
	} else {
		$(".openActions").hide();
		$(".closedActions").show();
		$("#open").removeClass("active");
		$("#completed").addClass("active");
	}
}

function getAppropriateActionId() {
	return urlParams.isOpenFilter ? "openActionsTable" : "closedActionsTable";
}

function updateTabsFromURLParams(isFormProcessed) {
	if (selectedTab == wfUtils.constants.ACTION_INDEX) {
		enableOrDisableAppropriateAction();
		reInitializeDataTable(getAppropriateActionId());
	} else {
		loadWorkflows();
	}

	if (!isFormProcessed) {
		if (urlParams.submit == true) {
			triggerActivityForSubmit();
		} else {
			initiateInputForm(urlParams.workflowId,
					urlParams.workflowName,
					urlParams.interactionId,
					urlParams.interactionName,
					urlParams.subTime);
		}
	}
}

function isFormPage(){
	return window.location.pathname === cvUtil.getContextPath() + "/forms/" || window.location.pathname === cvUtil.getContextPath() + "/form.do" ||  window.location.pathname === cvUtil.getContextPath() + "/tableForm.do" || window.location.pathname === cvUtil.getContextPath() + "/forms/preview/";
}

function isMobileView(){
	return urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] != undefined && urlParams[PARAM_SHOW_AS_MOBILEVIEW_FULLPAGE_FORM] === true;
}

function hideFormHeader(){
	if(isMobileView()){
		$("#wfFormsPopup .modal-header").hide();
}
}

function pushDefaultParameters() {
	if (isFormPage()) {
		isRefreshReq = false;
		var param = [];
		urlParams.workflowId = "";
		urlParams.workflowName = "";
		urlParams.wfEngineId = "";
		urlParams.interactionId = "";
		urlParams.interactionName = "";
		urlParams.actionName = "";
		urlParams.id = "";
		urlParams.tab = selectedTab;
		urlParams.isOpenFilter = isOpenFilter;
		urlParams.tableId = "";
		var updatedFilter = isOpenFilter;

		var changedURL = getStateURL(urlParams);
		changedURL += "&tableId=" + urlParams.tableId;

		readWorfklowParamtersFromUrl();
		isOpenFilter = updatedFilter;

		var currentURL = getStateURL(urlParams);
		currentURL += "&tableId=" + urlParams.tableId;

		if (urlParams.tab != -1 && changedURL == currentURL) {
			if (isRefreshReq) {
				workflowParametersChanged();
			} else {
				isRefreshReq = true;
			}
		} else {
			param.push(cvUtil.createParamString(PARAM_TAB, selectedTab));
			if (selectedTab == wfUtils.constants.ACTION_INDEX) {
				//param.push(cvUtil.createParamString(PARAM_FILTER, updatedFilter));
			}
			pushWorkflowParameterChangesToUrl(cvUtil.createParamsString(param));
		}
	}
}

function getOpenActionsCount(){
	var count = 0;
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/openActionsCount.do', null, function(data) {
		if (data != undefined) {
			count = parseInt(data);
			updateOpenActionsCount(count);
		}
	});
}

function displayInitialAppropriateTab() {
	var count = 0;

	readWorfklowParamtersFromUrl();

	if (!(History.emulated.pushState && History.getHash()) && urlParams.tab != -1) {
		workflowParametersChanged();
	} else {
		cvUtil.loadPage(cvUtil.getContextPath() + '/server/openActionsCount', null, function(data) {
			if (data != undefined) {
				count = parseInt(data);
				if (History.emulated.pushState && History.getHash()) {
					if (count > 0) {
						updateOpenActionsCount(count);
						intialStateofIE = true;
					}
					History.Adapter.trigger(window, "statechange");
				} else {
					readWorfklowParamtersFromUrl();
					if (urlParams.tab == -1) {
						if (count > 0) {
							updateOpenActionsCount(count);
							$("#tabs").tabs("select", wfUtils.constants.ACTION_INDEX);
						} else {
							pushDefaultParameters();
						}
					}
					/*
					 * else { workflowParametersChanged(); }
					 */
				}
			} else {
				pushDefaultParameters();
			}
		}, function(xhr, ajaxOptions, thrownError) {
			pushDefaultParameters();
		}, wfUtils.functions.getAjaxTimeOut());
	}
}

function enableOrDisableActionsTab(actionsCount, isCompletedActions) {
	if (actionsCount > 0 || isCompletedActions) {
		$("#tabs").tabs("enable", wfUtils.constants.ACTION_INDEX);
		$("#tab2").show();
		$(".activeActionsCount").show();
	} else {
		/*
		 * if(selectedTab == wfUtils.constants.ACTION_INDEX) { $( "#tabs" ).tabs( "select", wfUtils.constants.FORM_INDEX); } else {
		 */
		$("#tabs").tabs("disable", wfUtils.constants.ACTION_INDEX);
		$("#tab2").hide();
		$(".activeActionsCount").hide();
		//				}
	}
}

function getSelectedTab(){
	return selectedTab;
}

function setSelectedTab(curSelectedTab){
	selectedTab = curSelectedTab;
}

function getInputParamsForClosedWf(){
	return inputParamsForClosedWf;
}

function setInputParamsForClosedWf(curInputParamsForClosedWf){
	inputParamsForClosedWf = curInputParamsForClosedWf;
}

	function setFullPageParameter(fullPageVal,modalVal) {
		urlParams[PARAM_SHOW_AS_FULLPAGE_FORM] = fullPageVal;
		urlParams[PARAM_SHOW_AS_MODAL] = modalVal;
	}

function getUrlParams(){
	return urlParams;
}

function setSubmit(val){
	urlParams.submit = val;
}

function getCustomInputsMap(){
	return customInputsMap;
}

function setCustomInputsMap(curCustomInputMap){
	customInputsMap = curCustomInputMap;
}

	function addEscListener(){
		$(document).off("keyup").on("keyup",function(e) {
		     if (e.keyCode == 27 && e.target.className != "modal fade ng-isolate-scope small-size in-remove in-remove-active")
		    	 if(e.target.id == wfUtils.constants.FORMS_WARNINGMESSAGE_ID )
		    		 Forms.closeWarningMessage();
		    	 else if((Forms.isFullPageForm() ||  (Forms.isModalOpen() && !Forms.isModalOpen(wfUtils.constants.SEARCHABLE_POPUP_ID))) && (urlParams.v1 === false))// escape key maps to keycode `27`
		    		 Forms.processCancelEventRules(cancelRulesValidCallBack);

		});
	}

function checkWindowLocation(){
			if(!Forms.isFullPageForm()){
				var $modalDialog = $("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-dialog");
                var topVal = parseInt($modalDialog.css('top'));
                var leftVal = parseInt($modalDialog.css('left'));
                if (topVal < 0) {
                    $modalDialog.css('top', '0px');
                }
                if (leftVal < 0) {
					$modalDialog.css('left', '0px');
                }
			}
}

function populateLocalizedStringMap(){
	localizedStringMap["next"] = wf_localMsg.nextButtonLbl;
	localizedStringMap["back"] = wf_localMsg.backButtonLbl;
}

function getLocalizedText(key){
	var keyToSearch = key.toLowerCase();
	return localizedStringMap[keyToSearch]?localizedStringMap[keyToSearch]:key;
}

function getDoNotStartWorkflow(){
	return urlParams[PARAM_DO_NOT_START_WORKFLOW];
}


	formObj["openForm"] = openForm;
	formObj["getSelectedTab"] = getSelectedTab;
	formObj["setSelectedTab"] = setSelectedTab;
	formObj["getUrlParams"] = getUrlParams;
	formObj["getCustomInputParams"] = getCustomInputParams;
	formObj["updateInputEntryVal"] = updateInputEntryVal;
	formObj["isIntialReq"] =  isIntialReq;
	formObj["historyStateChanged"] = historyStateChanged;
	formObj["displayInitialAppropriateTab"] =  displayInitialAppropriateTab;
	formObj["updateTabsFromURLParams"] =  updateTabsFromURLParams;
	formObj["pushDefaultParameters"] =  pushDefaultParameters;
	formObj["customInputsMap"] = getCustomInputsMap;
	formObj["setCustomInputsMap"] = setCustomInputsMap;
	formObj["setSubmit"] =  setSubmit;
	formObj["onWorkflowCompletion"] = onWorkflowCompletion;
	formObj["updateCustomQueryParamValsFromJSON"] = updateCustomQueryParamValsFromJSON;
	formObj["addWarningListener"] = addWarningListener;
	formObj["isV3Form"] = isV3Form;
	formObj["getInputParamsForClosedWf"] = getInputParamsForClosedWf;
	formObj["setInputParamsForClosedWf"] = setInputParamsForClosedWf;
	formObj["initializeModal"] = initializeModal;
	formObj["isFullPageForm"] = isFullPageForm;
	formObj["initializeV2Form"] = initializeV2Form;
	formObj["setFullPageParameter"] = setFullPageParameter;
	formObj["PARAM_SHOW_AS_FULLPAGE_FORM"] = PARAM_SHOW_AS_FULLPAGE_FORM;
	formObj["PARAM_SHOW_AS_MODAL"] = PARAM_SHOW_AS_MODAL;
	formObj["isTargetDivFullPageForm"] = isTargetDivFullPageForm;
	formObj["getTargetContainerForFullPage"] = getTargetContainerForFullPage;
	formObj["isFormPage"] = isFormPage;
	formObj["openTableForm"] = openTableForm;
	formObj["isAppTableFormReq"] = isAppTableFormReq;
	formObj["isMobileView"] = isMobileView;
	formObj["isReadOnlyForm"] = isReadOnlyForm;
	formObj["showMobileViewSpinner"] = showMobileViewSpinner;
	formObj["deleteAppTableRow"] = deleteAppTableRow;
	formObj["openInputForm"] = openInputForm;
	formObj["openConfigForm"] = openConfigForm;
	formObj["isAddRecordReq"] = isAddRecordReq;
	formObj["isModifyRecordReq"] = isModifyRecordReq;
	formObj["cancelRulesValidCallBack"] = cancelRulesValidCallBack;
	formObj["checkWindowLocation"] = checkWindowLocation;
	formObj["addFormCloseListener"] = addFormCloseListener;
	formObj["previewAppStudioInputForm"] = previewAppStudioInputForm;
	formObj["isPreviewInputForm"] = isPreviewInputForm;
	formObj["hideTargetFullPageForm"] = hideTargetFullPageForm;
	formObj["getDoNotStartWorkflow"] = getDoNotStartWorkflow;
	formObj["updateAppStudioUrlParams"] = updateAppStudioUrlParams;
	formObj["openDataImportPage"] = openDataImportPage;
	formObj["getWorkflowParams"] = getWorkflowParams;
	formObj["postFormRendering"] = postFormRendering;
	formObj["getLocalizedText"] = getLocalizedText;
	formObj["populateLocalizedStringMap"] = populateLocalizedStringMap;

return formObj;

})(Forms || {});

var isV1Form = function(){
	return Forms.getUrlParams().v1 == true;
}

var openDataImportPage = function(wfJsonObj){
	return Forms.openDataImportPage(wfJsonObj);
}

var openTableForm = function(wfJsonObj){
	return Forms.openTableForm(wfJsonObj);
}

var openForm = function(wfJsonObj){
	return Forms.openForm(wfJsonObj);
}

var deleteAppTableRow = function(wfJsonObj){
	Forms.deleteAppTableRow(wfJsonObj);
}


var showErrorMessages = function(errors){
	FormOps.showErrorMessages(errors);
};