var inputForm;

function isIE() {
	  var userAgent = navigator.userAgent;
	  return userAgent.indexOf("MSIE ") > -1 || userAgent.indexOf("Trident/") > -1 || userAgent.indexOf("Edge/") > -1;
}

var parentWindow = parent;
var wfUtils = undefined;

if(isIE()){
	parentWindow = window.top;
	wfUtils = window.top.wfUtils;
	var parent = $.extend({},window.top.Forms,parentWindow);
	parent.wfUtils = wfUtils;
	parent.urlParams = parent.getUrlParams();
	parent.currentResp = parent.getCurrentResp();
	parent.selectedTab = parent.getSelectedTab();
	parent.userInteractionResp = parent.getUserInteractionResp();
}
else
{
	wfUtils = parent.wfUtils;
var parent = $.extend({},parent.Forms,parentWindow);
parent.wfUtils = wfUtils;
parent.urlParams = parent.getUrlParams();
parent.currentResp = parent.getCurrentResp();
parent.selectedTab = parent.getSelectedTab();
parent.userInteractionResp = parent.getUserInteractionResp();
}

parent.clearInfoResponseParams = function() {
	var interactionParams = $.extend(true, {}, parent.currentResp);
	interactionParams.response.message = "";
	interactionParams.title = "";
	interactionParams.html = "";
	interactionParams.response.properties = "";
	return interactionParams;
}

parent.clearUserInteractionParams = function() {
	var interactionParams = $.extend(true, {}, parent.userInteractionResp);
	interactionParams = interactionParams.request;
	interactionParams.inputForm = "";
	interactionParams.description = "";
	interactionParams.title = "";
	interactionParams.completedForm = "";
	return interactionParams;
}

parent.clearPopUpResponseParams = function() {
	var interactionParam = $.extend(true, {}, parent.currentResp);
	interactionParam.response.subject = "";
	interactionParam.response.description = "";
	interactionParam.response.inputForm = "";
	return interactionParam;
}

var workflowResp = {
	respMsg : '',
	errorCode : undefined,
	respType : ''
};
var TEXTBOX = "TEXTBOX";
var MULTILINE = "MULTILINE";
var DROPDOWN = "DROPDOWN";
var LISTBOX = "LISTBOX";
var RADIO = "RADIOBUTTON";
var CHECKBOX = "CHECKBOX";
var RADIOBUTTON = "RADIOBUTTON";
var PWD_TEXT_FIELD = "PWD_TEXT_FIELD";
var CALENDAR = "CALENDAR";
var DATE_TIME = "DATETIME_PICKER";
var TIME_PICKER = "TIME_PICKER";
var FILE_PICKER = "FILE_PICKER";
var ACTION_BUTTON_CONTROL = "ACTION_BUTTON_CONTROL";
var SEARCHABLEDROPDOWN = "SEARCHABLEDROPDOWN";
var SEARCHABLE_TEMPLATE = "SEARCHABLE_TEMPLATE";
var SELECTED_FILEROW_TEMPLATE = "SELECTED_FILEROW_TEMPLATE";
var APP_NAMESPACE = "formsApp";
var scriptMetaInfo = {
	cssInfo : {
		startTag : "<style>",
		endTag : "</style>"
	},
	javaScriptInfo : {
		startTag : "<script>",
		endTag : "</script>"
	}
};
var templateClass = {
	TEXTBOX : 'textbox ul',
	ENTITYTEXTBOX : 'textboxforcomplexentity ul',
	MULTILINE : 'multiline ul',
	RADIOBUTTON : 'radioButton',
	CHECKBOX : 'checkboxClass',
	PWD_TEXT_FIELD : 'textboxforpwd ul',
	HEADER : 'headerClass ul',
	DROPDOWN : 'selectClass select',
	CALENDAR : 'dateTimeControl ul',
	FILE_PICKER : 'filePicker ul',
	SEARCHABLEDROPDOWN : 'searchableDropdown ul',
	ACTION_BUTTON_CONTROL : 'buttonControl',
	SEARCHABLE_TEMPLATE : 'searchableTemplate',
	SELECTED_FILEROW_TEMPLATE : 'selectedFileRow',
	LISTBOX : 'listBoxControl'
};
var timeMap = {};
var term = "";
var fieldVals = [];
var dialogType = {
	POPUP_DIALOGTYPE : "Popup"
};
var modalOrigHt;
//var currentTop = 0;

var DATE_REGEX = /^(0[1-9]|1[0-2])\/(0[1-9]|1\d|2\d|3[01])\/(19|20)\d{2}/;
var TIME_REGEX = /^(0?[0-9]|1[0-9]|2[0-3]):(0?[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9]):(0?[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9])/;
var uploadFileList = [];
var destPath = "";
var interactionId;
var workflowId;
var workflowName;
var controlAlignment = {
	HORIZONTAL : "HORIZONTAL",
	VERTICAL : "VERTICAL"
};

var FORM_WIDTH = 465;
var FORM_HEIGHT = 305;
var FORM_MIN_HEIGHT = 150;
var FORM_MIN_WIDTH = 150;
var DESCRIPTION_HEIGHT = 95;
var PADDING_FOR_SMALLFORM = 100;
var PADDING_FOR_LARGEFORM = 50;
var wfInputEntryFileUploadMap = {};
var wfStagedFileInputs = [];
var inputFormValidated = false;
var formsSystemParams = {};
var curWfMetaInfo = {};

//var TIME_REGEX=/^(0?[0-9]|1[0-9]|2[0-3]):(0?[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9]):(0?[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9])\s(A[M]|P[M])/;
//regular expression for validating the date  in mm/dd/yyyy
//regular expression for validating the time  in hh:mm:ss AM|PM
function initFormsSysParamters() {
	formsSystemParams.userId = $("#curUserId").val();
	formsSystemParams.userName = $("#curUserName").val();
}

function getData() {
	return workflowResp;
}

function widthAdjuster() {
	var namecount = $("#inputcontainer .li1 .name").size(), listcount = $("#inputcontainer .li1").size(), namewidth = [], listwidth = [];
	for (var i = 0; i < namecount; i++) {
		namewidth.push($("#inputcontainer .li1").eq(i).outerWidth(true));
		listwidth.push($("#inputcontainer .li1 .name").eq(i).outerWidth(true));
	}
	var maxnamewidth = Math.max.apply(Math, listwidth);
	var secwidth = $("#inputcontainer .secrows").width();

	if (maxnamewidth > secwidth / 2) {
		maxnamewidth = secwidth / 2 - 30;
	}

	var minwidth = maxnamewidth + 25;
	//var li2width = secwidth - minwidth - 10;

	for (var j = 0; j < listcount; j++) {
		$("#inputcontainer .li1").eq(j).width(minwidth + "px");
	}

	var li2width1 = secwidth - $("#inputcontainer .li1").width() - 10;

	for (var j = 0; j < listcount; j++) {
		$("#inputcontainer .li2").eq(j).width(li2width1 + "px");
		if ($("#inputcontainer .li2").eq(j).html() == "") {
			$("#inputcontainer .li2").eq(j).css("width", "0%");
			$("#inputcontainer .li1").eq(j).css("width", "100%");
			$("#inputcontainer .li1").eq(j).css("max-width", "100%");
		}
	}
	var topheight = $(".top").height();

	var middleheight = $("#content").outerHeight(true) - 50 - 90 - $(".bottom").outerHeight(true) + 50 -
			$(".viewport").height() + "px";

	middleheight = parseInt(middleheight) < 50 ? 50 : parseInt(middleheight) + "px";
	$("#scrollbar1 .viewport").height(middleheight);
	$("#scrollbar2 .viewport").height(topheight + 5 + "px");
	$(".ui-multiselect").css("width", li2width1 + 5 + "px");
	//$(".ui-multiselect").css("width","100%");
	/* $(".ui-multiselect-menu").css("width",$(".ui-multiselect").width()+"px"); */
	$(".ui-multiselect-checkboxes").css("height", "auto");
	$(".ui-multiselect-checkboxes").css("max-height", "100px");
	$(".ui-multiselect-menu div.ui-widget-header div.ui-multiselect-filter input").width($(".ui-multiselect-menu")
			.width() - 60);
	//$(".ui-multiselect-menu div.ui-widget-header div.ui-multiselect-filter input").width($(".ui-multiselect-menu").width()-50);
	$(".ui-autocomplete").width(li2width1);
	$(".ui-multiselect-menu").css("width", $(".ui-multiselect").width() - 2 + "px");

	/* Date Time Picker Widths added expictly */
	$("#inputcontainer .hasDatepicker").width((li2width1 - 25) / 2 - 2);
	$("#inputcontainer .hasTimepicker").width((li2width1 - 25) / 2 + 9);
}

function textAreaResizeHandler() {
	var $textareas = jQuery('textarea');
	$textareas.mouseup(function() {
		updateScroll();
		widthAdjuster();
	});
}

function updateScroll() {

	var scroll1 = $('#scrollbar1').data("plugin_tinyscrollbar");
	if (scroll1 != undefined) {
		scroll1.update('relative');
	}

	var scroll2 = $('#scrollbar2').data("plugin_tinyscrollbar");
	if (scroll2 != undefined) {
		scroll2.update('relative');
	}

	widthAdjuster();

	var p = $(".ui-autocomplete-input");
	var position = p.position();
	if (position != null) {
		$(".ui-autocomplete").css("left", position.left + "px");
	}

	//Check if the middle part is empty, if yes increase the max height of description since
	//there will be more space
	var maxHLimit = (!$('.middle').find('#inputcontainer .secrows').length) ? 235 : 95;
	$("#scrollbar2 .viewport").css('max-height', maxHLimit + "px");

	if ($(".description").height() <= $("#scrollbar2 .viewport").height()) {
		$("#scrollbar2 .scrollbar").hide();
	} else {
		$("#scrollbar2 .scrollbar").show();
	}
}

function addInputEntryRow(currentInput, containerId, isParentRow) {
	var inputJSON = {};
	/*
	 * if(currentInput.hidden!=undefined && !currentInput.hidden) {
	 */
	currentInput.documentation = currentInput.documentation != undefined ? currentInput.documentation.replace(/\"/g,
			"&quot;") : "";
	var alignemt = currentInput.alignment;
	var inputEntryHtml = '<ul id="' + currentInput.inputName +
			'LabelHeaderArea" style="display: block;" class="secrows oddRow ';
	if (alignemt != undefined && alignemt == controlAlignment.VERTICAL) {
		inputEntryHtml += 'widerow';
	}
	inputEntryHtml += '" title="' + currentInput.documentation + '">';

	inputJSON["displayName"] = getDisplayName(currentInput);
	inputJSON["inputName"] = currentInput.inputName;

	if (isParentRow) {
		inputJSON["PARENTAREA"] = true;
		inputJSON["minus"] = "minus";
		inputEntryHtml += getHtml(inputJSON, templateClass["HEADER"]);
		inputEntryHtml += '<li class="li2"></li>';
		$("#" + containerId).append(inputEntryHtml);
		addToolTip(currentInput);
		resizeForm();
	} else {
		if (currentInput.inputType == "java.lang.Boolean") {
			inputJSON["BOOLEANAREA"] = true;
			if (currentInput.defaultValue != undefined && currentInput.defaultValue != "true") {
				currentInput.defaultValue = "";
			}
			inputJSON["defaultValue"] = currentInput.defaultValue;

			assignDisableInputMeta(inputJSON, currentInput);
		}

		if (currentInput.required) {
			inputJSON["REQUIRED"] = true;
		}
		inputEntryHtml += getHtml(inputJSON, templateClass["HEADER"]);
		addControl(containerId, inputEntryHtml, currentInput);
		//}
	}
}

function assignDisableInputMeta(inputJSON, currentInput) {
	if (currentInput.readOnly) {
		inputJSON["readOnly"] = "disablecontrol";
		inputJSON["disabledAttr"] = true;
		inputJSON["readonly"] = "disabled";
	} else {
		inputJSON["readonly"] = "";
	}
}

function addListenerForAutoComplete() {

	$("#inputcontainer .grabber").off("click." + APP_NAMESPACE);
	$("#inputcontainer .grabber").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var selectedAuto = $(this).attr("id") + "_autocomplete";
		$('.ui-autocomplete').each(function() {
			if ($(this).parent().attr("id") != selectedAuto) {
				$(this).hide();
			}
		});
		resizeForm();
	});

	/*
	 * $("#inputcontainer .grabber").on("focus",function (e) { e.preventDefault(); resizeForm(); });
	 */

	$("#inputcontainer .searchableArea").off("click." + APP_NAMESPACE);
	$("#inputcontainer .searchableArea").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		showSearchableResults($(this).attr("data-info"), false);
	});

	$("#inputcontainer .searchable").off("click." + APP_NAMESPACE);
	$("#inputcontainer .searchable").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		showSearchableResults($(this).attr("data-info"), false);
	});

	$("#inputcontainer .drop").off("click." + APP_NAMESPACE);
	$("#inputcontainer .drop").on("click." + APP_NAMESPACE, function(e) {
		var selectedAuto = $(this).siblings(".li2").children();
		$('.ui-autocomplete').each(function() {
			if ($(this).is(":visible") == true) {
				$(this).scrollTop(0);
				$(this).hide();
			} else {
				if ($(this).parent().attr("id") == selectedAuto.attr("id") + "_autocomplete") {
					if (selectedAuto.attr("readonly") == "readonly") {
						selectedAuto.autocomplete("search", "");
					} else {
						selectedAuto.autocomplete("search");
					}
				}
			}
		});
		resizeForm();
	});
}

function isComplexEntity(currentInputType) {
	if (currentInputType == "commvault.msgs.CvEntities.ClientEntity" ||
			currentInputType == "commvault.msgs.CvEntities.ClientGroupEntity" ||
			currentInputType == "commvault.msgs.CvEntities.StoragePolicyEntity" ||
			currentInputType == "commvault.msgs.CvEntities.UserEntity" ||
			currentInputType == "commvault.msgs.CvEntities.UserGroupEntity" ||
			currentInputType == "commvault.msgs.CvEntities.MediaAgentEntity" ||
			currentInputType == "commvault.msgs.CvEntities.CommCellEntity" ||
			currentInputType == "commvault.msgs.CvEntities.SchedulePolicyEntity" ||
			currentInputType == "commvault.msgs.CvEntities.WorkflowEntity"
	) {
		return true;
	}
	return false;
}

function resizeForm() {
	$('#scrollbar1').tinyscrollbar();
	$('#scrollbar2').tinyscrollbar();
	updateScroll();
	//widthAdjuster();
	$(".textarea").parent().css("height", "auto");
}

function highlightItems() {

	var escapeList = [ {
		"object" : new RegExp("\\(", "gi"),
		"value" : "\\("
	}, {
		"object" : new RegExp("\\)", "gi"),
		"value" : "\\)"
	}, {
		"object" : new RegExp("\\[", "gi"),
		"value" : "\\["
	}, {
		"object" : new RegExp("\\]", "gi"),
		"value" : "\\]"
	}, {
		"object" : new RegExp("\\{", "gi"),
		"value" : "\\{"
	}, {
		"object" : new RegExp("\\}", "gi"),
		"value" : "\\}"
	} ];

	var searchTerm = "";

	$.ui.autocomplete.prototype._renderMenu = function(ul, items) {
		var currItem = this;
		$.each(items, function(index, item) {
			currItem._renderItem(ul, item);
		});
	};
	$.ui.autocomplete.prototype._renderItem = function(ul, item) {

		if (term != this.term) {
			term = this.term;
			isProcessed = true;
			searchTerm = this.term;
			$(escapeList).each(function(index) {
				searchTerm = searchTerm.replace(this.object, this.value);
			});
		}

		/*
		 * var re = new RegExp("^" + searchTerm + "$","gi") ; var highlightedItem = item.label; var
		 * caseInsensitiveLabel = highlightedItem.toLowerCase(); if(searchTerm!=""){ highlightedItem =
		 * caseInsensitiveLabel.replace(re,'<span class="highlight">' + /*"$&" +
		 *///item.label +
		//}*/
		var re = new RegExp("^" + searchTerm, "ig");
		var highlightedItem = item.label.replace(re, '<span class="highlight">' + "$&" + "</span>");
		return $("<li></li>").data("item.autocomplete", item).append("<a>" + highlightedItem + "</a>").appendTo(ul);
	};
}
function addDateTimeListeners(currentInput, addDate, addTime) {
	var defaultDate = "";

	if (currentInput.defaultValue != undefined && currentInput.defaultValue != "") {
		defaultDate = new Date(parseInt(currentInput.defaultValue));
	} else if (currentInput.required) {
		defaultDate = new Date();
	}

	if (addDate) {
		$("#" + currentInput.inputName + "_date").datepicker({
			//maxDate: 0,
			showSecond : true,
			//changeYear:true,
			timeFormat : "hh:mm:ss",
			//yearRange:"2002:2012",
			//dateFormat: 'mm/dd/yy',
			beforeShow : function(input, inst) {
				//inst.dpDiv.css({top: input.offsetHeight + input.offsetTop + 'px', left: input.offsetLeft + 'px'});
				//console.log(input);
				$(inst.dpDiv).insertAfter("#" + currentInput.inputName + "_date");
				setTimeout(function() {
					inst.dpDiv.css({
						top : $(input).outerHeight() + $(input).position().top + 'px',
						left : $(input).position().left + 'px'
					});
					updateScroll();
				}, 100);
			},
			onClose : function(dateText, inst) {
				/*
				 * if ($("#" + currentInput.inputName).val() != '' && $("#" +
				 * currentInput.inputName).val()!="Choose Time") { var testStartDate = $("#" +
				 * currentInput.inputName).datetimepicker('getDate'); parent.alert(testStartDate); }
				 */
				setTimeout(function() {
					updateScroll();
				}, 300);

			},
			onSelect : function(selectedDateTime) {
				//endDateTextBox.datetimepicker('option', 'minDate', startDateTextBox.datetimepicker('getDate') );

				updateScroll();
			}
		});
		$("#" + currentInput.inputName + "_date").datepicker('setDate', defaultDate);
	}

	if (addTime) {
		/*
		 * if(defaultDate!="" && defaultDate.getHours() == 0) { defaultDate = "12:" + defaultDate.getMinutes() +
		 * ":" + defaultDate.getSeconds() + "AM"; }
		 */

		$("#" + currentInput.inputName + "_time").timepicker({
			template : false,
			showInputs : false,
			minuteStep : 1,
			showSeconds : true,
			showMeridian : false,
			secondStep : 1
		}).on('changeTime.timepicker', function(e) {
			timeMap[currentInput.inputName] = e.time;

			var curTime = timeMap[currentInput.inputName];
			console.log(curTime.hours + ":" + curTime.minutes + ":" + curTime.seconds + " " + curTime.meridian);
			/*
			 * console.log('The time is ' + e.time.value); console.log('The hour is ' + e.time.hour);
			 * console.log('The minute is ' + e.time.minute); console.log('The meridian is ' +
			 * e.time.meridian);
			 */
		});

		$("#" + currentInput.inputName + "_time").timepicker('setTime', defaultDate);
	}
}

function initializeControlWithDefaultValues(currentInput) {

	if (currentInput.controlType == RADIO || currentInput.controlType == CHECKBOX ||
			currentInput.controlType == LISTBOX) {
		var defaultValues = [];
		if ((currentInput.inputType == "java.lang.Boolean" || !currentInput.listType) &&
				currentInput.defaultValue != "") {
			defaultValues.push(currentInput.defaultValue);
		} else {
			defaultValues = currentInput.defaultValues;
		}

		if (currentInput.controlType == LISTBOX) {
			$(defaultValues).each(function() {
				var inputInfo = getFormattedDateTimeFromEpoch(currentInput, this);
				$("#" + currentInput.inputName + "Area").find("[data-val='" + inputInfo["actualValue"] + "']")
						.addClass("active");
			});
		} else {
			$(defaultValues).each(function() {
				var inputInfo = getFormattedDateTimeFromEpoch(currentInput, this);
				if (currentInput.type == "{http://www.w3.org/2001/XMLSchema}date" ||
						currentInput.type == "{http://www.w3.org/2001/XMLSchema}datetime" ||
						currentInput.type == "{http://www.w3.org/2001/XMLSchema}time") {
					$("#" + currentInput.inputName + "Area label").each(function() {
						if (inputInfo["formattedStr"] == $(this).text()) {
							$(this).children().attr("checked", true);
						}
					});
				} else {
					$("#" + currentInput.inputName + "Area").find("[value='" + inputInfo["actualValue"] + "']")
							.attr("checked", true);
				}
			});
		}
	} else if (currentInput.controlType == DROPDOWN && currentInput.searchable) {
		displaySelectedValsForSearchableType(currentInput.inputName);
	} else if (currentInput.controlType == FILE_PICKER) {
		var isWizardActivity = false;
		if (!$.isEmptyObject(parent.currentResp) && !$.isEmptyObject(parent.currentResp.response)) {
			isWizardActivity = parent.currentResp.response.isWizardActivity;
			isWizardActivity = !($.isEmptyObject(isWizardActivity)) ? isWizardActivity : false;
		}

		var inputName = currentInput.inputName;
		if (isWizardActivity) {
			var inputFieldFiles = [];

			if (wfInputEntryFileUploadMap != undefined && wfInputEntryFileUploadMap[inputName] != undefined) {
				var selectedFileMap = wfInputEntryFileUploadMap[inputName];
				if (!$.isEmptyObject(selectedFileMap)) {
					jQuery.each(selectedFileMap, function(key, value) {
						inputFieldFiles.push(value);
					});
					wfInputEntryFileUploadMap[inputName] = {}; //Clearing this as these files will be added in the map in showCurrentInputFiles method
					var desiredInputId = "#" + inputName + "DragArea";
					var selectedFilesArea = "#" + inputName + "selectedFilesArea";
					var $fileNum = $(selectedFilesArea).find(".upload-num-files");
					var displayName = $(desiredInputId).attr("data-displayName");

					var inputObj = {};
					inputObj.isMultiple = $(desiredInputId).attr("data-multiple");
					inputObj.fileCount = inputFieldFiles.length;
					inputObj.inputName = inputName;
					inputObj.fileNum = $fileNum;
					inputObj.displayName = displayName;
					inputObj.selectedFilesArea = selectedFilesArea;

					if (!initializeCurInputFileControlState(inputObj)) {
						return;
					}
					showCurrentInputFiles($("#" + inputName + "selectedFilesArea .upload-list"),
							inputName,
							inputFieldFiles);
				}
			}
		} else {
			wfInputEntryFileUploadMap[inputName] = {};
		}
	}
}

function showError(errorMsg) {
	//resizeErrorArea();
	$(".error").show();
	$(".error").html(errorMsg);
	$(".error").attr("title", errorMsg);
}

function resizeErrorArea() {
	if ($(".fullAlign .okSaveButton").length > 1) {
		$(".error").css("width", "40%");
	} else {
		$(".error").css("width", "auto");
	}
}

function addAppropriateListener(currentInput) {
	if (currentInput.controlType == DROPDOWN && !isComplexEntity(currentInput.inputType)) {
		$("#" + currentInput.inputName).attr("readonly", "readonly");
		$("#" + currentInput.inputName).parent(".li2").addClass("posRelative");
	}

	if (currentInput.controlType == LISTBOX) {
		$(".listBoxOption").off("click." + APP_NAMESPACE);
		$(".listBoxOption").on("click." + APP_NAMESPACE, function(e) {
			e.preventDefault();
			var $selectedOption = $(this);
			var $listBoxArea = $selectedOption.parents(".listBoxArea");
			var isListType = $listBoxArea.attr("data-multiple") == "false" ? false : true;
			if (isListType) {
				$selectedOption.toggleClass("active");
			} else {
				$listBoxArea.find(".listBoxOption").each(function() {
					if ($(this).attr("id") == $selectedOption.attr("id")) {
						$selectedOption.toggleClass("active");
					} else {
						$(this).removeClass("active");
					}
				});
			}
		});
	} else if (currentInput.controlType == CHECKBOX && !currentInput.listType) {
		$('input[name=' + currentInput.inputName + ']').off("change." + APP_NAMESPACE); // remove old listener - this can get called more than once due to table reinitialization
		$('input[name=' + currentInput.inputName + ']').on("change." + APP_NAMESPACE, function(event) {
			var selectedCheckbox = $(this);
			if (selectedCheckbox.prop('checked')) {
				$('input[name=' + currentInput.inputName + ']').attr("checked", false);
				selectedCheckbox.attr("checked", true);
			}
		});
	} else if (currentInput.controlType == TEXTBOX || currentInput.controlType == DROPDOWN) {
		if ((currentInput.options != undefined && currentInput.options.length > 0) ||
				(currentInput.defaultValues != undefined && currentInput.defaultValues.length > 0)) {
			/*
			 * var complexEntity = isComplexEntity(currentInput.inputType);
			 * if((currentInput.listType!=undefined && currentInput.listType) || complexEntity)
			 */
			$("#" + currentInput.inputName).parent(".li2").addClass("posRelative");
			if (currentInput.listType != undefined && currentInput.listType && !currentInput.searchable &&
					currentInput.controlType == DROPDOWN) {
				$("#" + currentInput.inputName).multiselect({
					height : 100,
					selectedList : 1,
					header: true,
					//multiple : (currentInput.listType!=undefined && currentInput.listType)?true:complexEntity?false:true,
					//noneSelectedText:currentInput.listType!=undefined && currentInput.listType?"Select Options":"Select Option",
					open : function(event, ui) {
						$(".ui-multiselect-checkboxes li:not(.ui-multiselect-optgroup-label)").show();
						resizeForm();
					},
					close : function(event, ui) {
						//$(".ui-autocomplete").scrollTop(0);
					}
				}).multiselectfilter({
					filter : function(event, matches) {
						$(matches).each(function() {
							if (this.attributes["value"].value.toUpperCase().indexOf(event.currentTarget.value
									.toUpperCase()) != 0) {
								$(this).parents("li").hide();
							}
						});
					},
				});

				//$("#" + currentInput.inputName).multiselect("widget").find(":checkbox").eq(0).attr("checked",false)
			} else if (!currentInput.readOnly) {
				var autoList = [];
				var list = currentInput.options;
				//timeMap[currentInput.inputName] = "";

				$(list).each(function(index) {
					var currentOption = getFormattedDateTimeFromEpoch(currentInput, this);
					autoList.push({
						currentId : $.trim(currentOption["actualValue"]),
						label : currentOption["formattedStr"]
					});
				});

				$("#" + currentInput.inputName).autocomplete({
					source : function(request, response) {
						var matches = $.map(autoList, function(tag) {
							if (tag.label.toUpperCase().indexOf(request.term.toUpperCase()) === 0) {
								return tag;
							}
						});
						response(matches);
					},
					minLength : 0,
					appendTo : '#' + currentInput.inputName + '_autocomplete',
					select : function(event, ui) {
						timeMap[currentInput.inputName] = ui.item.currentId;
						resizeForm();
					},
					open : function(event, ui) {
						$(".ui-autocomplete").width($("#inputcontainer .grabber").outerWidth(false) - 5);
						if (!isComplexEntity(currentInput.inputType)) {
							var desiredPos = $(".highlight");
							if (desiredPos.length != 0) {
								$(".ui-autocomplete").scrollTop(desiredPos.position().top);
								//currentTop = desiredPos.position().top - currentTop;
								/*
								 * var pos = desiredPos.position().top; if(pos < 0) { pos = -pos; }
								 * console.log(desiredPos.length + " " + desiredPos.position().top);
								 * $(".ui-autocomplete").scrollTop(desiredPos.position().top);
								 */
							}
						}
						//}
						resizeForm();
					},
					close : function(event, ui) {
						$(".ui-autocomplete").scrollTop(0);
					}
				}).focus(function() {
					if (!$(this).prop("readonly")) {
						/*
						 * highlightItems(); $(".ui-autocomplete").scrollTop(0);
						 */
						$(this).autocomplete("search");
					}
					return false;
				});
				if (!isComplexEntity(currentInput.inputType)) {
					highlightItems();
				}
				addListenerForAutoComplete(currentInput);
			}
		}
	} else if (currentInput.controlType == DATE_TIME) {
		addDateTimeListeners(currentInput, true, true);
	} else if (currentInput.controlType == CALENDAR) {
		addDateTimeListeners(currentInput, true, false);
	} else if (currentInput.controlType == TIME_PICKER) {
		addDateTimeListeners(currentInput, false, true);
	} else if (currentInput.controlType == FILE_PICKER) {
		addFileListeners(currentInput.inputName);
	}
}

function getAutoCompleteTemplate(currentInput) {
	var inputEntryHtml = '';
	var inputJSON = {};
	var inputInfo = {};

	inputInfo = getFormattedDateTimeFromEpoch(currentInput, currentInput.defaultValue);

	inputJSON["inputName"] = currentInput.inputName;
	inputJSON["defaultValue"] = inputInfo["formattedStr"];
	timeMap[currentInput.inputName] = inputInfo["actualValue"];

	assignDisableInputMeta(inputJSON, currentInput);

	/*
	 * if((currentInput.listType!=undefined && currentInput.listType) ||
	 * isComplexEntity(currentInput.inputType))
	 */
	if (currentInput.listType != undefined && currentInput.listType && !currentInput.searchable) {
		inputEntryHtml = '<li class="li2"><select id="' + currentInput.inputName + '" name="' + currentInput.inputName +
				'" class="grabber" multiple="multiple">';

		var defaultValues = currentInput.defaultValues;
		var optionsList = [];

		if (currentInput.options != undefined && currentInput.options.length) {
			optionsList = currentInput.options;
		} else if (defaultValues != undefined && defaultValues.length > 0) {
			optionsList = defaultValues;
		}

		for (var index = 0; index < optionsList.length; index++) {
			inputInfo = {};
			inputInfo = getFormattedDateTimeFromEpoch(currentInput, optionsList[index]);
			inputJSON["selectedAttr"] = false;
			inputJSON["actualValue"] = inputInfo["actualValue"];
			inputJSON["inputValue"] = inputInfo["formattedStr"];
			if (defaultValues != undefined && defaultValues.indexOf(optionsList[index]) != -1) {
				inputJSON["selectedAttr"] = true;
			}
			inputEntryHtml += getHtml(inputJSON, templateClass[DROPDOWN]);
		}
		inputEntryHtml += "</select></li>";
	} else {
		inputEntryHtml += getHtml(inputJSON, templateClass["ENTITYTEXTBOX"]);

		if (currentInput.controlType == DROPDOWN) {
			if (currentInput.searchable) {
				parent.window.searchableEntryMap[currentInput.inputName] = $.extend(true, {}, currentInput);
				parent.window.searchableEntryMap[currentInput.inputName]["selectedList"] = [];
				var noOfDefaultVals = currentInput.defaultValues != undefined &&
						currentInput.defaultValues.join() != "" ? currentInput.defaultValues.length : 0;
				if (noOfDefaultVals > 0) {
					parent.window.searchableEntryMap[currentInput.inputName]["selectedList"] = $.extend([],
							currentInput.defaultValues);
				}

				parent.window.searchableEntryMap[currentInput.inputName]["unSelectedList"] = [];
				var alignemt = currentInput.alignment;
				if (alignemt != undefined && alignemt == controlAlignment.VERTICAL) {
					inputJSON["searchableWideRow"] = 'searchableWideRowli2';
				}
				inputEntryHtml = getHtml(inputJSON, templateClass[SEARCHABLEDROPDOWN]);
				inputEntryHtml += '<div class="dropDown searchable ' +
						(currentInput.readOnly ? inputJSON.readOnly : '') + '" data-info="' + currentInput.inputName +
						'"></div>';
			} else {
				inputEntryHtml += getHtml(inputJSON, "dropdown");
			}
		}

		/*
		 * if(!currentInput.searchable && !currentInput.readOnly) { inputEntryHtml +=
		 * getHtml(inputJSON,"autoarea"); }
		 */
	}
	return inputEntryHtml;
}

function getHtml(input, template) {
	var templateHTML = $('.' + template).html();
	var html = Mustache.to_html(templateHTML, input);
	if (input["doNotTrimSpaces"] == undefined) {
		html = html.replace(/^\s*/mg, '');
	}
	html = $.trim(html);
	html = html.replace(/\n/g, '');
	return html;
}

function getFormattedTime(dateObj) {
	var hour = dateObj.getHours();
	/*
	 * if(hour>12){ hour = hour - 12; fmt = "PM"; } else if(hour == 12){ fmt = "PM"; } else if(hour == 0){
	 * hour = hour + 12; }
	 */

	return hour + ":" + dateObj.getMinutes() + ":" + dateObj.getSeconds()/* + " " + fmt */;
}

function getFormattedDateTimeFromEpoch(currentInput, currentOption) {
	var inputInfo = {};
	var formattedStr = "";
	var actualValue = "";

	if (currentOption != undefined && currentOption != "") {
		formattedStr = $.trim(currentOption);
		actualValue = $.trim(currentOption);
		var dateObj = new Date(parseInt(currentOption));

		if (currentInput.type == "{http://www.w3.org/2001/XMLSchema}dateTime") {
			actualValue = parseInt(currentOption);
			formattedStr = $.datepicker.formatDate('yy-mm-dd', dateObj);
			formattedStr += getFormattedTime(dateObj);
			actualValue = Math.round(actualValue / 1000);
		} else if (currentInput.type == "{http://www.w3.org/2001/XMLSchema}date") {
			actualValue = parseInt(currentOption);
			actualValue = Math.round(actualValue / 1000);
			formattedStr = $.datepicker.formatDate('yy-mm-dd', dateObj);
		} else if (currentInput.type == "{http://www.w3.org/2001/XMLSchema}time") {
			actualValue = parseInt(currentOption);
			actualValue = Math.round(actualValue / 1000);
			formattedStr = getFormattedTime(dateObj);
		}
	}
	inputInfo["formattedStr"] = formattedStr;
	inputInfo["actualValue"] = actualValue;
	return inputInfo;
}

function getHtmlWithUpdatedDefaultValues(inputJSON, currentInput, templateType) {

	var inputEntryHtml = "";
	if (currentInput.options != undefined && currentInput.options.length > 0) {
		$(currentInput.options).each(function(index) {
			var inputInfo = getFormattedDateTimeFromEpoch(currentInput, this);
			inputJSON["actualValue"] = inputInfo["actualValue"];
			inputJSON["defaultValue"] = inputInfo["formattedStr"];
			inputJSON["position"] = index;
			inputEntryHtml += getHtml(inputJSON, templateClass[templateType]);
		});
	} else {
		$(currentInput.defaultValues).each(function() {
			var inputInfo = getFormattedDateTimeFromEpoch(currentInput, this);
			inputJSON["actualValue"] = inputInfo["actualValue"];
			inputJSON["defaultValue"] = inputInfo["formattedStr"];
			inputEntryHtml += getHtml(inputJSON, templateClass[templateType]);
		});
	}
	return inputEntryHtml;
}

function addAppropriateTemplate(containerId, inputEntryHtml, currentInput, controlType) {
	var inputJSON = {};

	inputJSON["inputName"] = currentInput.inputName;
	inputJSON["defaultValue"] = currentInput.defaultValue;

	assignDisableInputMeta(inputJSON, currentInput);

	if (currentInput.controlType == TEXTBOX) {
		if (isComplexEntity(currentInput.inputType)) {
			inputEntryHtml += getAutoCompleteTemplate(currentInput);
		} else if (currentInput.inputType == "workflow.types.EncryptedString") {
			inputEntryHtml += getHtml(inputJSON, templateClass[PWD_TEXT_FIELD]);
		} else {
			inputEntryHtml += getHtml(inputJSON, templateClass[TEXTBOX]);
		}
	} else if (currentInput.controlType == MULTILINE) {
		inputJSON["doNotTrimSpaces"] = true;
		inputEntryHtml += getHtml(inputJSON, templateClass[MULTILINE]);
	} else if (currentInput.controlType == DROPDOWN) {
		inputEntryHtml += getAutoCompleteTemplate(currentInput);
	} else if (currentInput.controlType == LISTBOX) {
		if (currentInput.listType) {
			inputJSON["multiple"] = true;
		} else {
			inputJSON["multiple"] = false;
		}
		inputEntryHtml += '<li class="li2">';
		inputEntryHtml += '<div id="' + currentInput.inputName + 'Area" class="listBoxArea ' + inputJSON["readOnly"] +
				'" data-multiple="' + inputJSON["multiple"] + '">';
		inputEntryHtml += getHtmlWithUpdatedDefaultValues(inputJSON, currentInput, LISTBOX);
		inputEntryHtml += '</div>';
		inputEntryHtml += '</li>';
	} else if (currentInput.controlType == RADIO) {
		inputEntryHtml += '<li class="li2">';
		inputEntryHtml += '<div id="' + currentInput.inputName + 'Area">';
		inputEntryHtml += getHtmlWithUpdatedDefaultValues(inputJSON, currentInput, RADIO);
		inputEntryHtml += '</div>';
		inputEntryHtml += '</li>';
	} else if (currentInput.controlType == CHECKBOX) {
		inputEntryHtml += '<li class="li2"';
		if (currentInput.inputType == "java.lang.Boolean") {
			inputEntryHtml += ' data-boolean="true">';
			inputJSON["BOOLEAN"] = true;
			inputEntryHtml += getHtml(inputJSON, templateClass[CHECKBOX]);
		} else {
			inputEntryHtml += '><div id="' + currentInput.inputName + 'Area">';
			inputEntryHtml += getHtmlWithUpdatedDefaultValues(inputJSON, currentInput, CHECKBOX);
			inputEntryHtml += '</div>';
			inputEntryHtml += '</li>';
		}
	} else if (currentInput.controlType == CALENDAR) {
		inputJSON["hideTIME"] = "hideOnly";
		inputEntryHtml += getHtml(inputJSON, templateClass[CALENDAR]);
	} else if (currentInput.controlType == DATE_TIME) {
		inputEntryHtml += getHtml(inputJSON, templateClass[CALENDAR]);
	} else if (currentInput.controlType == TIME_PICKER) {
		inputJSON["hideDate"] = "hideOnly";
		inputEntryHtml += getHtml(inputJSON, templateClass[CALENDAR]);
	} else if (currentInput.controlType == FILE_PICKER) {
		//inputJSON["hideDate"] = "hideOnly";
		if (currentInput.listType) {
			inputJSON["multiple"] = true;
		} else {
			inputJSON["multiple"] = false;
		}

		inputJSON["displayName"] = getDisplayName(currentInput);
		inputEntryHtml += getHtml(inputJSON, templateClass[FILE_PICKER]);
	}

	$("#" + containerId).append(inputEntryHtml);
	initializeControlWithDefaultValues(currentInput);
	addToolTip(currentInput);
	resizeForm();
}

function addToolTip(currentInput, containerId) {
	var container = '#' + currentInput.inputName + 'LabelHeaderArea[title]';
	if (containerId != undefined) {
		container = containerId;
	}
	$(container).qtip({

		/*
		 * show: { effect: function() { $(this).fadeTo(150, 1); } }, hide: { effect: function() {
		 * $(this).slideUp(); } },
		 * 
		 * 
		 */
		position : {
			my : 'top left',
			at : 'bottom left',
			corner : true
		},
		style : {
			classes : 'qtip-rounded qtip-shadow qtip-cluetip'
		}
	});
}

function addControl(containerId, inputEntryHtml, currentInput) {
	if (currentInput.controlType != undefined && currentInput.controlType != "") {
		addAppropriateTemplate(containerId, inputEntryHtml, currentInput, currentInput.controlType);
	} else {
		if (currentInput.inputType == "java.lang.String" || currentInput.inputType == "java.lang.Integer" ||
				currentInput.inputType == "java.lang.Float" || currentInput.inputType == "java.lang.Double" ||
				currentInput.inputType == "java.lang.Short") {
			currentInput.controlType = TEXTBOX;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.inputType == MULTILINE) {
			currentInput.controlType = MULTILINE;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.inputType == "java.lang.Boolean") {
			currentInput.controlType = CHECKBOX;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.inputType == "workflow.types.EncryptedString") {
			currentInput.controlType = TEXTBOX;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.type == "java.util.Calendar") {
			currentInput.controlType = DATE_TIME;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.type == "java.util.Date") {
			currentInput.controlType = CALENDAR;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (currentInput.type == "workflow.types.Time") {
			currentInput.controlType = TIME_PICKER;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		} else if (isComplexEntity(currentInput.inputType)) {
			currentInput.controlType = DROPDOWN;
			addAppropriateTemplate(containerId, inputEntryHtml, currentInput);
		}
	}
}

function getDisplayName(inputEntry) {
	if (inputEntry.displayName != undefined && inputEntry.displayName != '') {
		return inputEntry.displayName;
	}
	return inputEntry.inputName;
}

function createAcionButtonRow(inputJSON, actionContainer) {
	var inputEntryHtml = "";
	inputEntryHtml += getHtml(inputJSON, templateClass[ACTION_BUTTON_CONTROL]);

	$("." + actionContainer).prepend(inputEntryHtml);
}

function createInputEntryRow(currentInput, containerId) {

	if(!currentInput.controlHidden){
		if (currentInput.children != undefined && currentInput.children.length > 0) {
			var inputEntryName = currentInput.inputName;
			if (inputForm[inputEntryName] != undefined) {
				addInputEntryRow(currentInput, containerId, false);
			} else {
				addInputEntryRow(currentInput, containerId, true);
	
				var childrens = currentInput.children;
				var childHeader = '<div id="' + currentInput.inputName + '_children" class="children"></div>';
	
				$("#" + containerId).append(childHeader);
				updateScroll();
				for (var childIndex = 0; childIndex < childrens.length; childIndex++) {
					var currentChildren = childrens[childIndex];
					if (currentInput.inputType == "workflow.types.Email" && currentChildren.inputName == "body") {
						currentChildren.inputType = MULTILINE;
					}
					createInputEntryRow(currentChildren, currentInput.inputName + '_children');
				}
			}
		} else {
			addInputEntryRow(currentInput, containerId, false);
		}
	}
}

function isCompletedForm(){
	return inputForm && inputForm.status === "COMPLETED";
}

function getInputActions(interactionId) {
	if (interactionId != "") {
		var isOpenAction = isCompletedForm()?false:true;
		if(!isOpenAction)
		return undefined;
		else
			return inputForm.inputForm.actions;
	} else {
		return inputForm.inputForm.actions;
	}
}

function getInputEntries(interactionId) {
	if (interactionId != "") {
		var isOpenAction = isCompletedForm()?false:true;
		return !isOpenAction ? inputForm.completedForm.entries : inputForm.inputForm.entries;
	} else {
		return inputForm.inputForm.entries;
	}
}

function addStartAndEndTagIfNotPresent(script, tagInfo, endTag) {
	var tempScript = script.trim().replace(/\s+/g, "");
	var startTag = tagInfo.startTag;
	var endTag = tagInfo.endTag;

	if (tempScript.indexOf(startTag) != 0) {
		script = tagInfo.startTag + script;
	}

	if (tempScript.substring(tempScript.length, tempScript.length - endTag.length) != endTag) {
		script += tagInfo.endTag;
	}
	return script;
}

function loadUserDefinedScriptAndCss(inputScript, inputStyleSheet) {

	if (inputStyleSheet != undefined && inputStyleSheet.trim() != "") {
		inputStyleSheet = addStartAndEndTagIfNotPresent(inputStyleSheet, scriptMetaInfo.cssInfo);
		$("head").append(inputStyleSheet);
	}

	if (inputScript != undefined && inputScript.trim() != "") {
		inputScript = addStartAndEndTagIfNotPresent(inputScript, scriptMetaInfo.javaScriptInfo);
		$("head").append(inputScript);
	}
}

function createDefaultActionButton(actionContainer) {
	var inputJSON = {};
	inputJSON["id"] = "okButton";
	inputJSON["name"] = "";
	inputJSON["label"] = parent.wf_localMsg.okButtonLbl;
	inputJSON["validateForm"] = true;
	inputJSON["buttonClass"] = "nonCustomAction";

	createAcionButtonRow(inputJSON, actionContainer);
	addValidationListeners("okButton");
}

function getCloseButton() {
	return cvUtil.getTopWindow().$(".ui-dialog-titlebar-close");
}

function showCloseButton() {
	var $closeButton = cvUtil.getTopWindow().$(".ui-dialog-titlebar-close");
	$closeButton.css("display", "block");
}

function hideCloseButton() {
	var $closeButton = cvUtil.getTopWindow().$(".ui-dialog-titlebar-close");
	$closeButton.css("display", "none");
}

function createInputForm(containerId, actionContainer, interactionId) {
	$("#" + containerId).empty();
	$(".fullAlign .customAction").remove();
	var inputEntries = getInputEntries(interactionId);
	var actionButtons = getInputActions();
	var isCustomActions = (actionButtons != undefined && actionButtons.length > 0) ? true : false;

	if (inputEntries != undefined && inputEntries.length > 0) {
		$(".middle").show();
		//setTimeout(centerModal,2000);
		$(".bottom").css("bottom", "25px");
		for (var index = 0; index < inputEntries.length; index++) {
			var currentInput = inputEntries[index];
			createInputEntryRow(currentInput, containerId);
		}
	} else {
		console.log("Inside the condition");
		//parent.modal.jqDialog.height("200px");
		$(".middle").hide();
		//$(".bottom").css("bottom","225px");
		//parent.window.contentFrame.parents(".ui-dialog").resizable('destroy');
	}

	if(parent.wfUtils.functions.isLMPage())
		createActionButtons(actionContainer, actionButtons, false);
	else
	createActionButtons(actionContainer, actionButtons, isCustomActions);

	var formProps = getFormProperties(interactionId);

	if (formProps != undefined) {
		loadUserDefinedScriptAndCss(formProps.javaScript, formProps.css);
	}

	if (inputEntries != undefined && inputEntries.length > 0) {
		for (var index = 0; index < inputEntries.length; index++) {
			addAppropriateListener(inputEntries[index]);
		}
	}

	var latestDialogH = modalOrigHt;
	var $topWfWindow = getActiveWfWindowModal();

	registerDefaultListenerForActions(actionButtons, isCustomActions);

		if(!parent.wfUtils.functions.isLMPage()){
	if (isCustomActions) {
		var $contentElem = $("#content");
		latestDialogH = ($contentElem.height() + $(".bottom").height());
		var $modalIframe = parent.$(".modal-iframe");
		$modalIframe.css("min-height", latestDialogH + "px");
		$topWfWindow.dialog("option", "minHeight", latestDialogH + 50);
	}
		}

	$topWfWindow.dialog().height(latestDialogH + "px");
	$topWfWindow.dialog({
		resizable : true
	});
	
	if(!parent.wfUtils.functions.isLMPage()){
	centerModal(getFormProperties(interactionId));
	cvUtil.getTopWindow().$(".ui-widget-overlay").eq(1).remove();
	}
	addFilePreventListeners();
}

function createActionButtons(actionContainer, actionButtons, isCustomActions) {
	showCloseButton();
	$("." + actionContainer + " .okSaveButton").remove();
	//registering  click event for vaildation for action buttons
	if (isCustomActions) {
		var inputJSON = {};
		for (var index = 0; index < actionButtons.length; index++) {
			var currentAction = actionButtons[index];
			if (!$.isEmptyObject(currentAction.name.trim())) {
				var currName = escapeSpecialSymbolsForId(currentAction.name.trim().replace(/\s+/g, ""));
				inputJSON = {};
				inputJSON["id"] = currName;
				inputJSON["name"] = currentAction.name;
				inputJSON["label"] = currentAction.name;
				inputJSON["validateForm"] = currentAction.validateForm;
				inputJSON["buttonClass"] = "customAction";

				createAcionButtonRow(inputJSON, actionContainer);
				addValidationListeners(currName);
			}
		}
		$(".customAction").css("display", "block");
		$(".nonCustomAction").css("display", "none");
	} else {
		var isOpenAction = isCompletedForm()?false:true;
		if (parent.selectedTab == parent.wfUtils.constants.FORM_INDEX || (parent.selectedTab == parent.wfUtils.constants.ACTION_INDEX && isOpenAction)) {
			createDefaultActionButton(actionContainer);
			$(".nonCustomAction").css("display", "block");

		}
		$(".customAction").css("display", "none");
	}
}

function registerDefaultListenerForActions(actionButtons, isCustomAction) {
	//registering default click event for action buttons
	if (isCustomAction) {
		for (var index = 0; index < actionButtons.length; index++) {
			var currentAction = actionButtons[index];
			if (!$.isEmptyObject(currentAction.name.trim())) {
				addListenerForActionButtons(escapeSpecialSymbolsForId(currentAction.name.trim().replace(/\s+/g, "")));
			}
		}
	} else {
		addListenerForActionButtons("okButton");
	}
}

function centerModal(formProps) {
	if (formProps != undefined) {
		var $dialog = getActiveWfWindowModal().parent(".ui-dialog");
		var $browserWindow = $(cvUtil.getTopWindow().window);
		var browserWidth = $browserWindow.width();
		var browserHeight = $browserWindow.height();

		top = Math.max(browserHeight - $dialog.outerHeight(), 0) / 2;
		left = Math.max(browserWidth - $dialog.outerWidth(), 0) / 2;
		$dialog.css({
			top : top + $browserWindow.scrollTop(),
			left : left + $browserWindow.scrollLeft()
		});
	}
}

function validateInputField(inputField, validate) {
	if (validate == "true") {
		var isInvalid = false;
		var errorMsg = parent.wf_localMsg.requiredValMsg + " " + getDisplayName(inputField);
		if (inputField.required && inputField.controlHidden != true) {
			var inputVals = $("#" + inputField.inputName).val();
			if (inputField.controlType == LISTBOX) {
				if ($('#' + inputField.inputName + 'Area .listBoxOption.active').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == DROPDOWN) {
				if (inputField.searchable != undefined && inputField.searchable) {
					inputVals = parent.window.searchableEntryMap[inputField.inputName]["selectedList"];
				}

				if (inputVals == undefined || inputVals.length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == RADIO) {
				if ($('input:radio[name=' + inputField.inputName + ']:checked').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == CHECKBOX) {
				if (inputField.inputType != "java.lang.Boolean" &&
						$('input:checkbox[name=' + inputField.inputName + ']:checked').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == DATE_TIME || inputField.controlType == CALENDAR ||
					inputField.controlType == TIME_PICKER) {
				errorMsg = validateDateTimeControl(inputField, true, true);
				if (errorMsg != undefined) {
					isInvalid = true;
				}
			} else if (inputField.controlType == FILE_PICKER) {
				errorMsg = parent.wf_localMsg.requiredFileMsg + " " + getDisplayName(inputField);
				var noOfFiles = parseInt($.trim($("#" + inputField.inputName + "selectedFilesArea")
						.find(".upload-num-files").html()));
				if (noOfFiles < 1) {
					isInvalid = true;
				}
			} else if (inputVals == undefined || inputVals == null || inputVals == "") {
				isInvalid = true;
			}

			if (isInvalid) {
				showError(errorMsg);
				return false;
			}
		}
	}
	return true;
}

function addUserSelectedOptions(currentInput, controlType, isMultiselect) {
	var inputName = currentInput.inputName;
	var wfId = inputForm.entity?inputForm.entity.workflowId:0;
	var currInputVals =[];
	var $topWindow = cvUtil.getTopWindow();

	if (currentInput.searchable != undefined && currentInput.searchable) {
		var inputVals = parent.window.searchableEntryMap[inputName]["selectedList"];
		$(inputVals).each(function() {
			fieldVals.push(cvUtil.createParamString(inputName, $.trim(this)));
		});
		$topWindow.updateInputEntryVal(wfId,inputName,inputVals);
	} else if (isMultiselect) {
		var isReadOnly = currentInput.readOnly;
		var inputVals = [];

		if (isReadOnly != undefined && isReadOnly) {
			inputVals = currentInput.defaultValues;
		} else {
			inputVals = $("#" + inputName).val();
		}
		$(inputVals).each(function() {
			fieldVals.push(cvUtil.createParamString(inputName, $.trim(this)));
		});
		$topWindow.updateInputEntryVal(wfId,inputName,inputVals);
	} else if (currentInput.controlType == CHECKBOX && currentInput.inputType == "java.lang.Boolean") {
		var currInputVal = $('input[name=' + currentInput.inputName + ']').prop("checked");
		currInputVals.push(currInputVal);
		
		fieldVals.push(cvUtil.createParamString(inputName,currInputVal));
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVals);
	} else {
		$('input:' + controlType + '[name=' + currentInput.inputName + ']:checked').each(function() {
			fieldVals.push(cvUtil.createParamString(inputName, $(this).val()));
			currInputVals.push($(this).val())
		});
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVals);
	}
}

function validateDateTimeControl(inputField) {
	var errorMsg = undefined;
	if (inputField.controlType == DATE_TIME || inputField.controlType == CALENDAR) {
		var inputVal = $("#" + inputField.inputName + "_date").val().trim();
		if (inputVal == "") {
			errorMsg = parent.wf_localMsg.emptyDateMsg + " \"" + getDisplayName(inputField) + "\"";
			return errorMsg;
		} else {
			if (!DATE_REGEX.test(inputVal.trim())) {
				errorMsg = "\"" + getDisplayName(inputField) + "\" " + parent.wf_localMsg.invalidDateFormat;
				return errorMsg;
			}
		}
	}

	if (inputField.controlType == DATE_TIME || inputField.controlType == TIME_PICKER) {
		inputVal = $("#" + inputField.inputName + "_time").val().trim();
		if (inputVal == "") {
			errorMsg = parent.wf_localMsg.emptyTimeMsg + " \"" + getDisplayName(inputField) + "\"";
			return errorMsg;
		} else {
			inputVal = timeMap[inputField.inputName].value.trim();
			if (!TIME_REGEX.test(inputVal)) {
				errorMsg = "\"" + getDisplayName(inputField) + "\" " + parent.wf_localMsg.invalidTimeFormat;
				return errorMsg;
			}
		}
	}
}

function getDateTimeValues(currentInput, dateReq, timeReq, getFormattedStr) {

	var inputValue = 0;
	var curDate = new Date();
	var datePart = ""/* curDate.getMonth() + 1 + "/" + curDate.getDate() +"/" + curDate.getFullYear(); */;
	var timePart = ""/* "00:00:00" */;/*
	 * curDate.getHours() + ":" + curDate.getMinutes() + ":" +
	 * curDate.getSeconds();
	 */
	var formattedStr = "";
	if (currentInput.required) {
		if (dateReq) {
			curDate = $("#" + currentInput.inputName + "_date").datepicker('getDate');
			datePart = curDate.getMonth() + 1 + "/" + curDate.getDate() + "/" + curDate.getFullYear();
			formattedStr = curDate.getFullYear() + "-" + ('0' + (curDate.getMonth() + 1)).slice(-2) + "-" +
					('0' + (curDate.getDate())).slice(-2);
		}

		if (timeReq) {
			if (datePart == "") {
				datePart = curDate.getMonth() + 1 + "/" + curDate.getDate() + "/" + curDate.getFullYear();
			}

			timePart = timeMap[currentInput.inputName].value;
		}
	} else {
		if (dateReq) {
			if (DATE_REGEX.test($("#" + currentInput.inputName + "_date").val())) {
				curDate = $("#" + currentInput.inputName + "_date").datepicker('getDate');
				datePart = curDate.getMonth() + 1 + "/" + curDate.getDate() + "/" + curDate.getFullYear();
				formattedStr = curDate.getFullYear() + "-" + ('0' + (curDate.getMonth() + 1)).slice(-2) + "-" +
						('0' + (curDate.getDate())).slice(-2);
			} else {
				datePart = "";
			}
		}

		if (timeReq) {
			if (TIME_REGEX.test($("#" + currentInput.inputName + "_time").val())) {
				if (datePart == "") {
					datePart = curDate.getMonth() + 1 + "/" + curDate.getDate() + "/" + curDate.getFullYear();
				}

				timePart = $("#" + currentInput.inputName + "_time").val().trim();
			} else {
				timePart = "";
			}
		}
	}

	if (getFormattedStr) {
		return formattedStr;
	}

	inputValue = datePart + " " + timePart;
	if (inputValue.trim() != "") {
		inputValue = Math.round((new Date(inputValue).getTime()) / 1000);
	} else {
		inputValue = "";
	}
	return inputValue;
}

function updateFormValues(currentInput, isChild, parent) {
	if (isChild) {
		fieldVals.push(cvUtil.createParamString("fieldList", parent));
		fieldVals.push(cvUtil.createParamString(parent + "_child", currentInput.inputName));
	} else {
		fieldVals.push(cvUtil.createParamString("fieldList", currentInput.inputName));
		if (currentInput.controlType == FILE_PICKER) {
			fieldVals.push(cvUtil.createParamString(currentInput.inputName + "_type", "Binary"));
		} else {
			fieldVals.push(cvUtil.createParamString(currentInput.inputName + "_type", currentInput.inputType));
		}

	}

	var inputName = currentInput.inputName;
	var wfId = inputForm.entity?inputForm.entity.workflowId:0;
	var currInputVal = [];
	var $topWindow = cvUtil.getTopWindow();

	if(currentInput.controlHidden){
		var defaultVals = currentInput.defaultValues;
		var formattedStr = "";
		var curDate = undefined;
		
		if(defaultVals){
			if(currentInput.controlType == CALENDAR){
				jQuery.each(defaultVals, function(index) {
					curDate = new Date(parseInt(this.trim()));
					formattedStr = curDate.getFullYear() + "-" + ('0' + (curDate.getMonth() + 1)).slice(-2) + "-" +
					('0' + (curDate.getDate())).slice(-2);
					fieldVals.push(cvUtil.createParamString(inputName, formattedStr));
				});
			}
			else
			{
				if(currentInput.controlType == TIME_PICKER || currentInput.controlType == DATE_TIME){
					jQuery.each(defaultVals, function(index) {
						fieldVals.push(cvUtil.createParamString(inputName, Math.round(parseInt(this.trim())/1000)));
					});
				}
				else
				{
			jQuery.each(defaultVals,function(index) {
				fieldVals.push(cvUtil.createParamString(inputName, this.trim()));
			});
			}
			}
			$topWindow.updateInputEntryVal(wfId,inputName,defaultVals);
		} else if (currentInput.defaultValue) {
			if(currentInput.controlType == CALENDAR){
					curDate = new Date(parseInt(currentInput.defaultValue));
					formattedStr = curDate.getFullYear() + "-" + ('0' + (curDate.getMonth() + 1)).slice(-2) + "-" +
					('0' + (curDate.getDate())).slice(-2);
					fieldVals.push(cvUtil.createParamString(inputName, formattedStr));
		}
			else
		{
				if(currentInput.controlType == TIME_PICKER || currentInput.controlType == DATE_TIME){
						fieldVals.push(cvUtil.createParamString(inputName, Math.round(parseInt(currentInput.defaultValue)/1000)));
				}
				else
			fieldVals.push(cvUtil.createParamString(inputName, currentInput.defaultValue));
			}
			currInputVal.push(currentInput.defaultValue);
			$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		}
		return;
	}
	
	if (currentInput.controlType == LISTBOX) {
		var $selectedOptions = $('#' + inputName + 'Area .listBoxOption.active');
		$selectedOptions.each(function(index) {
			fieldVals.push(cvUtil.createParamString(inputName, $(this).attr("data-val").trim()));
			currInputVal.push($(this).attr("data-val").trim());
		});
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
	} else if (currentInput.controlType == RADIO) {
		addUserSelectedOptions(currentInput, "radio", false);
	} else if (currentInput.controlType == CHECKBOX) {
		addUserSelectedOptions(currentInput, "checkbox", false);
	} else if (currentInput.searchable != undefined && currentInput.searchable) {
		addUserSelectedOptions(currentInput, undefined, true);
	} else if (currentInput.listType != undefined && currentInput.listType && currentInput.controlType == DROPDOWN) {
		addUserSelectedOptions(currentInput, undefined, true);
	} else if (currentInput.controlType == DATE_TIME) {
		inputValue = getDateTimeValues(currentInput, true, true, false);
		currInputVal.push(inputValue);
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
	} else if (currentInput.controlType == CALENDAR) {
		inputValue = getDateTimeValues(currentInput, true, false, true);
		currInputVal.push(inputValue);
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
	} else if (currentInput.controlType == TIME_PICKER) {

		inputValue = getDateTimeValues(currentInput, false, true, false);
		currInputVal.push(inputValue);
		$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
	} else if (currentInput.controlType == FILE_PICKER) {
		var selectedFileMap = wfInputEntryFileUploadMap[currentInput.inputName];
		var index = 0;
		if (!$.isEmptyObject(selectedFileMap)) {
			wfStagedFileInputs.push(currentInput.inputName);
			jQuery.each(selectedFileMap, function(key, value) {
				var curFile = value;
				addNewFile(currentInput, curFile, index);
				fieldVals.push(cvUtil
						.createParamString("file" + index + "_" + currentInput.inputName + "_fullDestPath",
								encodeURIComponent(inputForm.inputForm.destPath + "\\" +
										getDestPathOfCurrInput(currentInput.inputName) + "\\" + curFile.name)));
				index++;
			});
		}
	} else {
		var inputValue = $("#" + currentInput.inputName).val();
		if (currentInput.type == "{http://www.w3.org/2001/XMLSchema}date" ||
				currentInput.type == "{http://www.w3.org/2001/XMLSchema}datetime" ||
				currentInput.type == "{http://www.w3.org/2001/XMLSchema}time") {
			inputValue = timeMap[currentInput.inputName];
			currInputVal.push(inputValue);
			$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		} else if (currentInput.inputType == "workflow.types.EncryptedString") {
			fieldVals.push(cvUtil.createParamString(currentInput.inputName + "_reencrypt", true));
			inputValue = Base64.encode($.trim(inputValue));
		}
		else
		{
			currInputVal.push(inputValue.replace("<","&amp;lt;").replace(">","&amp;gt;"));
			$topWindow.updateInputEntryVal(wfId,inputName,currInputVal);
		}

		/*
		 * if(isComplexEntity(currentInput.inputType)) { if(inputValue!=undefined && inputValue!=null) {
		 */
		fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue.replace("<","&amp;lt;").replace(">","&amp;gt;")));
		//}
		//}
		/*
		 * else { fieldVals.push(cvUtil.createParamString(currentInput.inputName,inputValue)); }
		 */
	}
}

function validateInputForm(validate) {
	var inputEntries = inputForm.inputForm.entries;
	for (var index = 0; index < inputEntries.length; index++) {
		var currentInput = inputEntries[index];

		if (!validateInputField(currentInput, validate)) {
			return false;
		}

		if (currentInput.children != undefined && currentInput.children.length > 0) {

			var currentChild;
			for (var childIndex = 0; childIndex < currentInput.children.length; childIndex++) {
				currentChild = currentInput.children[childIndex];

				var isChildVaildated = validateInputField(currentChild, validate);
				if (!isChildVaildated) {
					return false;
				}
			}
		}
	}
	return true;
}

function getInputFormValuesEnteredByUser(actionName, validate,getParams) {
	if (inputFormValidated || (getParams!= undefined && getParams === true)) {
		var inputEntries = inputForm.inputForm.entries;
		uploadFileList = [];
		wfStagedFileInputs = [];
		destPath = /* inputForm.inputForm.destPath + "\\" + */Base64.encode(parent.userGUID + new Date().getTime());
		for (var index = 0; index < inputEntries.length; index++) {
			var currentInput = inputEntries[index];

			if (currentInput.children != undefined && currentInput.children.length > 0) {

				var currentChild;
				for (var childIndex = 0; childIndex < currentInput.children.length; childIndex++) {
					currentChild = currentInput.children[childIndex];
					updateFormValues(currentChild, true, currentInput.inputName);
				}
			} else {
				updateFormValues(currentInput, false, undefined);
			}
		}
		fieldVals.push(cvUtil.createParamString("actionName", actionName));
	}
}

function getFormObject(interactionId, data) {
	if (interactionId && interactionId != "") {
		return data.request;
	} else {
		return data.container[0];
	}
}

function isValidData(interactionId, data) {
	if (interactionId && interactionId != "") {
		return data.request != undefined;
	} else {
		return data.container != undefined && data.container.length != 0;
	}
}

$(document).ready(function() {
	wfInfo = {};
	wfInfo.interactionId = cvUtil.getParameterByName("interactionId", null, undefined, false, true);
	wfInfo.workflowId = cvUtil.getParameterByName("workflowId", null, undefined, false, true);
	wfInfo.workflowName = decodeURIComponent(cvUtil.getParameterByName("workflowName", null, undefined, false, true));
	wfInfo.subTime = cvUtil.getParameterByName("subTime", null, undefined, false, true);
	wfInfo.isInfoResp = cvUtil.getParameterByName("isInfoResp", null, undefined, false, true);
	wfInfo.isPopupResp = cvUtil.getParameterByName("isPopUpResp", null, undefined, false, true);
	wfInfo.submit = parent.urlParams.submit;
	
	cvUtil.getTopModal().jqDialog.dialog(
	{ 
		beforeClose:function( event, ui ) { 
			updateWfFormValues();
			cvUtil.closeModal();
			return false;
		}
	});
	
	processWorkflowRequest(wfInfo);
});

function updateWfFormValues(){
			if(!parent.wfUtils.functions.isLMPage()){
				if(parent.currentResp == undefined || parent.currentResp.respType == parent.respType.POPUP_RESP){
			fieldVals = [];
			getInputFormValuesEnteredByUser(undefined,true,true);
			parent.setInputParamsForClosedWf(cvUtil.createParamsString(fieldVals));
			fieldVals = [];
				}
			}
		}

function resizeDialog(formProps) {

	var width = FORM_WIDTH;
	var height = FORM_HEIGHT;
	var $modalIframe = parent.$(".modal-iframe");
	$modalIframe = $($modalIframe[$modalIframe.length - 1]);
	var $topWfWindow = getActiveWfWindowModal();

	if (!$.isEmptyObject(formProps) && formProps.width != undefined && formProps.width != "" &&
			formProps.height != undefined && formProps.height != "") {

		width = formProps.width;
		height = formProps.height;
		$(".bottom .btns").addClass("btns-absolute");
	}
	if (width != undefined) {
		var minWidth = width;

		if (width <= FORM_MIN_WIDTH) {
			width = FORM_MIN_WIDTH;
			minWidth = width + 160;
		}

		$modalIframe.css("min-width", width + "px");

		$topWfWindow.css({
			"width" : width,
			"min-width" : minWidth
		});
		//window.parent.$("#modal" + cvUtil.getTopModal().modalId).css("min-width",minWidth + "px");
		$topWfWindow.dialog("option", "minWidth", minWidth + 20);
	}

	if (height != undefined) {
		var minHeight;
		if (height < FORM_MIN_HEIGHT) {
			height = 100 + DESCRIPTION_HEIGHT;
			minHeight = height + PADDING_FOR_SMALLFORM;
		} else {
			height = height + DESCRIPTION_HEIGHT;
			minHeight = height + PADDING_FOR_LARGEFORM;
		}
		$modalIframe.css("min-height", height + "px");
		$topWfWindow.css({
			"height" : height,
			"min-height" : minHeight
		});
		//window.parent.$("#modal" + cvUtil.getTopModal().modalId).css("min-height",minHeight + "px");
		modalOrigHt = $topWfWindow.dialog().height();
		$topWfWindow.dialog("option", "minHeight", minHeight + 50);
	}
}

function displayInputForm(description, interactionId, formProps) {
	resizeDialog(formProps);
	$("#scrollbar2").show();
	if (description == undefined) {
		description = "";
	}

	$(".description").html(description);

	createInputForm("inputcontainer", "fullAlign", interactionId);
	$(".center").remove();
	textAreaResizeHandler();
	resizeForm();

	$(".minus").off("click." + APP_NAMESPACE);
	$(".minus").on("click." + APP_NAMESPACE, function(e) {
		$(this).parent().next(".children").toggle();
		$(this).toggleClass("plus");
		resizeForm();
	});
}

function getFormProperties(interactionId) {
	if (interactionId != "") {
		var isOpenAction = isCompletedForm()?false:true;
		if(isOpenAction){
			return inputForm.inputForm != undefined ? inputForm.inputForm.properties : undefined;			
		}
		else 
		{
		return inputForm.completedForm != undefined ? inputForm.completedForm.properties : undefined;
		}
	} else {
		return inputForm.inputForm != undefined ? inputForm.inputForm.properties : undefined;
	}
}

function clearInfoResponseParams() {
	var interactionParams = $.extend(true, {}, parent.currentResp);
	interactionParams.response.message = "";
	interactionParams.title = "";
	interactionParams.html = "";
	interactionParams.response.properties = "";
	return interactionParams;
}

function processWorkflowResp(data) {
	$("#inputcontainer").removeClass("infoMessage");
	workflowResp.respType = data.respType;
	if (data.respType == parent.respType.GENERIC_RESP) {
		workflowResp.respMsg = data.response.errorMessage;
		workflowResp.errorCode = data.response.errorCode;
		cvUtil.closeModal();
	} else if (data.respType == parent.respType.START_WORKFLOW_RESP) {
		workflowResp.respMsg = "";
		workflowResp.errorCode = 0;
		cvUtil.closeModal();
	} else if (data.respType == parent.respType.POPUP_RESP) {
		var title = parent.wf_localMsg.popUpInputRespTitle;
		if (data.response.subject != undefined && data.response.subject != "") {
			title = data.response.subject;
		}
		cvUtil.setModalTitle(title);
		inputForm = data.response;
		displayInputForm(data.response.description, "", getFormProperties(""));
	} else if (data.respType == parent.respType.INFO_RESP) {
		var title = data.response.title;
		if (title == undefined || title == "") {
			title = parent.wf_localMsg.infoRespTitle;
		}
		if (data.response.dialogType == dialogType.POPUP_DIALOGTYPE) {
			var actionButtons = data.response.actions;
			var isCustomActions = (actionButtons != undefined && actionButtons.length > 0) ? true : false;
			createActionButtons("fullAlign", actionButtons, isCustomActions);
			registerDefaultListenerForActions(actionButtons, isCustomActions);

			/*
			 * if(isCustomActions) { hideCloseButton(); }
			 */

			$("#inputcontainer").addClass("infoMessage");
			$("#inputcontainer").html(data.response.message);
			$(".middle").show();
			resizeDialog(undefined);
			$(".bottom").css("bottom", "50px");

			var latestDialogH = modalOrigHt;
			var $topWfWindow = getActiveWfWindowModal();

			if (isCustomActions) {
				var $contentElem = $("#content");
				latestDialogH = ($contentElem.height() + $(".bottom").height());
				var $modalIframe = parent.$(".modal-iframe");
				$modalIframe.css("min-height", latestDialogH + "px");
				$topWfWindow.dialog("option", "minHeight", latestDialogH + 50);
			}

			$topWfWindow.dialog().height(latestDialogH + "px");
			$topWfWindow.dialog({
				dialogClass : "noOverlayDialog",
				resizable : true
			});

			cvUtil.getTopWindow().$(".ui-widget-overlay").eq(1).remove();

			$("#scrollbar2").hide();
			cvUtil.setModalTitle(title);
			updateScroll();
			var formProps = data.response.properties;
			centerModal(formProps);
			resizeForm();
			if (formProps != undefined) {
				loadUserDefinedScriptAndCss(formProps.javaScript, formProps.css);
			}
		} else {
			parent.cvUtil.toast(title + "<br><br>" + data.response.message);
			var interactionParams = clearInfoResponseParams();
			fieldVals.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactionParams)));
			fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			inputParams = cvUtil.createParamsString(fieldVals);
			url = parent.wfUtils.functions.getURL(true);
			CheckIfUploadAndStartActivity(url, inputParams);
		}
	} else if (data.respType == parent.respType.END_USER_RESP) {
		workflowResp.errorCode = undefined;
		cvUtil.closeModal();
	} else {
		workflowResp.respMsg = data.errorMessage;
		workflowResp.errorCode = data.errorCode;
		cvUtil.closeModal();
	}
}

function startActivity(url, inputParams) {
	$("#container").unmask(" ");
	cvUtil.loadPage(url, inputParams, function(data) {
		parent.dataResp = data;
		if (data != undefined) {
			$(".error").html("");
			parent.currentResp = data;
			parent.setCurrentResp(data);
			workflowResp.respType = data.respType;
			processWorkflowResp(data);
			$("#container").unmask(" ");
		}
	}, function(xhr, ajaxOptions, thrownError) {
		workflowResp.respMsg = parent.wf_localMsg.startFormTimeoutWarning;
		workflowResp.errorCode = 10;
		cvUtil.closeModal();
		/*
		 * if(thrownError!='userAborted'){ cvUtil.handleError(xhr, ajaxOptions, thrownError); }
		 */
	}, parent.wfUtils.functions.getAjaxTimeOut());
	$("#container").mask(" ");
}

function getDestPathOfCurrInput(inputName) {
	return destPath + "_" + inputName;
}

function startUpload(url, inputParams) {

	$("#container").unmask(" ");
	var contentDiv = document.createElement("DIV");
	$(contentDiv).load(cvUtil.getContextPath() + "/logMonitoring/uploadForm.jsp", function() {

		$(contentDiv).find(".uploadInProgress").show();
		$(".uploadProgress").prepend($(contentDiv).find(".uploadFileDiv"));
		var formData = new FormData();
		formData.append("clientId", inputForm.client.clientId);
		formData.append("incompatibleBrowser", false);

		if (wfStagedFileInputs.length > 0 && !$.isEmptyObject(wfInputEntryFileUploadMap)) {
			jQuery.each(wfStagedFileInputs, function(index) {
				var curInput = this.trim();
				var curInputFileMap = wfInputEntryFileUploadMap[curInput];
				//var fullPath = inputForm.inputForm.destPath + "\\" + getDestPathOfCurrInput(curInput);
				var curDestPath = getDestPathOfCurrInput(curInput);
				if (!$.isEmptyObject(curInputFileMap)) {
					jQuery.each(curInputFileMap, function(key, value) {
						var file = value;
						formData.append("destPath", curDestPath);
						formData.append("isFile", true);
						formData.append("fileSize", file.size);
						formData.append("isWorkflowUpload", true);
						formData.append("wfEncodedFileName", encodeURIComponent(file.name));
						formData.append("wfDestFolderName", curDestPath);
						formData.append("wfWorkflowId", curWfMetaInfo.workflowId);
						formData.append("wfWorkflowName", curWfMetaInfo.workflowName);
						formData.append("wfJobId", inputForm.jobId);
						formData.append("wfEngineClientId", inputForm.client.clientId);

						formData.append('file', file);
					});
				}
			});
		}

		var uploadErrorMsg = parent.wf_localMsg.wfFileUploadError;

		window.setTimeout(function() {
			var ajaxId = $.ajax({
				url : 'uploadFile.do',
				type : 'POST',
				data : formData,
				async : true,
				success : function(dataResult) {
					var returnedItems = JSON.parse(dataResult);
					var returnCode = returnedItems.returnCode;
					if (returnCode == "Error") {
						showError(uploadErrorMsg);
						$("#container").unmask(" ");
					} else {
						uploadFileList = [];
						wfStagedFileInputs = [];
						//wfInputEntryFileUploadMap = {};
						startActivity(url, inputParams);
					}
				},
				error : function(xhr, ajaxOptions, thrownError) {
					showError(uploadErrorMsg);
					$("#container").unmask(" ");
				},
				cache : false,
				contentType : false,
				processData : false,
				timeout : parent.wfReqTimeOut?parent.wfReqTimeOut:630000
			});
		}, 100);
	});
	$("#container").mask(" ");
}

function CheckIfUploadAndStartActivity(url, inputParams) {
	if (uploadFileList.length > 0) {
		startUpload(url, inputParams);
	} else {
		startActivity(url, inputParams);
	}
}

function addURLForSelectedEntries(currentInputInfo, htmlText) {
	$("#" + currentInputInfo + " .selectedEntries").html(htmlText);
	$(".selectedEntries").off("click." + APP_NAMESPACE);
	$(".selectedEntries").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		e.stopPropagation();
		showSearchableResults($(this).attr("data-input"), true);
	});
}
function displaySelectedValsForSearchableType(currentInputInfo) {
	var selectedList = parent.window.searchableEntryMap[currentInputInfo]["selectedList"];
	var selectedSize = selectedList.length;
	var htmlText = selectedList.join(";"); //selectedSize + ' ' + parent.wf_localMsg.searchableItemsselectedLbl;
	$("#" + currentInputInfo).attr("title", htmlText);
	if (selectedSize > 1) {
		addURLForSelectedEntries(currentInputInfo, htmlText);
	} else if (selectedSize == 1) {
		htmlText = selectedList[0];
		addURLForSelectedEntries(currentInputInfo, htmlText);
	} else if (selectedSize == 0) {
		$("#" + currentInputInfo + " .selectedEntries").html("");
	}
}

function getActiveWfWindowModal() {
	var $topWindow = cvUtil.getTopWindow();
	var $activeDialogs = $topWindow.cvUtil.openDialogs;
	return $topWindow.$("#modal" + $activeDialogs[$activeDialogs.length - 1]);
}

function showSearchableResults(currentInputInfo, showSelectedList) {

	var params = [];
	params.push(cvUtil.createParamString("currentInput", currentInputInfo));
	params.push(cvUtil.createParamString("showSelectedList", showSelectedList));
	parent.window.searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
	parent.window.searchableEntryMap[currentInputInfo]["tempList"] = $.extend([],
			parent.window.searchableEntryMap[currentInputInfo]["selectedList"]);
	var inputParams = cvUtil.createParamsString(params);

	var target = cvUtil.getContextPath() + "/forms/paginate.jsp?" + inputParams;
	var closeListener = function(res) {
		if(cvUtil.getTopWindow().cvUtil.openDialogs && cvUtil.getTopWindow().cvUtil.openDialogs.length>1)
			cvUtil.getTopWindow().cvUtil.openDialogs.pop();
		if (res != undefined) {
			parent.window.searchableEntryMap[currentInputInfo]["selectedList"] = $.extend([],
					parent.window.searchableEntryMap[currentInputInfo]["tempList"]);
			displaySelectedValsForSearchableType(currentInputInfo);
		} else {
			var unselectedOptions = parent.window.searchableEntryMap[currentInputInfo]["unSelectedList"];
			var tempList = parent.window.searchableEntryMap[currentInputInfo]["tempList"];
			jQuery(unselectedOptions).each(function(index) {
				var curOption = this;
				if (tempList.indexOf("curOption") != -1) {
					parent.window.searchableEntryMap[currentInputInfo]["selectedList"].push(curOption);
				}
			});
		}
		parent.window.searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
		parent.window.searchableEntryMap[currentInputInfo]["tempList"] = [];
		$("#" + currentInputInfo).trigger("change");
	};

	var options = {
		width : 500,
		height : 500,
		title : showSelectedList ? parent.wf_localMsg.searchableSelectedOptionsTitle
				: parent.wf_localMsg.searchableResultsTitle,
		resizable : true,
		href : target,
		iframe : true,
	};

	cvUtil.showModal(options, null, closeListener);

	var $currModal = getActiveWfWindowModal().parents(".ui-dialog");

	$currModal.addClass("wfPopup");
	$currModal.children(".ui-dialog-titlebar").addClass("wfPopupTitle");
}

function addValidationListeners(buttonId) {

	//buttonId = buttonId.trim().replace(/\s+/g,"");
	$("#" + buttonId).off("click.validate" + APP_NAMESPACE);
	$("#" + buttonId).on("click.validate" + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var validate = $(this).attr("data-validate");
		inputFormValidated = false;
		if (parent.currentResp == undefined || parent.currentResp.respType == parent.respType.POPUP_RESP) {
			inputFormValidated = validateInputForm(validate);
			if (!inputFormValidated) {
				e.stopImmediatePropagation();
			}
		}
	});
}

function invokeDefaultEvent(e) {
	$(e.target).trigger(e.handleObj.type + "." + APP_NAMESPACE);
}

function escapeSpecialSymbolsForId(currentKey) {
	currentKey = currentKey.replace(/#/g, "s1").replace(/!/g, "s2").replace(/@/g, "s3").replace(/\*/g, "s4")
			.replace(/\$/g, "s5").replace(/%/g, "s6").replace(/\^/g, "s7").replace(/&/g, "s8").replace(/\(/g, "s9")
			.replace(/\)/g, "s10").replace(/\[/g, "s11").replace(/]/g, "s12").replace(/{/g, "s13").replace(/}/g, "s14")
			.replace(/\+/g, "s15").replace(/\\/g, "s16").replace(/\|/g, "s17").replace(/'/g, "s18").replace(/\"/g,
					's19').replace(/;/g, "s20").replace(/:/g, "s21").replace(/::/g, "s22").replace(/\?/g, "s23")
			.replace(/\./g, "s24").replace(/</g, "s25").replace(/>/g, "s26").replace(/,/g, "s27").replace(/`/g, "s28")
			.replace(/~/g, "s29").replace(/\=/g, "s30").replace(/\//g, "s31");
	return currentKey;
}

function addListenerForActionButtons(buttonId) {

	//buttonId = buttonId.trim().replace(/\s+/g,"");
	$("#" + buttonId).off("click." + APP_NAMESPACE);
	$("#" + buttonId)
			.on("click." + APP_NAMESPACE,
					function(e) {
						e.preventDefault();
						var interactionParams = undefined;
						var validate = $(this).attr("data-validate");
						var actionName = $(this).attr("data-action");
						isValidated = inputFormValidated;
						fieldVals = [];
						
						if(parent.wfUtils.functions.isLMPage()){
							getInputFormValuesEnteredByUser(actionName, validate);
							if (isValidated) {
								fieldVals.push(cvUtil.createParamString("workflowId", workflowId));
								workflowResp.wfInputsAdded = true;
								parent.window.wfInputEntryValMap[workflowId]["inputValStr"] = cvUtil.createParamsString(fieldVals);
								cvUtil.closeModal();
							}
						}
						else {
						if (parent.currentResp == undefined) {
							getInputFormValuesEnteredByUser(actionName, validate);

							if (isValidated) {
								if (interactionId != "") {
									fieldVals.push(cvUtil.createParamString("interactionId", interactionId));
									//fieldVals.push(cvUtil.createParamString("inputForm",JSON.stringify(inputForm.inputForm)));
									interactionParams = parent.clearUserInteractionParams();

									fieldVals.push(cvUtil.createParamString("interactionParams", JSON
											.stringify(interactionParams)));
								} else {
									fieldVals.push(cvUtil.createParamString("workflowName", workflowName));
									fieldVals.push(cvUtil.createParamString("workflowId", workflowId));
									if(parent.urlParams.wfEngineId && parent.urlParams.wfEngineId!=""){
										fieldVals.push(cvUtil.createParamString("_wfClientId",parent.urlParams.wfEngineId));
									}
									else{
									fieldVals.push(cvUtil.createParamString("_wfClientId", inputForm.client.clientId));
										fieldVals.push(cvUtil.createParamString("_wfClientName",inputForm.client.clientName));
									}
								}

								fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
								inputParams = cvUtil.createParamsString(fieldVals);

								var url = parent.wfUtils.functions.getURL(true);
								CheckIfUploadAndStartActivity(url, inputParams);
							} else {
								console.debug("Input Form Not Completely Entered : ");
							}
						} else if (parent.currentResp.respType == parent.respType.INFO_RESP ||
								parent.currentResp.respType == parent.respType.POPUP_RESP) {
							//params = [];
							if (parent.currentResp.respType == parent.respType.POPUP_RESP) {
								getInputFormValuesEnteredByUser(actionName, validate);
								interactionParams = parent.clearPopUpResponseParams();
							} else {
								interactionParams = clearInfoResponseParams();
								fieldVals.push(cvUtil.createParamString("actionName", actionName));
								isValidated = true;
							}

							if (isValidated) {
								if(parent.urlParams.wfEngineId && parent.urlParams.wfEngineId!=""){
									fieldVals.push(cvUtil.createParamString("_wfClientId",parent.urlParams.wfEngineId));
								}
								fieldVals.push(cvUtil.createParamString("interactionParams", JSON
										.stringify(interactionParams)));
								fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
								inputParams = cvUtil.createParamsString(fieldVals);
								var url = parent.wfUtils.functions.getURL(true);
								CheckIfUploadAndStartActivity(url, inputParams);
							}
						}
						}
					});
}

function isUserInteraction() {
	return inputForm.interactionId != undefined && inputForm.interactionId > 0 ? true : false;
}

function setCurrWorkflowMetaInfo(wfEntity) {
	curWfMetaInfo = wfEntity;
}

function processWorkflowRequest(wfInfo){

	var params = [];
	var isValidated;
	interactionId = wfInfo.interactionId;
	
	if(wfInfo.selectedTab != undefined){
		parent.selectedTab = wfInfo.selectedTab;
		parent.setSelectedTab(wfInfo.selectedTab);
	}
		
	var url = parent.wfUtils.functions.getURL(false);
	workflowId = wfInfo.workflowId;
	workflowName = wfInfo.workflowName;
	var subTime = wfInfo.subTime;
	modalOrigHt = parent.modal.jqDialog.height();

	parent.window.searchableEntryMap = {};
	
	var submit = wfInfo.submit?wfInfo.submit:false;

	initFormsSysParamters();
	
	var isInfoResp = wfInfo.isInfoResp?wfInfo.isInfoResp:"false";
	var isPopupResp = wfInfo.isPopupResp ? wfInfo.isPopupResp : "false";

	if (submit == true) {
		parent.setInputParamsForClosedWf(undefined);
		setCurrWorkflowMetaInfo(parent.currentResp.response.workflow);
		parent.urlParams.submit = "";
		parent.setSubmit(parent.urlParams.submit);
		processWorkflowResp(parent.currentResp);
	}

	if (submit == "" || submit == false) {
		if (isInfoResp == "false" && isPopupResp == "false") {
			parent.setInputParamsForClosedWf(undefined);
			parent.currentResp = undefined;
			parent.setCurrentResp(undefined);
			parent.userInteractionResp = undefined;
			parent.setUserInteractionResp(undefined);

			if (submit == false) {
				params = parent.getCustomInputParams();
				parent.urlParams.submit = "";
				parent.setSubmit(parent.urlParams.submit);
				parent.customInputsMap = {};
				parent.Forms.setCustomInputsMap({});
			}

			params.push(cvUtil.createParamString("workflowId", workflowId));
			params.push(cvUtil.createParamString("workflowName", workflowName));
			params.push(cvUtil.createParamString("interactionId", interactionId));
			//params.push(cvUtil.createParamString("filter", filter));
			params.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			params.push(cvUtil.createParamString(parent.wfUtils.constants.PARAM_SUBMIT_OPTION, submit));

			var inputParams = cvUtil.createParamsString(params);

			parent.isModalExists = true;

			cvUtil.loadPage(url, inputParams, function(data) {

				if (isValidData(interactionId, data)) {
					inputForm = getFormObject(interactionId, data);
					var description = inputForm.description;
					if (parent.selectedTab == parent.wfUtils.constants.ACTION_INDEX) {
						setCurrWorkflowMetaInfo(inputForm.workflow);
						parent.userInteractionResp = data;
						parent.setUserInteractionResp(data);
						cvUtil.setModalTitle(inputForm.subject);
						if (data.errorCode != undefined) {
							workflowResp.respMsg = data.errorMessage;
							workflowResp.errorCode = data.errorCode;
							cvUtil.closeModal();
						} else {
							if (inputForm.status == "NEW") {
								$(".bottom .btns").addClass("btns-absolute");
								displayInputForm(description, interactionId, getFormProperties(interactionId));
							} else if (inputForm.status == "KILLED") {
								workflowResp.respMsg = "";
								workflowResp.errorCode = -4;
								cvUtil.closeModal();
							} else if (inputForm.status == "COMPLETED") {
								//if (!filter) {
									//if (parent.selectedTab == parent.wfUtils.constants.ACTION_INDEX && !filter) {
										if(inputForm.completedBy && inputForm.completedBy.userName){
											$(".submittedby").html(inputForm.completedBy.userName);
										}
										else
											$(".submittedby").hide();
										
										$(".submittedon").html(new Date(parseInt(inputForm.completed) * 1000)
												.toLocaleString());
										$(".executor").show();
										$(".subtime").show();
										var actionExecuted = inputForm.actionExecuted;
										if (actionExecuted != undefined && actionExecuted != "") {
											$(".actionName").html(actionExecuted);
											$(".actionExecuted").show();
										}
										$("#okButton").css("display", "none");
										$(".bottom").addClass("completedActions");
									//}
									displayInputForm(description, interactionId, getFormProperties(interactionId));
								/*} else {
									workflowResp.respMsg = inputForm.completedBy && inputForm.completedBy.userName?inputForm.completedBy.userName:"";
									workflowResp.errorCode = -3;
									cvUtil.closeModal();
								}*/
							} else if (inputForm.status == "DELETED") {
								workflowResp.respMsg = "";
								workflowResp.errorCode = -1;
								cvUtil.closeModal();
							}
						}
					} else {
						setCurrWorkflowMetaInfo(inputForm.entity);
						workflowName = inputForm.entity.workflowName;
						
						cvUtil.setModalTitle(workflowName != undefined ? workflowName : "");
						
						displayInputForm(description, interactionId, getFormProperties(interactionId));
					}
				} else if (data.errorMessage != undefined) {
					workflowResp.respMsg = data.errorMessage;
					workflowResp.errorCode = data.errorCode;
					cvUtil.closeModal();
				}
			}, function(xhr, ajaxOptions, thrownError) {
				workflowResp.respMsg = parent.wf_localMsg.formError;
				workflowResp.errorCode = 10;
				cvUtil.closeModal();
				/*
				 * if(thrownError!='userAborted'){ cvUtil.handleError(xhr, ajaxOptions, thrownError); }
				 */
			}, parent.wfUtils.functions.getAjaxTimeOut());
		} else {
			var interactionParams = "";
			var inputParamsOfClosedWf = "";
			fieldVals = [];

			if (isInfoResp == "true") {
				interactionParams = clearInfoResponseParams();
			} else if (isPopupResp == "true") {
				interactionParams = parent.clearPopUpResponseParams();
				fieldVals.push(cvUtil.createParamString("continueWorkflow", "false"));
				inputParamsOfClosedWf = parent.getInputParamsForClosedWf();
			}
			setCurrWorkflowMetaInfo(parent.currentResp.response.workflow);
			fieldVals.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactionParams)));
			fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			inputParams = cvUtil.createParamsString(fieldVals);
			inputParams = inputParamsOfClosedWf!=undefined && inputParamsOfClosedWf.trim() != ""?inputParams + "&" + inputParamsOfClosedWf:inputParams;
			url = parent.wfUtils.functions.getURL(true);
			CheckIfUploadAndStartActivity(url, inputParams);
		}
	}

	$('#scrollbar1').tinyscrollbar();
	$('#scrollbar2').tinyscrollbar();

	if (isInfoResp == "false") {
		updateScroll();
	}

	$(window).bind('resize', function() {
		resizeForm();
	});

	$(document).mouseup(function(e) {
		var classList;
		if (navigator.userAgent.indexOf("IE") != -1) {
			classList = e.target.className.split(",");
		} else {
			classList = e.target.classList;
		}

		if (!classList.contains("ui-autocomplete") && !classList.contains("grabber") && !classList.contains("drop")) {
			$(".ui-autocomplete").hide();
		}
	});
}

(function($) {
	if(!parent.wfUtils.functions.isLMPage()){
	$("body")
			.keypress(function(evt) {
				if (evt.keyCode == 27 &&
						(parent.currentResp.respType != parent.respType.INFO_RESP && parent.currentResp.respType != parent.respType.POPUP_RESP)) {
					workflowResp.respType = parent.currentResp.respType;
					workflowResp.errorCode = undefined;
					cvUtil.closeModal();
				}

				if (evt.keyCode == 9) {
					widthAdjuster();
				}
			});
	}
})(jQuery);