var inputFormForActivity = JSON.parse('{"client":{"clientId":2,"clientName":"CRV2"},"inputForm":{"destPath":"","entries":[{"name":"name","className":"java.lang.String","defaultValue":"","options":[],"documentation":"","type":"{http://www.w3.org/2001/XMLSchema}string","listType":false,"required":true,"attribute":false,"hidden":false,"readOnly":false,"displayName":"Machine Name","controlType":"TEXTBOX","inputName":"name","inputType":"java.lang.String","minimumValue":"","maximumValue":"","searchable":false,"controlHidden":false,"labelsForOptions":[]},{"name":"Memory","className":"java.lang.Integer","defaultValue":"","options":["8","16","32"],"documentation":"memory","type":"{http://www.w3.org/2001/XMLSchema}integer","listType":false,"required":true,"attribute":false,"hidden":false,"readOnly":false,"displayName":"Memory (GB)","controlType":"RADIOBUTTON","inputName":"Memory","inputType":"java.lang.Integer","minimumValue":"","maximumValue":"","searchable":false,"alignment":"VERTICAL","controlHidden":false,"labelsForOptions":["8 GB","16 GB","32 GB"]},{"name":"Disk","className":"java.lang.Integer","defaultValue":"1000","defaultValues":["1000"],"options":["250","500","1000"],"documentation":"disk","type":"{http://www.w3.org/2001/XMLSchema}integer","listType":false,"required":true,"attribute":false,"hidden":false,"readOnly":false,"displayName":"Disk (GB)","controlType":"DROPDOWN","inputName":"Disk","inputType":"java.lang.Integer","minimumValue":"","maximumValue":"","searchable":false,"alignment":"HORIZONTAL","controlHidden":false,"labelsForOptions":["250 GB","500 GB","1 TB"]},{"name":"software","className":"java.lang.String","defaultValue":"Outlook","defaultValues":["Outlook"],"options":["Backup","Outlook","Chrome"],"documentation":"software","type":"{http://www.w3.org/2001/XMLSchema}string","listType":true,"required":true,"attribute":false,"hidden":false,"readOnly":false,"displayName":"Additional Software","controlType":"DROPDOWN","inputName":"software","inputType":"java.lang.String","minimumValue":"","maximumValue":"","searchable":false,"controlHidden":false,"labelsForOptions":["Backup","Outlook Mail","Chrome"]}],"properties":{"css":"","javaScript":"","formVersion":"DEFAULT","pageMode":"POPUP"}},"entity":{"workflowId":14,"workflowName":"Demo - New Machine Request"},"version":56,"description":"Request a new machine","creator":{"userId":1,"userName":"Admin"},"flags":64,"uniqueGuid":"da88c791-ec45-416a-b96b-34583da6c424","revision":"$Revision$"}');

var Forms = (function(formObj) {
	var currReactInfo = undefined;
	var TABLE_CONTAINER = "#wfRulesTable tbody";	
	var dispToInputEntryMap = {};
	var inputNameToDispMap = {};
	var fieldTypeMap = {};
	var RULE_INPUTFORM_URL = "retrieveInputFormForRules.do";
	var SAVE_CUSTOMIZATION_URL = "saveCustomization.do";
	var DEPLOY_CUSTOMIZATION_URL = "deployCustomization.do";
	var ruleReq = {};
	var RULE_DETAIL_FORM = undefined;
	var ruleSystem = {
		RULE_FOR_WORKFLOWS : 0,
		RULE_FOR_APP_STUDIO_BUSINESS_RULES : 1,
		RULE_FOR_APP_STUDIO_FORM_RULES : 2
	};
	var ruleEngineType = ruleSystem.RULE_FOR_WORKFLOWS;

	let workflowEntities = {};
	let fetchInputFormBusinessRules;
	let fetchWorkflows;
	let handleSaveRule;
		
	var MULTIPLE_CONDITION_FIELD = "wfMultipleConditions";
	
	var COND_GROUP_TEMPLATE    = 	'<tr id="wfConditionGroupRow" class="wfCondGroupRow">'
							   +		'<td style="padding:20px 10px 10px 15px;">'							
							   +				'<fieldset id="wfConditionFieldSet" class="wfFieldSet">'
							   +					'<legend id="wfConditionLegend" class="wfLegend">Condition Group</legend>'
							   +						'<table id="wfConditionRuWhenTable" class="wfCondRuWhenTable" cellspacing="4" cellpadding="0" class="xtable">'
							   +						'<tbody>'
							   +								'<tr>'
							   +									'<td style="padding-left: 20px;">'
							   +										'<div style="padding:12px 0px 14px 0px">'
							   +											'<span id="cbop1">Match </span>'
							   +											'<select id="wfConditionBoolOp" class="wfCondBoolOp">'
							   +												'<option value="ANY">any</option>'
							   +												'<option value="ALL">all</option>'
							   +											'</select>'
							   +											'of the following conditions :'
							   +										'</div>'
							   + 									'</td>'
							   +								'</tr>'
							   +						 '</tbody>'
							   +						 '</table>'
							   +					'</fieldset>'
							   +			'</td>'
							   +		'</tr>';

var COND_ROW_TEMPLATE_RULES      =    '<tr id="wfConditionRow" class="wfCondRows">'
							   +			'<td style="padding-left:20px;">'
                                +				'<select id="wfConditionRowField" class="wfCondRowField">'
                                +					'<option value="0" style="color:#999">select a field...</option>'
                                +					'<option id="wfConditionRowFirstLine" value="0" style="color:#999" disabled="">-------------</option>'
                                +					'<option value="$form_type$" style="display:none;">The record</option>'
                                +					'<option id="wfConditionRowSecondEmptyLine" value="0" style="color:#999" disabled="">-------------</option>'
                                +				'</select>'
                                +				'<select id="wfConditionOp" class="wfCondOp" style="display: none;">'
                                +					'<option value="EQUALS">is equal to</option>'
                                +					'<option value="NOT_EQUALS">is not equal to</option>'
                                +					'<option class="stringOps" value="STARTS_WITH">starts with</option>'
                                +					'<option class="stringOps" value="ENDS_WITH">ends with</option>'
                                +					'<option class="stringOps" value="CONTAINS">contains</option>'
                                +					'<option class="stringOps" value="NOT_CONTAINS">does not contain</option>'
                                +					'<option class="nullCheckOps" value="IS_EMPTY">is empty</option>'
                                +					'<option class="nullCheckOps" value="IS_NOT_EMPTY">is not empty</option>'
                                +					'<option class="opSeparator" value="" disabled="" style="color: rgb(119, 119, 119);">-------------</option>'
                                +					'<option class="numericOps" value="LESS_THAN">&lt;</option>'
                                +					'<option class="numericOps" value="LESS_THAN_EQUALS">&lt;=</option>'
                                +					'<option class="numericOps" value="GREATER_THAN">&gt;</option>'
                                +					'<option class="numericOps" value="GREATER_THAN_EQUALS">&gt;=</option>'
                                +					'<option value="" disabled="" style="color: rgb(119, 119, 119);display:none;">-------------</option>'
                                +				'</select>'
                                +				'<select id="wfConditionRecordOp" class="wfRecordOp">'
                                +					'<option value="RECORD_ADDED">is being added</option>'
                                +					'<option value="RECORD_MODIFIED">is being modified</option>'
                                //+					'<option value="RECORD_DELETED">is being deleted</option>'
                                +				'</select>'
							   +				'<span id="wfConditionBtns" class="wfCondBtns">'
							   +					'<button id="wfConditionRemoveBtn" class="wfCondRemnoveBtn" value="-">-</button>'
							   +					'<button id="wfConditionAddBtn" class="wfCondAddBtn" value="+">+</button>'
							   +				'</span>'
							   +			'</td>'
							   +		'</tr>';


	var COND_ROW_TEMPLATE      =    '<tr id="wfConditionRow" class="wfCondRows">'
							   +			'<td style="padding-left:20px;">'
							   +				'<select id="wfConditionRowField" class="wfCondRowField">'
							   +					'<option value="0" style="color:#999">select a field...</option>'
							   +					'<option id="wfConditionRowFirstLine" value="0" style="color:#999" disabled="">-------------</option>'
							   +					'<option value="$form_type$" style="display:none;">The record</option>'
							   +					'<option id="wfConditionRowSecondEmptyLine" value="0" style="color:#999" disabled="">-------------</option>'
							   +					'<option value="$custom$">custom</option>'
							   +				'</select>'
							   +				'<select id="wfConditionOp" class="wfCondOp">'
							   +					'<option value="EQUALS">is equal to</option>'
							   +					'<option value="NOT_EQUALS">is not equal to</option>'
							   +					'<option class="stringOps" value="STARTS_WITH">starts with</option>'
							   +					'<option class="stringOps" value="ENDS_WITH">ends with</option>'
							   +					'<option class="stringOps" value="CONTAINS">contains</option>'
							   +					'<option class="stringOps" value="NOT_CONTAINS">does not contain</option>'
							   +					'<option class="nullCheckOps" value="IS_EMPTY">is empty</option>'
							   +					'<option class="nullCheckOps" value="IS_NOT_EMPTY">is not empty</option>'
							   +					'<option class="opSeparator" value="" disabled="" style="color: rgb(119, 119, 119);">-------------</option>'
							   +					'<option class="numericOps" value="LESS_THAN">&lt;</option>'
							   +					'<option class="numericOps" value="LESS_THAN_EQUALS">&lt;=</option>'
							   +					'<option class="numericOps" value="GREATER_THAN">&gt;</option>'
							   +					'<option class="numericOps" value="GREATER_THAN_EQUALS">&gt;=</option>'
							   +					'<option value="" disabled="" style="color: rgb(119, 119, 119);display:none;">-------------</option>'
							   +				'</select>'
							   +				'<select id="wfConditionRecordOp" class="wfRecordOp" style="display:none;">'
							   +					'<option value="RECORD_ADDED">is being added</option>'
							   +					'<option value="RECORD_MODIFIED">is being modified</option>'
							   //+					'<option value="RECORD_DELETED">is being deleted</option>'
							   +				'</select>'
							   + 				'<textarea placeholder="Write your javascript code" rows="10" id="wfConditionCustomScript" class="wfCustomScript" style="display:none;margin-left: 0px; margin-bottom: 15px; vertical-align: top;"></textarea>'
							   +				'<span id="wfConditionVal" class="wfCondRowVal">'
							   +					'<input type="text" size="25" style="">'
							   +					'<select id="wfConditionRowOptionSelect" class="wfCondRowOptionSelect" style="display:none;">'
							   +				    '</select>'
							   +					'<select id="wfConditionRowBooleanSelect" class="wfCondRowBooleanSelect" style="display:none;">'
							   +						'<option selected value="true">true</option>'
							   +						'<option value="false">false</option>'
							   +				    '</select>'
							   +				'</span>'
							   +				'<span id="wfConditionBtns" class="wfCondBtns">'
							   +					'<button id="wfConditionRemoveBtn" class="wfCondRemnoveBtn" value="-">-</button>'
							   +					'<button id="wfConditionAddBtn" class="wfCondAddBtn" value="+">+</button>'
							   +				'</span>'
							   +			'</td>'
							   +		'</tr>';

	var ACTION_TEMPLATE_RULES = 	'<tr id="wfActionRow" class="wfActRows">'
                                +		'<td valign="top" style="padding-left:20px;">'
                                +			'<select id="wfActionRowSelection" style="width:160px;" class="wfActRowSelection">'
                                +				'<option class="wfFormActs" value=""></option>'
                                +				'<option class="wfFormActs" value="SEND_EMAIL">Send email</option>'
                                +				'<option class="wfFormActs" value="RUN_WORKFLOW">Run workflow</option>'
                                +			'</select>'
                                + 			 '<span id="wfActionDeleteBtn" class="wfDeleteRuActionBtn"></span>'
                                +		'</td>'
                                +	'</tr>';
                                +	'<tr id="wfActionRow" class="wfOptionsRow"></tr>';


    var ACTION_TEMPLATE_OPTIONS_RULES = "<tr id=\"wfActionRow\" class=\"wfOptionsRow\"></tr>";

    var renderWorkflowInput = function renderWorkflowInput(input) {

        return "<div  class=\"form-group wcWorkflowInputRow\" style=\"margin-right: 0\"><label class=\"col-xs-12 col-lg-4 wcWorkflowInputKey\" title=\"" + input.id + "\">" + input.id + "</label>\n                <div class=\"col-xs-12 col-lg-8 input-group\">\n                    <input type=\"text\" class=\"form-control wcWorkflowInputValue\" data-isMulti=\"" + input.isMulti + "\" value=\"" + input.value + "\" data-inputId=\"" + input.id + "\" aria-describedby=\"basic-addon1\"/>\n                    <span data-ng-hide=\"isTable\" class=\"input-group-addon\" id=\"basic-addon1\">f(x)</span>\n                </div>\n            </div>\n        ";
    };

    var getWorkflowSelectWithOptionsHtml = function getWorkflowSelectWithOptionsHtml(workflowEntities, actionIndex) {
        var selectOptions = Object.keys(workflowEntities).map(function (workflowKey) {
            return (
                "<option value=\"" + workflowKey + "\">" + workflowKey + "</option>"
            );
        });
        return "<select id=\"" + actionIndex + "_workflowOptionsSelect\" class=\"workflowOptionsSelect\">" + selectOptions.join("") + "</select>";
    };

    var getWorkflowInputsHtml = function getWorkflowInputsHtml(inputs, action) {
        var actionInputs = action.actionDetails ? action.actionDetails.inputs : [];
        var inputsArrRender = inputs ? inputs.map(function (input) {
            var actionInput = actionInputs.find(function (ainput) {
                return ainput.id === input.id;
            });
            return Object.assign(input, actionInput && { value: actionInput.value });
        }).map(renderWorkflowInput) : [];
        return "<div class=\"workflowInputs\" style=\"max-width: 400px; background: white; padding: 10px 20px;\">" + inputsArrRender.join("") + "</div>";
    };

    var getWorkflowActionOptionHtml = function getWorkflowActionOptionHtml(inputs, action) {
        return "<div id=\"wfActionOptions\" style=\"padding-left: 20px\"> " + getWorkflowInputsHtml(inputs, action) + "</div>";
    };


	var ORIGINAL_ACTION_TEMPLATE 	=	'<tr id="wfActionRow" class="wfActRows">'
							+		'<td valign="top" style="padding-left:20px;">'
							+			'<select id="wfActionRowSelection" style="width:160px;" class="wfActRowSelection">'
							//+				'<option value="$removeAction$">&lt; remove this action &gt;</option>'
							//+				'<option value="" disabled="" style="color: rgb(119, 119, 119);">-------------</option>'
							+				'<option class="wfFormActs" selected value="SHOW">show</option>'
							+				'<option class="wfFormActs" value="HIDE">hide</option>'
							+				'<option class="wfFormActs" value="REQUIRE">require</option>'
							+				'<option class="wfFormActs" value="UNREQUIRE">unrequire</option>'
							+				'<option class="wfFormActs" value="READONLY">make read-only</option>'
							+				'<option class="wfFormActs" value="EDITABLE">make editable</option>'
							+				'<option class="wfChangeAct" value="CHANGE_FIELD_VALUE">change</option>'
							+				'<option class="wfActShowMessage" value="SHOW_MESSAGE">show message</option>'
							+				'<option class="wfSubmitAct" value="CANCEL_SUBMIT" style="display:none;">cancel submit form</option>'
							+				'<option class="wfActFailValidation" value="FAIL_VALIDATION">fail validation</option>'
							+				'<option class="wfActCustom" value="CUSTOM">custom</option>'							
//							+				'<option value="" disabled="" style="color: rgb(119, 119, 119);">-------------</option>'
//							+				'<option value="1">change</option><option value="9">display a message</option>'
							+			'</select>'
							+			'<select id="wfActionRowField" class="wfActRowField">'
							+				'<option value="" style="color: rgb(153, 153, 153);">select a field...</option>'
							+				'<option id="wfActionRowFirstEmptyLine" value="" disabled="" style="color: rgb(119, 119, 119);">-------------</option>'
							+			'</select>'
							+			'<span id="wfActionRowFieldValSpan" class="wfActRowFieldValSpan" style="display:none"><span class="wfChangeToLbl"> to</span>'
							+					'<input type="text" size="25" style="display:none;margin-left: 7px;">'
							+					'<select id="wfActionRowOptionSelect" class="wfActRowOptionSelect" style="display:none;margin-left: 7px;">'
							+				    '</select>'
							+					'<select id="wfActionRowBooleanSelect" class="wfActRowBooleanSelect" style="display:none;margin-left: 7px;">'
							+						'<option selected value="true">true</option>'
							+						'<option value="false">false</option>'
							+				    '</select>'
							+					'<textarea rows="4" id="wfActionRowMessage" class="wfActRowMessage" style="display:none;margin-left: 0px;margin-bottom: 15px;vertical-align: top;">'
							+				    '</textarea>'
							+					'<select id="wfActionRowMsgType" style="width:160px;margin-left: 20px;display:none;" class="wfActRowMsgType">'
							+						'<option value="INFO">Information</option>'
							+						'<option value="WARNING">Warning</option>'
							+						'<option value="ERROR">Error</option>'
							+					'</select>'
							+					'<select id="wfActionRowMsgBtnTypeSelection" style="width:160px;display:none;" class="wfActRowMsgBtnTypeSelection">'
							+						'<option class="wfOkBtn" value="OK">OK</option>'
							+						'<option class="wfOkCancelBtn" value="OK_CANCEL">OK/Cancel</option>'
							+						'<option class="wfYesNoBtn" value="YES_NO">Yes/No</option>'
							+					'</select>'
							+				'</span>'
							+ 			 '<span id="wfActionDeleteBtn" class="wfDeleteRuActionBtn"></span>'
							+			'</td>'
							+		'</tr>';

	var ACTION_TEMPLATE = ORIGINAL_ACTION_TEMPLATE;

	var formTypeMap = {
		"added":"added",
		"modified" : "modified"
	};

	var formEventType = {
		"opened" : "opened",
		"cancelled" : "cancelled",
		"submitted" : "submitted"
	};

	var inputEntriesHtml = '';
	var condCnt = 0;
	var actionCnt = 0;

	var operatorMap = {
			EQUALS : "is equal to",
			NOT_EQUALS : "is not equal to",
			LESS_THAN : "<",
			LESS_THAN_EQUALS : "<=",
			GREATER_THAN : ">",
			GREATER_THAN_EQUALS : ">=",
			IS_EMPTY : "is empty",
			IS_NOT_EMPTY : "is not empty",
			STARTS_WITH : 'starts with',
			ENDS_WITH : 'ends with',
			CONTAINS : 'contains',
			NOT_CONTAINS : 'does not contain'
	}

	var recordOperatorMap = {
		"RECORD_ADDED" : "is being added",
		"RECORD_MODIFIED" : "is being modified",
		"RECORD_DELETED" : "is being deleted"
	};


	var SHOW = "SHOW";
	var HIDE = "HIDE";
	var REQUIRE = "REQUIRE";
	var UNREQUIRE = "UNREQUIRE";
	var READONLY = "READONLY";
	var EDITABLE = "EDITABLE";

	var oppositeActionTypeMap = {
			SHOW : HIDE,
			HIDE : SHOW,
			REQUIRE : UNREQUIRE,
			UNREQUIRE : REQUIRE,
			READONLY : EDITABLE,
			EDITABLE : READONLY
	}

	var rulesActionTypeMap = {
	    SEND_EMAIL: 'Send Email',
        RUN_WORKFLOW: 'Run Workflow'
    }



	var oppositeOperatorTypeMap = {
			"EQUALS" : "NOT EQUALS",
			"NOT EQUALS" : "EQUALS",
			"LESS_THAN" : "GREATER_THAN",
			"GREATER_THAN" : "LESS_THAN",
			"GREATER_THAN_EQUALS" : "LESS_THAN_EQUALS",
			"LESS_THAN_EQUALS" : "GREATER_THAN_EQUALS"
	};



	var SHOW = "SHOW";
	var HIDE = "HIDE";
	var REQUIRE = "REQUIRE";
	var UNREQUIRE = "UNREQUIRE";
	var READONLY = "READONLY";
	var EDITABLE = "EDITABLE";
	var CHANGE_FIELD_VALUE = "CHANGE_FIELD_VALUE";
	var CANCEL_SUBMIT = "CANCEL_SUBMIT";

	var	actionTypeMap = {
		SHOW : "show",
		HIDE : "hide",
		REQUIRE : "require",
		UNREQUIRE : "unrequire",
		READONLY : "make readonly",
		EDITABLE : "make editable",
		CHANGE_FIELD_VALUE : "change",
		SHOW_MESSAGE : "display a message",
		CANCEL_SUBMIT : "do not submit the form",
		FAIL_VALIDATION : "fail validation with message",
		CUSTOM : "execute custom script"
	}

	var rules = [];

    var hasSchema = function() {
        return currReactInfo && currReactInfo.schema;
    }

	var isOptionsAvailable = function(fieldName){
		return fieldName && (isClientEntity(fieldName) || hasSchema() && currReactInfo.schema.properties[fieldName].options && currReactInfo.schema.properties[fieldName].options.length > 0);
	}

	var isClientEntity = function(fieldName){
		return fieldName && fieldTypeMap[fieldName] && fieldTypeMap[fieldName] === "commvault.msgs.CvEntities.ClientEntity"?true:false;
	}

	var isBooleanType = function(fieldName){
		return fieldName && fieldTypeMap[fieldName] && fieldTypeMap[fieldName] === "java.lang.Boolean"?true:false;
	}

	var isNumericType = function(fieldName){
		return fieldName && fieldTypeMap[fieldName] && fieldTypeMap[fieldName] === "java.lang.Integer"?true:false;
	}

	var getOptionsInfoForComplexEntity = function(optionsJsonArr){
			var options = [];
			
			if(optionsJsonArr!=undefined){
			
					optionsJsonArr = JSON.parse(optionsJsonArr);
					
					if(optionsJsonArr.records!=undefined){
						optionsResp = {};
						var records = optionsJsonArr.records;
						
						
						var noOfRecords = records.length;
						for(i = 0 ;i<noOfRecords; i++)
						{
							var curRecord = records[i][0];
							options.push({name:curRecord,val:curRecord});
						}
					}
			}
		
		return options;
	}

	var getOptions = function(fieldName){
		if(isClientEntity(fieldName))
		{
			return getOptionsInfoForComplexEntity(currReactInfo.schema.properties[fieldName].optionsJsonArr);
		}
		
		if (!hasSchema()) 
			return;
		
		return currReactInfo.schema.properties[fieldName].options;
	}

	var getOppositeActionLbl = function(type){
		return actionTypeMap[oppositeActionTypeMap[type]];
	}

	var getOppositeOperatorLbl = function(type){
		return operatorMap[oppositeOperatorTypeMap[type]];
	}

	var updateRulePositiionColumn = function(){
		$("#wfRulesTable tbody tr td.rulePosition").each(function(index){
			$(this).html(index+1);
		});
	}

	var moveUp = function(index){
		$("tr.selected").insertBefore($("tr.selected").prev());

		 if (index === 0) {
		        return;
		 }

		 [rules[index], rules[index-1]] = [rules[index-1], rules[index]];
		 updateRulePositiionColumn();
		 displayRuleNo(getSelectedRulePosition());
	}

	var moveDown = function(index){
		$("tr.selected").insertAfter($("tr.selected").next());

		 if (index === rules.length - 1) {
		        return;
		 }

		 [rules[index], rules[index+1]] = [rules[index+1], rules[index]];
		 updateRulePositiionColumn();
		 displayRuleNo(getSelectedRulePosition());
	}

	var getSelectedRulePosition = function(){
		return $("#wfRulesTable tbody tr.selected").index();
	}

	var addListsnerForRules = function(){
		$(".data-table-list-row").off("click").on("click",function(){
			var $selectedRule = $(this);
			$("tr").removeClass("selected");
			$selectedRule.addClass("selected");
			initializeRuleDetail(updateRuleDetailForm,rules[$selectedRule.index()]);
		});
	}

	var addNavigationListeners = function(){
		$("#wfRuleUp").off("click").on("click",function(event){
			event.preventDefault();
			moveUp($("tr.selected").index());
		});

		$("#wfRuleDown").off("click").on("click",function(event){
			event.preventDefault();
			moveDown($("tr.selected").index());
		});
	}

	var addRuleOperationsListeners = function(){
		$("#wfAddNewRule").off("click").on("click",function(event){
			event.preventDefault();
			addRule();
		});

		$("#wfPreviewRule").off("click").on("click",function(event){
			event.preventDefault();
			previewCustomization();
		});

		$("#wfSaveRule").off("click").on("click",function(event){
			event.preventDefault();
			saveCustomization();
		});

		$("#wfPreviewCode").off("click").on("click",function(event){
			event.preventDefault();
			previewCustomization();
		});

		$("#wfSaveAndDeployRule").off("click").on("click",function(event){
			event.preventDefault();
			saveCustomization(true);
		});

		$("#wfSaveCode").off("click").on("click",function(event){
			event.preventDefault();
			saveCustomization(false);
		});
	}

	var saveRule = function(saveInTempRules,tempRules){
		var rule = constructRuleJson();

		if(isFormsRuleBuilder() || isAppStudioFormsRuleBuilder()){

		var desiredRule = getSelectedRulePosition();
		var statusMsg = "";

		if(saveInTempRules!=undefined && saveInTempRules === true)
		{
			if(desiredRule < 0)
			{
				tempRules.push(rule);
			}
			else
				tempRules[desiredRule] = rule;
		}
		else
		{
		if(desiredRule < 0)
		{
				statusMsg = "rule added!";
			rules.push(rule);
		}
			else{
				statusMsg = "rule updated!";
			rules[desiredRule] = rule;
			}

			displayInfoMessage(statusMsg);
		displayRuleTable(TABLE_CONTAINER);
		$("#wfRuleDetailArea").hide();
		deSelectRule();
	}
	}
		else if(isAppStudioBusinessRuleBuilder()){
			// changes for business rules
			//operation : saving a rule.
		}
	}

	var previewCustomization = function() {

		var curEpoch = new Date().getTime();

        var fullPageForm = $('<form id="wfPreviewForm" method="post" target="POPUPW' + curEpoch + '">').attr({
                        action :  "/webconsole/forms/preview"
        }).appendTo(document.body);

        var paramMap = {};

        for ( var inputName in paramMap) {
                        if (paramMap.hasOwnProperty(inputName)) {
                                        $('<input type="hidden" />').attr({
                                                        name : inputName,
                                                        value : paramMap[inputName]
                                        }).appendTo(fullPageForm);
                        }
        }

        $("#wfPreviewForm").submit(function(event){
        		var POPUPW = window.open('about:blank','POPUPW' + curEpoch,'width=938,height=458,left=-1500');
        		var ruleInfo = {};

        		if($("#wfRuleDetailArea:visible").length > 0)
        		{
        			var tempRules = $.extend([],true,rules);
        			saveRule(true,tempRules);
        			ruleInfo.rules = tempRules;
        		}
        		else
        		ruleInfo.rules = rules;

        		inputFormForActivity.properties.rules = ruleInfo;
        		inputFormForActivity.properties.javaScript = $("#wfJSArea").val();
        		inputFormForActivity.properties.css = $("#wfCSSArea").val();

        		POPUPW.sessionStorage["previewInputForm"] = JSON.stringify(inputFormForActivity);
        });

        fullPageForm.submit();
        fullPageForm.remove();
	};


	var displayRuleTable = function(container){
		$("#wfRulesTableAreaRow").addClass("active");
		$(container).empty();
		if(rules && rules.length>0){
			jQuery.each(rules,function(index){
				createRuleRow(this,container,index+1);
			})
			addListsnerForRules();
		}
	}

	var getOperatorText = function(op){
		return operatorMap[op];
	}

	var getRecordOperatorText = function(op){
		return recordOperatorMap[op];
	}

	var getActionText = function(action){
		return actionTypeMap[action["type"]] + ' ' + (action["type"] === "CUSTOM" || action["type"] === "FAIL_VALIDATION" || action["type"] === "SHOW_MESSAGE" || action["type"] === "CANCEL_SUBMIT"?"":getDispNameForInputEntry(action["field"])) + (action["type"] === "CHANGE_FIELD_VALUE"?" to " + action.value:action["type"] === "FAIL_VALIDATION"?" [" + action.value + "]":"");
	}

	var getLabelForValue = function(field,value){
		var options = getOptions(field);
		var label = options.filter(function(item){
			return item.val == value; 
		})[0];
		
		if(label == undefined)
			label = value;
		else
			label = label.name;
		
		return label;
	}

	var getRuleDescription = function(rule){
		var actionText = getActionText(rule["actions"][0]);
		var ruleDesc = "when ";
		var ruleTriggers = rule.ruleTriggers;
		var eventText = "";

		if(ruleTriggers)
		{
			if(ruleTriggers.OnFormFormOpened!=undefined && ruleTriggers.OnFormFormOpened === true)
				eventText += " form is opened";
			else if(ruleTriggers.onFormCancelled!=undefined && ruleTriggers.onFormCancelled === true)
				eventText += " form is cancelled";
			else if(ruleTriggers.onFormSubmitted!=undefined && ruleTriggers.onFormSubmitted === true)
				eventText += " form is submitted";

			ruleDesc += eventText;
			if(eventText!="")
			ruleDesc += ' and ';
		}

		if(!rule["conditionGroups"] || rule["conditionGroups"].length == 0)
		{
			ruleDesc = (eventText!=""?'when ' + eventText:'');
			return ruleDesc != ""? ruleDesc + ' ' + actionText:actionText;
		}
		else
		{
			actionText = "," + actionText;
		var cond =	rule["conditionGroups"][0]["conditions"][0];

		if(cond["field"] === wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD)
		{
			var field = "custom script ";
			return 'when ' + field + ' returns true' + actionText;
		}
		else if(cond["field"] === wfUtils.constants.FORMS_RECORD_OPERATION_FIELD)
		{
			var field = "record ";
			return 'when ' + field + ' ' + getRecordOperatorText(cond["value"]) + actionText;
		}
		else if(cond["op"] && (cond["op"] == "IS_EMPTY" || cond["op"] == "IS_NOT_EMPTY"))
				return ruleDesc + getDispNameForInputEntry(cond["field"]) + ' ' + getOperatorText(cond["op"]) + actionText;
		else
				return ruleDesc + getDispNameForInputEntry(cond["field"]) + ' ' + getOperatorText(cond["op"]) + ' ' + (isOptionsAvailable(cond["field"])?getLabelForValue(cond["field"],cond["value"]):cond["value"].replace(/</g,"&lt;").replace(/>/g,"&gt;")) + actionText;
		}
	}

	var createRuleRow = function(rule,container,position){
		var ruleTemplate = '';
		if(rule){
			ruleTemplate +=  '<tr class="data-table-list-row ' + (rule.enabled!=undefined && rule.enabled === false?'disabledRule':'') +  '">'
						   		+ '<td class="rulePosition">' + position + '</td>'
						   		+ '<td class="alertName">'
						   		+ '<span class="tableCellContainer vw-table-cell-container">'
						   		+ '<span class="vw-text">' + getRuleDescription(rule) + '</span></span>'
						   		+ '</td>';
						   		+ '</tr>';

			$(container).append(ruleTemplate);
		}
	}

	var addRule = function(){
		initializeRuleDetail(addRuleCallBack);
	}

	var addRuleCallBack = function(){
		displayRuleNo(isFormsRuleBuilder() || isAppStudioFormsRuleBuilder()?$("#wfRulesTable tbody tr").length:-1);
		addAction();
		addConditionGroup();
		$("#wfDeleteRuleBtn").hide();
		$("#wfRuleDetailArea").show();
		$("#wfRuOtherwiseRow").hide();
		deSelectRule();
		displayAppropriateActions($("#wfActRows").find(".wfActRow").eq(0));

		var action = {};
		action["type"] = $("#wfActRows").find(".wfActRow").eq(0).find(".wfActRowSelection").val();

		populateActionDropdownWithOptions(action,"#" + $("#wfActRows").find(".wfActRows").eq(0).find(".wfActRowField").attr("id"));
	}

	var deSelectRule = function(){
		$("#wfRulesTable tbody tr").removeClass("selected");
	}

	var getRules = function(){
		return rules;
	}

	var displayRuleNo = function(ruleNo){
		$("#wfRuDetailsHead").html(ruleNo > -1?"Rule #" +( parseInt(ruleNo)+1):"Rule");
	}

	var getOptionhtmlForInputEntry = function(dispName){
		return '<option val="' + dispName + '">' + dispName + '</option>';
	}

	var initializeRuleDetail = function(postInitCallBack,params){
		if(!RULE_DETAIL_FORM)
		{
			cvUtil.loadPage(cvUtil.getContextPath() + "/forms/customize/ruleDetail.jsp", {}, function(data) {
				RULE_DETAIL_FORM = data;
				initializeRuleDetailCallBack(postInitCallBack,params);
			});
			return;
		}
		initializeRuleDetailCallBack(postInitCallBack,params);
	};

	var initializeRuleDetailCallBack = function(postInitCallBack,params){
		$("#wfRuleDetailArea").html(RULE_DETAIL_FORM);
		addButtonListeners();

        hideRuleElelemntsForAdminConsole();

        if (isAppStudioBusinessRuleBuilder()) {
            $("#wfRuleType").hide();
            $("#wfRuleTypeRules").show();
        }

		if(postInitCallBack)
			postInitCallBack(params);
	}

	var populateDropdownWithFields = function(container){
		if(inputEntriesHtml.trim()!="")
		{
			$(inputEntriesHtml).insertAfter($(container))
		}

	}

	var getConditionGroupTemplate = function(index){
		var condGroupTemplate = COND_GROUP_TEMPLATE;
		condGroupTemplate = condGroupTemplate.replace(/wfCondition/g,index + "_wfCondition");
		return condGroupTemplate;
	}

	var getConditionTemplate = function(index){
		var condTemplate = COND_ROW_TEMPLATE;
		condTemplate = condTemplate.replace(/wfCondition/g,index + "_wfCondition");
		return condTemplate;
	}

	var getActionTemplate = function(index){
		var actTemplate = ACTION_TEMPLATE;
		actTemplate = actTemplate.replace(/wfAction/g,index + "_wfAction");
		return actTemplate;
	}

	var getActionOptionsTemplate = function(index){
		var actTemplate = ACTION_TEMPLATE_OPTIONS_RULES;
		actTemplate = actTemplate.replace(/wfAction/g,index + "_wfAction");
		return actTemplate;
	}

	var displayValueComponent = function($container){
		var wfCondOp = $container.siblings(".wfCondOp").val();
		if(wfCondOp && (wfCondOp === "IS_EMPTY" || wfCondOp === "IS_NOT_EMPTY"))
		{
			$container.siblings(".wfCondRowVal").hide();
		}
		else
		{
			if(isRecordField($container) || isCustomScriptField($container)){
				$container.siblings(".wfCondRowVal").hide();
			}
			else
			{
			$container.siblings(".wfCondRowVal").show();
		}
	}
	}

	var addListenerForFormCondRowField = function(container){
		$(container).off("change").on("change",function(event){
			event.preventDefault();
			if($(this).val() === "$removeCond$")
			{
				$(this).closest(".wfCondRows").remove();
				return;
			}

			displayAppropriateOperators($(this));
			displayValueComponent($(this));
		});

		$(container).siblings(".wfCondOp").off("change").on("change",function(event){
			event.preventDefault();
			displayValueComponent($(this).siblings(".wfCondRowField"));
		});
	}

	var getInputsFromWorkflow = function(workflowEntity) {
        var inputForm = workflowEntities[workflowEntity].deployments && workflowEntities[workflowEntity].deployments[0].inputForm;

        return inputForm
            ? inputForm.entries && inputForm.entries.map(function (input) {
				  return { id: input.inputName, value: "", isMulti: input.listType };
                })
            : [];
    }

	var addListenerToWorkflowOptionSelection = function(action, selectContainer, rowContainer) {
	    var $selectContainer = $(selectContainer);
        var actionIndex = getIndexFromContainer(rowContainer);
        $selectContainer.off("change").on("change",function(event) {
            event.preventDefault();
            var workflowName = $(this).val();
            if (!workflowName) return;
            var inputs = getInputsFromWorkflow(workflowName);
            var inputsHtml = getWorkflowActionOptionHtml(inputs, action);

            //if not exists options container we create it
            if (!$(rowContainer+'.wfOptionsRow').length) {
                var actionOptionsTemplate = getActionOptionsTemplate(actionIndex);
                $(actionOptionsTemplate).insertAfter(rowContainer);
            }

            //render workflow inputs inside option container;
            $(rowContainer+'.wfOptionsRow').find('.workflowInputs').remove();
            if (inputs && inputs.length > 0) $(rowContainer+".wfOptionsRow").append(inputsHtml);
        })

    }

    var getIndexFromContainer = function(container) {
	    var end = container.indexOf('_');
	    var start = container.indexOf('#') + 1;

	    return container.slice(start, end);
    }

	/*var populateRuleActionOptions = function(action, container) {
	    var type = action.type;
	    var actionIndex = getIndexFromContainer(container);
	    $(container).find(".wfActRowSelection").siblings().not(".wfDeleteRuActionBtn").remove();
	    $(container+".wfOptionsRow").remove();
        if (type === 'SEND_EMAIL') {

        } else if (type === 'RUN_WORKFLOW') {
            var html = getWorkflowSelectWithOptionsHtml(workflowEntities, actionIndex);
            var actionOptionsTemplate = getActionOptionsTemplate(actionIndex);

            $(html).insertAfter('#${actionIndex}_wfActionRowSelection');
            $(actionOptionsTemplate).insertAfter(container);

            addListenerToWorkflowOptionSelection(action, `#${actionIndex}_workflowOptionsSelect`, `#${actionIndex}_wfActionRow`);
            if(action.actionDetails) $("#"+actionIndex+"_workflowOptionsSelect").val(action.actionDetails.workflowName).trigger('change');
        }
    };*/

	var addListenerForFormActionRowField = function(container){
		var $container = $(container);
		$(container).off("change").on("change",function(event){
			event.preventDefault();
			var workflowName = $(this).val();
/*			if($(this).val() === "$removeAction$")
			{
				if($("#wfRulesActionsTable tbody .wfActRows").length === 1)
				{
					alert("A rule must have atleast one action");
					return;
				}
				$(this).closest(".wfActRows").remove();
			}*/

			//displayAppropriateOperators($(this));
            if (isAppStudioBusinessRuleBuilder()) {
                var action = {
                    type: $(this).val()
                };
                //populateRuleActionOptions(action, `#${$(this).closest('tr').attr('id')}`);
            } else {
                populateActionDropdownWithOptions({field:$(this).siblings(".wfActRowField").val(),type:$(this).val(),value:""},"#" + $(this).siblings(".wfActRowField").attr("id"));
            };


		});

		$container.siblings(".wfActRowField").off("change").on("change",function(event){
			event.preventDefault();
			populateActionDropdownWithOptions({field:$(this).val(),type:$(this).siblings(".wfActRowSelection").val(),value:""},"#" + $(this).attr("id"));
		});

		$container.siblings(".wfDeleteRuActionBtn").off("click").on("click",function(event){
				if($("#wfRulesActionsTable tbody .wfActRows").length === 1)
				{
					alert("A rule must have atleast one action");
					return;
				}
				var rowContainer = $(this).parent().parent().attr("id")
                $("#" + rowContainer + ".wfOptionsRow").remove();

                $(this).closest(".wfActRows").remove();
		})
	}

	var addConditionGroup = function(condGroup){
		var desiredIndex = condCnt++;
		$("#wfCondGroups tbody").append(getConditionGroupTemplate(desiredIndex));
		var $condGroupContainer = $("#" + desiredIndex + "_wfConditionGroupRow .wfCondRuWhenTable tbody");
		if(condGroup)
		{
			jQuery.each(condGroup.conditions,function(index){
				var condInfo = $.extend({}, true,this);
				condInfo.field = getDispNameForInputEntry(this.field);
				addCondition($condGroupContainer,condInfo);
			});
		}
		else
			addCondition($condGroupContainer);

		populateConditionGroup(condGroup,"#" + desiredIndex + "_wfConditionGroupRow");
	}

	var addCondition = function($condGroupContainer,cond){
		var desiredIndex = condCnt++;
		$condGroupContainer.append(getConditionTemplate(desiredIndex));
		populateDropdownWithFields("#" + desiredIndex + "_wfConditionRowField #" + desiredIndex + "_wfConditionRowSecondEmptyLine");

		if(isFormsRuleBuilder()){
			$("#" + desiredIndex + "_wfConditionRowField option[value='$form_type$']").hide();
			$("#" + desiredIndex + "_wfConditionRowField #" + desiredIndex + "_wfConditionRowFirstLine" ).hide();
		}
		else {
			$("#" + desiredIndex + "_wfConditionRowField option[value='$form_type$']").show();
			$("#" + desiredIndex + "_wfConditionRowField #" + desiredIndex + "_wfConditionRowFirstLine" ).show();
		}

		addListenerForFormCondRowField("#" + desiredIndex + "_wfConditionRowField");
		populateCondition(cond,"#" + desiredIndex + "_wfConditionRowField");
		addListenerForConditionRowBtns("#" + desiredIndex + "_wfConditionRowField");
		$("#wfRunConditionsSection").show();
	}

	var addListenerForConditionRowBtns = function(container){
		var $container = $(container);

		$container.siblings(".wfCondBtns").find(".wfCondRemnoveBtn").off("click").on("click",function(event){
			event.preventDefault();
			$(this).closest(".wfCondRows").remove();
		});

		$container.siblings(".wfCondBtns").find(".wfCondAddBtn").off("click").on("click",function(event){
			event.preventDefault();
			addCondition($(this).closest(".wfCondGroupRow").find(".wfCondRuWhenTable tbody"));
		});

	}

	var addAction = function(action){
		var desiredIndex = actionCnt++;
		$("#wfRulesActionsTable tbody").append(getActionTemplate(desiredIndex));
		populateDropdownWithFields("#" + desiredIndex + "_wfActionRowField #" + desiredIndex + "_wfActionRowFirstEmptyLine");
		addListenerForFormActionRowField("#" + desiredIndex + "_wfActionRowSelection");
		populateAction(action,"#" + desiredIndex + "_wfActionRowSelection");
		displayAppropriateActions($("#" + desiredIndex + "_wfActionRowField").closest(".wfActRows"),action);
		if(action === undefined){
			action = {};
			action["type"] = $("#" + desiredIndex + "_wfActionRowField").closest(".wfActRows").find(".wfActRowSelection").val();
		}
		populateActionDropdownWithOptions(action,"#" + desiredIndex + "_wfActionRowField");
		$("#wfRunActionsSection").show();
	}

	var hideActionShowMessage = function($actionRowVal){

		var $actRowMsg = $actionRowVal.find(".wfActRowMessage");
		var $msgType = $actionRowVal.find(".wfActRowMsgType");
		var $msgBtnType = $actionRowVal.find(".wfActRowMsgBtnTypeSelection");

		$actRowMsg.hide();
		$msgType.hide();
		$msgBtnType.hide();
	}

	var showActionShowMessage = function($actionRowVal,actionInfo,action){

		var popUpMessage = action.popUpMessage?action.popUpMessage:undefined;
		var showOnlyOkBtn = actionInfo && actionInfo.showOnlyOkBtn != undefined?actionInfo.showOnlyOkBtn:false;
		var $actRowMsg = $actionRowVal.find(".wfActRowMessage");
		var $msgType = $actionRowVal.find(".wfActRowMsgType");
		var $msgBtnType = $actionRowVal.find(".wfActRowMsgBtnTypeSelection");
		var $okBtn = $msgBtnType.find(".wfOkBtn");
		var $okCancelBtn = $msgBtnType.find(".wfOkCancelBtn");
		var $yesNoBtn = $msgBtnType.find(".wfYesNoBtn");

		if(showOnlyOkBtn)
		{
			$okCancelBtn.hide();
			$yesNoBtn.hide();
		}
		else
		{
			$okBtn.show();
			$okCancelBtn.show();
			$yesNoBtn.show();
		}

		if(popUpMessage)
		{
			$actRowMsg.val(popUpMessage.message);
			$msgBtnType.val(popUpMessage.button);
			$msgType.val(popUpMessage.type);
		}

		$actRowMsg.show();
		$msgType.show();
		$msgBtnType.show();
	}

    var populateActionDropdownWithOptions = function(action,container){
        if(action && action.type != undefined)
        {
            var $container =  $(container);
            var $actionRowVal = $container.siblings(".wfActRowFieldValSpan");
            var $actRowInput = $actionRowVal.find("input");
            var $actRowSelect = $actionRowVal.find(".wfActRowOptionSelect");
            var $actRowBoolean = $actionRowVal.find(".wfActRowBooleanSelect");
            var $actRowToLbl = $actionRowVal.find(".wfChangeToLbl");

            $actionRowVal.find(".wfActRowMessage").attr("rows",4)
            
            if (isAppStudioBusinessRuleBuilder()) {
                var actionDetails = action.actionDetails && JSON.parse(action.actionDetails);
                //populateRuleActionOptions(Object.assign(action, {actionDetails}), container);
            }

            if(action.type === "CUSTOM"){
                hideActionShowMessage($actionRowVal);
                $actRowInput.hide();
                $actRowSelect.hide();
                $actRowBoolean.hide();
                $actionRowVal.show();
                $actRowToLbl.hide();
                $container.hide();
                if(action.value!=undefined && action.value!="")
                    $actionRowVal.find(".wfActRowMessage").attr("rows",10).val(action.value);
                $actionRowVal.find(".wfActRowMessage").show();
            }
            else if(action.type === "FAIL_VALIDATION"){
                hideActionShowMessage($actionRowVal);
                $actRowInput.hide();
                $actRowSelect.hide();
                $actRowBoolean.hide();
                $actionRowVal.show();
                $actRowToLbl.hide();
                $container.hide();
                if(action.value!=undefined && action.value!="")
                    $actionRowVal.find(".wfActRowMessage").val(action.value);
                $actionRowVal.find(".wfActRowMessage").show();
            }
            else if(action.type === "CANCEL_SUBMIT"){
                $actRowInput.hide();
                $actRowSelect.hide();
                $actRowBoolean.hide();
                $actionRowVal.show();
                $container.hide();
                $actRowToLbl.hide();
                showActionShowMessage($actionRowVal,{showOnlyOkBtn:true},action);
            }
            else if(action.type === "CHANGE_FIELD_VALUE") {

                var inputName = getInputEntryName(action.field);

                if(isOptionsAvailable(inputName)){
                    $actRowSelect.show();
                    $actRowBoolean.hide();
                    $actRowInput.hide();
                    populateOptionsForCondRowValue($actRowSelect,inputName);
                    $actRowSelect.val(action.value);
                }
                else if(isBooleanType(inputName)){
                    $actRowSelect.hide();
                    $actRowInput.hide();
                    $actRowBoolean.show();
                    if(action.value!=undefined)
                        $actRowBoolean.val(action.value+"");
                }
                else {
                    $actRowInput.val(action.value);
                    $actRowInput.show();
                    $actRowSelect.hide();
                    $actRowBoolean.hide();
                }
                $actionRowVal.show();
                $actRowToLbl.show();
                $container.show();
                hideActionShowMessage($actionRowVal);
            }
            else if(action.type === "SHOW_MESSAGE") {
                $actRowInput.hide();
                $actRowSelect.hide();
                $actRowBoolean.hide();
                $actionRowVal.show();
                $actRowToLbl.hide();
                $container.hide();

                var $ruleType = $("#wfRuleDetailArea #wfRuleType input[name='wfCondMatchType']:checked").val();
                var actionInfo = undefined;
                if($ruleType === "ON_FIELD_CHANGE" || ($ruleType === "ON_EVENT" && $("#wfFormEventType").val() === "FORM_OPENED")){
                    actionInfo = {showOnlyOkBtn:true};
                }
                showActionShowMessage($actionRowVal,actionInfo,action);
            }
            else
            {
                $actionRowVal.hide();
                $container.show();
            }
        }
    }

	var displayAppropriateActionsForAllActions = function(){

		$(".wfActRows").each(function(index){
			var $actionContainer = $(this);
			displayAppropriateActions($actionContainer);
			populateActionDropdownWithOptions({field:$actionContainer.find(".wfActRowField").val(),type:$actionContainer.find(".wfActRowSelection").val(),value:""},"#" + $actionContainer.find(".wfActRowField").attr("id"));
		});
	}

	var displayAppropriateActions = function($actionContainer,action) {
		var $container = $("#wfFormEventType");
		var $wfSubmitAct = $actionContainer.find(".wfSubmitAct");
		var $wfFormActs = $actionContainer.find(".wfFormActs");
		var $wfChangeAct = $actionContainer.find(".wfChangeAct");
		var $wfActionsDropDown = $actionContainer.find(".wfActRowSelection");
		var $ruleType = $("#wfRuleDetailArea #wfRuleType input[name='wfCondMatchType']:checked").val();
		var actionType = action && action.type?action.type:undefined;
		var formsActionMap = {
				"SHOW" : true,
				"HIDE" : true,
				"REQUIRE" : true,
				"UNREQUIRE" : true,
				"READONLY" : true,
				"EDITABLE" : true,
				"CHANGE_FIELD_VALUE" : true,
				"SHOW_MESSAGE" : true,
				"FAIL_VALIDATION" : true,
				"CUSTOM" : true
		};

		var submitActionMap = {
				"CHANGE_FIELD_VALUE" : true,
				"SHOW_MESSAGE" : true,
				"CANCEL_SUBMIT" : true,
				"FAIL_VALIDATION" : true,
				"CUSTOM" : true
		};

		var cancelActionMap = {
			"SHOW_MESSAGE" : true,
			"FAIL_VALIDATION" : true,
			"CUSTOM" : true
			
		};

		if($ruleType === "ON_EVENT")
		{
			if($container.val() === "FORM_SUBMITTED")
			{
				$wfSubmitAct.show();
				$wfFormActs.hide();
				$wfChangeAct.show();
				$wfActionsDropDown.val(actionType?actionType:submitActionMap[$wfActionsDropDown.val()]!=undefined?$wfActionsDropDown.val():"CANCEL_SUBMIT");
			}
			else if($container.val() === "FORM_CANCELLED"){
				$wfFormActs.hide();
				$wfSubmitAct.hide();
				$wfActionsDropDown.val(actionType?actionType:cancelActionMap[$wfActionsDropDown.val()]!=undefined?$wfActionsDropDown.val():"SHOW_MESSAGE");
				$wfChangeAct.hide();
			}
			else {
				$wfFormActs.show();
				$wfSubmitAct.hide();
				$wfActionsDropDown.val(actionType?actionType:formsActionMap[$wfActionsDropDown.val()]!=undefined?$wfActionsDropDown.val():"SHOW");
				$wfChangeAct.show();
			}
		}
		else
		{
			$wfFormActs.show();
			$wfSubmitAct.hide();
			$wfActionsDropDown.val(actionType?actionType:formsActionMap[$wfActionsDropDown.val()]!=undefined?$wfActionsDropDown.val():"SHOW");
			$wfChangeAct.show();
		}
	}

	var addButtonListeners = function(){
/*		$("#wfAddCondBut").off("click").on("click",function(event){
			event.preventDefault();
			addCondition();
		});*/

		$("#wfRuleType input[type='radio']").off("click").on("click",function(event){
			if($(this).val() === "ON_EVENT")
				$("#wfFormEventType").removeClass("disabledActions");
			else
				$("#wfFormEventType").addClass("disabledActions");
			displayAppropriateActionsForAllActions();
		});

		$("#wfFormEventType").off("change").on("change",function(event){
			event.preventDefault();
			displayAppropriateActionsForAllActions();
		});

		$("#wfAddActionBut").off("click").on("click",function(event){
			event.preventDefault();
			addAction();
		});

		$("#wfDeleteRuleBtn").off("click").on("click",function(event){
			event.preventDefault();
			deleteSelectedRule();
		});

		$("#wfCancelRuleBtn").off("click").on("click",function(event){
			event.preventDefault();
			$("#wfRuleDetailArea").hide();
			deSelectRule();
		});

		$("#wfRuAddCondBut").off("click").on("click",function(event){
			event.preventDefault();
			saveRule();
		});
	}

	var displayInfoMessage = function(message){
		if (wfUtils.functions.isAdminConsole())
            Forms.showWarningDialog({onlyOneButton:true,yesText:"OK"},message);
		else
            cvUtil.toast(message);

	}

	var deleteSelectedRule = function(){
		if(isFormsRuleBuilder() || isAppStudioFormsRuleBuilder()){
			var index = getSelectedRulePosition();

			if(index < 0)
				return;

			rules.splice(index,1);
			displayRuleTable(TABLE_CONTAINER);
			$("#wfRuleDetailArea").hide();
		}
		else if(isAppStudioBusinessRuleBuilder()){
			// changes for business rules
			//operation : deleting a rule.
		}
	};

	var isRecordField = function($container){
		return $container.val() === wfUtils.constants.FORMS_RECORD_OPERATION_FIELD;
	};

	var isCustomScriptField = function($container){
		return $container.val() === wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD;
	};
	
	var enableMultipleConditions = function(){
		return $("#wfCondField").val() === MULTIPLE_CONDITION_FIELD;
	}

	var showOrHideEnableMultipleConditions = function(){
		if(enableMultipleConditions()){
			if($("#wfRuConditionsTable tbody .wfCondRows").length === 0)
				addCondition();
			$("#wfRunConditionsSection").show();
		}
		else
			$("wfRunConditionsSection").hide();
	}

	var addListenerForFormCondField = function(){
		$("#wfCondField").off("change").on("change",function(event){
			event.preventDefault();
			displayAppropriateOperators($(this));
			//showOrHideEnableMultipleConditions();
		});
	}

	var displayAppropriateOperators = function($container){
		if(isCustomScriptField($container)){
			$container.siblings(".wfCustomScript").show();
			$container.siblings(".wfRecordOp").hide();
			$container.siblings(".wfCondOp").hide();
			$container.siblings(".wfCondRowVal").hide();
		}
		else if(isRecordField($container)){
			$container.siblings(".wfRecordOp").show();
			$container.siblings(".wfCondOp").hide();
			$container.siblings(".wfCondRowVal").hide();
			$container.siblings(".wfCustomScript").hide();
		}
		else{
			$container.siblings(".wfRecordOp").hide();
			$container.siblings(".wfCondOp").show();
			$container.siblings(".wfCondRowVal").show();
			$container.siblings(".wfCustomScript").hide();
			populateConditionRowValue({field:$container.val()},$container);
		}
	};

	var displayAppropriateDataTypeOperators = function($container){
		if(!isRecordField($container) && !isCustomScriptField($container)){
			var inputName = getInputEntryName($container.val());
			var $condOp = $container.siblings(".wfCondOp");
			var $numericOps = $condOp.find(".numericOps");
			var $stringOps = $condOp.find(".stringOps");
			var $nullCheckOps = $condOp.find(".nullCheckOps");

			$condOp.find(".opSeparator").hide();
			if(isOptionsAvailable(inputName))
			{
				$stringOps.hide();
				$numericOps.hide();
			}
			else if(isNumericType(inputName)){
				$stringOps.hide();
				$numericOps.show();
				$nullCheckOps.show();
				$condOp.find(".opSeparator").show();
			}
			else if(isBooleanType(inputName)){
				$stringOps.hide();
				$numericOps.hide();
				$nullCheckOps.hide();
			}
			else
			{
				$stringOps.show();
				$numericOps.hide();
				$nullCheckOps.show();
			}
		}
	}

	var updateRuleEventType = function(ruleTriggers){
		if(ruleTriggers.OnFormFormOpened!=undefined && ruleTriggers.OnFormFormOpened === true)
			$("#ruleDetails #wfFormEventType").val("FORM_OPENED");
		else if(ruleTriggers.onFormCancelled!=undefined && ruleTriggers.onFormCancelled === true)
			$("#ruleDetails #wfFormEventType").val("FORM_CANCELLED");
		else if(ruleTriggers.onFormSubmitted!=undefined && ruleTriggers.onFormSubmitted === true)
			$("#ruleDetails #wfFormEventType").val("FORM_SUBMITTED");

		if (isAppStudioBusinessRuleBuilder()) {
		    Object.keys(ruleTriggers).forEach(function (key) {
                $("input.wfActionTriggers[name='" + key + "']").prop('checked', true);
			});

        }
	}

	var updateRuleDetailForm = function(rule){
//		var otherwiseStr = ""
		if(rule){
			displayRuleNo(getSelectedRulePosition());

			if(rule.ruleTriggers)
			{
				var ruleTriggers = rule.ruleTriggers;

				if(ruleTriggers){
					if(ruleTriggers.OnFormFieldChange != undefined)
					{
						if(ruleTriggers.OnFormFieldChange === true)
						{
							$("#ruleDetails #wfRuleType").find("[value='ON_FIELD_CHANGE']").prop("checked",true);
							$("#ruleDetails #wfFormEventType").addClass("disabledActions");
						}
						else
						{
							$("#ruleDetails #wfFormEventType").removeClass("disabledActions");
							$("#ruleDetails #wfRuleType").find("[value='ON_EVENT']").prop("checked",true);
							updateRuleEventType(ruleTriggers);
						}

					}
					else
					{
						$("#ruleDetails #wfFormEventType").removeClass("disabledActions");
						$("#ruleDetails #wfRuleType").find("[value='ON_EVENT']").prop("checked",true);
						updateRuleEventType(ruleTriggers);
					}
				}
			}


			if(rule.conditionGroups && rule.conditionGroups.length > 0){
				//otherwiseStr  = "when ";
				jQuery.each(rule.conditionGroups,function(index){
					var condGroup = $.extend({}, true,this);
					addConditionGroup(condGroup);
				});

				//$("#wfCondBoolOp").val(rule.ruleOp);
			}
			else
				addConditionGroup();

			if(rule.actions){
				jQuery.each(rule.actions,function(index){
					var action = $.extend({}, true,this);
					action.field = getDispNameForInputEntry(this.field);
					addAction(action);
					/*if(index > 0 )
						otherwiseStr +=	",and ";
					else
						otherwiseStr +=	",";
					otherwiseStr += "<b>" + getOppositeActionLbl(action.actionType) + "</b> " + action.field*/
				});
			}

			//displayAppropriateActions();

			if(rule.enabled!=undefined)
				$("#wfRuOptionsRow #wfRuleStatus").prop("checked",!rule.enabled);

			//populateOtherwiseLabel(otherwiseStr);
		}
		$("#wfRuleDetailArea").show();
	}

	var populateConditionGroup = function(condGroup,container){
		if(condGroup){
			if(condGroup.allOrAny)
			{
				var $container = $(container);
				$container.find(".wfCondBoolOp").val(condGroup.allOrAny);
			}
		}
	}

	var getOptionsForCondRowValue = function(field){

		var options = getOptions(field);
		var optionStr = "";

		jQuery(options).each(function(index){
			optionStr += '<option value="' + this.val + '">' + this.name + '</option>';
		});

		return optionStr;
	}

	var populateOptionsForCondRowValue = function($condRowSelect,field){
			var optionsStr  = 	'<option value="" style="color:#999">select a value...</option>'
							+   '<option id="wfConditionRowFirstLine" value="0" style="color:#999" disabled="">-------------</option>';

			optionsStr += getOptionsForCondRowValue(field);

			if(optionsStr.trim()!="")
			{
				$condRowSelect.html(optionsStr);
			}
	}

	var populateConditionRowValue = function(cond,$container){
		var inputName = getInputEntryName(cond.field);
		var $condRowVal = $container.siblings(".wfCondRowVal");
		var $condRowInput = $condRowVal.find("input");
		var $condRowSelect = $condRowVal.find(".wfCondRowOptionSelect");
		var $condRowBoolean = $condRowVal.find(".wfCondRowBooleanSelect");

		if(isOptionsAvailable(inputName))
		{
			$condRowSelect.show();
			$condRowBoolean.hide();
			$condRowInput.hide();
			populateOptionsForCondRowValue($condRowSelect,inputName);
			$condRowSelect.val(cond.value);
		}
		else if(isBooleanType(inputName)){
			$condRowSelect.hide();
			$condRowInput.hide();
			$condRowBoolean.show();
			if(cond.value!=undefined)
				$condRowBoolean.val(cond.value+"");
		}
		else
		{

			$condRowInput.val(cond.value);
			$condRowInput.show();
			$condRowSelect.hide();
			$condRowBoolean.hide();
		}

		displayAppropriateDataTypeOperators($container);
	}

	var populateCondition = function(cond,container){
//		$(container).
		if(cond){
			var $container = $(container);
			$container.val(cond.field);

			if(isCustomScriptField($container))
			{
				$container.siblings(".wfCustomScript").val(cond.value);
				displayAppropriateOperators($container);
			}
			else if(isRecordField($container))
			{
				$container.siblings(".wfRecordOp").val(cond.value);
				displayAppropriateOperators($container);
			}
			else
			{
				populateConditionRowValue(cond,$container);
				$container.siblings(".wfCondOp").val(cond.op);
				displayValueComponent($container);
			}
		}
	}

	var populateAction = function(action,container){
		if(action){
			var $container = $(container);
			$container.val(action.type);

			$container.siblings(".wfActRowField").val(action.field);
		}
	}

	var getDispNameForInputEntry = function(inputName){
		return inputNameToDispMap[inputName];
	};

	var getInputEntryName = function(dispName){
		return dispToInputEntryMap[dispName];
	};

	var maskPage = function() {
		if (wfUtils.functions.isAdminConsole()) {
			cvUtil.mask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
		} else {
			cvUtil.mask();
		}
	}

	var unmaskPage = function(){
		if (wfUtils.functions.isAdminConsole()) {
			cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
		}
		else
		cvUtil.unmask();
	}

	var initializeRuleBuilder = function(){
		var inputForm = inputFormForActivity?inputFormForActivity:undefined
		dispToInputEntryMap = {};
		inputNameToDispMap = {};
		fieldTypeMap = {};
		inputEntriesHtml = "";
				if(inputForm){
					if(inputForm.entries && inputForm.entries.length>0)
					{
						jQuery.each(inputForm.entries,function(){
							var currEntry = this;
							var dispName = currEntry.displayName && currEntry.displayName!=""?currEntry.displayName:currEntry.name;
							dispToInputEntryMap[dispName] = currEntry.name;
							inputNameToDispMap[currEntry.name] = dispName;
							fieldTypeMap [currEntry.name] = currEntry.className;
							inputEntriesHtml += getOptionhtmlForInputEntry(dispName);
						});
						dispToInputEntryMap[wfUtils.constants.FORMS_RECORD_OPERATION_FIELD] = wfUtils.constants.FORMS_RECORD_OPERATION_FIELD;
						inputNameToDispMap[wfUtils.constants.FORMS_RECORD_OPERATION_FIELD] = wfUtils.constants.FORMS_RECORD_OPERATION_FIELD;
						dispToInputEntryMap[wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD] = wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD;
						inputNameToDispMap[wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD] = wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD;
	}

					if(inputForm.properties)
					{
						if(inputForm.properties.javaScript)
							$("#wfJSArea").val(inputForm.properties.javaScript);

						if(inputForm.properties.css)
							$("#wfCSSArea").val(inputForm.properties.css);

						if(inputForm.properties.rules && inputForm.properties.rules.rules)
							rules = inputForm.properties.rules.rules;
					}
				}

		addNavigationListeners();
		addRuleOperationsListeners();
		addButtonListeners();
	}

	var postFetchInputForm = function(data){
		unmaskPage();
		if(data)
		{
			inputFormForActivity = data;
			currReactInfo = inputFormForActivity.reactForm?JSON.parse(inputFormForActivity.reactForm):null;
			initializeRuleBuilder();
		}
		}

	var fetchInputForm = function(ruleInfo){
		performInitialConfiguration(ruleInfo);

		if(isFormsRuleBuilder()){
			if(!window.System.additionalSettings.AdminConsole){
				window.System.additionalSettings.AdminConsole = {}
			}
			window.System.additionalSettings.AdminConsole.showReactRuleBuilder = true;
			if(window.System.additionalSettings.AdminConsole.showReactRuleBuilder){
				RuleBuilder.setFetcher(fetchInputFormForWorkflows);
				RuleBuilder.onSaveFormRuleBuilder(saveCustomization);
				RuleBuilder.onSaveAndDeployFormRuleBuilder(saveAndDeployForm);
				RuleBuilder.openWorkflowRuleBuilder(ruleReq);
			}
			else
			{
				maskPage();
				fetchInputFormForWorkflows();
			}

	
		}
		else if(isAppStudioBusinessRuleBuilder())
			fetchInputFormForAppStudioBusinessRules();
		else if(isAppStudioFormsRuleBuilder())
			fetchInputFormForAppStudioFormRules();
	}

    var hideListElementsForAdminConsole = function() {
        $("#wfRulesTableAreaRow, #wfRulesNavigation, .categoryTableBody").hide();
    }

    var hideRuleElelemntsForAdminConsole = function() {
		if(!isFormsRuleBuilder() && !isAppStudioFormsRuleBuilder())
        $("#wfRuDetailsHead, #ruleDetailsBtns").hide();
    };

	var showFormTitleTextBox = function(){
		$("#wfFormTitleArea").show();
	};

	var updateFormTitle = function(){
		$("#wfFormTitle").val(inputFormForActivity.formName && inputFormForActivity.formName.trim()!=""?inputFormForActivity.formName:"Default");
	};
	
	var fetchInputFormForAppStudioFormRules = function(){
		
		showFormTitleTextBox();
		
		var params = [];
		
		if(ruleReq.tableId)
			params.push(cvUtil.createParamString("tableId",ruleReq.tableId));

		if(ruleReq.formId)
			params.push(cvUtil.createParamString("formId",ruleReq.formId));

		var inputParams = cvUtil.createParamsString(params);
		
		cvUtil.loadPage("retrieveAppTableForm.do",inputParams,function(data){
			postFetchInputForm(data);
			updateFormTitle();
			displayRuleTable(TABLE_CONTAINER);
		},function(xhr, ajaxOptions, thrownError) {
			unmaskPage();
			alert(xhr.responseText);
		});
	}

    var fetchInputFormForAppStudioBusinessRules = function () {

        hideListElementsForAdminConsole();

        ACTION_TEMPLATE = ACTION_TEMPLATE_RULES;

        var ruleId = ruleReq.ruleId;
		var tableId = ruleReq.tableId;

        Promise.all([fetchInputFormBusinessRules(ruleId, tableId), fetchWorkflows()]).then(function (resp) {
		    var inputForm = resp[0];
		    workflowEntities = resp[1];
		    postFetchInputForm(inputForm);
		    displayRule(rules[0]);
		}, function (err) {
		    unmaskPage();
		    alert(err);
		});
    }
		
	var displayRule = function(rule){
		if(rule)
			initializeRuleDetail(updateRuleDetailForm,rule);
		else
			addRule();
	};

	var fetchInputFormForWorkflows = function(){
		var params = [];
		
		if(ruleReq.workflowId)
			params.push(cvUtil.createParamString("workflowId",ruleReq.workflowId));

		if(ruleReq.activityId)
			params.push(cvUtil.createParamString("activityId",ruleReq.activityId));
		
		var inputParams = cvUtil.createParamsString(params);
		
		if(window.System.additionalSettings.AdminConsole.showReactRuleBuilder){
			return cvUtil.loadPage(RULE_INPUTFORM_URL,inputParams).then(function(data){
				return {inputForm :data};
			});
		}
		else {
			
		cvUtil.loadPage(RULE_INPUTFORM_URL,inputParams,function(data){
			postFetchInputForm(data);
			displayRuleTable(TABLE_CONTAINER);
		},function(xhr, ajaxOptions, thrownError) {
			unmaskPage();
			alert(xhr.responseText);
		});
	}
	}

	var initializeTabs = function(){
		if(isFormsRuleBuilder() || isAppStudioFormsRuleBuilder())
			{
			$(".nav-tabs a").click(function(event){
			 	event.preventDefault();
		        $(this).tab('show');
		    });
				
		  $('.nav-tabs a').off('hidden.bs.tab').on('hidden.bs.tab', function(event){
		       $("#" + $(this).attr("name")).removeClass("in").hide();
		  });
				
		  $('.nav-tabs a').off('shown.bs.tab').on('shown.bs.tab', function(event){
			  $(".wfTabArea").hide().removeClass("in");
			  $("#" + $(this).attr("name")).addClass("in").show();
								});
		  $("#wfRulesNavigation").removeClass("removeTabs");		
							}
		else
							{
			$("#wfRulesNavigation").addClass("removeTabs");		
		}
		 $("#wfRules").addClass("in");
	};
									
									
	var performInitialConfiguration = function(ruleInfo){
		 initializeTabs();
		 ruleReq = ruleInfo;
		 ACTION_TEMPLATE = ORIGINAL_ACTION_TEMPLATE;
							}
	
	var isAppStudioFormsRuleBuilder = function(){
		return ruleEngineType === ruleSystem.RULE_FOR_APP_STUDIO_FORM_RULES;
						}
	
	var isAppStudioBusinessRuleBuilder = function(){
		return ruleEngineType === ruleSystem.RULE_FOR_APP_STUDIO_BUSINESS_RULES;
			}
	
	var isFormsRuleBuilder = function(){
		return ruleEngineType === ruleSystem.RULE_FOR_WORKFLOWS;
	};

	var openAppStudioFormsRuleBuilder = function(ruleInfo){
		ruleEngineType = ruleSystem.RULE_FOR_APP_STUDIO_FORM_RULES;
		fetchInputForm(ruleInfo);
	};
	
	var openAppStudioBusinessRuleBuilder = function(ruleInfo){
		ruleEngineType = ruleSystem.RULE_FOR_APP_STUDIO_BUSINESS_RULES;
		fetchInputForm(ruleInfo);
	};

	var openRuleBuilder = function(ruleInfo){
		
		if(ruleInfo.workflowId && ruleInfo.workflowId!="" || ruleInfo.activityId && ruleInfo.activityId!="")
			ruleEngineType = ruleSystem.RULE_FOR_WORKFLOWS;
		else if(ruleInfo.tableId && ruleInfo.tableId!="")
			ruleEngineType = ruleSystem.RULE_FOR_APP_STUDIO_FORM_RULES;
			
		fetchInputForm(ruleInfo);
	};
	
	var populateOtherwiseLabel = function(otherwiseStr){
		$("#wfRuOtherwiseRow #wfRuOtherwiseLbl").html(otherwiseStr);				
	}
	
	var constructCondition = function($container){
		var condition = {};
		
		if(isCustomScriptField($container)){
			condition.field = wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD;
			condition.op = "EQUALS";
			condition.value = $container.siblings(".wfCustomScript").val();
		}
		else if(isRecordField($container)){
			var recordOperation =	$container.siblings(".wfRecordOp").val();
			
			condition.field = wfUtils.constants.FORMS_RECORD_OPERATION_FIELD;
			condition.op = "EQUALS";
			condition.value = recordOperation;
		}
		else
		{
			var inputName = getInputEntryName($container.val());
			
			if(inputName != undefined){
				
			condition.field = inputName;
			
			var $condRowVal = $container.siblings(".wfCondRowVal");
			
			if(isBooleanType(inputName))
			{
					condition.value = $condRowVal.find(".wfCondRowBooleanSelect").val();
			}
			else if(isOptionsAvailable(inputName)){
				condition.value = $condRowVal.find(".wfCondRowOptionSelect").val();
				condition.value = condition.value === ""?undefined:condition.value;
			}
			else
				condition.value = $condRowVal.find("input").val().trim() === ""?undefined:$condRowVal.find("input").val().trim();

			condition.op = $container.siblings(".wfCondOp").val();
		}
			else
				return undefined;
		}
		return condition;
	}
	
	var constructConditions = function($container){
		var conditions = [];
		var $conditions = $container.find(".wfCondRows");
		$($conditions).each(function(){
			var condInfo = constructCondition($(this).find(".wfCondRowField"));
			if(condInfo != undefined)
				conditions.push(condInfo); 
		})
		return conditions;
	}
	
	var constructConditionGroup = function($container){
		var condGroup = undefined;

		$condGroupRow = $container.find(".wfCondRuWhenTable");
		var conditions = constructConditions($container);
		
		if(conditions.length > 0)
		{
			condGroup = {};
			condGroup.conditions = conditions;
		condGroup.allOrAny = $condGroupRow.find(".wfCondBoolOp").val();
		}
		
		return condGroup;
	}
	
	var constructConditionGroups = function($container){
		var condGroups = [];
		var $conditionGroups = $container.find(".wfCondGroupRow");
		$($conditionGroups).each(function(){
			var condGrpInfo = constructConditionGroup($(this));
			if(condGrpInfo!=undefined)
				condGroups.push(condGrpInfo); 
		});
		return condGroups;
	}

	var constructAction = function($container){

		var action = {};
		
		action.type = $container.find(".wfActRowSelection").val();
		action.field = getInputEntryName($container.find(".wfActRowField").val());
		var $actionRowVal = $container.find(".wfActRowFieldValSpan");
		

			if(action.type === "CUSTOM")
			{
				action.value = $actionRowVal.find(".wfActRowMessage").val();
			}
			else if(action.type === "FAIL_VALIDATION")
			{
				action.value = $actionRowVal.find(".wfActRowMessage").val();
			}
			else if(action.type === "CHANGE_FIELD_VALUE")
			{
				
				var inputName = action.field; 
				
				if(isOptionsAvailable(inputName)){
					action.value = $actionRowVal.find(".wfActRowOptionSelect").val();
				}
				else if(isBooleanType(inputName)){
					action.value = $actionRowVal.find(".wfActRowBooleanSelect").val();
				}
				else {
					action.value = $actionRowVal.find("input").val();
				}	
			}
			else if(action.type === "SHOW_MESSAGE")
			{
				action.popUpMessage = getShowMessageInfo($actionRowVal);
			}
			else if(action.type === "CANCEL_SUBMIT")
			{
				action.popUpMessage = getShowMessageInfo($actionRowVal);
			}
			/*else if(action.type === "RUN_WORKFLOW") {
			    var id = $container.attr("id");
			    var $workflowInputs = $("#"+id+".wfOptionsRow").find(".wcWorkflowInputRow")
			    var workflowKey = $("#"+id).find(".workflowOptionsSelect").val();
			    var workflowEntity = workflowEntities[workflowKey];
                var inputs = [];

                $workflowInputs.each(function() {
                    var $input = $(this).find(".wcWorkflowInputValue");
                    var id = $input.data("inputid");
                    var value = $input.val();
                    var isMulti = $input.data("ismulti");

                    inputs.push({id, value, isMulti})
                });
                var actionDetails = {
                    workflowId: workflowEntity.entity.workflowId,
                    workflowName: workflowEntity.entity.workflowName,
                    inputs
                };
			    action.actionDetails = JSON.stringify(actionDetails);

			}*/ else if (action.type === "SEND_EMAIL") {
			    var actionDetails = {}
			    action.actionDetails = JSON.stringify(actionDetails)
            }

		return action;
	}

	var getShowMessageInfo = function($actionRowVal){
		var msgInfo = {};
		msgInfo.message = $actionRowVal.find(".wfActRowMessage").val();
		msgInfo.type = $actionRowVal.find(".wfActRowMsgType").val();
		msgInfo.button = $actionRowVal.find(".wfActRowMsgBtnTypeSelection").val(); 
		return msgInfo;
	}
	
	var constructActions = function($container){
		var actions = [];
		var $actions = $container.find(".wfActRows");
		$($actions).each(function(){
			actions.push(constructAction($(this))); 
		})
		return actions;
	}
		
	var constructRuleJson = function(){
		var rule = {};
		
		rule.conditionGroups = constructConditionGroups($("#wfCondGroups"));
		rule.actions = constructActions($("#wfRulesActionsTable"));
		rule.enabled = !$("#wfRuleStatusArea #wfRuleStatus").prop("checked");
		rule.allOrAny = "ANY";
		rule.ruleTriggers = constructRuleTriggers();
		
		return rule;
	}
	
	var constructRuleTriggers = function(){
		var ruleTriggers = {};

		if (isAppStudioBusinessRuleBuilder()) {
            $("input.wfActionTriggers:checked").each(function (i, trigger) {
                var rule = $(trigger).val();
                ruleTriggers[rule] = true;
			});
        } else {
            var $ruleType = $("#wfRuleDetailArea #wfRuleType input[name='wfCondMatchType']:checked").val();

            if($ruleType === "ON_FIELD_CHANGE")
            {
                ruleTriggers['OnFormFieldChange'] = true;
            }
            else
            {
                ruleTriggers['OnFormFieldChange'] = false;
                var formEventType = $("#wfFormEventType").val();

                if(formEventType === "FORM_OPENED")
                    ruleTriggers['OnFormFormOpened'] = true;
                else if(formEventType === "FORM_CANCELLED")
                    ruleTriggers['onFormCancelled'] = true;
                else if(formEventType === "FORM_SUBMITTED")
                    ruleTriggers['onFormSubmitted'] = true;
            }
        }
		

		return ruleTriggers;
	}
	
	var saveAndDeployCustomization = function(){
		const builderData = RuleBuilder.getFormRuleBuilderData();
		
		var targetURL = "";
		targetURL = cvUtil.getContextPath() + "/proxy/cr/apps/inputform/";
		
		if(ruleReq.workflowId)
			targetURL += ruleReq.workflowId;

		if(ruleReq.activityId)
			targetURL += "?activity=" + ruleReq.activityId;
		
		
		var inputParams = $.extend({},true,inputFormForActivity);
		inputParams.properties = builderData.properties;
		delete inputParams.reactForm;
		
		inputParams = JSON.stringify(inputParams);
		
	
		
	}
	
	var saveAndDeployForm = function(){
		saveCustomization(true);
	}
	
	var saveCustomization = function(deploy){
		maskPage();
		
		var params = [];
		var targetURL = "";
		var inputParams = {};
		
		var reqOptions = {
					contentType : "application/json"
			}
		
		if(!inputFormForActivity.properties)
			inputFormForActivity.properties = {};
		
		var ruleInfo = {};
		ruleInfo.rules = rules;
		
		inputFormForActivity.properties.rules = ruleInfo;
		inputFormForActivity.properties.javaScript = $("#wfJSArea").val();
		inputFormForActivity.properties.css = $("#wfCSSArea").val();		
		
		if(isAppStudioFormsRuleBuilder()){
			targetURL = cvUtil.getContextPath() + "/proxy/cr/apps/tables"; 
			
			if(ruleReq.tableId)
				targetURL += "/" + ruleReq.tableId + "/forms";
				
			if(inputFormForActivity.formId)
				targetURL += "/" + inputFormForActivity.formId;
			
			var reqOptions = {
					callType : "PUT",
					contentType : "application/json"
			}
			
			var inputParams = {};
			inputParams.properties = $.extend({}, true,inputFormForActivity.properties);
			inputParams.formName = $("#wfFormTitle").val();
			delete inputParams.properties["pageMode"];
			inputParams = JSON.stringify(inputParams);			
		}
		else
		{
			targetURL = cvUtil.getContextPath() + "/proxy/cr/apps/inputform/";
			
			if(ruleReq.workflowId)
				targetURL += ruleReq.workflowId;

			if(ruleReq.activityId)
				targetURL += "?activity=" + ruleReq.activityId;
			
			
			var inputParams = $.extend({},true,inputFormForActivity);
			delete inputParams.reactForm;
			
			if(window.System.additionalSettings.AdminConsole.showReactRuleBuilder)
			{
				var builderData = RuleBuilder.getFormRuleBuilderData();
				inputParams.properties = builderData.properties;
			}
			
			inputParams = JSON.stringify(inputParams);
			
		}

		cvUtil.loadPage(targetURL,inputParams,function(data){
			if(isAppStudioFormsRuleBuilder()){
			unmaskPage();
				if(data === "")
				{
					displayInfoMessage("Customization saved successfully");
				}
			}
			else
			{
				if(data === "")
				{
					if(deploy){
						

						
						cvUtil.loadPage(cvUtil.getContextPath() + "/proxy/workflow/" + ruleReq.workflowId + "/Action/Deploy",JSON.stringify({}),function(deployResp){
							unmaskPage();
							deployResp = deployResp.children[0];
							if($(deployResp).attr("errorCode") === "0" ){
								displayInfoMessage("Customization saved and deployed successfully");
							}
							else
								alert("Customization saved, but couldn't be deployed!");
						},function(xhr, ajaxOptions, thrownError) {
							unmaskPage();
							alert("Customization saved, but couldn't be deployed!");
						},{contentType:"application/json"});				
					}
					else{
						unmaskPage();
					displayInfoMessage("Customization saved successfully");
					}
				}
			}
		},function(xhr, ajaxOptions, thrownError) {
			unmaskPage();
			alert(xhr.responseText);
		},reqOptions);
	}

    var setFetcherInputFormBusinessRules= function(fetcher) {
	    fetchInputFormBusinessRules = fetcher || function(){};
    }

    var saveBusinessRule = function() {
	    var ruleToSave = rules[0];
	    if (!ruleToSave) return;
	    if (ruleToSave && !ruleToSave['save']) return;

        var tempRules = $.extend([],true,rules);
        saveRule(true,tempRules);

	    var rule = constructRuleJson();
        ruleToSave.actions = rule.actions;
        ruleToSave.conditionGroups = rule.conditionGroups;
        ruleToSave.allOrAny = rule.allOrAny;
        ruleToSave.ruleTriggers = rule.ruleTriggers;
        ruleToSave.enabled = rule.enabled;

        maskPage();

	    return ruleToSave.save().then(function (response) {
		    unmaskPage();
		    return response;
		}, function (err) {
		    unmaskPage();
		    return Promise.reject(err);
		});

    };

	var setOnSaveBusinessRule = function(onSave) {
	    handleSaveRule = onSave
    }

    // var deleteBusinessRule = () => {};
	
	var setWorkflowFetcher = function(fetcher) {
	    fetchWorkflows = fetcher;
    }

	
	//openRuleBuilder();
	formObj["openRuleBuilder"] = openRuleBuilder;
	formObj["openAppStudioFormsRuleBuilder"] = openAppStudioFormsRuleBuilder;
	formObj["openAppStudioBusinessRuleBuilder"] = openAppStudioBusinessRuleBuilder;
	formObj["setFetcherInputFormBusinessRules"] = setFetcherInputFormBusinessRules;
	formObj["setWorkflowFetcher"] = setWorkflowFetcher;

	formObj["onSaveBusinessRule"] = setOnSaveBusinessRule;
	formObj["saveBusinessRule"] = saveBusinessRule;
	formObj["getRules"] = getRules;
	return formObj;

})(Forms || {});