<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="mbBackupSetDetailsCtrl.currentBackupSet.subclientName" data-ng-show="mbBackupSetDetailsCtrl.serverMessage.message==''"></h1>
		<span class="server-message {{mbBackupSetDetailsCtrl.serverMessage.type}}" data-ng-bind="mbBackupSetDetailsCtrl.serverMessage.message"></span>
		<span><a class="page-action-item" href="" data-ng-click="mbBackupSetDetailsCtrl.backup('runContentIndexing','backupset')"><cv:msg key="label.runContentIndexing" bundle="exchange" /></a></span>
		<span><a class="page-action-item" data-ui-sref="365exchangeBrowse({subclientId: mbBackupSetDetailsCtrl.subclientId})"><cv:msg key="action.restore" bundle="exchange" /></a></span>
		<span><a class="page-action-item" href="" data-ng-click="mbBackupSetDetailsCtrl.backup('cleanup','backupset')"><cv:msg key="label.cleanup" bundle="exchange" /></a></span>
		<span><a class="page-action-item" href="" data-ng-click="mbBackupSetDetailsCtrl.backup('archive','backupset')"><cv:msg key="label.archive" bundle="exchange" /></a></span>
		<span class="page-action-item spacing-right">
			<span uib-dropdown class="uib-dropdown" on-toggle="toggled(open)">
				<a href class="uib-dropdown-toggle" uib-dropdown-toggle>
					<span class="dropdownArrow right"></span><cv:msg key="MoreActions"/>
				</a>
				<ul uib-dropdown-menu class="dropdown-menu" role="menu">
					<li>
						<a href="" data-ng-click="mbBackupSetDetailsCtrl.getHistoryUrl('Restore')"><cv:msg key="label.RestoreHistory" bundle="exchange" /></a>
					</li>
					<li>
						<a href="" data-ng-click="mbBackupSetDetailsCtrl.getHistoryUrl('Archive')"><cv:msg key="label.archiveHistory" bundle="exchange" /></a>
					</li>
					<li>
						<a href="" data-ng-click="mbBackupSetDetailsCtrl.getHistoryUrl('ContentIndexing')"><cv:msg key="label.contentIndexingHistory" bundle="exchange" /></a>
					</li>
				</ul>
			</span>
		</span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="mailboxBackupSetDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="mbBackupSetDetailsCtrl.subclientDetails">
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.maxStream" bundle="exchange" /></span>
					<span class="pageDetailColumn" data-ng-bind="mbBackupSetDetailsCtrl.subclientDetails.exchangeDBSubClientProp.numberOfExchangeBackupStreams"></span></li>
			</ul>
			<div class="page-details-box-links">
				<a href="" data-ng-click="mbBackupSetDetailsCtrl.editGeneralInfo()"><cv:msg key="action.edit" bundle="profiles" /></a>
			</div>
		</cv-tile-component>
		<cv-activity-control-component data-ac-params="mbBackupSetDetailsCtrl.acParams"></cv-activity-control-component>
	</div>
	<div class="col-md-6">
		<cv-security-component entity-type='mbBackupSetDetailsCtrl.entityType'
							   generic-entity = 'mbBackupSetDetailsCtrl.genericEntity'
							   associations='mbBackupSetDetailsCtrl.formattedSecurityAssociations'
							   associations-loaded="mbBackupSetDetailsCtrl.associationsLoaded">
		</cv-security-component>
		<span >
        	<cv-plan-component data-ng-if="mbBackupSetDetailsCtrl.isPlanEnabled()" app-id="mbBackupSetDetailsCtrl.applicationId" subclient-id="mbBackupSetDetailsCtrl.subclientId" client-id="mbBackupSetDetailsCtrl.clientId" data-dont-show-edit="mbBackupSetDetailsCtrl.hasAssociatedPolicy" plan-entity="mbBackupSetDetailsCtrl.planEntity" dont-reload="true"></cv-plan-component>
		</span>
	</div>
	<div class="col-md-12">
		<cv-grid cv-grid-options="mbBackupSetDetailsCtrl.gridOptions"></cv-grid>
	</div>
</div>