<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="setup-title">
	<h1>{{'label.restoreOpts' | cvLoc}}</h1>
</div>
<form name="restoreForm" cv-hide-api
class="form-horizontal bootstrap-wrapper"
	novalidate
	data-cv-submit="exchMailboxRestoreOptionsController.restore()"
	autocomplete="off">
	<div class="modal-body">
		<div class="form-group">
			<label class="col-xs-5"><cv:msg key="label.restoreTo"
					bundle="exchange" /></label>
			<div class="col-xs-7">
				<select id="restoreTo" name="restoreTo"
					data-ng-disabled="exchMailboxRestoreOptionsController.disableRestoreTo"
					data-ng-model="exchMailboxRestoreOptionsController.model.restoreTo"
					data-ng-change="exchMailboxRestoreOptionsController.resetDestinationPaths()">
					<option
						value="{{exchMailboxRestoreOptionsController.EXCHANGE_RESTORE_TO_TYPES.TO_MAILBOX}}"><cv:msg
							key="label.restoreToMailbox" bundle="exchange"></cv:msg></option>
					<option
						value="{{exchMailboxRestoreOptionsController.EXCHANGE_RESTORE_TO_TYPES.TO_PST_FILE}}"><cv:msg
							key="label.restoreToPSTFile" bundle="exchange"></cv:msg></option>
					<option
						value="{{exchMailboxRestoreOptionsController.EXCHANGE_RESTORE_TO_TYPES.TO_DISK}}"><cv:msg
							key="label.restoreToDisk" bundle="exchange"></cv:msg></option>
				</select>
			</div>
		</div>
		<hr>
		<div
			data-ng-switch="exchMailboxRestoreOptionsController.model.restoreTo">
			<div data-ng-switch-when="TO_MAILBOX">
				<div class="form-group">
					<label class="col-xs-5" for="clientDestination"><cv:msg
							key="label.destHost" bundle="exchange"></cv:msg></label>
					<div class="col-xs-7">
						<select id="clientDestination" name="clientDestination"
							data-ng-model="exchMailboxRestoreOptionsController.model.clientDestination"
							data-ng-options="exchangeServer.name for exchangeServer in exchMailboxRestoreOptionsController.exchangeServers track by exchangeServer.clientId"
							required="required">
						</select>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.clientDestination)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectDestinationHost" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<input id="restoreToOriginal" name="restoreToOriginal"
							type="checkbox"
							data-ng-model="exchMailboxRestoreOptionsController.model.restoreToOriginal" />
						<label for="restoreToOriginal"><cv:msg
								key="label.restoreToOriginal" bundle="restore"></cv:msg></label>
					</div>
				</div>
				<div class="form-group"
					data-uib-collapse="exchMailboxRestoreOptionsController.model.restoreToOriginal">
					<label for="destinationPath" class="col-xs-5"><cv:msg
							key="label.destPath" bundle="exchange"></cv:msg></label>
					<div class="col-xs-7">
						<div class="input-group">
							<input type="text" id="destinationPath" name="destinationPath"
								data-ng-model="exchMailboxRestoreOptionsController.model.destinationPath"
								spellcheck="false"
								data-ng-disabled="exchMailboxRestoreOptionsController.model.restoreToOriginal || !exchMailboxRestoreOptionsController.model.clientDestination"
								data-ng-required="!exchMailboxRestoreOptionsController.model.restoreToOriginal" />
							<span class="input-group-btn">
								<button id="office365ExchMailboxRestoreOptions_button_#9424" class="btn btn-default" type="button" 
									data-ng-disabled="exchMailboxRestoreOptionsController.model.restoreToOriginal || !exchMailboxRestoreOptionsController.model.clientDestination"
									type="button"
									data-ng-click="exchMailboxRestoreOptionsController.openBrowseExchangeEmailsModal()">
									<cv:msg key="label.browse" bundle="restore"></cv:msg>
								</button>
							</span>
						</div>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationPath)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectDestinationPath" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="whenMessageExists" class="col-xs-5"><cv:msg
							key="label.whenMessageExists" bundle="exchange"></cv:msg></label>
					<div class="col-xs-7">
						<div class="radio">
							<label><input type="radio"
								data-ng-model="exchMailboxRestoreOptionsController.model.unconditionalOverwrite"
								data-ng-value="true" /> <cv:msg
									key="label.unconditionalOverwrite" bundle="exchange"></cv:msg></label>
						</div>
						<div class="radio">
							<label><input type="radio"
								data-ng-model="exchMailboxRestoreOptionsController.model.unconditionalOverwrite"
								data-ng-value="false" /> <cv:msg key="label.skip"
									bundle="exchange"></cv:msg></label>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-switch-when="TO_PST_FILE">
				<div class="form-group">
					<label class="col-xs-5" for="clientDestination"><cv:msg
							key="label.destHost" bundle="exchange"></cv:msg></label>
					<div class="col-xs-7">
						<select id="clientDestination" name="clientDestination"
							data-ng-model="exchMailboxRestoreOptionsController.model.clientDestination"
							data-ng-options="proxy.client.clientName for proxy in exchMailboxRestoreOptionsController.exchangeProxies track by proxy.client.clientId"
							required="required">
							<option value=""><cv:msg key="label.selectDestination"
									bundle="exchange"></cv:msg></option>
						</select>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.clientDestination)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectDestinationHost" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="destinationPath" class="col-xs-5">{{'label.destPath'
						| cvLoc}}</label>
					<div class="col-xs-7">
						<div class="input-group">
							<input type="text" id="destinationPath" name="destinationPath"
								pattern="^.*\.(pst)$"
								data-ng-disabled="!exchMailboxRestoreOptionsController.model.clientDestination"
								data-ng-model="exchMailboxRestoreOptionsController.model.destinationPath"
								required="required" /> <span class="input-group-btn">
								<button id="office365ExchMailboxRestoreOptions_button_#5981" class="btn btn-default" type="button" 
									data-ng-disabled="!exchMailboxRestoreOptionsController.model.clientDestination"
									data-ng-click="exchMailboxRestoreOptionsController.openDiskDestinationModal()">{{'label.browse'
									| cvLoc}}</button>
							</span>
						</div>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationPath)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectValidPST" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-5">
						<input id="limitPst" name="limitPst" type="checkbox"
							data-ng-model="exchMailboxRestoreOptionsController.model.limitPSTSize" />
						<label for="limitPst"><cv:msg key="label.limitPSTSizeTo"
								bundle="exchange"></cv:msg></label>
					</div>
					<div class="col-xs-7">
						<input id="limitPstTo"
							data-ng-disabled="!exchMailboxRestoreOptionsController.model.limitPSTSize"
							name="limitPstTo" type="number"
							data-ng-model="exchMailboxRestoreOptionsController.model.limitPSTSizeAmount" />
						<cv:msg key="labelMB" bundle="messagesJs"></cv:msg>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<div class="radio">
							<div class="form-group">
								<div class="col-xs-12">
									<label><input type="radio"
										data-ng-model="exchMailboxRestoreOptionsController.model.createCommonPST"
										data-ng-value="true" /> <cv:msg
											key="label.createCommonPSTForAllUsers" bundle="exchange"></cv:msg></label>
								</div>
							</div>
							<div class="form-group"
								data-ng-disabled="!exchMailboxRestoreOptionsController.model.createCommonPST">
								<div class="col-xs-12">
									<div class="radio">
										<label><input type="radio"
											data-ng-model="exchMailboxRestoreOptionsController.model.pstRestoreOption"
											value="TO_SINGLE_PST" /> <cv:msg
												key="label.mergeFolderHierarchyBetweenAllUsers"
												bundle="exchange"></cv:msg></label>
									</div>
									<div class="radio">
										<label><input type="radio"
											data-ng-model="exchMailboxRestoreOptionsController.model.pstRestoreOption"
											value="TO_SINGLE_PST_SMTP" /> <cv:msg
												key="label.preserveFolderHierarchyPerUser" bundle="exchange" /></label>
									</div>
								</div>
							</div>
						</div>
						<div class="radio">
							<div class="form-group">
								<label class="col-xs-5"><input type="radio"
									data-ng-model="exchMailboxRestoreOptionsController.model.createCommonPST"
									data-ng-value="false" /> <cv:msg
										key="label.createFolderPerUserUsing" bundle="exchange"></cv:msg></label>
								<div class="col-xs-7">
									<select
										data-ng-model="exchMailboxRestoreOptionsController.model.pstRestoreOptionSelection"
										data-ng-disabled="exchMailboxRestoreOptionsController.model.createCommonPST">
										<option value="TO_DIFFERNET_PST_ALIAS"><cv:msg
												key="label.aliasName" bundle="exchange"></cv:msg></option>
										<option value="TO_DIFFERNET_PST_DN"><cv:msg
												key="label.legacyExchangeDn" bundle="exchange"></cv:msg></option>
										<option value="TO_DIFFERNET_PST_SMTP"><cv:msg
												key="label.smtpAccount" bundle="exchange"></cv:msg></option>
										<option value="TO_DIFFERNET_PST_SAM_ACT_NAME"><cv:msg
												key="label.sAMAccountName" bundle="exchange"></cv:msg></option>
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-switch-when="TO_DISK">
				<div class="form-group">
					<label class="col-xs-5" for="clientDestination"><cv:msg
							key="label.destHost" bundle="exchange"></cv:msg></label>
					<div class="col-xs-7">
						<select id="clientDestination" name="clientDestination"
							data-ng-model="exchMailboxRestoreOptionsController.model.clientDestination"
							data-ng-options="proxy.client.clientName for proxy in exchMailboxRestoreOptionsController.exchangeProxies track by proxy.client.clientId"
							required="required">
							<option value=""><cv:msg key="label.selectDestination"
									bundle="exchange"></cv:msg></option>
						</select>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.clientDestination)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectDestinationHost" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="destinationPath" class="col-xs-5">{{'label.destPath'
						| cvLoc}}</label>
					<div class="col-xs-7">
						<div class="input-group">
							<input type="text" id="destinationPath" name="destinationPath"
								data-ng-disabled="!exchMailboxRestoreOptionsController.model.clientDestination"
								data-ng-model="exchMailboxRestoreOptionsController.model.destinationPath"
								required="required" /> <span class="input-group-btn">
								<button id="office365ExchMailboxRestoreOptions_button_#1090" class="btn btn-default" type="button" 
									data-ng-disabled="!exchMailboxRestoreOptionsController.model.clientDestination"
									data-ng-click="exchMailboxRestoreOptionsController.openDiskDestinationModal()">{{'label.browse'
									| cvLoc}}</button>
							</span>
						</div>
						<div class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationPath)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.selectDestinationPath" bundle="exchange"></cv:msg>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="form-group"
			data-ng-if="['journalmailbox', 'contentstoremailbox'].indexOf(exchMailboxRestoreOptionsController.subclient.subclientName.toLowerCase()) >= 0">
			<div class="col-xs-12">
				<input id="isJournalReport" name="isJournalReport" type="checkbox"
					data-ng-model="exchMailboxRestoreOptionsController.model.isJournalReport" />
				<label for="isJournalReport"><cv:msg
						key="label.removeJournalReport" bundle="exchange"></cv:msg></label>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="office365ExchMailboxRestoreOptions_button_#1583" class="btn btn-default cvBusyOnAjax" type="button" 
			data-ng-click="exchMailboxRestoreOptionsController.cancel()">{{'Cancel'
			| cvLoc}}</button>
		<button id="office365ExchMailboxRestoreOptions_button_#1231" class="btn btn-primary cvBusyOnAjax" type="submit">{{'Submit' 
			| cvLoc}}</button>
	</div>
</form>