<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<form name="editExchangeServersForm" novalidate
	cv-submit="editExchSerModalCtrl.save()" autocomplete="off"
	class="bootstrap-wrapper form-horizontal">
	<div class="modal-header">
		<h1 class="modal-title">
			<cv:msg key="label.exchangeSettings" bundle="exchange" />
		</h1>
	</div>
	<div class="modal-body">
		<span
			class="{{editExchSerModalCtrl.editExchangeServerMessage.type}} serverMessage">{{editExchSerModalCtrl.editExchangeServerMessage.message}}</span>
		<div class="form-group">
			<label for="exchangeServers" class="col-xs-12"><cv:msg
					key="label.exchangeServers" bundle="exchange" /></label>
			<div class="col-xs-12">
				<textarea id="exchangeServers" name="exchangeServers"
					class="textarea" spellcheck="false"
					data-ng-model="editExchSerModalCtrl.model.exchangeServers"
					placeholder="<cv:msg key="placeholder.exchangeServers" bundle="exchange"/>"></textarea>
			</div>
		</div>
		<div class="form-header push-down cursor-pointer"
			data-ng-click="editExchSerModalCtrl.showExchangeOnlineSettings = !editExchSerModalCtrl.showExchangeOnlineSettings">
			<cv:msg key="label.exchangeOnlineSettings" bundle="exchange" />
			<cv-help-component
				data-help-text="<cv:msg key="label.exchangeOnlineSettingsNotRequired"
						bundle="exchange"></cv:msg>"></cv-help-component>
			<i class="pull-right"
				data-ng-class="{'ion-chevron-down': editExchSerModalCtrl.showExchangeOnlineSettings, 'ion-chevron-right': !editExchSerModalCtrl.showExchangeOnlineSettings}"></i>
		</div>
		<div data-uib-collapse="!editExchSerModalCtrl.showExchangeOnlineSettings">
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="applicationId"><cv:msg
						key="label.applicationId" bundle="exchange"></cv:msg></label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" id="applicationId" name="applicationId"
						data-ng-model="editExchSerModalCtrl.model.azureDetails.azureAppKeyID" />
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="secretAccessKey"><cv:msg
						key="label.secretAccessKey" bundle="exchange"></cv:msg></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" id="secretAccessKey"
						autocomplete="new-password" name="secretAccessKey"
						placeholder="<cv:msg key="label.leaveAzureSecretKeyBlank" bundle="exchange"></cv:msg>"
						data-ng-model="editExchSerModalCtrl.model.azureDetails.azureAppKeySecret" />
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="tenantName"><cv:msg
						key="label.azureDirectoryID" bundle="messages"></cv:msg></label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" id="tenantName" name="tenantName"
						data-ng-model="editExchSerModalCtrl.model.azureDetails.azureTenantName" />
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="editOffice365ExchangeServersModal_button_#1794" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-click="editExchSerModalCtrl.cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="editOffice365ExchangeServersModal_button_#1524" type="submit" class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="action.save" bundle="profiles" />
		</button>
	</div>
</form>
<!-- needed for encoding the password -->
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>