<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="App.ServiceType"></cv:cvEnum>
	<cv:cvEnum name="App.AzureAdAppStatus"></cv:cvEnum>
</script>

<div class="row">
	<div class="col-md-6" data-ng-if="exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent || exchSettingsCtrl.infraStructureSettings.isJournalMailboxPresent || (exchSettingsCtrl.infraStructureSettings.isContentStoreMailboxPresent && exchSettingsCtrl.showServiceAccountsOnly)">
		<span data-ng-if="exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent || exchSettingsCtrl.infraStructureSettings.isJournalMailboxPresent">
			<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' loader="exchSettingsCtrl.infraStructureSettings.associationsLoaded" >
				<ul class="list-style-secondary">
					<li class="group" data-ng-if="exchSettingsCtrl.infraStructureSettings.envType && exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent && exchSettingsCtrl.isNotOffice365">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.environmentType" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-bind="exchSettingsCtrl.infraStructureSettings.envType"></span>
					</li>
					<li class="group" data-ng-if="exchSettingsCtrl.showExchServer">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.exchangeServers" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage" ng-if="exchSettingsCtrl.infraStructureSettings.servers">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.servers"></span>
							<a class="float-right tile-content-link" data-ng-click="exchSettingsCtrl.editExchConnectSettings()"><cv:msg key="label.edit" bundle="clients" /></a>
						</span>
						<span class="pageDetailColumn width-60-percentage" ng-if="!exchSettingsCtrl.infraStructureSettings.servers">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>	
							<a class="float-right tile-content-link" data-ng-click="exchSettingsCtrl.editExchConnectSettings()"><cv:msg key="label.add" bundle="exchange" /></a>
						</span>
					</li>
					<!-- Region --START -->
					<li class="group" data-ng-if="exchSettingsCtrl.showCloudRegion()">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.formattedCloudRegion"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="exchSettingsCtrl.editCloudRegion(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>

					<li class="group"  data-ng-if="!exchSettingsCtrl.previewCloudRegion">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<div class="inline-editor-input">
								<isteven-multi-select
									input-model="exchSettingsCtrl.msCloudRegions"
									output-model="exchSettingsCtrl.selectedCloudRegionList"
									button-label="region"
									item-label="region"
									selection-mode="single"
									helper-elements="filter"
									max-labels="1"
									on-item-click="exchSettingsCtrl.processCloudRegionSelection()"
									tick-property="selected"
									class="isteven-multi-select user-group-select"
									translation="exchSettingsCtrl.localLangRegion">
								</isteven-multi-select>
							</div>
							<span class="inline-editor-buttons">
								<a
									class="inline-editor-button"
									data-ng-class="{disabled: loading}"
									data-ng-click="exchSettingsCtrl.updateCloudRegion()">
										<span class="k-icon k-i-check"></span>
								</a>
								<a
									class="inline-editor-button"
									data-ng-class="{disabled: loading}"
									data-ng-click="exchSettingsCtrl.editCloudRegion(false)">
										<span class="k-icon k-i-x"></span>
								</a>
							</span>
						</span>
					</li>
					<!-- Region --END -->
					<li class="group" data-ng-if="exchSettingsCtrl.infraStructureSettings.environmentType !== exchSettingsCtrl.exchangeConstants.EnvironmentType.EXCHANGE_ON_PREMISES && exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent">
						<!--Global Admin Account ... On Edit ..open small-window dialog-->
						<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-if="exchSettingsCtrl.hasGlobalAdminAccount">
							<span data-ng-bind="exchSettingsCtrl.globalAdminAccountDetails.exchangeAdminSmtpAddress"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="exchSettingsCtrl.openAddEditServiceAccountModal(exchSettingsCtrl.globalAdminAccountDetails)"><cv:msg key="label.edit" bundle="clients" /></a>
								<a class="margin-left-10" data-ng-click="exchSettingsCtrl.deleteAccountConfirmation(true)"><cv:msg key="label.delete" bundle="ediscovery" /></a>		
							</span>
						</span>					
						<!--Add new Global Administrator-->
						<span class="pageDetailColumn width-60-percentage" data-ng-if="!exchSettingsCtrl.hasGlobalAdminAccount">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>			
							<a class="float-right tile-content-link" 
								data-ng-click="exchSettingsCtrl.openAddEditServiceAccountModal(exchSettingsCtrl.globalAdminAccountDetails,true)"><cv:msg key="label.add" bundle="exchange" /></a>
						</span>
				</li>
				<!-- <li class="group" data-ng-show="exchSettingsCtrl.infraStructureSettings.azureAppList.azureApps.length > 0 && exchSettingsCtrl.infraStructureSettings.environmentType !== exchSettingsCtrl.exchangeConstants.EnvironmentType.EXCHANGE_ON_PREMISES && exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent">
					<span class="pageDetailColumn"><cv:msg key="label.azureDirectoryID" bundle="exchange" /></span>
					<cv-tile-edit value="exchSettingsCtrl.infraStructureSettings.azureAppList.azureApps[0].azureDirectoryId" enable-edit="true" edit-func="exchSettingsCtrl.editAzureDirValue()">
						<input type="text" data-ng-model="exchSettingsCtrl.infraStructureSettings.azureDirValue"/>
					</cv-tile-edit>
				</li> -->
				<li class="group" data-ng-if="!exchSettingsCtrl.showServiceAccountsOnly">
					<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.useModernAuthentication" bundle="office365" /></span>
					<span class="pageDetailColumn width-60-percentage">
						<toggle-control status="exchSettingsCtrl.infraStructureSettings.isModernAuthEnabled" data-ng-click="exchSettingsCtrl.modernAuthToggled()" title='<cv:msg key="label.useModernAuthentication" bundle="office365"/> {{label}} '></toggle-control>
					</span>
				</li>
				<li class="group" data-ng-if="exchSettingsCtrl.showEWSToggle()">
					<span class="pageDetailColumn width-40-percentage">
						<cv-help-text
							help-label="label.useEWS"
							help-text="help.useEWS"
						/>
					</span>
					<span class="pageDetailColumn width-60-percentage">
						<toggle-control
							status="exchSettingsCtrl.infraStructureSettings.useEWS"
							data-ng-click="exchSettingsCtrl.EWSToggled()"
							title='<cv:msg key="label.useEWS" bundle="exchange"/> {{label}}'>
						</toggle-control>
					</span>
				</li>
				<li
					class="group"
					data-ng-if="exchSettingsCtrl.showEWSToggle() && exchSettingsCtrl.infraStructureSettings.useEWS"
				>
					<span class="pageDetailColumn width-40-percentage">
						<cv:msg key="title.EWSConnectionUrl" bundle="exchange" />
					</span>
					<span class="pageDetailColumn width-60-percentage">
						<span class="restore-help-text italic" data-ng-if="!exchSettingsCtrl.ewsConnectionUrlSet">
							<cv:msg key="label.app.not.configured" bundle="office365" />
						</span>
						<span
							data-ng-if="exchSettingsCtrl.ewsConnectionUrlSet"
							data-ng-bind="exchSettingsCtrl.configuredEWSConnectionURL">
						</span>
						<a
							class="float-right margin-top-3 tile-content-link" 
							data-ng-click="exchSettingsCtrl.showEWSDiscoveryURLPopup()"
						>
							<cv:msg key="label.edit" bundle="clients"/>
						</a>
					</span>
				</li>
			</ul>
			</cv-tile-component>
		</span>
		<cv-tile-component data-title='<cv:msg key="label.exchangeConnectionSettings" bundle="office365" />' loader="exchSettingsCtrl.infraStructureSettings.associationsLoaded">
			<ul class="list-style-secondary margin-top-15">
				<li class="group no-padding" data-ng-if="!exchSettingsCtrl.showServiceAccountsOnly">
					<cv-tabset-component control='exchSettingsCtrl.tabControls' element="cvtile" ng-if="exchSettingsCtrl.azureAppsGridOptions && exchSettingsCtrl.gridOptions">
						<cv-tab tabname='<cv:msg key="label.azureApps" bundle="office365" />'>
							<cv-kendo-grid class="exchange-service-account" data-cv-grid-options="exchSettingsCtrl.azureAppsGridOptions"></cv-kendo-grid>
						</cv-tab>
						<cv-tab tabname='<cv:msg key="label.office365ServiceAccts" bundle="exchange" />'>
							<cv-kendo-grid class="exchange-service-account" data-cv-grid-options="exchSettingsCtrl.gridOptions"></cv-kendo-grid>
						</cv-tab>
					</cv-tabset-component>
				</li>
				<li class="group" data-ng-if="exchSettingsCtrl.showServiceAccountsOnly">
					<cv-kendo-grid class="exchange-service-account" data-cv-grid-options="exchSettingsCtrl.gridOptions"></cv-kendo-grid>
				</li>
			</ul>
			<div class="page-details-box-links margin-top-30">
				<a href="" data-ng-click="exchSettingsCtrl.testConnectionSettings()" data-ng-if="!exchSettingsCtrl.showServiceAccountsOnly"><cv:msg key="action.verifyConnection" bundle="office365" /> </a>
				<a href="" data-ng-click="exchSettingsCtrl.addServiceAccount()" data-ng-if="exchSettingsCtrl.showAddServiceAccountButton()"><cv:msg key="label.addServiceAccount" bundle="exchange" /> </a>
				<a href="" data-ng-click="exchSettingsCtrl._addAzureApp()" data-ng-if="exchSettingsCtrl.showAddAzureAppButton()"><cv:msg key="dialog.azureapp.title" bundle="office365" /> </a> 
			</div>
		</cv-tile-component>
		<div data-ng-if="exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent">
			<cv-on-boarding-warning-msg backupset-id="exchSettingsCtrl.backupsetId" is-tile-view="true" client-id="exchSettingsCtrl.clientId"></cv-on-boarding-warning-msg>
		</div>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-title='<cv:msg key="label.infrastructurePane" bundle="exchange"/>' loader="exchSettingsCtrl.clientDetails.associationsLoaded">
			<!--Office 365 SaaS + Infrastructure pool Configuration --Start-->
			<div data-ng-if="!exchSettingsCtrl.showAllInfraSettings">				
				<ul class="list-style-secondary" >
					<li class="group" ng-if="!exchSettingsCtrl.editPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.planEntity.planName"></span>
							<span class="float-right tile-content-link" data-ng-if="exchSettingsCtrl.provideServerPlanEdit">
								<a data-ng-click="exchSettingsCtrl.editServerPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>		
					</li> 
					<li class="group" ng-if="exchSettingsCtrl.editPlan && exchSettingsCtrl.provideServerPlanEdit">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<cv-plan-summary-dropdown
								class="half-width"
								input-model="exchSettingsCtrl.planList"
								output-model="exchSettingsCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="exchSettingsCtrl.localLangPlan"
								disable-property="'disabled'"></cv-plan-summary-dropdown>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}" ng-click="exchSettingsCtrl.saveServerPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}" ng-click="exchSettingsCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<div data-ng-if="!exchSettingsCtrl.editPlan" class="text-muted pageDetailColumn width-60-percentage float-right tile-content-link">
						<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
					</div>
				</ul>					
			</div>
			<!--Office 365 SaaS Configuration --End-->

			<div data-ng-if="exchSettingsCtrl.showAllInfraSettings">
				<ul class="list-style-secondary" >
					<li class="group" ng-if="!exchSettingsCtrl.editPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<a data-ng-click="exchSettingsCtrl.gotoPlanDetails()">
								<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.planEntity.planName"></span>
							</a>
							<span class="float-right tile-content-link">
								<a data-ng-click="exchSettingsCtrl.editServerPlan(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>		
					</li> 
					<li class="group" ng-if="exchSettingsCtrl.editPlan">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<cv-plan-summary-dropdown
								class="full-width"
								input-model="exchSettingsCtrl.planList"
								output-model="exchSettingsCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
							selection-mode="'single'"
								directive-id="'plans'"
								max-labels="1"
								helper-elements="'filter'"
								translation="exchSettingsCtrl.localLang"
								disable-property="'disabled'"></cv-plan-summary-dropdown>
						
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}" ng-click="exchSettingsCtrl.saveServerPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}" ng-click="exchSettingsCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<li class="group" data-ng-if="exchSettingsCtrl.currentMaxStream && !exchSettingsCtrl.editStreamsCount">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage"><span data-ng-bind="exchSettingsCtrl.currentMaxStream"></span>
							<span class="float-right tile-content-link">
								<a data-ng-click="exchSettingsCtrl.editBackupStreams(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="exchSettingsCtrl.editStreamsCount && exchSettingsCtrl.currentMaxStream">
						<span class="pageDetailColumn margin-top-10 pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange"/></span>
						<span class="pageDetailColumn inline-editor pageDetailColumn width-60-percentage margin-top-5">
							<div class="inline-editor-input">
								<input class="full-width" 
									type="number" 
									min="1" 
									step="1"
									id="maxStream"
									required
									data-ng-model="exchSettingsCtrl.infraStructureSettings.maxStream"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="exchSettingsCtrl.saveMaxStreams()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="exchSettingsCtrl.editBackupStreams(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10"
								data-ng-show="exchSettingsCtrl.isMaxStreamsInputInvalid">
							<cv:msg key="help.validstreams" bundle="office365" />
						</div>
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.indexServer" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.indexServer.mediaAgentName"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="exchSettingsCtrl.editIndexServer()">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>		
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.accessNodes" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.accessNode"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="exchSettingsCtrl.editAccessNodes(true)"><cv:msg key="label.edit" bundle="clients" /></a>
							</span>
						</span>		
					</li>
					<li class="group" ng-if="exchSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.userName && exchSettingsCtrl.infraStructureSettings.isLocalSysAccount">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.localSystemAccount" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span data-ng-bind="exchSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.userName"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="exchSettingsCtrl.editAccessNodes(true)"><cv:msg key="label.edit" bundle="clients" /></a>
							</span>
						</span>		
					</li>
					<li class="group" ng-if="exchSettingsCtrl.infraStructureSettings.isUserMailboxPresent && !exchSettingsCtrl.isEditRecallService">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.recallService" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage"><span data-ng-bind="exchSettingsCtrl.currentRecallService"></span>
							<span class="float-right tile-content-link">
								<a data-ng-click="exchSettingsCtrl.editRecallService(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="exchSettingsCtrl.isEditRecallService">
						<span class="pageDetailColumn margin-top-10 pageDetailColumn width-40-percentage"><cv:msg key="label.recallService" bundle="exchange"/></span>
						<span class="pageDetailColumn inline-editor pageDetailColumn width-60-percentage margin-top-5">
							<div class="inline-editor-input">
								<input class="full-width" 
									type="text" 
									id="recallService"
									required
									data-ng-model="exchSettingsCtrl.infraStructureSettings.recallService"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="exchSettingsCtrl.saveIndexServer()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="exchSettingsCtrl.editRecallService(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
					<li class="group">
						<span class="pageDetailColumn width-40-percentage">
							<cv:msg key="label.clientReadiness" bundle="clients" />
						</span>
						<span data-ng-if="exchSettingsCtrl.readinessStatus" class="pageDetailColumn width-60-percentage client-readiness">
							<span data-ng-bind="exchSettingsCtrl.readinessStatus">
							</span>
							<span data-ng-if="exchSettingsCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked" data-ng-bind="exchSettingsCtrl.clientReadinessLastCheckedText">
							</span>
								<a class="float-right tile-content-link" data-ng-click="exchSettingsCtrl.onClickShowDetailedReport()" uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />" tooltip-placement="top"><cv:msg key='label.showDetails' bundle='clients' /></a>
							<img class="loader" ng-if="exchSettingsCtrl.checkReadinessLoading" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
						</span>
						<span data-ng-if="!exchSettingsCtrl.readinessStatus" class="pageDetailColumn width-60-percentage">
								<cv:msg key="label.notAvailable" bundle="servers" />
						</span>
					</li>
				</ul>
			</div>
		</cv-tile-component>
		
		<cv-activity-control-component data-ng-if="!(exchSettingsCtrl.infraStructureSettings.isContentStoreMailboxPresent && exchSettingsCtrl.showServiceAccountsOnly) && exchSettingsCtrl.acParams" data-ac-params="exchSettingsCtrl.acParams">
		</cv-activity-control-component>
		
		<cv-security-component ng-if="exchSettingsCtrl.hasMultipleBackupsets" entity-type='exchSettingsCtrl.entityType'
				generic-entity = 'exchSettingsCtrl.genericEntity'
				associations='exchSettingsCtrl.backupset.formattedSecurityAssociations'
				associations-loaded="exchSettingsCtrl.backupset.associationsLoaded">
		</cv-security-component>

		<cv-security-component ng-if="!exchSettingsCtrl.hasMultipleBackupsets" entity-type='exchSettingsCtrl.entityType' 
				generic-entity = 'exchSettingsCtrl.genericEntity' 
				associations='exchSettingsCtrl.formattedSecurityAssociations' 
				associations-loaded='exchSettingsCtrl.associationsLoaded' 
				client-props="exchSettingsCtrl.generatePrivacyParams" 
				show-owners=true 
				cv-capability="exchSettingsCtrl.cvCapabilityConfig.security">
		</cv-security-component>
	</div>
</div>
